/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.DefaultExecutionTarget;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.Topic;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public abstract class ExecutionTargetManager {
    public static final Topic<ExecutionTargetListener> TOPIC = Topic.create((String)"ExecutionTarget topic", ExecutionTargetListener.class);

    @NotNull
    public static ExecutionTargetManager getInstance(@NotNull Project project) {
        if (project == null) {
            ExecutionTargetManager.$$$reportNull$$$0(0);
        }
        ExecutionTargetManager executionTargetManager = (ExecutionTargetManager)project.getService(ExecutionTargetManager.class);
        if (executionTargetManager == null) {
            ExecutionTargetManager.$$$reportNull$$$0(1);
        }
        return executionTargetManager;
    }

    @NotNull
    public static ExecutionTarget getActiveTarget(@NotNull Project project) {
        if (project == null) {
            ExecutionTargetManager.$$$reportNull$$$0(2);
        }
        ExecutionTarget executionTarget = ExecutionTargetManager.getInstance(project).getActiveTarget();
        if (executionTarget == null) {
            ExecutionTargetManager.$$$reportNull$$$0(3);
        }
        return executionTarget;
    }

    public static void setActiveTarget(@NotNull Project project, @NotNull ExecutionTarget target) {
        if (project == null) {
            ExecutionTargetManager.$$$reportNull$$$0(4);
        }
        if (target == null) {
            ExecutionTargetManager.$$$reportNull$$$0(5);
        }
        ExecutionTargetManager.getInstance(project).setActiveTarget(target);
    }

    @NotNull
    public static List<ExecutionTarget> getTargetsToChooseFor(@NotNull Project project, @Nullable RunConfiguration configuration) {
        List result;
        if (project == null) {
            ExecutionTargetManager.$$$reportNull$$$0(6);
        }
        if ((result = ExecutionTargetManager.getInstance(project).getTargetsFor(configuration)).size() == 1 && DefaultExecutionTarget.INSTANCE.equals(result.get(0))) {
            List<ExecutionTarget> list = Collections.emptyList();
            if (list == null) {
                ExecutionTargetManager.$$$reportNull$$$0(7);
            }
            return list;
        }
        if ((result = ContainerUtil.filter(result, target -> !target.isExternallyManaged())).size() == 1 && DefaultExecutionTarget.INSTANCE.equals(result.get(0))) {
            List<ExecutionTarget> list = Collections.emptyList();
            if (list == null) {
                ExecutionTargetManager.$$$reportNull$$$0(8);
            }
            return list;
        }
        List list = result;
        if (list == null) {
            ExecutionTargetManager.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Deprecated(forRemoval=true)
    public static boolean canRun(@Nullable RunnerAndConfigurationSettings settings, @Nullable ExecutionTarget target) {
        return ExecutionTargetManager.canRun(settings != null ? settings.getConfiguration() : null, target);
    }

    public static boolean canRun(@Nullable RunConfiguration configuration, @Nullable ExecutionTarget target) {
        if (configuration == null || target == null) {
            return false;
        }
        return ExecutionTargetManager.getInstance(configuration.getProject()).doCanRun(configuration, target);
    }

    public static boolean canRun(@NotNull ExecutionEnvironment environment) {
        RunnerAndConfigurationSettings settings;
        if (environment == null) {
            ExecutionTargetManager.$$$reportNull$$$0(10);
        }
        return (settings = environment.getRunnerAndConfigurationSettings()) != null && ExecutionTargetManager.canRun(settings.getConfiguration(), environment.getExecutionTarget());
    }

    public abstract boolean doCanRun(@Nullable RunConfiguration var1, @NotNull ExecutionTarget var2);

    public static void update(@NotNull Project project) {
        if (project == null) {
            ExecutionTargetManager.$$$reportNull$$$0(11);
        }
        ExecutionTargetManager.getInstance(project).update();
    }

    @NotNull
    public abstract ExecutionTarget getActiveTarget();

    public abstract void setActiveTarget(@NotNull ExecutionTarget var1);

    @NotNull
    public abstract @Unmodifiable List<ExecutionTarget> getTargetsFor(@Nullable RunConfiguration var1);

    public abstract void update();

    public ExecutionTarget findTarget(RunConfiguration configuration) {
        ExecutionTarget target = this.getActiveTarget();
        if (ExecutionTargetManager.canRun(configuration, target)) {
            return target;
        }
        List<ExecutionTarget> targets = this.getTargetsFor(configuration);
        return (ExecutionTarget)ContainerUtil.getFirstItem(targets);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/ExecutionTargetManager";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/ExecutionTargetManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveTarget";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetsToChooseFor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getActiveTarget";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setActiveTarget";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getTargetsToChooseFor";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "canRun";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 7, 8, 9 -> new IllegalStateException(string);
        };
    }
}

