/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.executors;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.TextWithMnemonic;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u000b\u001a\u00020\u00072\b\b\u0001\u0010\f\u001a\u00020\u0007H\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H&J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\t\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0014\u00c0\u0006\u0001"}, d2={"Lcom/intellij/execution/executors/RunExecutorSettings;", "", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "actionName", "", "getActionName", "()Ljava/lang/String;", "startActionText", "getStartActionText", "configurationName", "isApplicable", "", "project", "Lcom/intellij/openapi/project/Project;", "canRun", "profile", "Lcom/intellij/execution/configurations/RunProfile;", "intellij.platform.execution"})
public interface RunExecutorSettings {
    @NotNull
    public Icon getIcon();

    @NotNull
    public String getActionName();

    @NotNull
    public String getStartActionText();

    @NotNull
    default public String getStartActionText(@NlsSafe @NotNull String configurationName) {
        Intrinsics.checkNotNullParameter((Object)configurationName, (String)"configurationName");
        String configName = StringUtil.isEmpty((String)configurationName) ? "" : " '" + Executor.shortenNameIfNeeded(configurationName) + "'";
        String string = TextWithMnemonic.parse((String)this.getStartActionText()).append(configName).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public boolean isApplicable(@NotNull Project var1);

    public boolean canRun(@NotNull RunProfile var1);
}

