/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.target.value;

import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.local.LocalTargetEnvironment;
import com.intellij.execution.target.value.TargetEnvironmentFunctions;
import com.intellij.execution.target.value.TraceableTargetEnvironmentFunction;
import com.intellij.openapi.diagnostic.Logger;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0082\b\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0013B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016J\t\u0010\n\u001a\u00020\u0004H\u00c2\u0003J\u0013\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0002H\u00d6\u0001R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/execution/target/value/TargetPathFunction;", "Lcom/intellij/execution/target/value/TraceableTargetEnvironmentFunction;", "", "localPath", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "applyInner", "t", "Lcom/intellij/execution/target/TargetEnvironment;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Companion", "intellij.platform.execution"})
@SourceDebugExtension(value={"SMAP\nTargetEnvironmentFunctions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TargetEnvironmentFunctions.kt\ncom/intellij/execution/target/value/TargetPathFunction\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,319:1\n13#2:320\n*S KotlinDebug\n*F\n+ 1 TargetEnvironmentFunctions.kt\ncom/intellij/execution/target/value/TargetPathFunction\n*L\n272#1:320\n*E\n"})
final class TargetPathFunction
extends TraceableTargetEnvironmentFunction<String> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path localPath;
    @NotNull
    private static final Logger LOG;

    public TargetPathFunction(@NotNull Path localPath) {
        Intrinsics.checkNotNullParameter((Object)localPath, (String)"localPath");
        this.localPath = localPath;
    }

    @Override
    @NotNull
    public String applyInner(@NotNull TargetEnvironment t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        if (t instanceof LocalTargetEnvironment) {
            return ((Object)this.localPath).toString();
        }
        String targetPath = TargetEnvironmentFunctions.access$getTargetPath(t, this.localPath);
        if (targetPath == null) {
            LOG.error("Could not find a target path for the local path " + this.localPath + " requested at:", this.getCreationStack());
            return ((Object)this.localPath).toString();
        }
        return targetPath;
    }

    private final Path component1() {
        return this.localPath;
    }

    @NotNull
    public final TargetPathFunction copy(@NotNull Path localPath) {
        Intrinsics.checkNotNullParameter((Object)localPath, (String)"localPath");
        return new TargetPathFunction(localPath);
    }

    public static /* synthetic */ TargetPathFunction copy$default(TargetPathFunction targetPathFunction, Path path, int n, Object object) {
        if ((n & 1) != 0) {
            path = targetPathFunction.localPath;
        }
        return targetPathFunction.copy(path);
    }

    @NotNull
    public String toString() {
        return "TargetPathFunction(localPath=" + this.localPath + ")";
    }

    public int hashCode() {
        return ((Object)this.localPath).hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TargetPathFunction)) {
            return false;
        }
        TargetPathFunction targetPathFunction = (TargetPathFunction)other;
        return Intrinsics.areEqual((Object)this.localPath, (Object)targetPathFunction.localPath);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(TargetPathFunction.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/execution/target/value/TargetPathFunction$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.execution"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

