/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.target.value;

import com.intellij.execution.target.value.TargetValue;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class DeferredLocalTargetValue<T>
implements TargetValue<T> {
    private final AsyncPromise<T> myLocalPromise = new AsyncPromise();
    private final Promise<T> myTargetValue;

    public DeferredLocalTargetValue(T targetValue) {
        this.myTargetValue = Promises.resolvedPromise(targetValue);
    }

    public void resolve(T valueToResolve) {
        if (this.myLocalPromise.isDone()) {
            throw new IllegalStateException("Local value is already resolved to '" + String.valueOf(this.myLocalPromise.get()) + "'");
        }
        this.myLocalPromise.setResult(valueToResolve);
    }

    @Override
    public Promise<T> getLocalValue() {
        return this.myLocalPromise;
    }

    @Override
    public Promise<T> getTargetValue() {
        return this.myTargetValue;
    }
}

