/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.Executor;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.dashboard.RunDashboardUiManager;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentWithExecutorListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.util.messages.Topic;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface RunContentManager {
    public static final Topic<RunContentWithExecutorListener> TOPIC = Topic.create((String)"Run Content", RunContentWithExecutorListener.class);

    @NotNull
    public static RunContentManager getInstance(@NotNull Project project) {
        if (project == null) {
            RunContentManager.$$$reportNull$$$0(0);
        }
        RunContentManager runContentManager = (RunContentManager)project.getService(RunContentManager.class);
        if (runContentManager == null) {
            RunContentManager.$$$reportNull$$$0(1);
        }
        return runContentManager;
    }

    @Nullable
    public static RunContentManager getInstanceIfCreated(@NotNull Project project) {
        if (project == null) {
            RunContentManager.$$$reportNull$$$0(2);
        }
        return (RunContentManager)project.getServiceIfCreated(RunContentManager.class);
    }

    @ApiStatus.Internal
    public void registerRunContentDescriptor(@NotNull RunContentDescriptor var1);

    @ApiStatus.Internal
    @NotNull
    public Collection<RunContentDescriptor> getRunContentDescriptors();

    @Nullable
    public RunContentDescriptor getSelectedContent();

    @NotNull
    public List<RunContentDescriptor> getAllDescriptors();

    @Nullable
    public RunContentDescriptor getReuseContent(@NotNull ExecutionEnvironment var1);

    @Nullable
    public RunContentDescriptor findContentDescriptor(Executor var1, ProcessHandler var2);

    public void showRunContent(@NotNull Executor var1, @NotNull RunContentDescriptor var2, @Nullable RunContentDescriptor var3);

    public void showRunContent(@NotNull Executor var1, @NotNull RunContentDescriptor var2);

    public void hideRunContent(@NotNull Executor var1, RunContentDescriptor var2);

    public boolean removeRunContent(@NotNull Executor var1, @NotNull RunContentDescriptor var2);

    public void toFrontRunContent(@NotNull Executor var1, @NotNull RunContentDescriptor var2);

    public void toFrontRunContent(@NotNull Executor var1, @NotNull ProcessHandler var2);

    @Nullable
    public ToolWindow getToolWindowByDescriptor(@NotNull RunContentDescriptor var1);

    public void selectRunContent(@NotNull RunContentDescriptor var1);

    @Nullable
    default public String getContentDescriptorToolWindowId(@NotNull ExecutionEnvironment environment) {
        if (environment == null) {
            RunContentManager.$$$reportNull$$$0(3);
        }
        if (!RunDashboardUiManager.getInstance(environment.getProject()).isSupported(environment.getExecutor())) {
            return null;
        }
        RunProfile runProfile = environment.getRunProfile();
        if (runProfile instanceof RunConfiguration) {
            return this.getContentDescriptorToolWindowId((RunConfiguration)runProfile);
        }
        RunnerAndConfigurationSettings settings = environment.getRunnerAndConfigurationSettings();
        if (settings != null) {
            return this.getContentDescriptorToolWindowId(settings.getConfiguration());
        }
        return null;
    }

    public String getContentDescriptorToolWindowId(@Nullable RunConfiguration var1);

    @NotNull
    public String getToolWindowIdByEnvironment(@NotNull ExecutionEnvironment var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/ui/RunContentManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/ui/RunContentManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getInstanceIfCreated";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getContentDescriptorToolWindowId";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

