/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.externalProcessAuthHelper;

import com.intellij.externalProcessAuthHelper.AuthenticationGate;
import com.intellij.externalProcessAuthHelper.AuthenticationGatesKt;
import com.intellij.openapi.progress.ProcessCanceledException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J!\u0010\u000b\u001a\u0002H\f\"\u0004\b\u0000\u0010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\f0\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0013\u001a\u00020\nH\u0016J\u0018\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/externalProcessAuthHelper/RestrictingAuthenticationGate;", "Lcom/intellij/externalProcessAuthHelper/AuthenticationGate;", "<init>", "()V", "semaphore", "Ljava/util/concurrent/Semaphore;", "cancelled", "", "inputData", "Ljava/util/concurrent/ConcurrentHashMap;", "", "waitAndCompute", "T", "operation", "Ljava/util/function/Supplier;", "(Ljava/util/function/Supplier;)Ljava/lang/Object;", "cancel", "", "getSavedInput", "key", "saveInput", "value", "intellij.platform.externalProcessAuthHelper"})
public final class RestrictingAuthenticationGate
implements AuthenticationGate {
    @NotNull
    private final Semaphore semaphore = new Semaphore(1);
    private volatile boolean cancelled;
    @NotNull
    private final ConcurrentHashMap<String, String> inputData = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T waitAndCompute(@NotNull Supplier<T> operation) {
        Intrinsics.checkNotNullParameter(operation, (String)"operation");
        try {
            AuthenticationGatesKt.access$getLOG$p().debug("Entered waitAndCompute");
            this.semaphore.acquire();
            AuthenticationGatesKt.access$getLOG$p().debug("Acquired permission");
            if (this.cancelled) {
                AuthenticationGatesKt.access$getLOG$p().debug("Authentication Gate has already been cancelled");
                throw new ProcessCanceledException();
            }
            T t = operation.get();
            return t;
        }
        catch (InterruptedException e) {
            AuthenticationGatesKt.access$getLOG$p().warn((Throwable)e);
            throw new ProcessCanceledException((Throwable)e);
        }
        finally {
            this.semaphore.release();
        }
    }

    @Override
    public void cancel() {
        this.cancelled = true;
    }

    @Override
    @Nullable
    public String getSavedInput(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.inputData.get(key);
    }

    @Override
    public void saveInput(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ((Map)this.inputData).put(key, value);
    }
}

