/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.externalProcessAuthHelper;

import com.intellij.openapi.util.NlsSafe;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class SshPrompts {
    public static final Pattern PASSPHRASE_PROMPT = Pattern.compile("\\r?Enter passphrase for( key)? '?(?<keyfile>[^']*)'?:\\s?");
    public static final Pattern PASSWORD_PROMPT = Pattern.compile("(?<username>.*)'s password:\\s?");
    public static final Pattern PKCS_PIN_TOKEN_PROMPT = Pattern.compile("\\r?Enter PIN for '?(?<tokenLabel>[^']*)'?:\\s?");
    public static final String PASSWORD_PROMPT_PREFIX = "password for";
    public static final String PASSWORD_PROMPT_SUFFIX = "password:";
    public static final String CONFIRM_CONNECTION_PROMPT = "Are you sure you want to continue connecting";
    public static final String REMOTE_HOST_IDENTIFICATION_HAS_CHANGED = "remote host identification has changed";

    public static String extractKeyPath(Matcher matcher) {
        return matcher.group("keyfile");
    }

    public static String extractPkcsTokenLabel(Matcher matcher) {
        return matcher.group("tokenLabel");
    }

    public static String extractUsername(Matcher matcher) {
        return matcher.group("username");
    }

    @NlsSafe
    @NotNull
    public static String stripConfirmConnectionOptions(@NotNull String description) {
        if (description == null) {
            SshPrompts.$$$reportNull$$$0(0);
        }
        String string = description.replaceAll("Are you sure you want to continue connecting \\(.+?\\)\\?", "Are you sure you want to continue connecting?");
        if (string == null) {
            SshPrompts.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/externalProcessAuthHelper/SshPrompts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/externalProcessAuthHelper/SshPrompts";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "stripConfirmConnectionOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "stripConfirmConnectionOptions";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

