/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataClassResolver;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.serialization.NonDefaultConstructorInfo;
import com.intellij.serialization.ReadConfiguration;
import com.intellij.serialization.WriteConfiguration;
import java.lang.reflect.Constructor;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u001a\u001c\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0007\u001aD\u0010\b\u001a\u00020\u00032<\u0010\t\u001a8\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000f\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00100\n\u00a8\u0006\u0011"}, d2={"createCacheWriteConfiguration", "Lcom/intellij/serialization/WriteConfiguration;", "createCacheReadConfiguration", "Lcom/intellij/serialization/ReadConfiguration;", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "testOnlyClassLoader", "Ljava/lang/ClassLoader;", "createDataNodeReadConfiguration", "loadClass", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "", "hostObject", "Ljava/lang/Class;", "intellij.platform.externalSystem"})
public final class SerializationKt {
    @NotNull
    public static final WriteConfiguration createCacheWriteConfiguration() {
        return new WriteConfiguration(false, null, false, true, 7, null);
    }

    @JvmOverloads
    @NotNull
    public static final ReadConfiguration createCacheReadConfiguration(@NotNull Logger log, @Nullable ClassLoader testOnlyClassLoader) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        DataClassResolver dataNodeResolver = testOnlyClassLoader == null ? new DataClassResolver(log) : null;
        return SerializationKt.createDataNodeReadConfiguration((arg_0, arg_1) -> SerializationKt.createCacheReadConfiguration$lambda$0(log, dataNodeResolver, testOnlyClassLoader, arg_0, arg_1));
    }

    public static /* synthetic */ ReadConfiguration createCacheReadConfiguration$default(Logger logger, ClassLoader classLoader, int n, Object object) {
        if ((n & 2) != 0) {
            classLoader = null;
        }
        return SerializationKt.createCacheReadConfiguration(logger, classLoader);
    }

    @NotNull
    public static final ReadConfiguration createDataNodeReadConfiguration(@NotNull Function2<? super String, Object, ? extends Class<?>> loadClass) {
        Intrinsics.checkNotNullParameter(loadClass, (String)"loadClass");
        return new ReadConfiguration(true, loadClass, SerializationKt::createDataNodeReadConfiguration$lambda$0, SerializationKt::createDataNodeReadConfiguration$lambda$1);
    }

    @JvmOverloads
    @NotNull
    public static final ReadConfiguration createCacheReadConfiguration(@NotNull Logger log) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        return SerializationKt.createCacheReadConfiguration$default(log, null, 2, null);
    }

    private static final Class<?> createCacheReadConfiguration$lambda$0(Logger $log, DataClassResolver dataNodeResolver, ClassLoader $testOnlyClassLoader, String name, Object hostObject) {
        Class<?> clazz;
        if (!(hostObject instanceof DataNode)) {
            Object object;
            Class<?> hostObjectClass = hostObject.getClass();
            try {
                object = hostObjectClass.getClassLoader().loadClass(name);
            }
            catch (ClassNotFoundException e) {
                $log.debug("cannot find class " + name + " using class loader of class " + hostObjectClass.getName() + " (classLoader=" + hostObjectClass.getClassLoader() + ")", (Throwable)e);
                Object object2 = dataNodeResolver;
                if (object2 == null || (object2 = ((DataClassResolver)object2).resolve(name, null)) == null) {
                    throw e;
                }
                object = object2;
            }
            clazz = object;
        } else if (dataNodeResolver == null) {
            ClassLoader classLoader = $testOnlyClassLoader;
            Intrinsics.checkNotNull((Object)classLoader);
            clazz = classLoader.loadClass(name);
        } else {
            clazz = dataNodeResolver.resolve(name, (DataNode)hostObject);
        }
        return clazz;
    }

    private static final Object createDataNodeReadConfiguration$lambda$0(Object it) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it instanceof ProjectSystemId) {
            ProjectSystemId projectSystemId = ((ProjectSystemId)it).intern();
            Intrinsics.checkNotNull((Object)projectSystemId);
            object = projectSystemId;
        } else {
            object = it;
        }
        return object;
    }

    private static final NonDefaultConstructorInfo createDataNodeReadConfiguration$lambda$1(Class beanClass) {
        NonDefaultConstructorInfo nonDefaultConstructorInfo;
        Intrinsics.checkNotNullParameter((Object)beanClass, (String)"beanClass");
        String string = beanClass.getName();
        if (Intrinsics.areEqual((Object)string, (Object)"org.jetbrains.kotlin.idea.configuration.KotlinTargetData")) {
            List list = CollectionsKt.listOf((Object)"externalName");
            Class[] classArray = new Class[]{String.class};
            Constructor constructor = beanClass.getDeclaredConstructor(classArray);
            Intrinsics.checkNotNullExpressionValue(constructor, (String)"getDeclaredConstructor(...)");
            nonDefaultConstructorInfo = new NonDefaultConstructorInfo(list, constructor);
        } else if (Intrinsics.areEqual((Object)string, (Object)"org.jetbrains.kotlin.idea.configuration.KotlinAndroidSourceSetData")) {
            List list = CollectionsKt.listOf((Object)"sourceSetInfos");
            Constructor<?>[] constructorArray = beanClass.getConstructors();
            Intrinsics.checkNotNullExpressionValue(constructorArray, (String)"getConstructors(...)");
            Object object = ArraysKt.first((Object[])constructorArray);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first(...)");
            nonDefaultConstructorInfo = new NonDefaultConstructorInfo(list, (Constructor)object);
        } else {
            nonDefaultConstructorInfo = null;
        }
        return nonDefaultConstructorInfo;
    }
}

