/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.autoimport;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.util.PathUtil;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0014\u001a\u00020\u0005H\u0016J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\f\u001a\u00070\u0005\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\u00070\u0005\u00a2\u0006\u0002\b\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u001c\u0010\u0010\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u000b\u00a8\u0006\u001d"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectId;", "", "systemId", "Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "externalProjectPath", "", "<init>", "(Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;Ljava/lang/String;)V", "getSystemId", "()Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "getExternalProjectPath", "()Ljava/lang/String;", "systemName", "Lorg/jetbrains/annotations/Nls;", "projectName", "getProjectName", "debugName", "getDebugName$annotations", "()V", "getDebugName", "toString", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "intellij.platform.externalSystem"})
public final class ExternalSystemProjectId {
    @NotNull
    private final ProjectSystemId systemId;
    @NotNull
    private final String externalProjectPath;
    @NotNull
    private final String systemName;
    @NotNull
    private final String projectName;
    @NotNull
    private final String debugName;

    public ExternalSystemProjectId(@NotNull ProjectSystemId systemId, @NotNull String externalProjectPath) {
        Intrinsics.checkNotNullParameter((Object)systemId, (String)"systemId");
        Intrinsics.checkNotNullParameter((Object)externalProjectPath, (String)"externalProjectPath");
        this.systemId = systemId;
        this.externalProjectPath = externalProjectPath;
        String string = this.systemId.getReadableName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getReadableName(...)");
        this.systemName = string;
        String string2 = PathUtil.getFileName((String)this.externalProjectPath);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getFileName(...)");
        this.projectName = string2;
        this.debugName = this.systemName + " (" + this.projectName + ")";
    }

    @NotNull
    public final ProjectSystemId getSystemId() {
        return this.systemId;
    }

    @NotNull
    public final String getExternalProjectPath() {
        return this.externalProjectPath;
    }

    @NotNull
    public final String getProjectName() {
        return this.projectName;
    }

    @NotNull
    public final String getDebugName() {
        return this.debugName;
    }

    @Deprecated(message="Use ExternalSystemProjectId#toString instead", replaceWith=@ReplaceWith(expression="this.toString()", imports={}))
    public static /* synthetic */ void getDebugName$annotations() {
    }

    @NotNull
    public String toString() {
        return this.systemName + " (" + this.projectName + ")";
    }

    @NotNull
    public final ProjectSystemId component1() {
        return this.systemId;
    }

    @NotNull
    public final String component2() {
        return this.externalProjectPath;
    }

    @NotNull
    public final ExternalSystemProjectId copy(@NotNull ProjectSystemId systemId, @NotNull String externalProjectPath) {
        Intrinsics.checkNotNullParameter((Object)systemId, (String)"systemId");
        Intrinsics.checkNotNullParameter((Object)externalProjectPath, (String)"externalProjectPath");
        return new ExternalSystemProjectId(systemId, externalProjectPath);
    }

    public static /* synthetic */ ExternalSystemProjectId copy$default(ExternalSystemProjectId externalSystemProjectId, ProjectSystemId projectSystemId, String string, int n, Object object) {
        if ((n & 1) != 0) {
            projectSystemId = externalSystemProjectId.systemId;
        }
        if ((n & 2) != 0) {
            string = externalSystemProjectId.externalProjectPath;
        }
        return externalSystemProjectId.copy(projectSystemId, string);
    }

    public int hashCode() {
        int result = this.systemId.hashCode();
        result = result * 31 + this.externalProjectPath.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ExternalSystemProjectId)) {
            return false;
        }
        ExternalSystemProjectId externalSystemProjectId = (ExternalSystemProjectId)other;
        if (!Intrinsics.areEqual((Object)this.systemId, (Object)externalSystemProjectId.systemId)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.externalProjectPath, (Object)externalSystemProjectId.externalProjectPath);
    }
}

