/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.folding.CollapseBlockHandler;
import com.intellij.codeInsight.folding.impl.EditorFoldingInfo;
import com.intellij.codeInsight.folding.impl.FoldingUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CollapseBlockHandlerImpl
implements CollapseBlockHandler {
    private static final Logger LOG = Logger.getInstance(CollapseBlockHandler.class);

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            CollapseBlockHandlerImpl.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            CollapseBlockHandlerImpl.$$$reportNull$$$0(1);
        }
        if (file == null) {
            CollapseBlockHandlerImpl.$$$reportNull$$$0(2);
        }
        int[] targetCaretOffset = new int[]{-1};
        editor.getFoldingModel().runBatchFoldingOperation(() -> {
            EditorFoldingInfo info = EditorFoldingInfo.get(editor);
            FoldingModelEx model = (FoldingModelEx)editor.getFoldingModel();
            int offset = editor.getCaretModel().getOffset();
            PsiElement element = file.findElementAt(offset - 1);
            if (!this.isEndBlockToken(element)) {
                element = file.findElementAt(offset);
            }
            if (element == null) {
                return;
            }
            PsiElement block = this.findParentBlock(element);
            FoldRegion previous = null;
            FoldRegion myPrevious = null;
            while (block != null) {
                int end;
                TextRange range = this.getFoldingRange(block);
                if (!range.containsOffset(offset)) {
                    block = this.findParentBlock(block);
                    continue;
                }
                int start = range.getStartOffset();
                FoldRegion existing = FoldingUtil.findFoldRegion((Editor)editor, (int)start, (int)(end = range.getEndOffset()));
                if (existing != null) {
                    if (existing.isExpanded()) {
                        existing.setExpanded(false);
                        targetCaretOffset[0] = existing.getEndOffset();
                        return;
                    }
                    previous = existing;
                    if (info.getPsiElement(existing) == null) {
                        myPrevious = existing;
                    }
                    block = this.findParentBlock(block);
                    continue;
                }
                if (model.intersectsRegion(start, end)) break;
                FoldRegion region = model.addFoldRegion(start, end, this.getPlaceholderText());
                LOG.assertTrue(region != null);
                region.setExpanded(false);
                if (myPrevious != null && info.getPsiElement(region) == null) {
                    info.removeRegion(myPrevious);
                    model.removeFoldRegion(myPrevious);
                }
                targetCaretOffset[0] = block.getTextRange().getEndOffset() < offset ? start : end;
                return;
            }
            if (previous != null) {
                previous.setExpanded(false);
                if (myPrevious != null) {
                    info.removeRegion(myPrevious);
                    model.removeFoldRegion(myPrevious);
                }
                targetCaretOffset[0] = previous.getEndOffset();
            }
        });
        if (targetCaretOffset[0] >= 0) {
            editor.getCaretModel().moveToOffset(targetCaretOffset[0]);
        }
    }

    @Nullable
    protected abstract PsiElement findParentBlock(@Nullable PsiElement var1);

    protected abstract boolean isEndBlockToken(@Nullable PsiElement var1);

    @NotNull
    protected String getPlaceholderText() {
        return "{...}";
    }

    @NotNull
    protected TextRange getFoldingRange(@NotNull PsiElement element) {
        if (element == null) {
            CollapseBlockHandlerImpl.$$$reportNull$$$0(3);
        }
        TextRange textRange = element.getTextRange();
        if (textRange == null) {
            CollapseBlockHandlerImpl.$$$reportNull$$$0(4);
        }
        return textRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/folding/impl/CollapseBlockHandlerImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/folding/impl/CollapseBlockHandlerImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFoldingRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFoldingRange";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

