/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.folding.impl.ElementSignatureProvider;
import com.intellij.codeInsight.folding.impl.GenericElementSignatureProvider;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class FoldingPolicy {
    private static final ExtensionPointName<ElementSignatureProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.elementSignatureProvider");
    private static final Logger LOG = Logger.getInstance(FoldingPolicy.class);
    private static final GenericElementSignatureProvider GENERIC_PROVIDER = new GenericElementSignatureProvider();

    private FoldingPolicy() {
    }

    static boolean isCollapsedByDefault(@NotNull FoldingDescriptor foldingDescriptor, @NotNull FoldingBuilder foldingBuilder) {
        if (foldingDescriptor == null) {
            FoldingPolicy.$$$reportNull$$$0(0);
        }
        if (foldingBuilder == null) {
            FoldingPolicy.$$$reportNull$$$0(1);
        }
        try {
            return foldingBuilder.isCollapsedByDefault(foldingDescriptor);
        }
        catch (IndexNotReadyException e) {
            LOG.error((Throwable)e);
            return false;
        }
    }

    static boolean keepExpandedOnFirstCollapseAll(@NotNull FoldingDescriptor foldingDescriptor, @NotNull FoldingBuilder foldingBuilder) {
        if (foldingDescriptor == null) {
            FoldingPolicy.$$$reportNull$$$0(2);
        }
        if (foldingBuilder == null) {
            FoldingPolicy.$$$reportNull$$$0(3);
        }
        try {
            return foldingBuilder.keepExpandedOnFirstCollapseAll(foldingDescriptor);
        }
        catch (IndexNotReadyException e) {
            return false;
        }
    }

    @Nullable
    public static String getSignature(@NotNull PsiElement element) {
        if (element == null) {
            FoldingPolicy.$$$reportNull$$$0(4);
        }
        for (ElementSignatureProvider provider : EP_NAME.getExtensionList()) {
            String signature = provider.getSignature(element);
            if (signature == null) continue;
            return signature;
        }
        return GENERIC_PROVIDER.getSignature(element);
    }

    @Nullable
    public static PsiElement restoreBySignature(@NotNull PsiFile file, @NotNull String signature) {
        if (file == null) {
            FoldingPolicy.$$$reportNull$$$0(5);
        }
        if (signature == null) {
            FoldingPolicy.$$$reportNull$$$0(6);
        }
        return FoldingPolicy.restoreBySignature(file, signature, null);
    }

    @Nullable
    public static PsiElement restoreBySignature(@NotNull PsiFile file, @NotNull String signature, @Nullable StringBuilder processingInfoStorage) {
        if (file == null) {
            FoldingPolicy.$$$reportNull$$$0(7);
        }
        if (signature == null) {
            FoldingPolicy.$$$reportNull$$$0(8);
        }
        for (ElementSignatureProvider provider : EP_NAME.getExtensionList()) {
            PsiElement result = provider.restoreBySignature(file, signature, processingInfoStorage);
            if (result == null) continue;
            return result;
        }
        return GENERIC_PROVIDER.restoreBySignature(file, signature, processingInfoStorage);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foldingDescriptor";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foldingBuilder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/folding/impl/FoldingPolicy";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isCollapsedByDefault";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "keepExpandedOnFirstCollapseAll";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getSignature";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "restoreBySignature";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

