/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.folding.impl.CodeFoldingManagerImpl;
import com.intellij.codeInsight.folding.impl.FoldingPolicy;
import com.intellij.codeInsight.folding.impl.FoldingUtil;
import com.intellij.codeInsight.folding.impl.UpdateFoldRegionsOperation;
import com.intellij.formatting.visualLayer.VisualFormattingLayerService;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.folding.LanguageFolding;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.impl.FoldingKeys;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.text.CodeFoldingState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.formatter.WhiteSpaceFormattingStrategy;
import com.intellij.psi.formatter.WhiteSpaceFormattingStrategyFactory;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.StringTokenizer;
import com.intellij.xml.util.XmlStringUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DocumentFoldingInfo
implements CodeFoldingState {
    private static final Logger LOG = Logger.getInstance(DocumentFoldingInfo.class);
    private static final Key<FoldingInfo> FOLDING_INFO_KEY = Key.create((String)"FOLDING_INFO");
    @NotNull
    private final Project myProject;
    private final VirtualFile file;
    @NotNull
    private final List<Info> myInfos;
    @NotNull
    private final List<RangeMarker> myRangeMarkers;
    private static final String DEFAULT_PLACEHOLDER = "...";
    @NonNls
    private static final String ELEMENT_TAG = "element";
    @NonNls
    private static final String SIGNATURE_ATT = "signature";
    @NonNls
    private static final String EXPANDED_ATT = "expanded";
    @NonNls
    private static final String MARKER_TAG = "marker";
    @NonNls
    private static final String DATE_ATT = "date";
    @NonNls
    private static final String PLACEHOLDER_ATT = "ph";

    DocumentFoldingInfo(@NotNull Project project, @NotNull Document document) {
        if (project == null) {
            DocumentFoldingInfo.$$$reportNull$$$0(0);
        }
        if (document == null) {
            DocumentFoldingInfo.$$$reportNull$$$0(1);
        }
        this.myInfos = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myRangeMarkers = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myProject = project;
        this.file = FileDocumentManager.getInstance().getFile(document);
    }

    void loadFromEditor(@NotNull Editor editor) {
        FoldRegion[] foldRegions;
        if (editor == null) {
            DocumentFoldingInfo.$$$reportNull$$$0(2);
        }
        ThreadingAssertions.assertEventDispatchThread();
        LOG.assertTrue(!editor.isDisposed());
        this.clear();
        for (FoldRegion region : foldRegions = editor.getFoldingModel().getAllFoldRegions()) {
            boolean collapseByDefault;
            if (!region.isValid() || region.shouldNeverExpand() || CodeFoldingManagerImpl.isNotPersistent(region)) continue;
            boolean expanded = region.isExpanded();
            String signature = (String)region.getUserData(UpdateFoldRegionsOperation.SIGNATURE);
            if (Strings.areSameInstance((String)signature, (String)"no signature")) continue;
            Boolean storedCollapseByDefault = CodeFoldingManagerImpl.getCollapsedByDef(region);
            boolean bl = collapseByDefault = storedCollapseByDefault != null && storedCollapseByDefault != false && !FoldingUtil.caretInsideRange((Editor)editor, (TextRange)region.getTextRange());
            if (collapseByDefault != expanded && !DocumentFoldingInfo.isManuallyCreated(region, signature)) continue;
            if (signature != null) {
                this.myInfos.add(new Info(signature, expanded));
                continue;
            }
            RangeMarker marker = editor.getDocument().createRangeMarker(region.getStartOffset(), region.getEndOffset());
            this.myRangeMarkers.add(marker);
            marker.putUserData(FOLDING_INFO_KEY, (Object)new FoldingInfo(region.getPlaceholderText(), expanded));
        }
    }

    private static boolean isManuallyCreated(@Nullable FoldRegion region, @Nullable String signature) {
        return signature == null && !CodeFoldingManagerImpl.isAutoCreated(region);
    }

    public void setToEditor(@NotNull Editor editor) {
        if (editor == null) {
            DocumentFoldingInfo.$$$reportNull$$$0(3);
        }
        ThreadingAssertions.assertEventDispatchThread();
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        if (psiManager.isDisposed()) {
            return;
        }
        if (!this.file.isValid()) {
            return;
        }
        PsiFile psiFile = psiManager.findFile(this.file);
        if (psiFile == null) {
            return;
        }
        Map<PsiElement, FoldingDescriptor> ranges = null;
        for (Info info : this.myInfos) {
            FoldingDescriptor descriptor;
            PsiElement element = FoldingPolicy.restoreBySignature(psiFile, info.signature);
            if (element == null || !element.isValid()) continue;
            if (ranges == null) {
                ranges = DocumentFoldingInfo.buildRanges(editor, psiFile);
            }
            if ((descriptor = (FoldingDescriptor)ranges.get(element)) == null) continue;
            TextRange range = descriptor.getRange();
            FoldRegion region = FoldingUtil.findFoldRegion((Editor)editor, (int)range.getStartOffset(), (int)range.getEndOffset());
            DocumentFoldingInfo.expandRegionBlessForNewLife(editor, region, info.expanded);
        }
        for (RangeMarker marker : this.myRangeMarkers) {
            if (!marker.isValid() || marker.getStartOffset() == marker.getEndOffset()) continue;
            FoldRegion region = FoldingUtil.findFoldRegion((Editor)editor, (int)marker.getStartOffset(), (int)marker.getEndOffset());
            FoldingInfo info = (FoldingInfo)marker.getUserData(FOLDING_INFO_KEY);
            if (region == null) {
                if (info != null) {
                    region = editor.getFoldingModel().addFoldRegion(marker.getStartOffset(), marker.getEndOffset(), info.placeHolder);
                }
                if (region == null) {
                    return;
                }
            }
            boolean state = info != null && info.expanded;
            DocumentFoldingInfo.expandRegionBlessForNewLife(editor, region, state);
        }
    }

    private static void expandRegionBlessForNewLife(@NotNull Editor editor, @Nullable FoldRegion region, boolean expanded) {
        if (editor == null) {
            DocumentFoldingInfo.$$$reportNull$$$0(4);
        }
        if (region != null) {
            int offset;
            if (!CodeFoldingManagerImpl.isFoldingsInitializedInEditor(editor) && (offset = editor.getCaretModel().getOffset()) > region.getStartOffset() && offset < region.getEndOffset()) {
                expanded = true;
            }
            FoldingKeys.ZOMBIE_REGION_KEY.set((UserDataHolder)region, null);
            region.setExpanded(expanded);
        }
    }

    @NotNull
    private static Map<PsiElement, FoldingDescriptor> buildRanges(@NotNull Editor editor, @NotNull PsiFile psiFile) {
        if (editor == null) {
            DocumentFoldingInfo.$$$reportNull$$$0(5);
        }
        if (psiFile == null) {
            DocumentFoldingInfo.$$$reportNull$$$0(6);
        }
        FoldingBuilder foldingBuilder = LanguageFolding.INSTANCE.forLanguage(psiFile.getLanguage());
        FileASTNode node = psiFile.getNode();
        if (node == null) {
            Map<PsiElement, FoldingDescriptor> map = Collections.emptyMap();
            if (map == null) {
                DocumentFoldingInfo.$$$reportNull$$$0(7);
            }
            return map;
        }
        FoldingDescriptor[] descriptors = LanguageFolding.buildFoldingDescriptors((FoldingBuilder)foldingBuilder, (PsiElement)psiFile, (Document)editor.getDocument(), (boolean)true);
        HashMap<PsiElement, FoldingDescriptor> ranges = new HashMap<PsiElement, FoldingDescriptor>();
        for (FoldingDescriptor descriptor : descriptors) {
            ASTNode ast = descriptor.getElement();
            PsiElement psi = ast.getPsi();
            if (psi == null) continue;
            ranges.put(psi, descriptor);
        }
        HashMap<PsiElement, FoldingDescriptor> hashMap = ranges;
        if (hashMap == null) {
            DocumentFoldingInfo.$$$reportNull$$$0(8);
        }
        return hashMap;
    }

    void clear() {
        this.myInfos.clear();
        for (RangeMarker marker : this.myRangeMarkers) {
            marker.dispose();
        }
        this.myRangeMarkers.clear();
    }

    void writeExternal(@NotNull Element element) {
        if (element == null) {
            DocumentFoldingInfo.$$$reportNull$$$0(9);
        }
        if (this.myInfos.isEmpty() && this.myRangeMarkers.isEmpty()) {
            return;
        }
        for (Info info : this.myInfos) {
            Element e = new Element(ELEMENT_TAG);
            e.setAttribute(SIGNATURE_ATT, info.signature);
            if (info.expanded) {
                e.setAttribute(EXPANDED_ATT, Boolean.toString(true));
            }
            element.addContent(e);
        }
        String date = null;
        for (RangeMarker marker : this.myRangeMarkers) {
            FoldingInfo fi = (FoldingInfo)marker.getUserData(FOLDING_INFO_KEY);
            boolean state = fi != null && fi.expanded;
            Element e = new Element(MARKER_TAG);
            if (date == null) {
                date = this.getTimeStamp();
            }
            if (date.isEmpty()) continue;
            e.setAttribute(DATE_ATT, date);
            e.setAttribute(EXPANDED_ATT, Boolean.toString(state));
            String signature = marker.getStartOffset() + ":" + marker.getEndOffset();
            e.setAttribute(SIGNATURE_ATT, signature);
            String placeHolderText = fi == null ? DEFAULT_PLACEHOLDER : fi.placeHolder;
            e.setAttribute(PLACEHOLDER_ATT, XmlStringUtil.escapeIllegalXmlChars((String)placeHolderText));
            element.addContent(e);
        }
    }

    void readExternal(@NotNull Element element) {
        if (element == null) {
            DocumentFoldingInfo.$$$reportNull$$$0(10);
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            this.clear();
            if (!this.file.isValid()) {
                return;
            }
            Document document = FileDocumentManager.getInstance().getDocument(this.file);
            if (document == null) {
                return;
            }
            WhiteSpaceFormattingStrategy whiteSpaceFormattingStrategy = WhiteSpaceFormattingStrategyFactory.DEFAULT_STRATEGY;
            boolean removeVFmtZombieFoldings = VisualFormattingLayerService.shouldRemoveZombieFoldings();
            String date = null;
            for (Element e : element.getChildren()) {
                String signature = e.getAttributeValue(SIGNATURE_ATT);
                if (signature == null) continue;
                boolean expanded = Boolean.parseBoolean(e.getAttributeValue(EXPANDED_ATT));
                if (ELEMENT_TAG.equals(e.getName())) {
                    this.myInfos.add(new Info(signature, expanded));
                    continue;
                }
                if (MARKER_TAG.equals(e.getName())) {
                    if (date == null) {
                        date = this.getTimeStamp();
                    }
                    if (date.isEmpty() || !date.equals(e.getAttributeValue(DATE_ATT)) || FileDocumentManager.getInstance().isDocumentUnsaved(document)) continue;
                    StringTokenizer tokenizer = new StringTokenizer(signature, ":");
                    try {
                        String placeHolderText;
                        int start = Integer.valueOf(tokenizer.nextToken());
                        int end = Integer.valueOf(tokenizer.nextToken());
                        if (start < 0 || end >= document.getTextLength() || start > end) continue;
                        String placeholderAttributeValue = e.getAttributeValue(PLACEHOLDER_ATT);
                        String string = placeHolderText = placeholderAttributeValue == null ? DEFAULT_PLACEHOLDER : XmlStringUtil.unescapeIllegalXmlChars((String)placeholderAttributeValue);
                        if (removeVFmtZombieFoldings && placeHolderText.isEmpty() && whiteSpaceFormattingStrategy.check((CharSequence)document.getText(), start, end) >= end) continue;
                        RangeMarker marker = document.createRangeMarker(start, end);
                        this.myRangeMarkers.add(marker);
                        FoldingInfo fi = new FoldingInfo(placeHolderText, expanded);
                        marker.putUserData(FOLDING_INFO_KEY, (Object)fi);
                    }
                    catch (NoSuchElementException exc) {
                        LOG.error((Throwable)exc);
                    }
                    continue;
                }
                throw new IllegalStateException("unknown tag: " + e.getName());
            }
        });
    }

    private String getTimeStamp() {
        if (!this.file.isValid()) {
            return "";
        }
        return Long.toString(this.file.getTimeStamp());
    }

    public int hashCode() {
        int result = this.myProject.hashCode();
        result = 31 * result + (this.file != null ? this.file.hashCode() : 0);
        result = 31 * result + this.myInfos.hashCode();
        result = 31 * result + this.myRangeMarkers.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentFoldingInfo info = (DocumentFoldingInfo)o;
        if (this.file != null ? !this.file.equals(info.file) : info.file != null) {
            return false;
        }
        if (!this.myProject.equals((Object)info.myProject) || !this.myInfos.equals(info.myInfos)) {
            return false;
        }
        if (this.myRangeMarkers.size() != info.myRangeMarkers.size()) {
            return false;
        }
        for (int i = 0; i < this.myRangeMarkers.size(); ++i) {
            FoldingInfo ofi;
            RangeMarker other;
            RangeMarker marker = this.myRangeMarkers.get(i);
            if (marker == (other = info.myRangeMarkers.get(i)) || !marker.isValid() || !other.isValid()) continue;
            if (!TextRange.areSegmentsEqual((Segment)marker, (Segment)other)) {
                return false;
            }
            FoldingInfo fi = (FoldingInfo)marker.getUserData(FOLDING_INFO_KEY);
            if (Comparing.equal((Object)fi, (Object)(ofi = (FoldingInfo)other.getUserData(FOLDING_INFO_KEY)))) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/folding/impl/DocumentFoldingInfo";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = ELEMENT_TAG;
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/folding/impl/DocumentFoldingInfo";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "buildRanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadFromEditor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setToEditor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "expandRegionBlessForNewLife";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "buildRanges";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8 -> new IllegalStateException(string);
        };
    }

    private record Info(@NotNull String signature, boolean expanded) {
        @NotNull
        private final String signature;

        private Info(@NotNull String signature, boolean expanded) {
            if (signature == null) {
                Info.$$$reportNull$$$0(0);
            }
        }

        @NotNull
        public String signature() {
            String string = this.signature;
            if (string == null) {
                Info.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = DocumentFoldingInfo.SIGNATURE_ATT;
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/folding/impl/DocumentFoldingInfo$Info";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/folding/impl/DocumentFoldingInfo$Info";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = DocumentFoldingInfo.SIGNATURE_ATT;
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private record FoldingInfo(@NotNull String placeHolder, boolean expanded) {
        @NotNull
        private final String placeHolder;

        private FoldingInfo(@NotNull String placeHolder, boolean expanded) {
            if (placeHolder == null) {
                FoldingInfo.$$$reportNull$$$0(0);
            }
        }

        @NotNull
        public String placeHolder() {
            String string = this.placeHolder;
            if (string == null) {
                FoldingInfo.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "placeHolder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/folding/impl/DocumentFoldingInfo$FoldingInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/folding/impl/DocumentFoldingInfo$FoldingInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "placeHolder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

