/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.codeInsight.folding.impl.DocumentFoldingInfo;
import com.intellij.codeInsight.folding.impl.EditorFoldingInfo;
import com.intellij.codeInsight.folding.impl.FoldingUpdate;
import com.intellij.codeInsight.folding.impl.FoldingUtil;
import com.intellij.codeInsight.folding.impl.UpdateFoldRegionsOperation;
import com.intellij.lang.folding.CustomFoldingProvider;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.LanguageFolding;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.CodeFoldingState;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.psi.LanguageInjector;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.KeyedLazyInstance;
import com.intellij.util.SlowOperations;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.WeakList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class CodeFoldingManagerImpl
extends CodeFoldingManager
implements Disposable {
    private static final Key<Boolean> FOLDING_STATE_KEY = Key.create((String)"FOLDING_STATE_KEY");
    private static final Key<Boolean> ASYNC_FOLDING_UPDATE = Key.create((String)"ASYNC_FOLDING_UPDATE");
    private static final Key<Map<TextRange, Boolean>> ASYNC_FOLDING_CACHE = Key.create((String)"ASYNC_FOLDING_CACHE");
    private static final Key<Boolean> AUTO_CREATED = Key.create((String)"AUTO_CREATED");
    private static final Key<Boolean> FRONTEND_CREATED = Key.create((String)"FRONTEND_CREATED");
    private static final Key<Boolean> NOT_PERSISTENT = Key.create((String)"NOT_PERSISTENT");
    private final Project myProject;
    private final Collection<Document> myDocumentsWithFoldingInfo = new WeakList();
    private final Key<DocumentFoldingInfo> myFoldingInfoInDocumentKey = Key.create((String)"FOLDING_INFO_IN_DOCUMENT_KEY");

    public CodeFoldingManagerImpl(final Project project) {
        this.myProject = project;
        LanguageFolding.EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<KeyedLazyInstance<FoldingBuilder>>(){

            public void extensionAdded(@NotNull KeyedLazyInstance<FoldingBuilder> extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                for (FileEditor fileEditor : FileEditorManager.getInstance((Project)project).getAllEditors()) {
                    if (!(fileEditor instanceof TextEditor)) continue;
                    CodeFoldingManagerImpl.this.scheduleAsyncFoldingUpdate(((TextEditor)fileEditor).getEditor());
                }
            }

            public void extensionRemoved(@NotNull KeyedLazyInstance<FoldingBuilder> extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(3);
                }
                for (FileEditor fileEditor : FileEditorManager.getInstance((Project)project).getAllEditors()) {
                    if (!(fileEditor instanceof TextEditor)) continue;
                    CodeFoldingManagerImpl.this.updateFoldRegions(((TextEditor)fileEditor).getEditor());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "extension";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInsight/folding/impl/CodeFoldingManagerImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this);
        Runnable listener = () -> {
            for (FileEditor fileEditor : FileEditorManager.getInstance((Project)project).getAllEditors()) {
                if (!(fileEditor instanceof TextEditor)) continue;
                FoldingUpdate.clearFoldingCache(((TextEditor)fileEditor).getEditor());
            }
        };
        MultiHostInjector.MULTIHOST_INJECTOR_EP_NAME.addChangeListener((AreaInstance)project, listener, (Disposable)this);
        LanguageInjector.EXTENSION_POINT_NAME.addChangeListener(listener, (Disposable)this);
        CustomFoldingProvider.EP_NAME.addChangeListener(listener, (Disposable)this);
    }

    public void dispose() {
        for (Document document : this.myDocumentsWithFoldingInfo) {
            if (document == null) continue;
            document.putUserData(this.myFoldingInfoInDocumentKey, null);
        }
    }

    @Override
    @RequiresEdt
    public void releaseFoldings(@NotNull Editor editor) {
        if (editor == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(0);
        }
        ThreadingAssertions.assertEventDispatchThread();
        EditorFoldingInfo.disposeForEditor(editor);
    }

    @Override
    public void buildInitialFoldings(@NotNull Editor editor) {
        Project project;
        if (editor == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(1);
        }
        if ((project = editor.getProject()) == null || !project.equals((Object)this.myProject) || editor.isDisposed()) {
            return;
        }
        if (!((FoldingModelEx)editor.getFoldingModel()).isFoldingEnabled()) {
            return;
        }
        if (!FoldingUpdate.supportsDumbModeFolding(editor)) {
            return;
        }
        Document document = editor.getDocument();
        PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(document);
        CodeFoldingState foldingState = this.buildInitialFoldings(document);
        if (foldingState != null) {
            foldingState.setToEditor(editor);
        }
    }

    @Override
    @Nullable
    public CodeFoldingState buildInitialFoldings(@NotNull Document document) {
        if (document == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        if (this.myProject.isDisposed()) {
            return null;
        }
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)this.myProject);
        if (psiDocumentManager.isUncommited(document)) {
            return null;
        }
        PsiFile file = psiDocumentManager.getPsiFile(document);
        if (file == null || !file.isValid() || !file.getViewProvider().isPhysical() && !ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        List<FoldingUpdate.RegionInfo> regionInfos = FoldingUpdate.getFoldingsFor(file, true);
        boolean supportsDumbModeFolding = FoldingUpdate.supportsDumbModeFolding(file);
        long modStamp = document.getModificationStamp();
        return editor -> {
            ThreadingAssertions.assertEventDispatchThread();
            if (this.myProject.isDisposed() || editor.isDisposed() || modStamp != document.getModificationStamp()) {
                return;
            }
            FoldingModelEx foldingModel = (FoldingModelEx)editor.getFoldingModel();
            if (!foldingModel.isFoldingEnabled()) {
                return;
            }
            if (CodeFoldingManagerImpl.isFoldingsInitializedInEditor(editor)) {
                return;
            }
            if (DumbService.isDumb((Project)this.myProject) && !supportsDumbModeFolding) {
                return;
            }
            this.updateAndInitFolding(editor, foldingModel, file, regionInfos);
        };
    }

    private void updateAndInitFolding(Editor editor, @NotNull FoldingModelEx foldingModel, PsiFile file, List<FoldingUpdate.RegionInfo> regionInfos) {
        if (foldingModel == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(3);
        }
        foldingModel.runBatchFoldingOperationDoNotCollapseCaret((Runnable)new UpdateFoldRegionsOperation(this.myProject, editor, file, regionInfos, UpdateFoldRegionsOperation.ApplyDefaultStateMode.YES, false, false));
        try (AccessToken ignore = SlowOperations.knownIssue((String)"IDEA-319892, EA-838676");){
            this.initFolding(editor);
        }
    }

    @Override
    @Nullable
    public Boolean isCollapsedByDefault(@NotNull FoldRegion region) {
        if (region == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(4);
        }
        return CodeFoldingManagerImpl.getCollapsedByDef(region);
    }

    @Override
    @Nullable
    public Boolean keepExpandedOnFirstCollapseAll(@NotNull FoldRegion region) {
        if (region == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(5);
        }
        return (Boolean)region.getUserData(UpdateFoldRegionsOperation.KEEP_EXPANDED_ON_FIRST_COLLAPSE_ALL);
    }

    public void markForUpdate(FoldRegion region) {
        UpdateFoldRegionsOperation.UPDATE_REGION.set((UserDataHolder)region, (Object)Boolean.TRUE);
    }

    public void markUpdated(FoldRegion region) {
        UpdateFoldRegionsOperation.UPDATE_REGION.set((UserDataHolder)region, null);
    }

    public static void markAsAutoCreated(@NotNull FoldRegion region) {
        if (region == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(6);
        }
        AUTO_CREATED.set((UserDataHolder)region, (Object)true);
    }

    public static boolean isAutoCreated(@Nullable FoldRegion region) {
        return AUTO_CREATED.isIn((UserDataHolder)region);
    }

    public static void markAsFrontendCreated(@NotNull FoldRegion region) {
        if (region == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(7);
        }
        FRONTEND_CREATED.set((UserDataHolder)region, (Object)true);
    }

    public static boolean isFrontendCreated(@Nullable FoldRegion region) {
        return FRONTEND_CREATED.isIn((UserDataHolder)region);
    }

    public static void markAsCanBeRemovedWhenCollapsed(@NotNull FoldRegion region) {
        if (region == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(8);
        }
        UpdateFoldRegionsOperation.CAN_BE_REMOVED_WHEN_COLLAPSED.set((UserDataHolder)region, (Object)true);
    }

    public static boolean canBeRemovedWhenCollapsed(@Nullable FoldRegion region) {
        return UpdateFoldRegionsOperation.CAN_BE_REMOVED_WHEN_COLLAPSED.get((UserDataHolder)region) == Boolean.TRUE;
    }

    public static Boolean getCollapsedByDef(@NotNull FoldRegion region) {
        if (region == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(9);
        }
        return (Boolean)UpdateFoldRegionsOperation.COLLAPSED_BY_DEFAULT.get((UserDataHolder)region);
    }

    public static void setCollapsedByDef(@NotNull FoldRegion region, boolean isCollapsed) {
        if (region == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(10);
        }
        UpdateFoldRegionsOperation.COLLAPSED_BY_DEFAULT.set((UserDataHolder)region, (Object)isCollapsed);
    }

    public static void markAsNotPersistent(@NotNull FoldRegion region) {
        if (region == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(11);
        }
        NOT_PERSISTENT.set((UserDataHolder)region, (Object)true);
    }

    public static boolean isNotPersistent(@Nullable FoldRegion region) {
        return NOT_PERSISTENT.isIn((UserDataHolder)region);
    }

    public static Map<TextRange, Boolean> getAsyncExpandStatusMap(@Nullable Editor editor) {
        return (Map)ASYNC_FOLDING_CACHE.get((UserDataHolder)editor);
    }

    public static void setAsyncExpandStatusMap(@Nullable Editor editor, @Nullable Map<TextRange, Boolean> regionExpansionStates) {
        ASYNC_FOLDING_CACHE.set((UserDataHolder)editor, regionExpansionStates);
    }

    public static void markAsAsyncFoldingUpdater(@Nullable Editor editor) {
        ASYNC_FOLDING_UPDATE.set((UserDataHolder)editor, (Object)true);
    }

    public static boolean isAsyncFoldingUpdater(@Nullable Editor editor) {
        return ASYNC_FOLDING_UPDATE.get((UserDataHolder)editor) == Boolean.TRUE;
    }

    @Override
    public void scheduleAsyncFoldingUpdate(@NotNull Editor editor) {
        if (editor == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(12);
        }
        FoldingUpdate.clearFoldingCache(editor);
        DaemonCodeAnalyzerEx.getInstanceEx((Project)this.myProject).restart((Object)"CodeFoldingManagerImpl.scheduleAsyncFoldingUpdate");
    }

    private void initFolding(@NotNull Editor editor) {
        if (editor == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(13);
        }
        Document document = editor.getDocument();
        editor.getFoldingModel().runBatchFoldingOperation(() -> {
            DocumentFoldingInfo documentFoldingInfo = this.getDocumentFoldingInfo(document);
            EditorFactory.getInstance().editors(document, this.myProject).filter(otherEditor -> otherEditor != editor && CodeFoldingManagerImpl.isFoldingsInitializedInEditor(otherEditor)).findFirst().ifPresent(documentFoldingInfo::loadFromEditor);
            documentFoldingInfo.setToEditor(editor);
            documentFoldingInfo.clear();
            editor.putUserData(FOLDING_STATE_KEY, (Object)Boolean.TRUE);
        });
    }

    @Override
    @Nullable
    public FoldRegion findFoldRegion(@NotNull Editor editor, int startOffset, int endOffset) {
        if (editor == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(14);
        }
        return FoldingUtil.findFoldRegion((Editor)editor, (int)startOffset, (int)endOffset);
    }

    @Override
    public FoldRegion[] getFoldRegionsAtOffset(@NotNull Editor editor, int offset) {
        if (editor == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(15);
        }
        return FoldingUtil.getFoldRegionsAtOffset((Editor)editor, (int)offset);
    }

    @Override
    public void updateFoldRegions(@NotNull Editor editor) {
        if (editor == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(16);
        }
        this.updateFoldRegions(editor, false);
    }

    public void updateFoldRegions(Editor editor, boolean quick) {
        if (!editor.getSettings().isAutoCodeFoldingEnabled()) {
            return;
        }
        PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(editor.getDocument());
        Runnable runnable = this.updateFoldRegions(editor, false, quick);
        if (runnable != null) {
            runnable.run();
        }
    }

    @Override
    @Nullable
    public Runnable updateFoldRegionsAsync(@NotNull Editor editor, boolean firstTime) {
        if (editor == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(17);
        }
        if (!editor.getSettings().isAutoCodeFoldingEnabled()) {
            return null;
        }
        Runnable runnable = this.updateFoldRegions(editor, firstTime, false);
        return () -> {
            if (runnable != null) {
                runnable.run();
            }
            if (firstTime && !CodeFoldingManagerImpl.isFoldingsInitializedInEditor(editor)) {
                this.initFolding(editor);
            }
        };
    }

    @Nullable
    private Runnable updateFoldRegions(@NotNull Editor editor, boolean applyDefaultState, boolean quick) {
        PsiFile file;
        if (editor == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(18);
        }
        return (file = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(editor.getDocument())) == null ? null : FoldingUpdate.updateFoldRegions(editor, file, applyDefaultState, quick);
    }

    @Override
    public CodeFoldingState saveFoldingState(@NotNull Editor editor) {
        if (editor == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(19);
        }
        ThreadingAssertions.assertEventDispatchThread();
        DocumentFoldingInfo info = this.getDocumentFoldingInfo(editor.getDocument());
        if (CodeFoldingManagerImpl.isFoldingsInitializedInEditor(editor)) {
            info.loadFromEditor(editor);
        }
        return info;
    }

    @Override
    public void restoreFoldingState(@NotNull Editor editor, @NotNull CodeFoldingState state) {
        if (editor == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(20);
        }
        if (state == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(21);
        }
        ThreadingAssertions.assertEventDispatchThread();
        if (CodeFoldingManagerImpl.isFoldingsInitializedInEditor(editor)) {
            state.setToEditor(editor);
        }
    }

    @Override
    public void writeFoldingState(@NotNull CodeFoldingState state, @NotNull Element element) {
        if (state == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(22);
        }
        if (element == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(23);
        }
        if (state instanceof DocumentFoldingInfo) {
            ((DocumentFoldingInfo)state).writeExternal(element);
        }
    }

    @Override
    public CodeFoldingState readFoldingState(@NotNull Element element, @NotNull Document document) {
        if (element == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(24);
        }
        if (document == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(25);
        }
        DocumentFoldingInfo info = this.getDocumentFoldingInfo(document);
        info.readExternal(element);
        return info;
    }

    @NotNull
    private DocumentFoldingInfo getDocumentFoldingInfo(@NotNull Document document) {
        DocumentFoldingInfo info;
        if (document == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(26);
        }
        if ((info = (DocumentFoldingInfo)document.getUserData(this.myFoldingInfoInDocumentKey)) == null) {
            info = new DocumentFoldingInfo(this.myProject, document);
            DocumentFoldingInfo written = (DocumentFoldingInfo)((UserDataHolderEx)document).putUserDataIfAbsent(this.myFoldingInfoInDocumentKey, (Object)info);
            if (written == info) {
                this.myDocumentsWithFoldingInfo.add(document);
            } else {
                info = written;
            }
        }
        DocumentFoldingInfo documentFoldingInfo = info;
        if (documentFoldingInfo == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(27);
        }
        return documentFoldingInfo;
    }

    static boolean isFoldingsInitializedInEditor(@NotNull Editor editor) {
        if (editor == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(28);
        }
        return Boolean.TRUE.equals(editor.getUserData(FOLDING_STATE_KEY));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 27 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foldingModel";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "region";
                break;
            }
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/folding/impl/CodeFoldingManagerImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/folding/impl/CodeFoldingManagerImpl";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocumentFoldingInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "releaseFoldings";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildInitialFoldings";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateAndInitFolding";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isCollapsedByDefault";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "keepExpandedOnFirstCollapseAll";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "markAsAutoCreated";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "markAsFrontendCreated";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "markAsCanBeRemovedWhenCollapsed";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCollapsedByDef";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setCollapsedByDef";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "markAsNotPersistent";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "scheduleAsyncFoldingUpdate";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "initFolding";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findFoldRegion";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getFoldRegionsAtOffset";
                break;
            }
            case 16: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "updateFoldRegions";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "updateFoldRegionsAsync";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "saveFoldingState";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "restoreFoldingState";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "writeFoldingState";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "readFoldingState";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentFoldingInfo";
                break;
            }
            case 27: {
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isFoldingsInitializedInEditor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 27 -> new IllegalStateException(string);
        };
    }
}

