/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.folding.impl.CodeFoldingRegion;
import com.intellij.codeInsight.folding.impl.CodeFoldingZombie;
import com.intellij.openapi.editor.impl.zombie.Necromancy;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.IOUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0018\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0002J\u0018\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0002J\u0018\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0002J\u0018\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001f\u0010\u0015\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001aH\u0002J\u0017\u0010\u001d\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001c\u001a\u00020\u001aH\u0002\u00a2\u0006\u0002\u0010\u001e\u00a8\u0006\u001f"}, d2={"Lcom/intellij/codeInsight/folding/impl/CodeFoldingNecromancy;", "Lcom/intellij/openapi/editor/impl/zombie/Necromancy;", "Lcom/intellij/codeInsight/folding/impl/CodeFoldingZombie;", "<init>", "()V", "spellLevel", "", "isDeepBury", "", "buryZombie", "", "grave", "Ljava/io/DataOutput;", "zombie", "writeRegionCount", "output", "writeRegions", "writeGroupedRegions", "writeRegion", "region", "Lcom/intellij/codeInsight/folding/impl/CodeFoldingRegion;", "writeGroupId", "groupId", "", "(Ljava/io/DataOutput;Ljava/lang/Long;)V", "exhumeZombie", "Ljava/io/DataInput;", "read", "input", "readGroupId", "(Ljava/io/DataInput;)Ljava/lang/Long;", "intellij.platform.foldings"})
@SourceDebugExtension(value={"SMAP\nCodeFoldingNecromancy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeFoldingNecromancy.kt\ncom/intellij/codeInsight/folding/impl/CodeFoldingNecromancy\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,94:1\n1#2:95\n*E\n"})
public final class CodeFoldingNecromancy
implements Necromancy<CodeFoldingZombie> {
    @NotNull
    public static final CodeFoldingNecromancy INSTANCE = new CodeFoldingNecromancy();

    private CodeFoldingNecromancy() {
    }

    public int spellLevel() {
        return 2;
    }

    public boolean isDeepBury() {
        return false;
    }

    public void buryZombie(@NotNull DataOutput grave, @NotNull CodeFoldingZombie zombie) {
        Intrinsics.checkNotNullParameter((Object)grave, (String)"grave");
        Intrinsics.checkNotNullParameter((Object)zombie, (String)"zombie");
        this.writeRegionCount(grave, zombie);
        this.writeRegions(grave, zombie);
        this.writeGroupedRegions(grave, zombie);
    }

    /*
     * WARNING - void declaration
     */
    private final void writeRegionCount(DataOutput output, CodeFoldingZombie zombie) {
        int n;
        Iterable iterable = zombie.getGroupedRegions().values();
        int n2 = zombie.getRegions().size();
        int n3 = 0;
        for (Object t : iterable) {
            void it;
            List list = (List)t;
            n = n3;
            boolean bl = false;
            int n4 = it.size();
            n3 = n + n4;
        }
        n = n3;
        int regionCount = n2 + n;
        DataInputOutputUtil.writeINT((DataOutput)output, (int)regionCount);
    }

    private final void writeRegions(DataOutput output, CodeFoldingZombie zombie) {
        for (CodeFoldingRegion region : zombie.getRegions()) {
            this.writeRegion(output, region);
        }
    }

    private final void writeGroupedRegions(DataOutput output, CodeFoldingZombie zombie) {
        Iterator<Map.Entry<Long, List<CodeFoldingRegion>>> iterator = zombie.getGroupedRegions().entrySet().iterator();
        while (iterator.hasNext()) {
            List<CodeFoldingRegion> regions = iterator.next().getValue();
            for (CodeFoldingRegion region : regions) {
                this.writeRegion(output, region);
            }
        }
    }

    private final void writeRegion(DataOutput output, CodeFoldingRegion region) {
        DataInputOutputUtil.writeINT((DataOutput)output, (int)region.getStartOffset());
        DataInputOutputUtil.writeINT((DataOutput)output, (int)region.getEndOffset());
        IOUtil.writeUTF((DataOutput)output, (String)region.getPlaceholderText());
        this.writeGroupId(output, region.getGroupId());
        output.writeBoolean(region.getNeverExpands());
        output.writeBoolean(region.isExpanded());
        output.writeBoolean(region.isCollapsedByDefault());
        output.writeBoolean(region.isFrontendCreated());
    }

    private final void writeGroupId(DataOutput output, Long groupId) {
        if (groupId == null) {
            output.writeBoolean(false);
        } else {
            output.writeBoolean(true);
            DataInputOutputUtil.writeLONG((DataOutput)output, (long)groupId);
        }
    }

    @NotNull
    public CodeFoldingZombie exhumeZombie(@NotNull DataInput grave) {
        Intrinsics.checkNotNullParameter((Object)grave, (String)"grave");
        int regionCount = DataInputOutputUtil.readINT((DataInput)grave);
        ArrayList regions = new ArrayList();
        HashMap groupedRegions = new HashMap();
        int n = 0;
        while (n < regionCount) {
            int it = n++;
            boolean bl = false;
            CodeFoldingRegion region = INSTANCE.read(grave);
            CodeFoldingZombie.Companion.putRegion(region, regions, groupedRegions);
        }
        return new CodeFoldingZombie(regions, groupedRegions);
    }

    private final CodeFoldingRegion read(DataInput input) {
        int start = DataInputOutputUtil.readINT((DataInput)input);
        int end = DataInputOutputUtil.readINT((DataInput)input);
        String placeholder = IOUtil.readUTF((DataInput)input);
        Long groupId = this.readGroupId(input);
        boolean neverExpands = input.readBoolean();
        boolean isExpanded = input.readBoolean();
        boolean isCollapsedByDefault = input.readBoolean();
        boolean isFrontendCreated = input.readBoolean();
        Intrinsics.checkNotNull((Object)placeholder);
        return new CodeFoldingRegion(start, end, placeholder, groupId, neverExpands, isExpanded, isCollapsedByDefault, isFrontendCreated);
    }

    private final Long readGroupId(DataInput input) {
        return input.readBoolean() ? Long.valueOf(DataInputOutputUtil.readLONG((DataInput)input)) : null;
    }
}

