/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.folding.impl.EditorFoldingInfo;
import com.intellij.codeInsight.folding.impl.FoldingPolicy;
import com.intellij.codeInsight.folding.impl.UpdateFoldRegionsOperation;
import com.intellij.diagnostic.CoreAttachmentFactory;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.Language;
import com.intellij.lang.folding.CompositeFoldingBuilder;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.folding.LanguageFolding;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.source.tree.injected.FoldingRegionWindow;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class FoldingUpdate {
    private static final Logger LOG = Logger.getInstance(FoldingUpdate.class);
    private static final Key<CachedValue<Runnable>> CODE_FOLDING_KEY = Key.create((String)"code folding");
    public static final Key<Boolean> INJECTED_CODE_FOLDING_ENABLED = Key.create((String)"injected code folding is enabled");
    private static final Key<Object> LAST_UPDATE_INJECTED_STAMP_KEY = Key.create((String)"LAST_UPDATE_INJECTED_STAMP_KEY");

    private FoldingUpdate() {
    }

    @Nullable
    static Runnable updateFoldRegions(@NotNull Editor editor, @NotNull PsiFile file, boolean applyDefaultState, boolean quick) {
        Getter cached;
        if (editor == null) {
            FoldingUpdate.$$$reportNull$$$0(0);
        }
        if (file == null) {
            FoldingUpdate.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Project project = file.getProject();
        Document document = editor.getDocument();
        LOG.assertTrue(!PsiDocumentManager.getInstance((Project)project).isUncommited(document));
        if (document.getTextLength() != file.getTextLength()) {
            LOG.error(DebugUtil.diagnosePsiDocumentInconsistency((PsiElement)file, (Document)document));
            return EmptyRunnable.INSTANCE;
        }
        CachedValue value = (CachedValue)editor.getUserData(CODE_FOLDING_KEY);
        if (value != null && !applyDefaultState && (cached = value.getUpToDateOrNull()) != null) {
            return (Runnable)cached.get();
        }
        if (quick || applyDefaultState) {
            return (Runnable)FoldingUpdate.getUpdateResult(file, document, quick, project, editor, applyDefaultState).getValue();
        }
        return (Runnable)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)editor, CODE_FOLDING_KEY, () -> {
            PsiFile file1 = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
            return FoldingUpdate.getUpdateResult(file1, document, false, project, editor, false);
        }, false);
    }

    private static CachedValueProvider.Result<Runnable> getUpdateResult(@NotNull PsiFile file, @NotNull Document document, boolean quick, Project project, Editor editor, boolean applyDefaultState) {
        if (file == null) {
            FoldingUpdate.$$$reportNull$$$0(2);
        }
        if (document == null) {
            FoldingUpdate.$$$reportNull$$$0(3);
        }
        PsiUtilCore.ensureValid((PsiElement)file);
        List<RegionInfo> elementsToFold = FoldingUpdate.getFoldingsFor(file, quick);
        UpdateFoldRegionsOperation operation = new UpdateFoldRegionsOperation(project, editor, file, elementsToFold, FoldingUpdate.applyDefaultStateMode(applyDefaultState), !applyDefaultState, false);
        int documentLength = document.getTextLength();
        AtomicBoolean alreadyExecuted = new AtomicBoolean();
        Runnable runnable = () -> {
            if (alreadyExecuted.compareAndSet(false, true)) {
                if (documentLength != document.getTextLength() || !PsiDocumentManager.getInstance((Project)project).isCommitted(document)) {
                    FoldingUpdate.reportUnexpectedDocumentChange(file, document, documentLength);
                }
                editor.getFoldingModel().runBatchFoldingOperationDoNotCollapseCaret((Runnable)operation);
            }
        };
        HashSet<Object> dependencies = new HashSet<Object>();
        dependencies.add(file);
        dependencies.add(editor.getFoldingModel());
        for (RegionInfo info : elementsToFold) {
            dependencies.addAll(info.descriptor.getDependencies());
        }
        return CachedValueProvider.Result.create((Object)runnable, (Object[])ArrayUtil.toObjectArray(dependencies));
    }

    private static void reportUnexpectedDocumentChange(@NotNull PsiFile file, @NotNull Document document, int prevLength) {
        if (file == null) {
            FoldingUpdate.$$$reportNull$$$0(4);
        }
        if (document == null) {
            FoldingUpdate.$$$reportNull$$$0(5);
        }
        Document fileDoc = file.getViewProvider().getDocument();
        VirtualFile vFile = file.getViewProvider().getVirtualFile();
        PsiDocumentManager pdm = PsiDocumentManager.getInstance((Project)file.getProject());
        PsiFile docFile = pdm.getCachedPsiFile(document);
        LOG.error("Document has changed since fold regions were calculated:\n  lengths: " + prevLength + " vs " + document.getTextLength() + "\n  document=" + String.valueOf(document) + "\n  file.document=" + String.valueOf(fileDoc == document ? "same" : fileDoc) + "\n  document.file=" + String.valueOf(docFile == file ? "same" : docFile) + "\n  committed=" + pdm.isCommitted(document) + "\n  psiFile=" + String.valueOf(file) + "\n  vFile.length=" + (vFile.isValid() ? vFile.getLength() : -1L));
    }

    @NotNull
    private static UpdateFoldRegionsOperation.ApplyDefaultStateMode applyDefaultStateMode(boolean applyDefaultState) {
        UpdateFoldRegionsOperation.ApplyDefaultStateMode applyDefaultStateMode = applyDefaultState ? UpdateFoldRegionsOperation.ApplyDefaultStateMode.EXCEPT_CARET_REGION : UpdateFoldRegionsOperation.ApplyDefaultStateMode.NO;
        if (applyDefaultStateMode == null) {
            FoldingUpdate.$$$reportNull$$$0(6);
        }
        return applyDefaultStateMode;
    }

    @Nullable
    static Runnable updateInjectedFoldRegions(@NotNull Editor editor, @NotNull PsiFile file, boolean applyDefaultState) {
        if (editor == null) {
            FoldingUpdate.$$$reportNull$$$0(7);
        }
        if (file == null) {
            FoldingUpdate.$$$reportNull$$$0(8);
        }
        if (file instanceof PsiCompiledElement) {
            return null;
        }
        boolean codeFoldingForInjectedEnabled = editor.getUserData(INJECTED_CODE_FOLDING_ENABLED) != Boolean.FALSE;
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Project project = file.getProject();
        Document document = editor.getDocument();
        LOG.assertTrue(!PsiDocumentManager.getInstance((Project)project).isUncommited(document));
        FoldingModel foldingModel = editor.getFoldingModel();
        long timeStamp = document.getModificationStamp();
        Object lastTimeStamp = editor.getUserData(LAST_UPDATE_INJECTED_STAMP_KEY);
        if (lastTimeStamp instanceof Long && (Long)lastTimeStamp == timeStamp) {
            return null;
        }
        List injectedDocuments = InjectedLanguageManager.getInstance((Project)project).getCachedInjectedDocumentsInRange(file, file.getTextRange());
        if (injectedDocuments.isEmpty()) {
            return null;
        }
        ArrayList injectedEditors = new ArrayList();
        ArrayList injectedFiles = new ArrayList();
        ArrayList lists = new ArrayList();
        for (DocumentWindow injectedDocument : injectedDocuments) {
            if (!injectedDocument.isValid()) continue;
            InjectedLanguageUtil.enumerate((DocumentWindow)injectedDocument, (PsiFile)file, (injectedFile, places) -> {
                if (!injectedFile.isValid()) {
                    return;
                }
                Editor injectedEditor = InjectedLanguageUtil.getInjectedEditorForInjectedFile((Editor)editor, (PsiFile)injectedFile);
                if (!(injectedEditor instanceof EditorWindow)) {
                    return;
                }
                injectedEditors.add((EditorWindow)injectedEditor);
                injectedFiles.add(injectedFile);
                ArrayList map = new ArrayList();
                lists.add(map);
                if (codeFoldingForInjectedEnabled) {
                    FoldingUpdate.getFoldingsFor(injectedFile, map, false);
                }
            });
        }
        return () -> {
            ArrayList<UpdateFoldRegionsOperation> updateOperations = new ArrayList<UpdateFoldRegionsOperation>(injectedEditors.size());
            for (int i = 0; i < injectedEditors.size(); ++i) {
                EditorWindow injectedEditor = (EditorWindow)injectedEditors.get(i);
                PsiFile injectedFile = (PsiFile)injectedFiles.get(i);
                if (!injectedEditor.getDocument().isValid()) continue;
                List list = (List)lists.get(i);
                updateOperations.add(new UpdateFoldRegionsOperation(project, (Editor)injectedEditor, injectedFile, list, FoldingUpdate.applyDefaultStateMode(applyDefaultState), !applyDefaultState, true));
            }
            foldingModel.runBatchFoldingOperation(() -> {
                for (Runnable operation : updateOperations) {
                    operation.run();
                }
            });
            EditorFoldingInfo info = EditorFoldingInfo.get(editor);
            for (FoldRegion region : editor.getFoldingModel().getAllFoldRegions()) {
                FoldingRegionWindow injectedRegion = FoldingRegionWindow.getInjectedRegion(region);
                if (injectedRegion == null || injectedRegion.isValid()) continue;
                info.removeRegion(region);
            }
            editor.putUserData(LAST_UPDATE_INJECTED_STAMP_KEY, (Object)timeStamp);
        };
    }

    static boolean supportsDumbModeFolding(@NotNull Editor editor) {
        PsiFile file;
        Project project;
        if (editor == null) {
            FoldingUpdate.$$$reportNull$$$0(9);
        }
        if ((project = editor.getProject()) != null && (file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument())) != null) {
            return FoldingUpdate.supportsDumbModeFolding(file);
        }
        return true;
    }

    static boolean supportsDumbModeFolding(@NotNull PsiFile file) {
        if (file == null) {
            FoldingUpdate.$$$reportNull$$$0(10);
        }
        FileViewProvider viewProvider = file.getViewProvider();
        for (Language language : viewProvider.getLanguages()) {
            FoldingBuilder foldingBuilder = LanguageFolding.INSTANCE.forLanguage(language);
            if (foldingBuilder == null || DumbService.isDumbAware((Object)foldingBuilder)) continue;
            return false;
        }
        return true;
    }

    @VisibleForTesting
    public static List<RegionInfo> getFoldingsFor(@NotNull PsiFile file, boolean quick) {
        if (file == null) {
            FoldingUpdate.$$$reportNull$$$0(11);
        }
        if (file instanceof PsiCompiledFile) {
            file = ((PsiCompiledFile)file).getDecompiledPsiFile();
        }
        ArrayList<RegionInfo> foldingMap = new ArrayList<RegionInfo>();
        FoldingUpdate.getFoldingsFor(file, foldingMap, quick);
        return foldingMap;
    }

    private static void getFoldingsFor(@NotNull PsiFile file, @NotNull List<? super RegionInfo> elementsToFold, boolean quick) {
        FileViewProvider viewProvider;
        Document document;
        if (file == null) {
            FoldingUpdate.$$$reportNull$$$0(12);
        }
        if (elementsToFold == null) {
            FoldingUpdate.$$$reportNull$$$0(13);
        }
        if ((document = (viewProvider = file.getViewProvider()).getDocument()) == null) {
            LOG.error("No document for " + String.valueOf(viewProvider));
            return;
        }
        LOG.assertTrue(PsiDocumentManager.getInstance((Project)file.getProject()).isCommitted(document));
        int textLength = document.getTextLength();
        ArrayList hardRefToRangeMarkers = new ArrayList();
        Comparator<PsiFile> preferBaseLanguage = Comparator.comparing(f -> f.getLanguage() != viewProvider.getBaseLanguage()).thenComparing(f -> f.getLanguage().getID());
        List allFiles = ContainerUtil.sorted((Collection)viewProvider.getAllFiles(), preferBaseLanguage);
        DocumentImpl copyDoc = allFiles.size() > 1 ? new DocumentImpl(document.getImmutableCharSequence(), document instanceof DocumentImpl && ((DocumentImpl)document).acceptsSlashR(), true) : null;
        for (PsiFile psi : allFiles) {
            Language language = psi.getLanguage();
            FoldingBuilder foldingBuilder = LanguageFolding.INSTANCE.forLanguage(language);
            if (foldingBuilder == null) continue;
            if (psi.getTextLength() != textLength) {
                LOG.error(DebugUtil.diagnosePsiDocumentInconsistency((PsiElement)psi, (Document)document));
                return;
            }
            PsiFile containingFile = PsiUtilCore.getTemplateLanguageFile((PsiElement)file);
            for (FoldingDescriptor descriptor : LanguageFolding.buildFoldingDescriptors((FoldingBuilder)foldingBuilder, (PsiElement)psi, (Document)document, (boolean)quick)) {
                TextRange range;
                PsiElement psiElement = descriptor.getElement().getPsi();
                if (psiElement == null) {
                    LOG.error("No PSI for folding descriptor " + String.valueOf(descriptor));
                    continue;
                }
                if (!(foldingBuilder instanceof CompositeFoldingBuilder)) {
                    CompositeFoldingBuilder.assertSameFile((PsiFile)containingFile, (FoldingDescriptor)descriptor, (PsiElement)psiElement, (FoldingBuilder)foldingBuilder);
                }
                if ((range = descriptor.getRange()).getEndOffset() > textLength) {
                    FoldingUpdate.diagnoseIncorrectRange(psi, document, language, foldingBuilder, descriptor, psiElement);
                    continue;
                }
                if (copyDoc != null && !FoldingUpdate.addNonConflictingRegion((DocumentEx)copyDoc, range, hardRefToRangeMarkers)) continue;
                RegionInfo regionInfo = new RegionInfo(descriptor, psiElement, foldingBuilder);
                elementsToFold.add(regionInfo);
            }
        }
    }

    private static boolean addNonConflictingRegion(@NotNull DocumentEx document, @NotNull TextRange range, @NotNull List<? super RangeMarker> hardRefToRangeMarkers) {
        int end;
        int start;
        if (document == null) {
            FoldingUpdate.$$$reportNull$$$0(14);
        }
        if (range == null) {
            FoldingUpdate.$$$reportNull$$$0(15);
        }
        if (hardRefToRangeMarkers == null) {
            FoldingUpdate.$$$reportNull$$$0(16);
        }
        if (!document.processRangeMarkersOverlappingWith(start = range.getStartOffset(), end = range.getEndOffset(), rm -> !FoldingUpdate.areConflicting(range, rm.getTextRange()))) {
            return false;
        }
        RangeMarker marker = document.createRangeMarker(start, end);
        hardRefToRangeMarkers.add((RangeMarker)marker);
        return true;
    }

    private static boolean areConflicting(TextRange range1, TextRange range2) {
        if (range1.equals((Object)range2)) {
            return true;
        }
        if (range1.contains(range2) || range2.contains(range1)) {
            return false;
        }
        return range1.intersectsStrict(range2);
    }

    private static void diagnoseIncorrectRange(@NotNull PsiFile file, @NotNull Document document, @NotNull Language language, @NotNull FoldingBuilder foldingBuilder, @NotNull FoldingDescriptor descriptor, @NotNull PsiElement psiElement) {
        Attachment[] attachmentArray;
        if (file == null) {
            FoldingUpdate.$$$reportNull$$$0(17);
        }
        if (document == null) {
            FoldingUpdate.$$$reportNull$$$0(18);
        }
        if (language == null) {
            FoldingUpdate.$$$reportNull$$$0(19);
        }
        if (foldingBuilder == null) {
            FoldingUpdate.$$$reportNull$$$0(20);
        }
        if (descriptor == null) {
            FoldingUpdate.$$$reportNull$$$0(21);
        }
        if (psiElement == null) {
            FoldingUpdate.$$$reportNull$$$0(22);
        }
        String message = "Folding descriptor " + String.valueOf(descriptor) + " made by " + String.valueOf(foldingBuilder) + " for " + String.valueOf(language) + " is outside document range, PSI element: " + String.valueOf(psiElement) + ", PSI element range: " + String.valueOf(psiElement.getTextRange()) + "; " + DebugUtil.diagnosePsiDocumentInconsistency((PsiElement)psiElement, (Document)document);
        if (ApplicationManager.getApplication().isInternal()) {
            Attachment[] attachmentArray2 = new Attachment[2];
            attachmentArray2[0] = CoreAttachmentFactory.createAttachment((Document)document);
            attachmentArray = attachmentArray2;
            attachmentArray2[1] = new Attachment("psiTree.txt", DebugUtil.psiToString((PsiElement)file, (boolean)true, (boolean)true));
        } else {
            attachmentArray = Attachment.EMPTY_ARRAY;
        }
        LOG.error(message, attachmentArray);
    }

    static void clearFoldingCache(@NotNull Editor editor) {
        if (editor == null) {
            FoldingUpdate.$$$reportNull$$$0(23);
        }
        editor.putUserData(CODE_FOLDING_KEY, null);
        editor.putUserData(LAST_UPDATE_INJECTED_STAMP_KEY, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 5: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/folding/impl/FoldingUpdate";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsToFold";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hardRefToRangeMarkers";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foldingBuilder";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/folding/impl/FoldingUpdate";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "applyDefaultStateMode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateFoldRegions";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getUpdateResult";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "reportUnexpectedDocumentChange";
                break;
            }
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "updateInjectedFoldRegions";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "supportsDumbModeFolding";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getFoldingsFor";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addNonConflictingRegion";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "diagnoseIncorrectRange";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "clearFoldingCache";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }

    @ApiStatus.Internal
    public static final class RegionInfo {
        @NotNull
        public final FoldingDescriptor descriptor;
        public final PsiElement element;
        final String signature;
        final boolean collapsedByDefault;
        final boolean keepExpandedOnFirstCollapseAll;

        private RegionInfo(@NotNull FoldingDescriptor descriptor, @NotNull PsiElement psiElement, @NotNull FoldingBuilder foldingBuilder) {
            if (descriptor == null) {
                RegionInfo.$$$reportNull$$$0(0);
            }
            if (psiElement == null) {
                RegionInfo.$$$reportNull$$$0(1);
            }
            if (foldingBuilder == null) {
                RegionInfo.$$$reportNull$$$0(2);
            }
            this.descriptor = descriptor;
            this.element = psiElement;
            Boolean hardCoded = descriptor.isCollapsedByDefault();
            this.collapsedByDefault = hardCoded == null ? FoldingPolicy.isCollapsedByDefault(descriptor, foldingBuilder) : hardCoded;
            this.keepExpandedOnFirstCollapseAll = FoldingPolicy.keepExpandedOnFirstCollapseAll(descriptor, foldingBuilder);
            this.signature = RegionInfo.createSignature(psiElement);
        }

        private static String createSignature(@NotNull PsiElement element) {
            PsiFile containingFile;
            PsiElement restoredElement;
            String signature;
            if (element == null) {
                RegionInfo.$$$reportNull$$$0(3);
            }
            if ((signature = FoldingPolicy.getSignature(element)) != null && Registry.is((String)"folding.signature.validation") && !element.equals((Object)(restoredElement = FoldingPolicy.restoreBySignature(containingFile = element.getContainingFile(), signature)))) {
                StringBuilder trace = new StringBuilder();
                PsiElement restoredAgain = FoldingPolicy.restoreBySignature(containingFile, signature, trace);
                LOG.error("element: " + String.valueOf(element) + "(" + element.getText() + "); restoredElement: " + String.valueOf(restoredElement) + "; signature: '" + signature + "'; file: " + String.valueOf(containingFile) + "; injected: " + InjectedLanguageManager.getInstance((Project)element.getProject()).isInjectedFragment(containingFile) + "; languages: " + String.valueOf(containingFile.getViewProvider().getLanguages()) + "; restored again: " + String.valueOf(restoredAgain) + "; restore produces same results: " + (restoredAgain == restoredElement) + "; trace:\n" + String.valueOf(trace));
            }
            return signature;
        }

        public String toString() {
            return String.valueOf(this.descriptor) + ", collapsedByDefault=" + this.collapsedByDefault;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiElement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "foldingBuilder";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/folding/impl/FoldingUpdate$RegionInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createSignature";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

