/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl.actions;

import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.codeInsight.folding.impl.actions.BaseFoldingHandler;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ExpandAllRegionsAction
extends EditorAction
implements ActionRemoteBehaviorSpecification.Frontend {
    public ExpandAllRegionsAction() {
        super((EditorActionHandler)new BaseFoldingHandler(){

            public void doExecute(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
                if (editor == null) {
                    1.$$$reportNull$$$0(0);
                }
                Project project = editor.getProject();
                assert (project != null);
                CodeFoldingManager codeFoldingManager = CodeFoldingManager.getInstance(project);
                List<FoldRegion> regions = this.getFoldRegionsForSelection(editor, caret);
                ExpandAllRegionsAction.twoStepFoldToggling(editor, regions, region -> ExpandAllRegionsAction.expandInFirstStep(codeFoldingManager, region), true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/folding/impl/actions/ExpandAllRegionsAction$1", "doExecute"));
            }
        });
    }

    public static void twoStepFoldToggling(@NotNull Editor editor, @NotNull @NotNull List<@NotNull FoldRegion> regions, Function<@NotNull FoldRegion, @NotNull Boolean> toggleFoldingInFirstStep, boolean expand) {
        if (editor == null) {
            ExpandAllRegionsAction.$$$reportNull$$$0(0);
        }
        if (regions == null) {
            ExpandAllRegionsAction.$$$reportNull$$$0(1);
        }
        FoldingModel foldingModel = editor.getFoldingModel();
        ArrayList expandedRegions = new ArrayList();
        foldingModel.runBatchFoldingOperation(() -> {
            for (FoldRegion region : regions) {
                if (!((Boolean)toggleFoldingInFirstStep.apply(region)).booleanValue()) continue;
                region.setExpanded(expand);
                expandedRegions.add(region);
            }
        });
        for (FoldRegion expandedRegion : expandedRegions) {
            FoldRegion collapsedRegion = foldingModel.getCollapsedRegionAtOffset(expandedRegion.getStartOffset());
            if (collapsedRegion != null && collapsedRegion.shouldNeverExpand()) continue;
            return;
        }
        foldingModel.runBatchFoldingOperation(() -> {
            for (FoldRegion region : regions) {
                region.setExpanded(expand);
            }
        });
    }

    private static boolean expandInFirstStep(@NotNull CodeFoldingManager codeFoldingManager, @NotNull FoldRegion region) {
        if (codeFoldingManager == null) {
            ExpandAllRegionsAction.$$$reportNull$$$0(2);
        }
        if (region == null) {
            ExpandAllRegionsAction.$$$reportNull$$$0(3);
        }
        boolean collapsedByDefault = Objects.requireNonNullElse(codeFoldingManager.isCollapsedByDefault(region), true);
        return !region.isExpanded() && !region.shouldNeverExpand() && !collapsedByDefault;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "regions";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeFoldingManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "region";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/folding/impl/actions/ExpandAllRegionsAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "twoStepFoldToggling";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "expandInFirstStep";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

