/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.codeInsight.folding.impl.EditorFoldingInfo;
import com.intellij.lang.CodeDocumentationAwareCommenter;
import com.intellij.lang.Commenter;
import com.intellij.lang.LanguageCommenters;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiDocCommentBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class CollapseExpandDocCommentsHandler
implements CodeInsightActionHandler {
    private static final Key<Boolean> DOC_COMMENT_MARK = Key.create((String)"explicit.fold.region.doc.comment.mark");
    private final boolean myExpand;

    public static void setDocCommentMark(@NotNull FoldRegion region, boolean value) {
        if (region == null) {
            CollapseExpandDocCommentsHandler.$$$reportNull$$$0(0);
        }
        region.putUserData(DOC_COMMENT_MARK, (Object)value);
    }

    public CollapseExpandDocCommentsHandler(boolean isExpand) {
        this.myExpand = isExpand;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        if (project == null) {
            CollapseExpandDocCommentsHandler.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            CollapseExpandDocCommentsHandler.$$$reportNull$$$0(2);
        }
        if (psiFile == null) {
            CollapseExpandDocCommentsHandler.$$$reportNull$$$0(3);
        }
        CodeFoldingManager foldingManager = CodeFoldingManager.getInstance(project);
        foldingManager.updateFoldRegions(editor);
        FoldRegion[] allFoldRegions = editor.getFoldingModel().getAllFoldRegions();
        Runnable processor = () -> {
            for (FoldRegion region : allFoldRegions) {
                PsiElement element = EditorFoldingInfo.get(editor).getPsiElement(region);
                if (!(element instanceof PsiDocCommentBase) && !Boolean.TRUE.equals(region.getUserData(DOC_COMMENT_MARK)) && !CollapseExpandDocCommentsHandler.hasAllowedTokenType(editor, region, element)) continue;
                region.setExpanded(this.myExpand);
            }
        };
        editor.getFoldingModel().runBatchFoldingOperation(processor);
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        if (currentFile == null) {
            CollapseExpandDocCommentsHandler.$$$reportNull$$$0(4);
        }
        return null;
    }

    private static boolean hasAllowedTokenType(@NotNull Editor editor, @NotNull FoldRegion region, @Nullable PsiElement element) {
        if (editor == null) {
            CollapseExpandDocCommentsHandler.$$$reportNull$$$0(5);
        }
        if (region == null) {
            CollapseExpandDocCommentsHandler.$$$reportNull$$$0(6);
        }
        if (element == null) {
            return false;
        }
        Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(element.getLanguage());
        if (!(commenter instanceof CodeDocumentationAwareCommenter)) {
            return false;
        }
        HighlighterIterator iterator = editor.getHighlighter().createIterator(region.getStartOffset());
        if (iterator.atEnd()) {
            return false;
        }
        return ((CodeDocumentationAwareCommenter)commenter).getDocumentationCommentTokenType() == iterator.getTokenType();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "region";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentFile";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/folding/impl/CollapseExpandDocCommentsHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setDocCommentMark";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getElementToMakeWritable";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "hasAllowedTokenType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

