// Copyright 2000-2025 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
package com.intellij.codeInsight.folding.impl.actions;

import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.Objects;

import static com.intellij.codeInsight.folding.impl.actions.ExpandAllRegionsAction.twoStepFoldToggling;

final class CollapseAllRegionsAction extends EditorAction implements ActionRemoteBehaviorSpecification.Frontend {
  CollapseAllRegionsAction() {
    super(new BaseFoldingHandler() {
      @Override
      public void doExecute(final @NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
        Project project = editor.getProject();
        assert project != null;
        CodeFoldingManager codeFoldingManager = CodeFoldingManager.getInstance(project);

        final List<FoldRegion> regions = getFoldRegionsForSelection(editor, caret);
        twoStepFoldToggling(editor, regions, (region) -> collapseInFirstStep(codeFoldingManager, region), false);
      }
    });
  }

  private static boolean collapseInFirstStep(@NotNull CodeFoldingManager codeFoldingManager, @NotNull FoldRegion region) {
    boolean expandedByDefault = Objects.requireNonNullElse(codeFoldingManager.keepExpandedOnFirstCollapseAll(region), false);
    return region.isExpanded() && !expandedByDefault;
  }
}
