/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeHighlighting.EditorBoundHighlightingPass;
import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.codeInsight.folding.impl.FoldingUpdate;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.SlowOperations;
import org.jetbrains.annotations.NotNull;

final class CodeFoldingPass
extends EditorBoundHighlightingPass
implements PossiblyDumbAware {
    private static final Key<Boolean> THE_FIRST_TIME = Key.create((String)"FirstFoldingPass");
    private volatile Runnable myRunnable;

    CodeFoldingPass(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            CodeFoldingPass.$$$reportNull$$$0(0);
        }
        if (file == null) {
            CodeFoldingPass.$$$reportNull$$$0(1);
        }
        super(editor, file, false);
    }

    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            CodeFoldingPass.$$$reportNull$$$0(2);
        }
        boolean firstTime = CodeFoldingPass.isFirstTime(this.myFile, this.myEditor, THE_FIRST_TIME);
        try (AccessToken ignored = CodeFoldingPass.runPass();){
            this.myRunnable = CodeFoldingManager.getInstance(this.myProject).updateFoldRegionsAsync(this.myEditor, firstTime);
        }
    }

    static boolean isFirstTime(PsiFile file, Editor editor, Key<Boolean> key) {
        return file.getUserData(key) == null || editor.getUserData(key) == null;
    }

    static void clearFirstTimeFlag(PsiFile file, Editor editor, Key<? super Boolean> key) {
        file.putUserData(key, (Object)Boolean.FALSE);
        editor.putUserData(key, (Object)Boolean.FALSE);
    }

    public void doApplyInformationToEditor() {
        Runnable runnable = this.myRunnable;
        if (runnable != null) {
            try (AccessToken ignore = SlowOperations.knownIssue((String)"IDEA-333911, EA-840750");){
                runnable.run();
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
        }
        if (InjectedLanguageManager.getInstance((Project)this.myFile.getProject()).getTopLevelFile((PsiElement)this.myFile) == this.myFile) {
            CodeFoldingPass.clearFirstTimeFlag(this.myFile, this.myEditor, THE_FIRST_TIME);
        }
    }

    public boolean isDumbAware() {
        return FoldingUpdate.supportsDumbModeFolding(this.myFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/folding/impl/CodeFoldingPass";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "doCollectInformation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

