/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.folding.impl.CodeFoldingManagerImpl;
import com.intellij.codeInsight.folding.impl.CodeFoldingRegion;
import com.intellij.codeInsight.folding.impl.CodeFoldingZombieKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.editor.impl.FoldingKeys;
import com.intellij.openapi.editor.impl.zombie.CodeFoldingZombieUtils;
import com.intellij.openapi.editor.impl.zombie.Zombie;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000  2\u00020\u0001:\u0001 B/\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\"\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u00042\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR#\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006!"}, d2={"Lcom/intellij/codeInsight/folding/impl/CodeFoldingZombie;", "Lcom/intellij/openapi/editor/impl/zombie/Zombie;", "regions", "", "Lcom/intellij/codeInsight/folding/impl/CodeFoldingRegion;", "groupedRegions", "", "", "<init>", "(Ljava/util/List;Ljava/util/Map;)V", "getRegions", "()Ljava/util/List;", "getGroupedRegions", "()Ljava/util/Map;", "isEmpty", "", "applyState", "", "document", "Lcom/intellij/openapi/editor/Document;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "applyRegions", "foldingModel", "Lcom/intellij/openapi/editor/ex/FoldingModelEx;", "applyGroupedRegions", "applyRegion", "regionState", "group", "Lcom/intellij/openapi/editor/FoldingGroup;", "toString", "", "Companion", "intellij.platform.foldings"})
@SourceDebugExtension(value={"SMAP\nCodeFoldingZombie.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeFoldingZombie.kt\ncom/intellij/codeInsight/folding/impl/CodeFoldingZombie\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,167:1\n60#2,5:168\n13#2:173\n*S KotlinDebug\n*F\n+ 1 CodeFoldingZombie.kt\ncom/intellij/codeInsight/folding/impl/CodeFoldingZombie\n*L\n84#1:168,5\n25#1:173\n*E\n"})
public final class CodeFoldingZombie
implements Zombie {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<CodeFoldingRegion> regions;
    @NotNull
    private final Map<Long, List<CodeFoldingRegion>> groupedRegions;
    @NotNull
    private static final Logger logger;

    public CodeFoldingZombie(@NotNull List<CodeFoldingRegion> regions, @NotNull Map<Long, ? extends List<CodeFoldingRegion>> groupedRegions) {
        Intrinsics.checkNotNullParameter(regions, (String)"regions");
        Intrinsics.checkNotNullParameter(groupedRegions, (String)"groupedRegions");
        this.regions = regions;
        this.groupedRegions = groupedRegions;
    }

    @NotNull
    public final List<CodeFoldingRegion> getRegions() {
        return this.regions;
    }

    @NotNull
    public final Map<Long, List<CodeFoldingRegion>> getGroupedRegions() {
        return this.groupedRegions;
    }

    public final boolean isEmpty() {
        return this.regions.isEmpty() && this.groupedRegions.isEmpty();
    }

    @RequiresEdt
    public final void applyState(@NotNull Document document, @NotNull EditorEx editor) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        FoldingModelEx foldingModelEx = editor.getFoldingModel();
        Intrinsics.checkNotNullExpressionValue((Object)foldingModelEx, (String)"getFoldingModel(...)");
        FoldingModelEx foldingModel = foldingModelEx;
        foldingModel.runBatchFoldingOperationDoNotCollapseCaret(() -> CodeFoldingZombie.applyState$lambda$0(this, foldingModel, editor));
        foldingModel.clearDocumentRangesModificationStatus();
        Logger $this$debug_u24default$iv = logger;
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("restored " + this + " for " + document, e$iv);
        }
    }

    private final boolean applyRegions(FoldingModelEx foldingModel) {
        boolean appliedAny = false;
        for (CodeFoldingRegion region : this.regions) {
            boolean bl;
            boolean bl2 = bl = region.getGroupId() == null;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string = "regions with non-null groupId should be handled as a grouped region";
                throw new AssertionError((Object)string);
            }
            boolean applied = this.applyRegion(foldingModel, region, null);
            appliedAny = appliedAny || applied;
        }
        return appliedAny;
    }

    private final boolean applyGroupedRegions(FoldingModelEx foldingModel) {
        boolean appliedAny = false;
        for (Map.Entry<Long, List<CodeFoldingRegion>> entry : this.groupedRegions.entrySet()) {
            long groupId = ((Number)entry.getKey()).longValue();
            List<CodeFoldingRegion> regions = entry.getValue();
            FoldingGroup group = FoldingGroup.newGroup((String)"zombie-group");
            for (CodeFoldingRegion region : regions) {
                boolean bl;
                Long l = region.getGroupId();
                long l2 = groupId;
                boolean bl2 = bl = l != null && l == l2;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl3 = false;
                    String string = "folding group mismatch: expected " + groupId + ", action " + region.getGroupId();
                    throw new AssertionError((Object)string);
                }
                boolean applied = this.applyRegion(foldingModel, region, group);
                appliedAny = appliedAny || applied;
            }
        }
        return appliedAny;
    }

    private final boolean applyRegion(FoldingModelEx foldingModel, CodeFoldingRegion regionState, FoldingGroup group) {
        int start = regionState.component1();
        int end = regionState.component2();
        String placeholder = regionState.component3();
        boolean neverExpands = regionState.component5();
        boolean isExpanded = regionState.component6();
        boolean isCollapsedByDefault = regionState.component7();
        boolean isFrontendCreated = regionState.component8();
        FoldRegion region = foldingModel.createFoldRegion(start, end, placeholder, group, neverExpands);
        if (region != null) {
            if (region.isExpanded() != isExpanded) {
                region.setExpanded(isExpanded);
            }
            region.putUserData(FoldingKeys.ZOMBIE_REGION_KEY, (Object)true);
            CodeFoldingManagerImpl.setCollapsedByDef(region, isCollapsedByDefault);
            if (isFrontendCreated) {
                CodeFoldingManagerImpl.markAsFrontendCreated(region);
            }
            return true;
        }
        return false;
    }

    @NotNull
    public String toString() {
        return "CodeFoldingZombie(regions=" + this.regions.size() + ", groupedRegions=" + this.groupedRegions.size() + ")";
    }

    private static final void applyState$lambda$0(CodeFoldingZombie this$0, FoldingModelEx $foldingModel, EditorEx $editor) {
        boolean applied1 = this$0.applyRegions($foldingModel);
        boolean applied2 = this$0.applyGroupedRegions($foldingModel);
        CodeFoldingZombieUtils.INSTANCE.setZombieRaised((Editor)$editor, applied1 || applied2);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CodeFoldingZombie.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        CodeFoldingZombie.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010%\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002J6\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u00132\u0018\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00130\u0015R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/codeInsight/folding/impl/CodeFoldingZombie$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "create", "Lcom/intellij/codeInsight/folding/impl/CodeFoldingZombie;", "foldRegions", "", "Lcom/intellij/openapi/editor/FoldRegion;", "createPlaceholderText", "", "text", "putRegion", "", "region", "Lcom/intellij/codeInsight/folding/impl/CodeFoldingRegion;", "regions", "", "groupedRegions", "", "", "intellij.platform.foldings"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CodeFoldingZombie create(@NotNull List<? extends FoldRegion> foldRegions) {
            Intrinsics.checkNotNullParameter(foldRegions, (String)"foldRegions");
            ArrayList regions = new ArrayList();
            HashMap groupedRegions = new HashMap();
            for (FoldRegion foldRegion : foldRegions) {
                int n = foldRegion.getStartOffset();
                int n2 = foldRegion.getEndOffset();
                String string = foldRegion.getPlaceholderText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPlaceholderText(...)");
                FoldingGroup foldingGroup = foldRegion.getGroup();
                CodeFoldingRegion regionState = new CodeFoldingRegion(n, n2, this.createPlaceholderText(string), foldingGroup != null ? Long.valueOf(foldingGroup.getId()) : null, foldRegion.shouldNeverExpand(), foldRegion.isExpanded(), Intrinsics.areEqual((Object)CodeFoldingManagerImpl.getCollapsedByDef(foldRegion), (Object)true), CodeFoldingManagerImpl.isFrontendCreated(foldRegion));
                this.putRegion(regionState, regions, groupedRegions);
            }
            return new CodeFoldingZombie(regions, groupedRegions);
        }

        private final String createPlaceholderText(String text) {
            return Registry.Companion.is("cache.folding.model.hide.placeholder") ? StringsKt.repeat((CharSequence)" ", (int)CodeFoldingZombieKt.access$graphemeCount(text)) : text;
        }

        public final void putRegion(@NotNull CodeFoldingRegion region, @NotNull List<CodeFoldingRegion> regions, @NotNull Map<Long, List<CodeFoldingRegion>> groupedRegions) {
            Intrinsics.checkNotNullParameter((Object)region, (String)"region");
            Intrinsics.checkNotNullParameter(regions, (String)"regions");
            Intrinsics.checkNotNullParameter(groupedRegions, (String)"groupedRegions");
            Long groupId = region.getGroupId();
            boolean bl = groupId == null ? regions.add(region) : groupedRegions.computeIfAbsent(groupId, arg_0 -> Companion.putRegion$lambda$1(Companion::putRegion$lambda$0, arg_0)).add(region);
        }

        private static final List putRegion$lambda$0(Long it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return new ArrayList();
        }

        private static final List putRegion$lambda$1(Function1 $tmp0, Object p0) {
            return (List)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

