/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.folding.impl.CodeFoldingManagerImpl;
import com.intellij.codeInsight.folding.impl.EditorFoldingInfo;
import com.intellij.codeInsight.folding.impl.FoldingUpdate;
import com.intellij.codeInsight.folding.impl.FoldingUtil;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.editor.impl.FoldingKeys;
import com.intellij.openapi.editor.impl.zombie.CodeFoldingZombieUtils;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SlowOperations;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class UpdateFoldRegionsOperation
implements Runnable {
    private static final Logger LOG = Logger.getInstance(UpdateFoldRegionsOperation.class);
    static final Key<Boolean> CAN_BE_REMOVED_WHEN_COLLAPSED = Key.create((String)"canBeRemovedWhenCollapsed");
    static final Key<Boolean> COLLAPSED_BY_DEFAULT = Key.create((String)"collapsedByDefault");
    static final Key<Boolean> KEEP_EXPANDED_ON_FIRST_COLLAPSE_ALL = Key.create((String)"keepExpandedOnFirstCollapseAll");
    static final Key<String> SIGNATURE = Key.create((String)"signature");
    static final Key<Boolean> UPDATE_REGION = Key.create((String)"update");
    static final String NO_SIGNATURE = "no signature";
    private static final Comparator<PsiElement> COMPARE_BY_OFFSET_REVERSED = (element, element1) -> {
        int startOffsetDiff = element1.getTextRange().getStartOffset() - element.getTextRange().getStartOffset();
        return startOffsetDiff == 0 ? element1.getTextRange().getEndOffset() - element.getTextRange().getEndOffset() : startOffsetDiff;
    };
    private final Project myProject;
    private final Editor myEditor;
    private final PsiFile myFile;
    @NotNull
    private final ApplyDefaultStateMode myApplyDefaultState;
    private final FoldingMap myElementsToFoldMap;
    private final Set<FoldingUpdate.RegionInfo> myRegionInfos;
    private final MultiMap<FoldingGroup, FoldingUpdate.RegionInfo> myGroupedRegionInfos;
    private final boolean myKeepCollapsedRegions;
    private final boolean myForInjected;

    UpdateFoldRegionsOperation(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @NotNull List<? extends FoldingUpdate.RegionInfo> elementsToFold, @NotNull ApplyDefaultStateMode applyDefaultState, boolean keepCollapsedRegions, boolean forInjected) {
        if (project == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(1);
        }
        if (file == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(2);
        }
        if (elementsToFold == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(3);
        }
        if (applyDefaultState == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(4);
        }
        this.myElementsToFoldMap = new FoldingMap();
        this.myRegionInfos = new LinkedHashSet<FoldingUpdate.RegionInfo>();
        this.myGroupedRegionInfos = new MultiMap();
        this.myProject = project;
        this.myEditor = editor;
        this.myFile = file;
        this.myApplyDefaultState = applyDefaultState;
        this.myKeepCollapsedRegions = keepCollapsedRegions;
        this.myForInjected = forInjected;
        for (FoldingUpdate.RegionInfo regionInfo : elementsToFold) {
            this.myElementsToFoldMap.putValue(regionInfo.element, regionInfo);
            this.myRegionInfos.add(regionInfo);
            FoldingGroup group = regionInfo.descriptor.getGroup();
            if (group == null) continue;
            this.myGroupedRegionInfos.putValue((Object)group, (Object)regionInfo);
        }
    }

    @Override
    public void run() {
        EditorFoldingInfo info = EditorFoldingInfo.get(this.myEditor);
        FoldingModelEx foldingModel = (FoldingModelEx)this.myEditor.getFoldingModel();
        Map<TextRange, Boolean> rangeToExpandStatusMap = this.removeInvalidRegions(info, foldingModel);
        HashMap<FoldRegion, Boolean> shouldExpand = new HashMap<FoldRegion, Boolean>();
        HashMap<FoldingGroup, Boolean> groupExpand = new HashMap<FoldingGroup, Boolean>();
        List<FoldRegion> newRegions = this.addNewRegions(info, foldingModel, rangeToExpandStatusMap, shouldExpand, groupExpand);
        if (CodeFoldingManagerImpl.isAsyncFoldingUpdater(this.myEditor)) {
            Map<TextRange, Boolean> postponedExpansionMap = CodeFoldingManagerImpl.getAsyncExpandStatusMap(this.myEditor);
            if (postponedExpansionMap != null) {
                postponedExpansionMap.putAll(rangeToExpandStatusMap);
            } else {
                CodeFoldingManagerImpl.setAsyncExpandStatusMap(this.myEditor, rangeToExpandStatusMap);
            }
        }
        UpdateFoldRegionsOperation.applyExpandStatus(newRegions, shouldExpand, groupExpand);
        foldingModel.clearDocumentRangesModificationStatus();
        CodeFoldingZombieUtils.INSTANCE.postponeAndScheduleCleanupZombieRegions(this.myEditor);
    }

    private static void applyExpandStatus(@NotNull List<? extends FoldRegion> newRegions, @NotNull Map<FoldRegion, Boolean> shouldExpand, @NotNull Map<FoldingGroup, Boolean> groupExpand) {
        if (newRegions == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(5);
        }
        if (shouldExpand == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(6);
        }
        if (groupExpand == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(7);
        }
        for (FoldRegion foldRegion : newRegions) {
            FoldingGroup group = foldRegion.getGroup();
            Boolean expanded = group == null ? shouldExpand.get(foldRegion) : groupExpand.get(group);
            if (expanded == null) continue;
            foldRegion.setExpanded(expanded.booleanValue());
        }
    }

    @NotNull
    private List<FoldRegion> addNewRegions(@NotNull EditorFoldingInfo info, @NotNull FoldingModelEx foldingModel, @NotNull Map<TextRange, Boolean> rangeToExpandStatusMap, @NotNull Map<FoldRegion, Boolean> shouldExpand, @NotNull Map<FoldingGroup, Boolean> groupExpand) {
        if (info == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(8);
        }
        if (foldingModel == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(9);
        }
        if (rangeToExpandStatusMap == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(10);
        }
        if (shouldExpand == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(11);
        }
        if (groupExpand == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(12);
        }
        ArrayList<FoldRegion> newRegions = new ArrayList<FoldRegion>();
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)this.myProject);
        for (FoldingUpdate.RegionInfo regionInfo : this.myRegionInfos) {
            PsiElement psi;
            ProgressManager.checkCanceled();
            FoldingDescriptor descriptor = regionInfo.descriptor;
            FoldingGroup group = descriptor.getGroup();
            TextRange range = descriptor.getRange();
            String placeholder = null;
            try {
                placeholder = descriptor.getPlaceholderText();
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
            if (range.getEndOffset() > this.myEditor.getDocument().getTextLength()) {
                LOG.error(String.format("Invalid folding descriptor detected (%s). It ends beyond the document range (%d)", descriptor, this.myEditor.getDocument().getTextLength()));
                continue;
            }
            FoldRegion region = UpdateFoldRegionsOperation.mergeWithZombie(foldingModel, range, placeholder == null ? "..." : placeholder, group, descriptor.isNonExpandable());
            if (region == null) continue;
            AccessToken ignore = SlowOperations.knownIssue((String)"IDEA-326651, EA-831712");
            try {
                psi = descriptor.getElement().getPsi();
                if (psi == null || !psi.isValid() || !this.myFile.isValid()) {
                    region.dispose();
                    continue;
                }
            }
            finally {
                if (ignore == null) continue;
                ignore.close();
                continue;
            }
            region.setGutterMarkEnabledForSingleLine(descriptor.isGutterMarkEnabledForSingleLine());
            if (descriptor.canBeRemovedWhenCollapsed()) {
                region.putUserData(CAN_BE_REMOVED_WHEN_COLLAPSED, (Object)Boolean.TRUE);
            }
            CodeFoldingManagerImpl.markAsFrontendCreated(region);
            CodeFoldingManagerImpl.setCollapsedByDef(region, regionInfo.collapsedByDefault);
            region.putUserData(KEEP_EXPANDED_ON_FIRST_COLLAPSE_ALL, (Object)regionInfo.keepExpandedOnFirstCollapseAll);
            region.putUserData(SIGNATURE, (Object)((String)ObjectUtils.chooseNotNull((Object)regionInfo.signature, (Object)NO_SIGNATURE)));
            info.addRegion(region, smartPointerManager.createSmartPsiElementPointer(psi));
            newRegions.add(region);
            if (descriptor.isNonExpandable()) {
                region.putUserData(FoldingKeys.SELECT_REGION_ON_CARET_NEARBY, (Object)Boolean.TRUE);
                continue;
            }
            boolean expandStatus = this.shouldExpandNewRegion(range, rangeToExpandStatusMap, regionInfo.collapsedByDefault);
            if (group == null) {
                shouldExpand.put(region, expandStatus);
                continue;
            }
            Boolean alreadyExpanded = groupExpand.get(group);
            groupExpand.put(group, alreadyExpanded == null ? expandStatus : alreadyExpanded != false || expandStatus);
        }
        ArrayList<FoldRegion> arrayList = newRegions;
        if (arrayList == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @Nullable
    private static FoldRegion mergeWithZombie(@NotNull FoldingModelEx foldingModel, @NotNull TextRange range, @NotNull String placeholder, @Nullable FoldingGroup group, boolean shouldNeverExpand) {
        if (foldingModel == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(14);
        }
        if (range == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(15);
        }
        if (placeholder == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(16);
        }
        FoldRegion region = null;
        Object zombieExpand = null;
        FoldRegion zombieFoldRegion = foldingModel.getFoldRegion(range.getStartOffset(), range.getEndOffset());
        if (zombieFoldRegion != null && FoldingKeys.ZOMBIE_REGION_KEY.isIn((UserDataHolder)zombieFoldRegion)) {
            if (placeholder.equals(zombieFoldRegion.getPlaceholderText()) && group == zombieFoldRegion.getGroup() && shouldNeverExpand == zombieFoldRegion.shouldNeverExpand()) {
                region = zombieFoldRegion;
                FoldingKeys.ZOMBIE_REGION_KEY.set((UserDataHolder)region, null);
            } else {
                foldingModel.removeFoldRegion(zombieFoldRegion);
            }
        }
        if (region == null) {
            region = foldingModel.createFoldRegion(range.getStartOffset(), range.getEndOffset(), placeholder, group, shouldNeverExpand);
        }
        return region;
    }

    private boolean shouldExpandNewRegion(TextRange range, Map<TextRange, Boolean> rangeToExpandStatusMap, boolean collapsedByDefault) {
        if (this.myApplyDefaultState != ApplyDefaultStateMode.NO) {
            TextRange lineRange;
            if (this.myApplyDefaultState == ApplyDefaultStateMode.EXCEPT_CARET_REGION && (lineRange = OpenFileDescriptor.getRangeToUnfoldOnNavigation((Editor)this.myEditor)).intersects(range)) {
                return true;
            }
            return !collapsedByDefault;
        }
        Boolean oldStatus = rangeToExpandStatusMap.get(range);
        return oldStatus == null || oldStatus != false || FoldingUtil.caretInsideRange((Editor)this.myEditor, (TextRange)range);
    }

    @NotNull
    private Map<TextRange, Boolean> removeInvalidRegions(@NotNull EditorFoldingInfo info, @NotNull FoldingModelEx foldingModel) {
        if (info == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(17);
        }
        if (foldingModel == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(18);
        }
        HashMap<TextRange, Boolean> rangeToExpandStatusMap = new HashMap<TextRange, Boolean>();
        ArrayList toRemove = new ArrayList();
        Ref infoRef = Ref.create();
        HashSet<FoldingGroup> processedGroups = new HashSet<FoldingGroup>();
        ArrayList<FoldingUpdate.RegionInfo> matchedInfos = new ArrayList<FoldingUpdate.RegionInfo>();
        for (FoldRegion region : foldingModel.getAllFoldRegions()) {
            FoldingGroup group = region.getGroup();
            if (group != null && !processedGroups.add(group)) continue;
            List regionsToProcess = group == null ? Collections.singletonList(region) : foldingModel.getGroupedRegions(group);
            matchedInfos.clear();
            boolean shouldRemove = false;
            boolean isLight = true;
            for (Object regionToProcess : regionsToProcess) {
                if (!regionToProcess.isValid() || this.shouldRemoveRegion((FoldRegion)regionToProcess, info, rangeToExpandStatusMap, (Ref<? super FoldingUpdate.RegionInfo>)infoRef)) {
                    shouldRemove = true;
                }
                isLight &= regionToProcess.getUserData(SIGNATURE) == null;
                FoldingUpdate.RegionInfo regionInfo = (FoldingUpdate.RegionInfo)infoRef.get();
                matchedInfos.add(regionInfo);
            }
            if (!shouldRemove && group != null && !isLight) {
                Object regionToProcess;
                FoldingGroup requestedGroup = null;
                regionToProcess = matchedInfos.iterator();
                while (regionToProcess.hasNext()) {
                    FoldingUpdate.RegionInfo matchedInfo = (FoldingUpdate.RegionInfo)regionToProcess.next();
                    if (matchedInfo == null) {
                        shouldRemove = true;
                        break;
                    }
                    FoldingGroup g = matchedInfo.descriptor.getGroup();
                    if (g == null) {
                        shouldRemove = true;
                        break;
                    }
                    if (requestedGroup == null) {
                        requestedGroup = g;
                        continue;
                    }
                    if (requestedGroup.equals((Object)g)) continue;
                    shouldRemove = true;
                    break;
                }
                if (this.myGroupedRegionInfos.get(requestedGroup).size() != matchedInfos.size()) {
                    shouldRemove = true;
                }
            }
            if (shouldRemove) {
                for (FoldRegion r : regionsToProcess) {
                    rangeToExpandStatusMap.putIfAbsent(r.getTextRange(), r.isExpanded());
                }
                toRemove.addAll(regionsToProcess);
                continue;
            }
            for (FoldingUpdate.RegionInfo matchedInfo : matchedInfos) {
                if (matchedInfo == null) continue;
                this.myElementsToFoldMap.remove(matchedInfo.element, matchedInfo);
                this.myRegionInfos.remove(matchedInfo);
            }
        }
        for (FoldRegion region : toRemove) {
            foldingModel.removeFoldRegion(region);
            info.removeRegion(region);
        }
        HashMap<TextRange, Boolean> hashMap = rangeToExpandStatusMap;
        if (hashMap == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(19);
        }
        return hashMap;
    }

    private boolean shouldRemoveRegion(@NotNull FoldRegion region, @NotNull EditorFoldingInfo info, @NotNull Map<TextRange, Boolean> rangeToExpandStatusMap, @NotNull Ref<? super FoldingUpdate.RegionInfo> matchingInfo) {
        Collection regionInfos;
        if (region == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(20);
        }
        if (info == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(21);
        }
        if (rangeToExpandStatusMap == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(22);
        }
        if (matchingInfo == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(23);
        }
        matchingInfo.set(null);
        if (UPDATE_REGION.get((UserDataHolder)region) == Boolean.TRUE) {
            rangeToExpandStatusMap.put(region.getTextRange(), region.isExpanded());
            return true;
        }
        PsiElement element = info.getPsiElement(region);
        if (element != null) {
            PsiFile containingFile = element.getContainingFile();
            boolean isInjected = InjectedLanguageManager.getInstance((Project)this.myProject).isInjectedFragment(containingFile);
            if (isInjected != this.myForInjected) {
                return false;
            }
        }
        boolean forceKeepRegion = this.myKeepCollapsedRegions && !region.isExpanded() && !this.regionOrGroupCanBeRemovedWhenCollapsed(region);
        Boolean storedCollapsedByDefault = CodeFoldingManagerImpl.getCollapsedByDef(region);
        if (element != null && !(regionInfos = this.myElementsToFoldMap.get(element)).isEmpty()) {
            FoldingUpdate.RegionInfo[] array = regionInfos.toArray(new FoldingUpdate.RegionInfo[0]);
            for (FoldingUpdate.RegionInfo regionInfo : array) {
                FoldingDescriptor descriptor = regionInfo.descriptor;
                TextRange range = descriptor.getRange();
                if (!TextRange.areSegmentsEqual((Segment)region, (Segment)range)) continue;
                if (storedCollapsedByDefault != null && storedCollapsedByDefault != regionInfo.collapsedByDefault) {
                    rangeToExpandStatusMap.put(range, !regionInfo.collapsedByDefault);
                    return true;
                }
                if (!region.getPlaceholderText().equals(descriptor.getPlaceholderText()) || range.getLength() < 2) {
                    return true;
                }
                matchingInfo.set((Object)regionInfo);
                return false;
            }
            if (!forceKeepRegion) {
                for (FoldingUpdate.RegionInfo regionInfo : regionInfos) {
                    rangeToExpandStatusMap.put(regionInfo.descriptor.getRange(), region.isExpanded());
                }
                return true;
            }
        } else {
            if (CodeFoldingManagerImpl.isAutoCreated(region)) {
                return !forceKeepRegion && Boolean.TRUE.equals(region.getUserData(CAN_BE_REMOVED_WHEN_COLLAPSED));
            }
            return !forceKeepRegion && region.getUserData(SIGNATURE) != null;
        }
        return false;
    }

    private boolean regionOrGroupCanBeRemovedWhenCollapsed(@NotNull FoldRegion region) {
        FoldingGroup group;
        if (region == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(24);
        }
        List affectedRegions = (group = region.getGroup()) != null && this.myEditor instanceof EditorEx ? ((EditorEx)this.myEditor).getFoldingModel().getGroupedRegions(group) : Collections.singletonList(region);
        for (FoldRegion affectedRegion : affectedRegions) {
            if (!this.regionCanBeRemovedWhenCollapsed(affectedRegion)) continue;
            return true;
        }
        return false;
    }

    private boolean regionCanBeRemovedWhenCollapsed(@NotNull FoldRegion region) {
        if (region == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(25);
        }
        return Boolean.TRUE.equals(region.getUserData(CAN_BE_REMOVED_WHEN_COLLAPSED)) || ((FoldingModelEx)this.myEditor.getFoldingModel()).hasDocumentRegionChangedFor(region) || !region.isValid() || this.isRegionInCaretLine(region);
    }

    private boolean isRegionInCaretLine(@NotNull FoldRegion region) {
        if (region == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(26);
        }
        int regionStartLine = this.myEditor.getDocument().getLineNumber(region.getStartOffset());
        int regionEndLine = this.myEditor.getDocument().getLineNumber(region.getEndOffset());
        int caretLine = this.myEditor.getCaretModel().getLogicalPosition().line;
        return caretLine >= regionStartLine && caretLine <= regionEndLine;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 13, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsToFold";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applyDefaultState";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRegions";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shouldExpand";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupExpand";
                break;
            }
            case 8: 
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 9: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foldingModel";
                break;
            }
            case 10: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeToExpandStatusMap";
                break;
            }
            case 13: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/folding/impl/UpdateFoldRegionsOperation";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeholder";
                break;
            }
            case 20: 
            case 24: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "region";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchingInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/folding/impl/UpdateFoldRegionsOperation";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "addNewRegions";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "removeInvalidRegions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "applyExpandStatus";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addNewRegions";
                break;
            }
            case 13: 
            case 19: {
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "mergeWithZombie";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "removeInvalidRegions";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "shouldRemoveRegion";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "regionOrGroupCanBeRemovedWhenCollapsed";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "regionCanBeRemovedWhenCollapsed";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isRegionInCaretLine";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 13, 19 -> new IllegalStateException(string);
        };
    }

    private static final class FoldingMap
    extends MultiMap<PsiElement, FoldingUpdate.RegionInfo> {
        private FoldingMap() {
            super(new TreeMap(COMPARE_BY_OFFSET_REVERSED));
        }

        @NotNull
        protected Collection<FoldingUpdate.RegionInfo> createCollection() {
            return new ArrayList<FoldingUpdate.RegionInfo>();
        }
    }

    static enum ApplyDefaultStateMode {
        YES,
        EXCEPT_CARET_REGION,
        NO;

    }
}

