/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ide.bootstrap;

import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.ErrorManager;
import java.util.logging.Handler;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

final class OutputStreamLogger
extends OutputStream {
    private static final ThreadLocal<Boolean> ourSkipRedirect = ThreadLocal.withInitial(() -> false);
    private static final int BUFFER_SIZE = 10000;
    private final byte[] myBuffer = new byte[10000];
    private final PrintStream myOriginalStream;
    private final com.intellij.openapi.diagnostic.Logger myLogger;
    private int myPosition;
    private boolean mySlashRWritten;
    private final AtomicBoolean myStackOverflowProtectionTriggered = new AtomicBoolean();
    private final ThreadLocal<Boolean> myStackOverflowProtection = ThreadLocal.withInitial(() -> false);

    OutputStreamLogger(String name, PrintStream originalStream) {
        this.myOriginalStream = originalStream;
        this.myLogger = com.intellij.openapi.diagnostic.Logger.getInstance((String)name);
        Logger rootLogger = Logger.getLogger("");
        for (Handler handler : rootLogger.getHandlers()) {
            ErrorManager errorManager = handler.getErrorManager();
            if (errorManager instanceof SkipRedirectErrorManager) continue;
            handler.setErrorManager(new SkipRedirectErrorManager(errorManager));
        }
    }

    @Override
    public void write(int b) {
        this.myOriginalStream.write(b);
        if (ourSkipRedirect.get().booleanValue()) {
            return;
        }
        this.processByte(b);
    }

    @Override
    public void write(byte @NotNull [] b, int off, int len) {
        if (b == null) {
            OutputStreamLogger.$$$reportNull$$$0(0);
        }
        this.myOriginalStream.write(b, off, len);
        if (ourSkipRedirect.get().booleanValue()) {
            return;
        }
        for (int i = 0; i < len; ++i) {
            this.processByte(b[off + i]);
        }
    }

    private synchronized void processByte(int b) {
        if (b == 13) {
            this.writeBuffer();
            this.mySlashRWritten = true;
        } else if (b == 10) {
            if (this.mySlashRWritten) {
                this.mySlashRWritten = false;
            } else {
                this.writeBuffer();
            }
        } else {
            this.mySlashRWritten = false;
            if (this.myPosition == 10000) {
                this.writeBuffer();
            }
            this.myBuffer[this.myPosition++] = (byte)b;
        }
    }

    private void writeBuffer() {
        if (this.myStackOverflowProtection.get().booleanValue()) {
            if (this.myStackOverflowProtectionTriggered.compareAndSet(false, true)) {
                this.myLogger.error("Stack overflow protection triggered in logger. A standard stream overridden to write to logs?");
            }
            return;
        }
        this.myStackOverflowProtection.set(true);
        try {
            this.myLogger.info(new String(this.myBuffer, 0, this.myPosition, Charset.defaultCharset()));
            this.myPosition = 0;
        }
        finally {
            this.myStackOverflowProtection.set(false);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "com/intellij/platform/ide/bootstrap/OutputStreamLogger", "write"));
    }

    private static class SkipRedirectErrorManager
    extends ErrorManager {
        private final ErrorManager myOriginal;

        private SkipRedirectErrorManager(ErrorManager original) {
            this.myOriginal = original;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void error(String msg, Exception ex, int code) {
            ourSkipRedirect.set(true);
            try {
                this.myOriginal.error(msg, ex, code);
            }
            finally {
                ourSkipRedirect.set(false);
            }
        }
    }
}

