/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ide.bootstrap;

import com.intellij.platform.ide.bootstrap.MyEntryResolver;
import com.intellij.util.lang.ZipEntryResolverPool;
import com.intellij.util.lang.ZipFile;
import com.intellij.util.lang.ZipFilePool;
import java.nio.file.Path;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.StampedLock;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\nH\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0007H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u0007H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lcom/intellij/platform/ide/bootstrap/ZipFilePoolImpl;", "Lcom/intellij/util/lang/ZipFilePool;", "Lcom/intellij/util/lang/ZipEntryResolverPool;", "<init>", "()V", "pool", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/nio/file/Path;", "Lcom/intellij/platform/ide/bootstrap/MyEntryResolver;", "mask", "", "locks", "", "Ljava/util/concurrent/locks/StampedLock;", "[Ljava/util/concurrent/locks/StampedLock;", "getLock", "hash", "loadZipFile", "Lcom/intellij/util/lang/ZipFile;", "file", "load", "Lcom/intellij/util/lang/ZipFilePool$EntryResolver;", "close", "", "intellij.platform.ide.bootstrap"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nZipFilePoolImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ZipFilePoolImpl.kt\ncom/intellij/platform/ide/bootstrap/ZipFilePoolImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,61:1\n1#2:62\n*E\n"})
public final class ZipFilePoolImpl
extends ZipFilePool
implements ZipEntryResolverPool {
    @NotNull
    private final ConcurrentHashMap<Path, MyEntryResolver> pool = new ConcurrentHashMap(1024);
    private final int mask = (1 << 32 - Integer.numberOfLeadingZeros(63)) - 1;
    @NotNull
    private final StampedLock[] locks;

    public ZipFilePoolImpl() {
        int n = 0;
        int n2 = this.mask + 1;
        StampedLock[] stampedLockArray = new StampedLock[n2];
        ZipFilePoolImpl zipFilePoolImpl = this;
        while (n < n2) {
            int n3 = n++;
            stampedLockArray[n3] = new StampedLock();
        }
        zipFilePoolImpl.locks = stampedLockArray;
    }

    private final StampedLock getLock(int hash) {
        return this.locks[hash & this.mask];
    }

    @NotNull
    public ZipFile loadZipFile(@NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        MyEntryResolver resolver = this.pool.get(file);
        MyEntryResolver myEntryResolver = resolver;
        if (myEntryResolver == null || (myEntryResolver = myEntryResolver.zipFile) == null) {
            ZipFile zipFile = ZipFile.load((Path)file);
            myEntryResolver = zipFile;
            Intrinsics.checkNotNullExpressionValue((Object)zipFile, (String)"load(...)");
        }
        return myEntryResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ZipFilePool.EntryResolver load(@NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        MyEntryResolver myEntryResolver = this.pool.get(file);
        if (myEntryResolver != null) {
            MyEntryResolver it = myEntryResolver;
            boolean bl = false;
            return it;
        }
        StampedLock lock = this.getLock(((Object)file).hashCode());
        long stamp = lock.writeLock();
        try {
            MyEntryResolver myEntryResolver2 = this.pool.computeIfAbsent(file, arg_0 -> ZipFilePoolImpl.load$lambda$2(arg_0 -> ZipFilePoolImpl.load$lambda$1(file, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)myEntryResolver2, (String)"computeIfAbsent(...)");
            ZipFilePool.EntryResolver entryResolver = myEntryResolver2;
            return entryResolver;
        }
        finally {
            lock.unlockWrite(stamp);
        }
    }

    public void close() {
        this.pool.clear();
    }

    private static final MyEntryResolver load$lambda$1(Path $file, Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ZipFile zipFile = ZipFile.load((Path)$file);
        Intrinsics.checkNotNullExpressionValue((Object)zipFile, (String)"load(...)");
        return new MyEntryResolver(zipFile);
    }

    private static final MyEntryResolver load$lambda$2(Function1 $tmp0, Object p0) {
        return (MyEntryResolver)$tmp0.invoke(p0);
    }
}

