/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.inline.completion;

import com.intellij.codeInsight.inline.completion.InlineCompletionHandler;
import com.intellij.codeInsight.inline.completion.InlineCompletionHandlerInitializer;
import com.intellij.codeInsight.inline.completion.InlineCompletionInstallListener;
import com.intellij.codeInsight.inline.completion.listeners.InlineCompletionFocusListener;
import com.intellij.codeInsight.inline.completion.listeners.InlineCompletionSelectionListener;
import com.intellij.codeInsight.inline.completion.listeners.InlineEditorMouseListener;
import com.intellij.codeInsight.inline.completion.listeners.typing.InlineCompletionDocumentListener;
import com.intellij.codeInsight.inline.completion.listeners.typing.InlineCompletionTypingSessionTracker;
import com.intellij.codeInsight.inline.completion.logs.InlineCompletionUsageTracker;
import com.intellij.codeInsight.inline.completion.logs.TypingSpeedTracker;
import com.intellij.codeInsight.inline.completion.tooltip.InlineCompletionTooltipProvokerMouseListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.observable.util.DisposerUtilKt;
import com.intellij.openapi.observable.util.RevertOnDisposeUtilKt;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.util.ApplicationKt;
import java.awt.Component;
import java.awt.event.KeyListener;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\r\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fJ\u0014\u0010\u0016\u001a\u00020\u0011*\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R9\u0010\u0004\u001a-\u0012$\u0012\"\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b \t*\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/codeInsight/inline/completion/InlineCompletion;", "", "<init>", "()V", "KEY", "Lcom/intellij/openapi/util/Key;", "Lkotlin/Pair;", "Lcom/intellij/codeInsight/inline/completion/InlineCompletionHandler;", "Lcom/intellij/openapi/Disposable;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getHandlerOrNull", "editor", "Lcom/intellij/openapi/editor/Editor;", "install", "", "Lcom/intellij/openapi/editor/ex/EditorEx;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "remove", "disposeWithEditorIfNeeded", "intellij.platform.ide.codeinsight.inline"})
@SourceDebugExtension(value={"SMAP\nInlineCompletion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlineCompletion.kt\ncom/intellij/codeInsight/inline/completion/InlineCompletion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,105:1\n67#2,4:106\n67#2,4:110\n67#2,4:114\n67#2,4:118\n13#2:122\n*S KotlinDebug\n*F\n+ 1 InlineCompletion.kt\ncom/intellij/codeInsight/inline/completion/InlineCompletion\n*L\n55#1:106,4\n60#1:110,4\n80#1:114,4\n91#1:118,4\n31#1:122\n*E\n"})
public final class InlineCompletion {
    @NotNull
    public static final InlineCompletion INSTANCE = new InlineCompletion();
    @NotNull
    private static final Key<Pair<InlineCompletionHandler, Disposable>> KEY;
    @NotNull
    private static final Logger LOG;

    private InlineCompletion() {
    }

    @Nullable
    public final InlineCompletionHandler getHandlerOrNull(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Pair pair = (Pair)editor.getUserData(KEY);
        return pair != null ? (InlineCompletionHandler)pair.getFirst() : null;
    }

    public final void install(@NotNull EditorEx editor, @NotNull CoroutineScope scope) {
        Logger logger;
        boolean $i$f$trace;
        Logger $this$trace$iv;
        Disposable disposable;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        if (!SwingUtilities.isEventDispatchThread()) {
            LOG.error("Inline Completion should be installed only in EDT. This error will be replaced with assertion.");
        }
        if (editor.isDisposed()) {
            return;
        }
        InlineCompletionHandler currentHandler = this.getHandlerOrNull((Editor)editor);
        Disposable it = disposable = Disposer.newDisposable((String)"inline-completion");
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        INSTANCE.disposeWithEditorIfNeeded(it, (Editor)editor);
        Disposable disposable2 = disposable;
        Intrinsics.checkNotNullExpressionValue((Object)disposable2, (String)"also(...)");
        Disposable disposable3 = disposable2;
        CoroutineScope workingScope = CoroutineScopeKt.childScope$default((CoroutineScope)scope, null, (!ApplicationKt.getApplication().isUnitTestMode() ? 1 : 0) != 0, (int)1, null);
        InlineCompletionHandler handler = InlineCompletionHandlerInitializer.Companion.initialize((Editor)editor, workingScope, disposable3);
        if (handler == null) {
            kotlinx.coroutines.CoroutineScopeKt.cancel$default((CoroutineScope)workingScope, null, (int)1, null);
            Disposer.dispose((Disposable)disposable3);
            $this$trace$iv = LOG;
            $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger2 = $this$trace$iv;
                boolean bl2 = false;
                logger2.trace("[Inline Completion] No handler initializer is found for " + editor + ".");
            }
            return;
        }
        if (currentHandler != null) {
            $this$trace$iv = LOG;
            $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                logger = $this$trace$iv;
                boolean bl3 = false;
                logger.trace("[Inline Completion] Handler is being replaced for " + editor + ".");
            }
            this.remove((Editor)editor);
        }
        editor.putUserData(KEY, (Object)TuplesKt.to((Object)handler, (Object)disposable3));
        editor.getDocument().addDocumentListener((DocumentListener)new InlineCompletionDocumentListener((Editor)editor), disposable3);
        editor.addEditorMouseListener((EditorMouseListener)new InlineEditorMouseListener(), disposable3);
        editor.addFocusListener((FocusChangeListener)new InlineCompletionFocusListener(), disposable3);
        JComponent jComponent = editor.getContentComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getContentComponent(...)");
        RevertOnDisposeUtilKt.addKeyListener((Component)jComponent, (Disposable)disposable3, (KeyListener)new TypingSpeedTracker.KeyListener());
        editor.getSelectionModel().addSelectionListener((SelectionListener)new InlineCompletionSelectionListener(), disposable3);
        editor.getCaretModel().addCaretListener((CaretListener)new InlineCompletionTypingSessionTracker.TypingSessionCaretListener(), disposable3);
        editor.addEditorMouseListener((EditorMouseListener)new InlineCompletionTooltipProvokerMouseListener(), disposable3);
        ((InlineCompletionInstallListener)ApplicationKt.getApplication().getMessageBus().syncPublisher(InlineCompletionInstallListener.Companion.getTOPIC())).handlerInstalled((Editor)editor, handler);
        DisposerUtilKt.whenDisposed((Disposable)disposable3, () -> InlineCompletion.install$lambda$3(workingScope));
        $this$trace$iv = LOG;
        $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl4 = false;
            logger.trace("[Inline Completion] Handler is installed for " + editor + ".");
        }
    }

    public final void remove(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Pair pair = (Pair)editor.getUserData(KEY);
        if (pair == null) {
            return;
        }
        Pair pair2 = pair;
        InlineCompletionHandler handler = (InlineCompletionHandler)pair2.component1();
        Disposable disposable = (Disposable)pair2.component2();
        handler.cancel(InlineCompletionUsageTracker.ShownEvents.FinishType.EDITOR_REMOVED);
        Disposer.dispose((Disposable)disposable);
        ((InlineCompletionInstallListener)ApplicationKt.getApplication().getMessageBus().syncPublisher(InlineCompletionInstallListener.Companion.getTOPIC())).handlerUninstalled(editor, handler);
        editor.putUserData(KEY, null);
        Logger $this$trace$iv = LOG;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("[Inline Completion] Handler is removed for " + editor + ".");
        }
    }

    private final void disposeWithEditorIfNeeded(Disposable $this$disposeWithEditorIfNeeded, Editor editor) {
        AtomicReference<Boolean> isDisposed = new AtomicReference<Boolean>(false);
        DisposerUtilKt.whenDisposed((Disposable)$this$disposeWithEditorIfNeeded, () -> InlineCompletion.disposeWithEditorIfNeeded$lambda$0(isDisposed));
        EditorUtil.disposeWithEditor((Editor)editor, () -> InlineCompletion.disposeWithEditorIfNeeded$lambda$1(isDisposed, $this$disposeWithEditorIfNeeded));
    }

    private static final Unit install$lambda$3(CoroutineScope $workingScope) {
        kotlinx.coroutines.CoroutineScopeKt.cancel$default((CoroutineScope)$workingScope, null, (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit disposeWithEditorIfNeeded$lambda$0(AtomicReference $isDisposed) {
        $isDisposed.set(true);
        return Unit.INSTANCE;
    }

    private static final void disposeWithEditorIfNeeded$lambda$1(AtomicReference $isDisposed, Disposable $this_disposeWithEditorIfNeeded) {
        if ($isDisposed.compareAndSet(false, true)) {
            Disposer.dispose((Disposable)$this_disposeWithEditorIfNeeded);
        }
    }

    static {
        Key key = Key.create((String)"inline.completion.handler");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        KEY = key;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(InlineCompletionHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

