/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.inline.completion.render;

import com.intellij.codeInsight.inline.completion.render.InlineCompletionComponentFactory;
import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.editor.impl.FoldingKeys;
import com.intellij.openapi.observable.util.DisposerUtilKt;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0001H\u0007J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0010H\u0007J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0010H\u0007J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0017\u001a\u00020\u0010H\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/codeInsight/inline/completion/render/InlineCompletionFoldingManager;", "Lcom/intellij/openapi/Disposable;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/openapi/editor/Editor;)V", "document", "Lcom/intellij/openapi/editor/Document;", "getDocument", "()Lcom/intellij/openapi/editor/Document;", "foldingModel", "Lcom/intellij/openapi/editor/FoldingModel;", "getFoldingModel", "()Lcom/intellij/openapi/editor/FoldingModel;", "foldedLines", "", "", "Lcom/intellij/openapi/editor/FoldRegion;", "foldLineEnd", "Lcom/intellij/openapi/util/TextRange;", "startOffset", "disposable", "firstNotFoldedOffset", "offset", "offsetOfFoldStart", "getFoldingRegion", "dispose", "", "clear", "Companion", "intellij.platform.ide.codeinsight.inline"})
@SourceDebugExtension(value={"SMAP\nInlineCompletionFoldingManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlineCompletionFoldingManager.kt\ncom/intellij/codeInsight/inline/completion/render/InlineCompletionFoldingManager\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,159:1\n60#2,5:160\n60#2,5:165\n23#2:172\n216#3,2:170\n*S KotlinDebug\n*F\n+ 1 InlineCompletionFoldingManager.kt\ncom/intellij/codeInsight/inline/completion/render/InlineCompletionFoldingManager\n*L\n56#1:160,5\n87#1:165,5\n142#1:172\n133#1:170,2\n*E\n"})
public final class InlineCompletionFoldingManager
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Editor editor;
    @NotNull
    private final Map<Integer, FoldRegion> foldedLines;
    @NotNull
    private static final Key<InlineCompletionFoldingManager> KEY = new Key("inline.completion.folding.manager");
    @NotNull
    private static final Logger LOG;

    private InlineCompletionFoldingManager(Editor editor) {
        this.editor = editor;
        this.foldedLines = new LinkedHashMap();
    }

    private final Document getDocument() {
        Document document = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        return document;
    }

    private final FoldingModel getFoldingModel() {
        FoldingModel foldingModel = this.editor.getFoldingModel();
        Intrinsics.checkNotNullExpressionValue((Object)foldingModel, (String)"getFoldingModel(...)");
        return foldingModel;
    }

    @RequiresEdt
    @Nullable
    public final TextRange foldLineEnd(int startOffset, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        ThreadingAssertions.assertEventDispatchThread();
        if (!InlineCompletionFoldingManager.Companion.isFoldingSupported(this.editor)) {
            return null;
        }
        FoldingModel foldingModel = this.getFoldingModel();
        Intrinsics.checkNotNull((Object)foldingModel, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.FoldingModelEx");
        FoldingModelEx foldingModel2 = (FoldingModelEx)foldingModel;
        int lineNumber = this.getDocument().getLineNumber(startOffset);
        int lineEnd = this.getDocument().getLineEndOffset(lineNumber);
        if (startOffset == lineEnd) {
            return null;
        }
        int n = startOffset + 1;
        int n2 = this.editor.getCaretModel().getOffset();
        boolean bl = n <= n2 ? n2 < lineEnd : false;
        if (bl) {
            Logger $this$debug_u24default$iv = LOG;
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl2 = false;
                logger.debug("[Inline Completion] Cannot fold a line end because the caret is inside the range.", e$iv);
            }
            return null;
        }
        if (this.foldedLines.containsKey(lineNumber)) {
            LOG.error("[Inline Completion] Incorrect state of folding. The same line " + lineNumber + " is folded twice.");
            return null;
        }
        foldingModel2.runBatchFoldingOperation(() -> InlineCompletionFoldingManager.foldLineEnd$lambda$1(foldingModel2, startOffset, lineEnd, this, lineNumber, disposable));
        FoldRegion foldRegion = this.foldedLines.get(lineNumber);
        return foldRegion != null ? foldRegion.getTextRange() : null;
    }

    @RequiresEdt
    public final int firstNotFoldedOffset(int offset) {
        FoldRegion foldRegion = this.getFoldingRegion(offset);
        if (foldRegion == null) {
            return offset;
        }
        FoldRegion foldRegion2 = foldRegion;
        return foldRegion2.getTextRange().contains(offset) ? foldRegion2.getEndOffset() : offset;
    }

    @RequiresEdt
    public final int offsetOfFoldStart(int offset) {
        FoldRegion foldRegion = this.getFoldingRegion(offset);
        if (foldRegion == null) {
            return offset;
        }
        FoldRegion foldRegion2 = foldRegion;
        TextRange textRange = foldRegion2.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
        TextRange range = textRange;
        return range.contains(offset) || range.getEndOffset() == offset ? foldRegion2.getStartOffset() : offset;
    }

    private final FoldRegion getFoldingRegion(int offset) {
        ThreadingAssertions.assertEventDispatchThread();
        return this.foldedLines.get(this.getDocument().getLineNumber(offset));
    }

    public void dispose() {
        if (!this.foldedLines.isEmpty()) {
            LOG.error("[Inline Completion] Incorrect state of folding. Some folded regions are not disposed.");
            this.clear();
        }
    }

    private final void clear() {
        this.getFoldingModel().runBatchFoldingOperation(() -> InlineCompletionFoldingManager.clear$lambda$0(this));
        this.foldedLines.clear();
    }

    private static final void foldLineEnd$lambda$1(FoldingModelEx $foldingModel, int $startOffset, int $lineEnd, InlineCompletionFoldingManager this$0, int $lineNumber, Disposable $disposable) {
        FoldRegion foldRegion = $foldingModel.createFoldRegion($startOffset, $lineEnd, "", null, true);
        if (foldRegion != null) {
            foldRegion.putUserData(FoldingKeys.ADDITIONAL_CARET_POSITION_FOR_EMPTY_PLACEHOLDER, (Object)true);
            foldRegion.setExpanded(false);
            foldRegion.setGreedyToRight(false);
            foldRegion.setGreedyToLeft(false);
            this$0.foldedLines.put($lineNumber, foldRegion);
            DisposerUtilKt.whenDisposed((Disposable)$disposable, () -> InlineCompletionFoldingManager.foldLineEnd$lambda$1$0($foldingModel, this$0, $lineNumber, foldRegion));
        } else {
            Logger $this$debug_u24default$iv = LOG;
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("[Inline Completion] Failed to fold line " + $lineNumber + ".", e$iv);
            }
        }
    }

    private static final Unit foldLineEnd$lambda$1$0(FoldingModelEx $foldingModel, InlineCompletionFoldingManager this$0, int $lineNumber, FoldRegion $foldRegion) {
        $foldingModel.runBatchFoldingOperation(() -> InlineCompletionFoldingManager.foldLineEnd$lambda$1$0$0($foldingModel, $foldRegion));
        this$0.foldedLines.remove($lineNumber);
        return Unit.INSTANCE;
    }

    private static final void foldLineEnd$lambda$1$0$0(FoldingModelEx $foldingModel, FoldRegion $foldRegion) {
        $foldingModel.removeFoldRegion($foldRegion);
    }

    private static final void clear$lambda$0(InlineCompletionFoldingManager this$0) {
        Map<Integer, FoldRegion> $this$forEach$iv = this$0.foldedLines;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Integer, FoldRegion>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, FoldRegion> element$iv;
            Map.Entry<Integer, FoldRegion> entry = element$iv = iterator.next();
            boolean bl = false;
            FoldRegion region = entry.getValue();
            this$0.getFoldingModel().removeFoldRegion(region);
        }
    }

    public /* synthetic */ InlineCompletionFoldingManager(Editor editor, DefaultConstructorMarker $constructor_marker) {
        this(editor);
    }

    static {
        Companion $this$thisLogger$iv = Companion;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0014R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u00068TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/intellij/codeInsight/inline/completion/render/InlineCompletionFoldingManager$Companion;", "Lcom/intellij/codeInsight/inline/completion/render/InlineCompletionComponentFactory;", "Lcom/intellij/codeInsight/inline/completion/render/InlineCompletionFoldingManager;", "<init>", "()V", "KEY", "Lcom/intellij/openapi/util/Key;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "isFoldingSupported", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "create", "key", "getKey", "()Lcom/intellij/openapi/util/Key;", "intellij.platform.ide.codeinsight.inline"})
    public static final class Companion
    extends InlineCompletionComponentFactory<InlineCompletionFoldingManager> {
        private Companion() {
        }

        private final boolean isFoldingSupported(Editor editor) {
            if (!ClientId.Companion.isLocal(ClientId.Companion.getCurrentOrNull())) {
                return false;
            }
            FoldingModel foldingModel = editor.getFoldingModel();
            Intrinsics.checkNotNullExpressionValue((Object)foldingModel, (String)"getFoldingModel(...)");
            FoldingModel foldingModel2 = foldingModel;
            return foldingModel2 instanceof FoldingModelEx && ((FoldingModelEx)foldingModel2).isFoldingEnabled();
        }

        @Override
        @NotNull
        protected InlineCompletionFoldingManager create(@NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            return new InlineCompletionFoldingManager(editor, null);
        }

        @Override
        @NotNull
        protected Key<InlineCompletionFoldingManager> getKey() {
            return KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

