/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.inline.completion.render;

import com.intellij.codeInsight.inline.completion.InlineCompletionFontUtils;
import com.intellij.codeInsight.inline.completion.render.InlineCompletionRenderTextBlock;
import com.intellij.codeInsight.inline.completion.render.InlineCompletionRenderingUtilsKt;
import com.intellij.codeInsight.inline.completion.render.InlineCompletionVolumetricTextBlockFactory;
import com.intellij.ide.ui.AntialiasingType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.ui.paint.EffectPainter2D;
import com.intellij.ui.paint.RectanglePainter2D;
import com.intellij.util.concurrency.ThreadingAssertions;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.TextLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB#\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\u0007\u0010\rJ\u0016\u0010\u0016\u001a\u00020\u00172\u000e\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\u0019J\u0014\u0010\u001a\u001a\u00020\u001b2\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0019H\u0016J$\u0010\u001c\u001a\u00020\u00172\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0014J,\u0010!\u001a\u00020\u00172\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\"\u001a\u00020\fH\u0016J:\u0010#\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(2\u0006\u0010*\u001a\u00020(2\u0006\u0010+\u001a\u00020(H\u0002J<\u0010,\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&2\b\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(2\u0006\u0010*\u001a\u00020(H\u0002J\u001c\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R0\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u00060"}, d2={"Lcom/intellij/codeInsight/inline/completion/render/InlineCompletionLineRenderer;", "Lcom/intellij/openapi/editor/EditorCustomElementRenderer;", "editor", "Lcom/intellij/openapi/editor/Editor;", "initialBlocks", "", "Lcom/intellij/codeInsight/inline/completion/render/InlineCompletionRenderTextBlock;", "<init>", "(Lcom/intellij/openapi/editor/Editor;Ljava/util/List;)V", "text", "", "attributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "(Lcom/intellij/openapi/editor/Editor;Ljava/lang/String;Lcom/intellij/openapi/editor/markup/TextAttributes;)V", "isDirty", "", "newBlocks", "blocks", "getBlocks", "()Ljava/util/List;", "setBlocks$intellij_platform_ide_codeinsight_inline", "(Ljava/util/List;)V", "updateIfNeeded", "", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "calcWidthInPixels", "", "beforePaint", "g", "Ljava/awt/Graphics;", "targetRegion", "Ljava/awt/Rectangle;", "paint", "textAttributes", "paintBackground", "Ljava/awt/Graphics2D;", "color", "Ljava/awt/Color;", "x", "", "y", "width", "height", "paintEffect", "effectType", "Lcom/intellij/openapi/editor/markup/EffectType;", "format", "intellij.platform.ide.codeinsight.inline"})
@ApiStatus.Internal
@ApiStatus.NonExtendable
@SourceDebugExtension(value={"SMAP\nInlineCompletionLineRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlineCompletionLineRenderer.kt\ncom/intellij/codeInsight/inline/completion/render/InlineCompletionLineRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,146:1\n774#2:147\n865#2,2:148\n1563#2:150\n1634#2,3:151\n*S KotlinDebug\n*F\n+ 1 InlineCompletionLineRenderer.kt\ncom/intellij/codeInsight/inline/completion/render/InlineCompletionLineRenderer\n*L\n143#1:147\n143#1:148,2\n143#1:150\n143#1:151,3\n*E\n"})
public class InlineCompletionLineRenderer
implements EditorCustomElementRenderer {
    @NotNull
    private final Editor editor;
    private boolean isDirty;
    @NotNull
    private List<InlineCompletionRenderTextBlock> blocks;

    public InlineCompletionLineRenderer(@NotNull Editor editor, @NotNull List<InlineCompletionRenderTextBlock> initialBlocks) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(initialBlocks, (String)"initialBlocks");
        this.editor = editor;
        this.blocks = this.format(initialBlocks);
    }

    public InlineCompletionLineRenderer(@NotNull Editor editor, @NotNull String text, @NotNull TextAttributes attributes) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        this(editor, CollectionsKt.listOf((Object)new InlineCompletionRenderTextBlock(text, attributes)));
    }

    public /* synthetic */ InlineCompletionLineRenderer(Editor editor, String string, TextAttributes textAttributes, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            textAttributes = InlineCompletionFontUtils.INSTANCE.attributes(editor);
        }
        this(editor, string, textAttributes);
    }

    @NotNull
    public final List<InlineCompletionRenderTextBlock> getBlocks() {
        return this.blocks;
    }

    public final void setBlocks$intellij_platform_ide_codeinsight_inline(@NotNull List<InlineCompletionRenderTextBlock> newBlocks) {
        Intrinsics.checkNotNullParameter(newBlocks, (String)"newBlocks");
        ThreadingAssertions.assertEventDispatchThread();
        this.isDirty = true;
        this.blocks = this.format(newBlocks);
    }

    public final void updateIfNeeded(@NotNull Inlay<? extends InlineCompletionLineRenderer> inlay) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        ThreadingAssertions.assertEventDispatchThread();
        if (!(inlay.getRenderer() == this)) {
            throw new IllegalStateException("Check failed.");
        }
        if (this.isDirty) {
            inlay.update();
            this.isDirty = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public int calcWidthInPixels(@NotNull Inlay<?> inlay) {
        double d;
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        AutoCloseable autoCloseable = new InlineCompletionVolumetricTextBlockFactory(this.editor);
        Throwable throwable = null;
        try {
            InlineCompletionVolumetricTextBlockFactory volumetricFactory = (InlineCompletionVolumetricTextBlockFactory)autoCloseable;
            boolean bl = false;
            Iterable iterable = this.blocks;
            double d2 = 0.0;
            for (Object t : iterable) {
                void block;
                InlineCompletionRenderTextBlock inlineCompletionRenderTextBlock = (InlineCompletionRenderTextBlock)t;
                double d3 = d2;
                boolean bl2 = false;
                double d4 = ((CharSequence)block.getText()).length() == 0 ? 0.0 : volumetricFactory.getVolumetric((InlineCompletionRenderTextBlock)block).getWidthInPixels();
                d2 = d3 + d4;
            }
            d = d2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        double result2 = d;
        return Math.max(1, InlineCompletionVolumetricTextBlockFactory.Companion.accumulatedWidthToInt$intellij_platform_ide_codeinsight_inline(result2));
    }

    protected void beforePaint(@NotNull Inlay<?> inlay, @NotNull Graphics g, @NotNull Rectangle targetRegion) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)targetRegion, (String)"targetRegion");
    }

    public void paint(@NotNull Inlay<?> inlay, @NotNull Graphics g, @NotNull Rectangle targetRegion, @NotNull TextAttributes textAttributes) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)targetRegion, (String)"targetRegion");
        Intrinsics.checkNotNullParameter((Object)textAttributes, (String)"textAttributes");
        if (this.blocks.isEmpty()) {
            return;
        }
        this.beforePaint(inlay, g, targetRegion);
        Object previousRenderingHint = ((Graphics2D)g).getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, AntialiasingType.getKeyForCurrentScope((boolean)false));
        double x = targetRegion.x;
        for (InlineCompletionRenderTextBlock block : this.blocks) {
            if (((CharSequence)block.getText()).length() == 0) continue;
            ((Graphics2D)g).setFont(InlineCompletionFontUtils.INSTANCE.getFont$intellij_platform_ide_codeinsight_inline(this.editor, block.getText(), block.getAttributes().getFontType()));
            TextLayout textLayout = new TextLayout(block.getText(), ((Graphics2D)g).getFont(), ((Graphics2D)g).getFontRenderContext());
            double textWidth = textLayout.getAdvance();
            double textHeight = targetRegion.height;
            int topY = targetRegion.y;
            int bottomY = topY + this.editor.getAscent();
            this.paintBackground((Graphics2D)g, block.getAttributes().getBackgroundColor(), x, topY, textWidth, textHeight);
            this.paintEffect((Graphics2D)g, block.getAttributes().getEffectColor(), block.getAttributes().getEffectType(), x, bottomY, textWidth);
            ((Graphics2D)g).setColor(block.getAttributes().getForegroundColor());
            textLayout.draw((Graphics2D)g, (float)x, bottomY);
            x += textWidth;
        }
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, previousRenderingHint);
    }

    private final void paintBackground(Graphics2D g, Color color, double x, double y, double width, double height) {
        if (color == null) {
            return;
        }
        g.setColor(color);
        RectanglePainter2D.FILL.paint(g, x, y, width, height);
    }

    private final void paintEffect(Graphics2D g, Color color, EffectType effectType, double x, double y, double width) {
        EffectPainter2D painter;
        if (color == null || effectType == null) {
            return;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[effectType.ordinal()]) {
            case 1: {
                EffectPainter2D effectPainter2D = EffectPainter2D.LINE_UNDERSCORE;
                break;
            }
            case 2: {
                EffectPainter2D effectPainter2D = EffectPainter2D.WAVE_UNDERSCORE;
                break;
            }
            case 3: {
                EffectPainter2D effectPainter2D = EffectPainter2D.STRIKE_THROUGH;
                break;
            }
            case 4: {
                EffectPainter2D effectPainter2D = EffectPainter2D.BOLD_LINE_UNDERSCORE;
                break;
            }
            case 5: {
                EffectPainter2D effectPainter2D = EffectPainter2D.BOLD_DOTTED_UNDERSCORE;
                break;
            }
            default: {
                EffectPainter2D effectPainter2D = painter = null;
            }
        }
        if (painter != null) {
            g.setColor(color);
            painter.paint(g, x, y, width, (double)g.getFontMetrics().getDescent(), (Object)g.getFont());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<InlineCompletionRenderTextBlock> format(List<InlineCompletionRenderTextBlock> blocks) {
        void $this$mapTo$iv$iv;
        InlineCompletionRenderTextBlock it;
        Iterable $this$filterTo$iv$iv;
        int tabSize = this.editor.getSettings().getTabSize(this.editor.getProject());
        Iterable $this$filter$iv = blocks;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (InlineCompletionRenderTextBlock)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)it.getText()).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (InlineCompletionRenderTextBlock)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(InlineCompletionRenderTextBlock.copy$default(it, InlineCompletionRenderingUtilsKt.formatTabs(it.getText(), tabSize), null, null, 6, null));
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EffectType.values().length];
            try {
                nArray[EffectType.LINE_UNDERSCORE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EffectType.WAVE_UNDERSCORE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EffectType.STRIKEOUT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EffectType.BOLD_LINE_UNDERSCORE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EffectType.BOLD_DOTTED_LINE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

