/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.inline.completion.tooltip;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.inline.completion.session.InlineCompletionSession;
import com.intellij.codeInsight.inline.completion.tooltip.InlineCompletionTooltip;
import com.intellij.codeInsight.inline.completion.tooltip.InlineCompletionTooltipComponent;
import com.intellij.codeInsight.inline.completion.tooltip.onboarding.InlineCompletionOnboardingComponent;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.client.ClientSessionsUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.util.UiSizeUtilKt;
import com.intellij.util.ApplicationKt;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.awt.Point;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0007R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/codeInsight/inline/completion/tooltip/InlineCompletionTooltip;", "", "<init>", "()V", "tooltipKey", "Lcom/intellij/openapi/util/Key;", "", "show", "session", "Lcom/intellij/codeInsight/inline/completion/session/InlineCompletionSession;", "intellij.platform.ide.codeinsight.inline"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nInlineCompletionTooltip.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlineCompletionTooltip.kt\ncom/intellij/codeInsight/inline/completion/tooltip/InlineCompletionTooltip\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,82:1\n1#2:83\n*E\n"})
public final class InlineCompletionTooltip {
    @NotNull
    public static final InlineCompletionTooltip INSTANCE = new InlineCompletionTooltip();
    @NotNull
    private static final Key<Unit> tooltipKey = new Key("EDITOR_HAS_INLINE_TOOLTIP");

    private InlineCompletionTooltip() {
    }

    @RequiresEdt
    public final void show(@NotNull InlineCompletionSession session) {
        Point point;
        LightweightHint lightweightHint;
        LookupEx activeLookup;
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Editor editor = session.getContext().getEditor();
        if (tooltipKey.isIn((UserDataHolder)editor)) {
            return;
        }
        if (!ClientSessionsUtil.getCurrentSession((Application)ApplicationKt.getApplication()).isLocal() && !Boolean.parseBoolean(System.getProperty("inline.completion.tooltip.remote.dev"))) {
            return;
        }
        LookupEx lookupEx = activeLookup = LookupManager.getActiveLookup((Editor)editor);
        boolean bl = lookupEx != null ? lookupEx.isPositionedAboveCaret() : false;
        if (bl) {
            return;
        }
        DialogPanel panel = new InlineCompletionTooltipComponent().create(session);
        LightweightHint $this$show_u24lambda_u240 = lightweightHint = new LightweightHint(panel, editor){
            private final long hintShownMs;
            private boolean hintTimeRegistered;
            final /* synthetic */ Editor $editor;
            {
                this.$editor = $editor;
                super((JComponent)$panel);
                this.hintShownMs = System.currentTimeMillis();
            }

            protected void onPopupCancel() {
                this.$editor.putUserData(InlineCompletionTooltip.access$getTooltipKey$p(), null);
                if (!this.hintTimeRegistered) {
                    long hintHiddenMs = System.currentTimeMillis();
                    InlineCompletionOnboardingComponent.Companion.getInstance().fireTooltipLivedFor$intellij_platform_ide_codeinsight_inline(hintHiddenMs - this.hintShownMs);
                    this.hintTimeRegistered = true;
                }
            }
        };
        boolean bl2 = false;
        $this$show_u24lambda_u240.setForceShowAsPopup(true);
        $this$show_u24lambda_u240.setBelongsToGlobalPopupStack(false);
        LightweightHint hint2 = lightweightHint;
        int offset = ((Number)ActionsKt.runReadAction(() -> InlineCompletionTooltip.show$lambda$1(editor))).intValue();
        Point $this$show_u24lambda_u242 = point = HintManagerImpl.getHintPosition((LightweightHint)hint2, (Editor)editor, (LogicalPosition)editor.offsetToLogicalPosition(offset), (short)1);
        boolean bl3 = false;
        $this$show_u24lambda_u242.y -= UiSizeUtilKt.getPreferredHeight((JComponent)((JComponent)panel)) + JBUIScale.scale((int)8);
        Point location = point;
        HintManagerImpl.getInstanceImpl().showEditorHint(hint2, editor, location, 1064, 0, false, HintManagerImpl.createHintHint((Editor)editor, (Point)location, (LightweightHint)hint2, (short)1).setContentActive(false));
        editor.putUserData(tooltipKey, (Object)Unit.INSTANCE);
        Disposer.register((Disposable)session, () -> InlineCompletionTooltip.show$lambda$3(hint2));
    }

    private static final int show$lambda$1(Editor $editor) {
        return $editor.getCaretModel().getOffset();
    }

    private static final void show$lambda$3(show.hint.1 $hint) {
        $hint.hide();
    }

    public static final /* synthetic */ Key access$getTooltipKey$p() {
        return tooltipKey;
    }
}

