/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.inline.completion.listeners;

import com.intellij.codeInsight.inline.completion.elements.InlineCompletionElement;
import com.intellij.codeInsight.inline.completion.logs.InlineCompletionUsageTracker;
import com.intellij.codeInsight.inline.completion.session.InlineCompletionContext;
import com.intellij.codeInsight.inline.completion.utils.InlineCompletionHandlerUtils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseListener;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0014\u0010\b\u001a\u00020\t*\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\f"}, d2={"Lcom/intellij/codeInsight/inline/completion/listeners/InlineEditorMouseListener;", "Lcom/intellij/openapi/editor/event/EditorMouseListener;", "<init>", "()V", "mousePressed", "", "event", "Lcom/intellij/openapi/editor/event/EditorMouseEvent;", "containsPoint", "", "Lcom/intellij/codeInsight/inline/completion/session/InlineCompletionContext;", "Companion", "intellij.platform.ide.codeinsight.inline"})
@SourceDebugExtension(value={"SMAP\nInlineCompletionListeners.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlineCompletionListeners.kt\ncom/intellij/codeInsight/inline/completion/listeners/InlineEditorMouseListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,118:1\n1761#2,3:119\n23#3:122\n*S KotlinDebug\n*F\n+ 1 InlineCompletionListeners.kt\ncom/intellij/codeInsight/inline/completion/listeners/InlineEditorMouseListener\n*L\n31#1:119,3\n35#1:122\n*E\n"})
public final class InlineEditorMouseListener
implements EditorMouseListener {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private static final Logger LOG;

    public void mousePressed(@NotNull EditorMouseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Editor editor = event.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
        InlineCompletionContext inlineCompletionContext = InlineCompletionContext.Companion.getOrNull(editor);
        boolean bl = inlineCompletionContext != null ? this.containsPoint(inlineCompletionContext, event) : false;
        if (bl) {
            return;
        }
        LOG.trace("Valuable mouse pressed event " + event);
        Editor editor2 = event.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
        InlineCompletionHandlerUtils.INSTANCE.hideInlineCompletion(editor2, InlineCompletionUsageTracker.ShownEvents.FinishType.MOUSE_PRESSED);
    }

    private final boolean containsPoint(InlineCompletionContext $this$containsPoint, EditorMouseEvent event) {
        boolean bl;
        block3: {
            Point point = event.getMouseEvent().getPoint();
            Iterable $this$any$iv = $this$containsPoint.getState().getElements();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    InlineCompletionElement.Presentable it = (InlineCompletionElement.Presentable)element$iv;
                    boolean bl2 = false;
                    Rectangle rectangle = it.getBounds();
                    boolean bl3 = rectangle != null ? rectangle.contains(point) : false;
                    if (!bl3) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    static {
        Companion $this$thisLogger$iv = Companion = new Companion(null);
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/codeInsight/inline/completion/listeners/InlineEditorMouseListener$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.ide.codeinsight.inline"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

