/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.inline.completion.logs;

import com.intellij.codeInsight.inline.completion.InlineCompletionEvent;
import com.intellij.codeInsight.inline.completion.InlineCompletionEventType;
import com.intellij.codeInsight.inline.completion.InlineCompletionRequest;
import com.intellij.codeInsight.inline.completion.editor.InlineCompletionEditorType;
import com.intellij.codeInsight.inline.completion.elements.InlineCompletionElement;
import com.intellij.codeInsight.inline.completion.logs.CustomRequestIdLogger;
import com.intellij.codeInsight.inline.completion.logs.FinishingLogs;
import com.intellij.codeInsight.inline.completion.logs.InlineCompletionContextLogs;
import com.intellij.codeInsight.inline.completion.logs.InlineCompletionFilteringEventListener;
import com.intellij.codeInsight.inline.completion.logs.InlineCompletionLogsContainer;
import com.intellij.codeInsight.inline.completion.logs.InlineCompletionLogsListener;
import com.intellij.codeInsight.inline.completion.logs.InlineCompletionLogsUtils;
import com.intellij.codeInsight.inline.completion.logs.InlineCompletionUsageTracker;
import com.intellij.codeInsight.inline.completion.logs.InsertedStateTracker;
import com.intellij.codeInsight.inline.completion.logs.StartingLogs;
import com.intellij.codeInsight.inline.completion.session.InlineCompletionContext;
import com.intellij.codeInsight.inline.completion.session.InlineCompletionInvalidationListener;
import com.intellij.codeWithMe.ClientId;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiFile;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0002'(B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u000e2\u000e\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001f0\u001eH\u0002J\u0010\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u000eH\u0016J\u0010\u0010!\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\u000eH\u0002J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/codeInsight/inline/completion/logs/InlineCompletionLogsListener;", "Lcom/intellij/codeInsight/inline/completion/logs/InlineCompletionFilteringEventListener;", "Lcom/intellij/codeInsight/inline/completion/session/InlineCompletionInvalidationListener;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/openapi/editor/Editor;)V", "holder", "Lcom/intellij/codeInsight/inline/completion/logs/InlineCompletionLogsListener$Holder;", "isApplicable", "", "requestEvent", "Lcom/intellij/codeInsight/inline/completion/InlineCompletionEventType$Request;", "onRequest", "", "event", "onComputed", "Lcom/intellij/codeInsight/inline/completion/InlineCompletionEventType$Computed;", "onShow", "Lcom/intellij/codeInsight/inline/completion/InlineCompletionEventType$Show;", "onVariantSwitched", "Lcom/intellij/codeInsight/inline/completion/InlineCompletionEventType$VariantSwitched;", "onInsert", "Lcom/intellij/codeInsight/inline/completion/InlineCompletionEventType$Insert;", "onAfterInsert", "Lcom/intellij/codeInsight/inline/completion/InlineCompletionEventType$AfterInsert;", "onChange", "Lcom/intellij/codeInsight/inline/completion/InlineCompletionEventType$Change;", "onInvalidatedByEvent", "eventClass", "Ljava/lang/Class;", "Lcom/intellij/codeInsight/inline/completion/InlineCompletionEvent;", "onInvalidatedByUnclassifiedDocumentChange", "onHide", "Lcom/intellij/codeInsight/inline/completion/InlineCompletionEventType$Hide;", "startTracking", "getDurations", "", "Ljava/time/Duration;", "Holder", "VariantState", "intellij.platform.ide.codeinsight.inline"})
@SourceDebugExtension(value={"SMAP\nInlineCompletionLogsListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlineCompletionLogsListener.kt\ncom/intellij/codeInsight/inline/completion/logs/InlineCompletionLogsListener\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,245:1\n42#2,3:246\n*S KotlinDebug\n*F\n+ 1 InlineCompletionLogsListener.kt\ncom/intellij/codeInsight/inline/completion/logs/InlineCompletionLogsListener\n*L\n197#1:246,3\n*E\n"})
public final class InlineCompletionLogsListener
extends InlineCompletionFilteringEventListener
implements InlineCompletionInvalidationListener {
    @NotNull
    private final Editor editor;
    @NotNull
    private Holder holder;

    public InlineCompletionLogsListener(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.editor = editor;
        this.holder = new Holder();
    }

    @Override
    protected boolean isApplicable(@NotNull InlineCompletionEventType.Request requestEvent) {
        Intrinsics.checkNotNullParameter((Object)requestEvent, (String)"requestEvent");
        return InlineCompletionLogsUtils.INSTANCE.isLoggable(requestEvent.getProvider());
    }

    @Override
    public void onRequest(@NotNull InlineCompletionEventType.Request event) {
        PsiFile file;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.holder = new Holder();
        this.holder.setLastInvocationTimestamp(System.currentTimeMillis());
        this.holder.setRequestId(event.getRequest().getRequestId());
        InlineCompletionLogsContainer container = InlineCompletionLogsContainer.Companion.create(event.getRequest().getEditor());
        container.addProject(event.getRequest().getEditor().getProject());
        container.add(StartingLogs.INSTANCE.getREQUEST_ID().with((Object)event.getRequest().getRequestId()));
        container.add(StartingLogs.INSTANCE.getREQUEST_EVENT().with(event.getRequest().getEvent().getClass()));
        container.add(StartingLogs.INSTANCE.getEDITOR_TYPE().with((Object)InlineCompletionEditorType.Companion.get(event.getRequest().getEditor())));
        container.add(StartingLogs.INSTANCE.getINLINE_API_PROVIDER().with(event.getProvider()));
        InlineCompletionRequest inlineCompletionRequest = event.getRequest().getEvent().toRequest();
        PsiFile psiFile = file = inlineCompletionRequest != null ? inlineCompletionRequest.getFile() : null;
        if (psiFile != null) {
            PsiFile it = psiFile;
            boolean bl = false;
            Language language = it.getLanguage();
            Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
            Language fileLanguage = language;
            container.add(StartingLogs.INSTANCE.getFILE_LANGUAGE().with((Object)fileLanguage));
        }
        container.addAsync((Function1)new Function1<Continuation<? super List<? extends EventPair<?>>>, Object>(event, null){
            int label;
            final /* synthetic */ InlineCompletionEventType.Request $event;
            {
                this.$event = $event;
                super(1, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = CoroutinesKt.readAction(() -> onRequest.2.invokeSuspend$lambda$0(this.$event), (Continuation)((Continuation)this));
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super List<? extends EventPair<?>>> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }

            private static final List invokeSuspend$lambda$0(InlineCompletionEventType.Request $event) {
                return InlineCompletionContextLogs.INSTANCE.getFor($event.getRequest());
            }
        });
    }

    @Override
    public void onComputed(@NotNull InlineCompletionEventType.Computed event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.holder.getPotentiallySelectedIndex() == null) {
            this.holder.setPotentiallySelectedIndex(event.getVariantIndex());
        }
        VariantState variantState = this.holder.getVariantStates().computeIfAbsent(event.getVariantIndex(), arg_0 -> InlineCompletionLogsListener.onComputed$lambda$1(InlineCompletionLogsListener::onComputed$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)variantState, (String)"computeIfAbsent(...)");
        VariantState state = variantState;
        state.setInitialSuggestion(state.getInitialSuggestion() + event.getElement().getText());
        state.setFinalSuggestion(state.getFinalSuggestion() + event.getElement().getText());
    }

    @Override
    public void onShow(@NotNull InlineCompletionEventType.Show event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.holder.getWasShown()) {
            return;
        }
        this.holder.setWasShown(true);
        InlineCompletionLogsContainer inlineCompletionLogsContainer = InlineCompletionLogsContainer.Companion.get(this.editor);
        if (inlineCompletionLogsContainer == null) {
            return;
        }
        InlineCompletionLogsContainer container = inlineCompletionLogsContainer;
        container.add(FinishingLogs.INSTANCE.getTIME_TO_START_SHOWING().with((Object)(System.currentTimeMillis() - this.holder.getLastInvocationTimestamp())));
        this.holder.setShowStartTime(System.currentTimeMillis());
    }

    @Override
    public void onVariantSwitched(@NotNull InlineCompletionEventType.VariantSwitched event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.holder.setPotentiallySelectedIndex(event.getToVariantIndex());
    }

    @Override
    public void onInsert(@NotNull InlineCompletionEventType.Insert event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        InlineCompletionContext context = InlineCompletionContext.Companion.getOrNull(this.editor);
        Object object = context;
        if (object == null || (object = object.textToInsert()) == null) {
            return;
        }
        InlineCompletionContext textToInsert = object;
        Holder holder = this.holder;
        holder.setTotalInsertedLength(holder.getTotalInsertedLength() + ((String)((Object)textToInsert)).length());
        holder = this.holder;
        holder.setTotalInsertedLines(holder.getTotalInsertedLines() + StringsKt.lines((CharSequence)((CharSequence)((Object)textToInsert))).size());
        holder = this.holder;
        int n = holder.getFullInsertActions();
        holder.setFullInsertActions(n + 1);
        this.holder.setTrackedStartOffset(context.startOffset());
        this.holder.setTrackedEndOffset(context.endOffset());
        this.holder.setTrackedLanguage(context.getLanguage());
    }

    @Override
    public void onAfterInsert(@NotNull InlineCompletionEventType.AfterInsert event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.startTracking();
        this.holder = new Holder();
    }

    @Override
    public void onChange(@NotNull InlineCompletionEventType.Change event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        InlineCompletionEvent inlineCompletionEvent = event.getEvent();
        if (inlineCompletionEvent instanceof InlineCompletionEvent.InsertNextWord) {
            Holder holder = this.holder;
            holder.setTotalInsertedLength(holder.getTotalInsertedLength() + event.getLengthChange());
            holder = this.holder;
            int n = holder.getNextWordActions();
            holder.setNextWordActions(n + 1);
        } else if (inlineCompletionEvent instanceof InlineCompletionEvent.InsertNextLine) {
            Holder holder = this.holder;
            holder.setTotalInsertedLength(holder.getTotalInsertedLength() + event.getLengthChange());
            holder = this.holder;
            int n = holder.getTotalInsertedLines();
            holder.setTotalInsertedLines(n + 1);
            holder = this.holder;
            n = holder.getNextLineActions();
            holder.setNextLineActions(n + 1);
        }
        VariantState variantState = this.holder.getVariantStates().get(event.getVariantIndex());
        Intrinsics.checkNotNull((Object)variantState);
        VariantState state = variantState;
        state.setFinalSuggestion(CollectionsKt.joinToString$default((Iterable)event.getElements(), (CharSequence)"", null, null, (int)0, null, InlineCompletionLogsListener::onChange$lambda$0, (int)30, null));
    }

    private final void onInvalidatedByEvent(Class<? extends InlineCompletionEvent> eventClass) {
        InlineCompletionLogsContainer inlineCompletionLogsContainer = InlineCompletionLogsContainer.Companion.get(this.editor);
        if (inlineCompletionLogsContainer == null) {
            return;
        }
        InlineCompletionLogsContainer container = inlineCompletionLogsContainer;
        container.add(FinishingLogs.INSTANCE.getINVALIDATION_EVENT().with(eventClass));
    }

    @Override
    public void onInvalidatedByEvent(@NotNull InlineCompletionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.onInvalidatedByEvent(event.getClass());
    }

    @Override
    public void onInvalidatedByUnclassifiedDocumentChange() {
        this.onInvalidatedByEvent(InlineCompletionEvent.DocumentChange.class);
    }

    @Override
    public void onHide(@NotNull InlineCompletionEventType.Hide event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        InlineCompletionLogsContainer inlineCompletionLogsContainer = InlineCompletionLogsContainer.Companion.remove(this.editor);
        if (inlineCompletionLogsContainer == null) {
            return;
        }
        InlineCompletionLogsContainer container = inlineCompletionLogsContainer;
        Holder $this$onHide_u24lambda_u240 = this.holder;
        boolean bl = false;
        container.add(FinishingLogs.INSTANCE.getFINISH_TYPE().with((Object)event.getFinishType()));
        container.add(FinishingLogs.INSTANCE.getWAS_SHOWN().with((Object)$this$onHide_u24lambda_u240.getWasShown()));
        if ($this$onHide_u24lambda_u240.getWasShown()) {
            container.add(FinishingLogs.INSTANCE.getSHOWING_TIME().with((Object)(System.currentTimeMillis() - $this$onHide_u24lambda_u240.getShowStartTime())));
            container.add(FinishingLogs.INSTANCE.getFULL_INSERT_ACTIONS().with((Object)$this$onHide_u24lambda_u240.getFullInsertActions()));
            container.add(FinishingLogs.INSTANCE.getNEXT_WORD_ACTIONS().with((Object)$this$onHide_u24lambda_u240.getNextWordActions()));
            container.add(FinishingLogs.INSTANCE.getNEXT_LINE_ACTIONS().with((Object)$this$onHide_u24lambda_u240.getNextLineActions()));
            container.add(FinishingLogs.INSTANCE.getTOTAL_INSERTED_LENGTH().with((Object)$this$onHide_u24lambda_u240.getTotalInsertedLength()));
            container.add(FinishingLogs.INSTANCE.getTOTAL_INSERTED_LINES().with((Object)$this$onHide_u24lambda_u240.getTotalInsertedLines()));
            VariantState variantState = $this$onHide_u24lambda_u240.getVariantStates().get($this$onHide_u24lambda_u240.getPotentiallySelectedIndex());
            if (variantState != null) {
                VariantState state = variantState;
                boolean bl2 = false;
                container.add(FinishingLogs.INSTANCE.getRECEIVED_PROPOSAL_LENGTH().with((Object)state.getInitialSuggestion().length()));
                container.add(FinishingLogs.INSTANCE.getRECEIVED_PROPOSAL_LINES().with((Object)StringsKt.lines((CharSequence)state.getInitialSuggestion()).size()));
                container.add(FinishingLogs.INSTANCE.getFINAL_PROPOSAL_LENGTH().with((Object)state.getFinalSuggestion().length()));
                container.add(FinishingLogs.INSTANCE.getFINAL_PROPOSAL_LINE().with((Object)StringsKt.lines((CharSequence)state.getFinalSuggestion()).size()));
            }
        }
        container.logCurrent(CustomRequestIdLogger.Companion.remove(this.editor));
        if (event.getFinishType() != InlineCompletionUsageTracker.ShownEvents.FinishType.SELECTED) {
            this.holder = new Holder();
        }
    }

    private final void startTracking() {
        Integer n = this.holder.getPotentiallySelectedIndex();
        if (n == null) {
            return;
        }
        int selectedIndex = n;
        VariantState variantState = this.holder.getVariantStates().get(selectedIndex);
        if (variantState == null) {
            return;
        }
        VariantState selectedVariant = variantState;
        Integer n2 = this.holder.getTrackedStartOffset();
        if (n2 == null) {
            return;
        }
        int insertOffset = n2;
        Integer n3 = this.holder.getTrackedEndOffset();
        if (n3 == null) {
            return;
        }
        int endOffset = n3;
        boolean $i$f$service = false;
        Class<InsertedStateTracker> serviceClass$iv = InsertedStateTracker.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        ((InsertedStateTracker)object).trackV2(this.holder.getRequestId(), this.holder.getTrackedLanguage(), this.editor, endOffset, insertOffset, selectedVariant.getFinalSuggestion(), this.getDurations());
    }

    private final List<Duration> getDurations() {
        List list;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            list = CollectionsKt.listOf((Object)Duration.ofMillis(100L));
        } else {
            Object[] objectArray = new Duration[]{Duration.ofSeconds(10L), Duration.ofSeconds(30L), Duration.ofMinutes(1L), Duration.ofMinutes(5L)};
            list = CollectionsKt.listOf((Object[])objectArray);
        }
        return list;
    }

    private static final VariantState onComputed$lambda$0(Integer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new VariantState();
    }

    private static final VariantState onComputed$lambda$1(Function1 $tmp0, Object p0) {
        return (VariantState)$tmp0.invoke(p0);
    }

    private static final CharSequence onChange$lambda$0(InlineCompletionElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getText();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0017\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001a\u0010\r\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0007\"\u0004\b\u000f\u0010\tR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0019\"\u0004\b\u001e\u0010\u001bR\u001a\u0010\u001f\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0019\"\u0004\b!\u0010\u001bR\u001a\u0010\"\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0019\"\u0004\b$\u0010\u001bR\u001a\u0010%\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u0019\"\u0004\b'\u0010\u001bR\u001e\u0010(\u001a\u0004\u0018\u00010\u0017X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010-\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u001d\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u0002000/\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u001e\u00103\u001a\u0004\u0018\u00010\u0017X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010-\u001a\u0004\b4\u0010*\"\u0004\b5\u0010,R\u001e\u00106\u001a\u0004\u0018\u00010\u0017X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010-\u001a\u0004\b7\u0010*\"\u0004\b8\u0010,R\u001c\u00109\u001a\u0004\u0018\u00010:X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>\u00a8\u0006?"}, d2={"Lcom/intellij/codeInsight/inline/completion/logs/InlineCompletionLogsListener$Holder;", "", "<init>", "()V", "requestId", "", "getRequestId", "()J", "setRequestId", "(J)V", "lastInvocationTimestamp", "getLastInvocationTimestamp", "setLastInvocationTimestamp", "showStartTime", "getShowStartTime", "setShowStartTime", "wasShown", "", "getWasShown", "()Z", "setWasShown", "(Z)V", "fullInsertActions", "", "getFullInsertActions", "()I", "setFullInsertActions", "(I)V", "nextWordActions", "getNextWordActions", "setNextWordActions", "nextLineActions", "getNextLineActions", "setNextLineActions", "totalInsertedLength", "getTotalInsertedLength", "setTotalInsertedLength", "totalInsertedLines", "getTotalInsertedLines", "setTotalInsertedLines", "potentiallySelectedIndex", "getPotentiallySelectedIndex", "()Ljava/lang/Integer;", "setPotentiallySelectedIndex", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "variantStates", "", "Lcom/intellij/codeInsight/inline/completion/logs/InlineCompletionLogsListener$VariantState;", "getVariantStates", "()Ljava/util/Map;", "trackedStartOffset", "getTrackedStartOffset", "setTrackedStartOffset", "trackedEndOffset", "getTrackedEndOffset", "setTrackedEndOffset", "trackedLanguage", "Lcom/intellij/lang/Language;", "getTrackedLanguage", "()Lcom/intellij/lang/Language;", "setTrackedLanguage", "(Lcom/intellij/lang/Language;)V", "intellij.platform.ide.codeinsight.inline"})
    private static final class Holder {
        private long requestId;
        private long lastInvocationTimestamp;
        private long showStartTime;
        private boolean wasShown;
        private int fullInsertActions;
        private int nextWordActions;
        private int nextLineActions;
        private int totalInsertedLength;
        private int totalInsertedLines;
        @Nullable
        private Integer potentiallySelectedIndex;
        @NotNull
        private final Map<Integer, VariantState> variantStates = new LinkedHashMap();
        @Nullable
        private Integer trackedStartOffset;
        @Nullable
        private Integer trackedEndOffset;
        @Nullable
        private Language trackedLanguage;

        public final long getRequestId() {
            return this.requestId;
        }

        public final void setRequestId(long l) {
            this.requestId = l;
        }

        public final long getLastInvocationTimestamp() {
            return this.lastInvocationTimestamp;
        }

        public final void setLastInvocationTimestamp(long l) {
            this.lastInvocationTimestamp = l;
        }

        public final long getShowStartTime() {
            return this.showStartTime;
        }

        public final void setShowStartTime(long l) {
            this.showStartTime = l;
        }

        public final boolean getWasShown() {
            return this.wasShown;
        }

        public final void setWasShown(boolean bl) {
            this.wasShown = bl;
        }

        public final int getFullInsertActions() {
            return this.fullInsertActions;
        }

        public final void setFullInsertActions(int n) {
            this.fullInsertActions = n;
        }

        public final int getNextWordActions() {
            return this.nextWordActions;
        }

        public final void setNextWordActions(int n) {
            this.nextWordActions = n;
        }

        public final int getNextLineActions() {
            return this.nextLineActions;
        }

        public final void setNextLineActions(int n) {
            this.nextLineActions = n;
        }

        public final int getTotalInsertedLength() {
            return this.totalInsertedLength;
        }

        public final void setTotalInsertedLength(int n) {
            this.totalInsertedLength = n;
        }

        public final int getTotalInsertedLines() {
            return this.totalInsertedLines;
        }

        public final void setTotalInsertedLines(int n) {
            this.totalInsertedLines = n;
        }

        @Nullable
        public final Integer getPotentiallySelectedIndex() {
            return this.potentiallySelectedIndex;
        }

        public final void setPotentiallySelectedIndex(@Nullable Integer n) {
            this.potentiallySelectedIndex = n;
        }

        @NotNull
        public final Map<Integer, VariantState> getVariantStates() {
            return this.variantStates;
        }

        @Nullable
        public final Integer getTrackedStartOffset() {
            return this.trackedStartOffset;
        }

        public final void setTrackedStartOffset(@Nullable Integer n) {
            this.trackedStartOffset = n;
        }

        @Nullable
        public final Integer getTrackedEndOffset() {
            return this.trackedEndOffset;
        }

        public final void setTrackedEndOffset(@Nullable Integer n) {
            this.trackedEndOffset = n;
        }

        @Nullable
        public final Language getTrackedLanguage() {
            return this.trackedLanguage;
        }

        public final void setTrackedLanguage(@Nullable Language language) {
            this.trackedLanguage = language;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\t\u00a8\u0006\r"}, d2={"Lcom/intellij/codeInsight/inline/completion/logs/InlineCompletionLogsListener$VariantState;", "", "<init>", "()V", "initialSuggestion", "", "getInitialSuggestion", "()Ljava/lang/String;", "setInitialSuggestion", "(Ljava/lang/String;)V", "finalSuggestion", "getFinalSuggestion", "setFinalSuggestion", "intellij.platform.ide.codeinsight.inline"})
    private static final class VariantState {
        @NotNull
        private String initialSuggestion = "";
        @NotNull
        private String finalSuggestion = "";

        @NotNull
        public final String getInitialSuggestion() {
            return this.initialSuggestion;
        }

        public final void setInitialSuggestion(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.initialSuggestion = string;
        }

        @NotNull
        public final String getFinalSuggestion() {
            return this.finalSuggestion;
        }

        public final void setFinalSuggestion(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.finalSuggestion = string;
        }
    }
}

