/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.inline.completion.statistics;

import com.intellij.codeInsight.inline.completion.statistics.LocalStatistics;
import com.intellij.codeWithMe.ClientId;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.SimplePersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.xmlb.annotations.XMap;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

@Service
@com.intellij.openapi.components.State(name="DailyLocalStatistics", storages={@Storage(value="dailyLocalStatistics.xml", roamingType=RoamingType.DISABLED)})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0007\u0018\u0000 \u001f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0006\u001a\u001b\u001c\u001d\u001e\u001fB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J)\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0017\u0010\r\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u000b0\u000e\u00a2\u0006\u0002\b\u000fH\u0007J\u0014\u0010\u0014\u001a\u00020\u000b2\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0016H\u0007J\b\u0010\u0017\u001a\u00020\u000bH\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0007R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\u00020\u00118\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006 "}, d2={"Lcom/intellij/codeInsight/inline/completion/statistics/LocalStatistics;", "Lcom/intellij/openapi/components/SimplePersistentStateComponent;", "Lcom/intellij/codeInsight/inline/completion/statistics/LocalStatistics$State;", "<init>", "()V", "currentDate", "Lcom/intellij/codeInsight/inline/completion/statistics/LocalStatistics$Date;", "getCurrentDate", "()Lcom/intellij/codeInsight/inline/completion/statistics/LocalStatistics$Date;", "mockedCurrentDate", "withMockedCurrentDate", "", "date", "block", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "forcePrune", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getForcePrune", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "saveIfRegistered", "pair", "Lcom/intellij/internal/statistic/eventLog/events/EventPair;", "prune", "generateRepresentation", "", "Schema", "Date", "MetricValue", "DateState", "State", "Companion", "intellij.platform.ide.codeinsight.inline"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nLocalStatistics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalStatistics.kt\ncom/intellij/codeInsight/inline/completion/statistics/LocalStatistics\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,247:1\n1563#2:248\n1634#2,3:249\n774#2:252\n865#2,2:253\n1869#2,2:255\n1056#2:257\n*S KotlinDebug\n*F\n+ 1 LocalStatistics.kt\ncom/intellij/codeInsight/inline/completion/statistics/LocalStatistics\n*L\n168#1:248\n168#1:249,3\n169#1:252\n169#1:253,2\n171#1:255,2\n186#1:257\n*E\n"})
public final class LocalStatistics
extends SimplePersistentStateComponent<State> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Date mockedCurrentDate;
    @TestOnly
    @NotNull
    private final AtomicBoolean forcePrune = new AtomicBoolean(false);
    private static final long MONTHS_LIMIT = 3L;
    private static final double PRUNE_PROBABILITY = 0.01;

    public LocalStatistics() {
        super((BaseState)new State());
    }

    private final Date getCurrentDate() {
        Date date = this.mockedCurrentDate;
        if (date == null) {
            date = Date.Companion.now();
        }
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public final void withMockedCurrentDate(@NotNull Date date, @NotNull Function1<? super LocalStatistics, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        try {
            this.mockedCurrentDate = date;
            block.invoke((Object)this);
        }
        finally {
            this.mockedCurrentDate = null;
        }
    }

    @NotNull
    public final AtomicBoolean getForcePrune() {
        return this.forcePrune;
    }

    @RequiresBackgroundThread
    public final void saveIfRegistered(@NotNull EventPair<?> pair) {
        Intrinsics.checkNotNullParameter(pair, (String)"pair");
        if (!Schema.INSTANCE.getRegistered().contains(pair.getField().getName())) {
            return;
        }
        if (this.forcePrune.get() || Math.random() < 0.01) {
            this.prune();
        }
        MetricValue value = ((State)this.getState()).getOrPutValue(this.getCurrentDate(), pair.getField().getName());
        int n = value.getCount();
        value.setCount(n + 1);
        Object object = pair.getData();
        if (object instanceof Number) {
            float f = value.getSum();
            Object object2 = pair.getData();
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Number");
            value.setSum(f + ((Number)object2).floatValue());
        } else if (object instanceof Boolean || object instanceof Enum || object instanceof Language) {
            String strValue = String.valueOf(pair.getData());
            value.getDistribution().put(strValue, ((Number)value.getDistribution().getOrDefault(strValue, 0)).intValue() + 1);
        }
        ((State)this.getState()).valueModificationPerformed();
    }

    /*
     * WARNING - void declaration
     */
    private final void prune() {
        void $this$filterTo$iv$iv;
        Iterable $this$mapTo$iv$iv;
        LocalDate currentLocalDate = this.getCurrentDate().toLocalDate();
        LocalDate cutoffLocalDate = LocalDate.of(currentLocalDate.getYear(), currentLocalDate.getMonth(), 1).minusMonths(2L);
        Iterable $this$map$iv = ((State)this.getState()).getDateToStats().keySet();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Date.Companion.parseFromString$intellij_platform_ide_codeinsight_inline((String)it));
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Date date = (Date)element$iv$iv;
            boolean bl = false;
            if (!date.toLocalDate().isBefore(cutoffLocalDate)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Date it = (Date)element$iv;
            boolean bl = false;
            ((State)this.getState()).remove(it);
        }
    }

    @RequiresBackgroundThread
    @NotNull
    public final String generateRepresentation() {
        this.prune();
        StringBuilder jsonBuilder = new StringBuilder();
        jsonBuilder.append("{\n");
        Iterable $this$sortedBy$iv = ((State)this.getState()).getDateToStats().entrySet();
        boolean $i$f$sortedBy = false;
        List sortedDates = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)((String)it.getKey()));
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((String)it.getKey()))));
            }
        });
        Iterator iterator = ((Iterable)sortedDates).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int dateIndex = n++;
            Map.Entry dateEntry = (Map.Entry)iterator.next();
            String date = (String)dateEntry.getKey();
            DateState stats = (DateState)((Object)dateEntry.getValue());
            jsonBuilder.append("  \"" + date + "\": {\n");
            Iterator iterator2 = ((Iterable)stats.getValues().entrySet()).iterator();
            int n2 = 0;
            while (iterator2.hasNext()) {
                int statIndex = n2++;
                Map.Entry statEntry = (Map.Entry)iterator2.next();
                String fieldName = (String)statEntry.getKey();
                MetricValue value = (MetricValue)((Object)statEntry.getValue());
                jsonBuilder.append("    \"" + fieldName + "\": {\n");
                jsonBuilder.append("      \"count\": " + value.getCount() + ",\n");
                jsonBuilder.append("      \"sum\": " + value.getSum());
                if (!value.getDistribution().isEmpty()) {
                    jsonBuilder.append(",\n      \"distribution\": {\n");
                    List distributions = CollectionsKt.toList((Iterable)value.getDistribution().entrySet());
                    Iterator iterator3 = ((Iterable)distributions).iterator();
                    int n3 = 0;
                    while (iterator3.hasNext()) {
                        int distIndex = n3++;
                        Map.Entry distEntry = (Map.Entry)iterator3.next();
                        String distValue = (String)distEntry.getKey();
                        int distCount = ((Number)distEntry.getValue()).intValue();
                        jsonBuilder.append("        \"" + distValue + "\": " + distCount);
                        if (distIndex < distributions.size() - 1) {
                            jsonBuilder.append(",");
                        }
                        jsonBuilder.append("\n");
                    }
                    jsonBuilder.append("      }");
                }
                jsonBuilder.append("\n    }");
                if (statIndex < stats.getValues().size() - 1) {
                    jsonBuilder.append(",");
                }
                jsonBuilder.append("\n");
            }
            jsonBuilder.append("  }");
            if (dateIndex < sortedDates.size() - 1) {
                jsonBuilder.append(",");
            }
            jsonBuilder.append("\n");
        }
        jsonBuilder.append("}");
        String string = jsonBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/codeInsight/inline/completion/statistics/LocalStatistics$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/codeInsight/inline/completion/statistics/LocalStatistics;", "MONTHS_LIMIT", "", "PRUNE_PROBABILITY", "", "intellij.platform.ide.codeinsight.inline"})
    @SourceDebugExtension(value={"SMAP\nLocalStatistics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalStatistics.kt\ncom/intellij/codeInsight/inline/completion/statistics/LocalStatistics$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,247:1\n42#2,3:248\n*S KotlinDebug\n*F\n+ 1 LocalStatistics.kt\ncom/intellij/codeInsight/inline/completion/statistics/LocalStatistics$Companion\n*L\n238#1:248,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LocalStatistics getInstance() {
            boolean $i$f$service = false;
            Class<LocalStatistics> serviceClass$iv = LocalStatistics.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (LocalStatistics)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0086\b\u0018\u0000 \"2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\"B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0010J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0013J\u0011\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0000H\u0096\u0002J\u0006\u0010\u0016\u001a\u00020\u0017J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u0015\u001a\u0004\u0018\u00010\u001fH\u00d6\u0003J\t\u0010 \u001a\u00020\u0003H\u00d6\u0001J\t\u0010!\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006#"}, d2={"Lcom/intellij/codeInsight/inline/completion/statistics/LocalStatistics$Date;", "", "year", "", "month", "day", "hour", "<init>", "(IIII)V", "getYear", "()I", "getMonth", "getDay", "getHour", "serializeAsString", "", "serializeAsString$intellij_platform_ide_codeinsight_inline", "minusMonths", "months", "", "compareTo", "other", "toLocalDate", "Ljava/time/LocalDate;", "component1", "component2", "component3", "component4", "copy", "equals", "", "", "hashCode", "toString", "Companion", "intellij.platform.ide.codeinsight.inline"})
    public static final class Date
    implements Comparable<Date> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int year;
        private final int month;
        private final int day;
        private final int hour;

        public Date(int year, int month, int day, int hour) {
            this.year = year;
            this.month = month;
            this.day = day;
            this.hour = hour;
        }

        public final int getYear() {
            return this.year;
        }

        public final int getMonth() {
            return this.month;
        }

        public final int getDay() {
            return this.day;
        }

        public final int getHour() {
            return this.hour;
        }

        @NotNull
        public final String serializeAsString$intellij_platform_ide_codeinsight_inline() {
            return this.year + "-" + this.month + "-" + this.day + "-" + this.hour;
        }

        @NotNull
        public final Date minusMonths(long months) {
            LocalDate localDate = this.toLocalDate().minusMonths(months);
            Intrinsics.checkNotNull((Object)localDate);
            return Companion.of(localDate, this.hour);
        }

        @Override
        public int compareTo(@NotNull Date other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            Function1[] function1Array = new Function1[]{compareTo.1.INSTANCE, compareTo.2.INSTANCE, compareTo.3.INSTANCE, compareTo.4.INSTANCE};
            return ComparisonsKt.compareValuesBy((Object)this, (Object)other, (Function1[])function1Array);
        }

        @NotNull
        public final LocalDate toLocalDate() {
            LocalDate localDate = LocalDate.of(this.year, this.month, this.day);
            Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"of(...)");
            return localDate;
        }

        public final int component1() {
            return this.year;
        }

        public final int component2() {
            return this.month;
        }

        public final int component3() {
            return this.day;
        }

        public final int component4() {
            return this.hour;
        }

        @NotNull
        public final Date copy(int year, int month, int day, int hour) {
            return new Date(year, month, day, hour);
        }

        public static /* synthetic */ Date copy$default(Date date, int n, int n2, int n3, int n4, int n5, Object object) {
            if ((n5 & 1) != 0) {
                n = date.year;
            }
            if ((n5 & 2) != 0) {
                n2 = date.month;
            }
            if ((n5 & 4) != 0) {
                n3 = date.day;
            }
            if ((n5 & 8) != 0) {
                n4 = date.hour;
            }
            return date.copy(n, n2, n3, n4);
        }

        @NotNull
        public String toString() {
            return "Date(year=" + this.year + ", month=" + this.month + ", day=" + this.day + ", hour=" + this.hour + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.year);
            result2 = result2 * 31 + Integer.hashCode(this.month);
            result2 = result2 * 31 + Integer.hashCode(this.day);
            result2 = result2 * 31 + Integer.hashCode(this.hour);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Date)) {
                return false;
            }
            Date date = (Date)other;
            if (this.year != date.year) {
                return false;
            }
            if (this.month != date.month) {
                return false;
            }
            if (this.day != date.day) {
                return false;
            }
            return this.hour == date.hour;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\bJ\u0016\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\t\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u0005\u00a8\u0006\u0011"}, d2={"Lcom/intellij/codeInsight/inline/completion/statistics/LocalStatistics$Date$Companion;", "", "<init>", "()V", "parseFromString", "Lcom/intellij/codeInsight/inline/completion/statistics/LocalStatistics$Date;", "dateString", "", "parseFromString$intellij_platform_ide_codeinsight_inline", "of", "localDate", "Ljava/time/LocalDate;", "hour", "", "localDateTime", "Ljava/time/LocalDateTime;", "now", "intellij.platform.ide.codeinsight.inline"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Date parseFromString$intellij_platform_ide_codeinsight_inline(@NotNull String dateString) {
                Intrinsics.checkNotNullParameter((Object)dateString, (String)"dateString");
                char[] cArray = new char[]{'-'};
                List list = StringsKt.split$default((CharSequence)dateString, (char[])cArray, (boolean)false, (int)0, (int)6, null);
                String year = (String)list.get(0);
                String month = (String)list.get(1);
                String day = (String)list.get(2);
                String hour = (String)list.get(3);
                return new Date(Integer.parseInt(year), Integer.parseInt(month), Integer.parseInt(day), Integer.parseInt(hour));
            }

            @NotNull
            public final Date of(@NotNull LocalDate localDate, int hour) {
                Intrinsics.checkNotNullParameter((Object)localDate, (String)"localDate");
                return new Date(localDate.getYear(), localDate.getMonthValue(), localDate.getDayOfMonth(), hour);
            }

            @NotNull
            public final Date of(@NotNull LocalDateTime localDateTime) {
                Intrinsics.checkNotNullParameter((Object)localDateTime, (String)"localDateTime");
                return new Date(localDateTime.getYear(), localDateTime.getMonthValue(), localDateTime.getDayOfMonth(), localDateTime.getHour());
            }

            @NotNull
            public final Date now() {
                LocalDateTime localDateTime = LocalDateTime.now();
                Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"now(...)");
                return this.of(localDateTime);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R'\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00058GX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Lcom/intellij/codeInsight/inline/completion/statistics/LocalStatistics$DateState;", "Lcom/intellij/openapi/components/BaseState;", "<init>", "()V", "values", "", "", "Lcom/intellij/codeInsight/inline/completion/statistics/LocalStatistics$MetricValue;", "getValues", "()Ljava/util/Map;", "values$delegate", "Lkotlin/properties/ReadWriteProperty;", "intellij.platform.ide.codeinsight.inline"})
    public static final class DateState
    extends BaseState {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
        @NotNull
        private final ReadWriteProperty values$delegate = this.map().provideDelegate((Object)this, $$delegatedProperties[0]);

        @XMap
        @NotNull
        public final Map<String, MetricValue> getValues() {
            return (Map)this.values$delegate.getValue((Object)this, $$delegatedProperties[0]);
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(DateState.class, "values", "getValues()Ljava/util/Map;", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R+\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00058F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\f\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR+\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\r8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0013\u0010\f\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R'\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00050\u00158GX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\f\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001a"}, d2={"Lcom/intellij/codeInsight/inline/completion/statistics/LocalStatistics$MetricValue;", "Lcom/intellij/openapi/components/BaseState;", "<init>", "()V", "<set-?>", "", "count", "getCount", "()I", "setCount", "(I)V", "count$delegate", "Lkotlin/properties/ReadWriteProperty;", "", "sum", "getSum", "()F", "setSum", "(F)V", "sum$delegate", "distribution", "", "", "getDistribution", "()Ljava/util/Map;", "distribution$delegate", "intellij.platform.ide.codeinsight.inline"})
    public static final class MetricValue
    extends BaseState {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
        @NotNull
        private final ReadWriteProperty count$delegate = this.property(0).provideDelegate((Object)this, $$delegatedProperties[0]);
        @NotNull
        private final ReadWriteProperty sum$delegate = BaseState.property$default((BaseState)this, (float)0.0f, null, (int)2, null).provideDelegate((Object)this, $$delegatedProperties[1]);
        @NotNull
        private final ReadWriteProperty distribution$delegate = this.map().provideDelegate((Object)this, $$delegatedProperties[2]);

        public final int getCount() {
            return ((Number)this.count$delegate.getValue((Object)this, $$delegatedProperties[0])).intValue();
        }

        public final void setCount(int n) {
            this.count$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)n);
        }

        public final float getSum() {
            return ((Number)this.sum$delegate.getValue((Object)this, $$delegatedProperties[1])).floatValue();
        }

        public final void setSum(float f) {
            this.sum$delegate.setValue((Object)this, $$delegatedProperties[1], (Object)Float.valueOf(f));
        }

        @XMap
        @NotNull
        public final Map<String, Integer> getDistribution() {
            return (Map)this.distribution$delegate.getValue((Object)this, $$delegatedProperties[2]);
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(MetricValue.class, "count", "getCount()I", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(MetricValue.class, "sum", "getSum()F", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(MetricValue.class, "distribution", "getDistribution()Ljava/util/Map;", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fH\u0007R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lcom/intellij/codeInsight/inline/completion/statistics/LocalStatistics$Schema;", "", "<init>", "()V", "registered", "", "", "getRegistered", "()Ljava/util/Set;", "register", "", "field", "Lcom/intellij/internal/statistic/eventLog/events/EventField;", "intellij.platform.ide.codeinsight.inline"})
    @VisibleForTesting
    public static final class Schema {
        @NotNull
        public static final Schema INSTANCE = new Schema();
        @NotNull
        private static final Set<String> registered;

        private Schema() {
        }

        @NotNull
        public final Set<String> getRegistered() {
            return registered;
        }

        @VisibleForTesting
        public final void register(@NotNull EventField<?> field) {
            Intrinsics.checkNotNullParameter(field, (String)"field");
            registered.add(field.getName());
        }

        static {
            ConcurrentHashMap.KeySetView keySetView = ConcurrentHashMap.newKeySet();
            Intrinsics.checkNotNullExpressionValue(keySetView, (String)"newKeySet(...)");
            registered = keySetView;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0086\u0002J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0006J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u0014\u001a\u00020\u0013R'\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00058GX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"Lcom/intellij/codeInsight/inline/completion/statistics/LocalStatistics$State;", "Lcom/intellij/openapi/components/BaseState;", "<init>", "()V", "dateToStats", "", "", "Lcom/intellij/codeInsight/inline/completion/statistics/LocalStatistics$DateState;", "getDateToStats", "()Ljava/util/Map;", "dateToStats$delegate", "Lkotlin/properties/ReadWriteProperty;", "get", "date", "Lcom/intellij/codeInsight/inline/completion/statistics/LocalStatistics$Date;", "getOrPutValue", "Lcom/intellij/codeInsight/inline/completion/statistics/LocalStatistics$MetricValue;", "name", "remove", "", "valueModificationPerformed", "intellij.platform.ide.codeinsight.inline"})
    @VisibleForTesting
    @SourceDebugExtension(value={"SMAP\nLocalStatistics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalStatistics.kt\ncom/intellij/codeInsight/inline/completion/statistics/LocalStatistics$State\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,247:1\n382#2,7:248\n*S KotlinDebug\n*F\n+ 1 LocalStatistics.kt\ncom/intellij/codeInsight/inline/completion/statistics/LocalStatistics$State\n*L\n105#1:248,7\n*E\n"})
    public static final class State
    extends BaseState {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
        @NotNull
        private final ReadWriteProperty dateToStats$delegate = this.map().provideDelegate((Object)this, $$delegatedProperties[0]);

        @XMap
        @NotNull
        public final Map<String, DateState> getDateToStats() {
            return (Map)this.dateToStats$delegate.getValue((Object)this, $$delegatedProperties[0]);
        }

        @Nullable
        public final DateState get(@NotNull Date date) {
            Intrinsics.checkNotNullParameter((Object)date, (String)"date");
            return this.getDateToStats().get(date.serializeAsString$intellij_platform_ide_codeinsight_inline());
        }

        @NotNull
        public final MetricValue getOrPutValue(@NotNull Date date, @NotNull String name) {
            Object object;
            Object object2;
            Map<String, MetricValue> $this$getOrPut$iv;
            Intrinsics.checkNotNullParameter((Object)date, (String)"date");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Map<String, DateState> map = this.getDateToStats();
            String key$iv = date.serializeAsString$intellij_platform_ide_codeinsight_inline();
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                DateState answer$iv = new DateState();
                $this$getOrPut$iv.put(key$iv, (MetricValue)((Object)answer$iv));
                object2 = answer$iv;
            } else {
                object2 = value$iv;
            }
            $this$getOrPut$iv = ((DateState)((Object)object2)).getValues();
            key$iv = name;
            $i$f$getOrPut = false;
            value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                MetricValue answer$iv = new MetricValue();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            return (MetricValue)((Object)object);
        }

        public final void remove(@NotNull Date date) {
            Intrinsics.checkNotNullParameter((Object)date, (String)"date");
            this.getDateToStats().remove(date.serializeAsString$intellij_platform_ide_codeinsight_inline());
            this.incrementModificationCount();
        }

        public final void valueModificationPerformed() {
            this.incrementModificationCount();
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(State.class, "dateToStats", "getDateToStats()Ljava/util/Map;", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }
}

