/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.inline.completion.logs;

import com.intellij.codeInsight.inline.completion.InlineCompletionRequest;
import com.intellij.codeInsight.inline.completion.features.InlineCompletionFeaturesCollector;
import com.intellij.codeInsight.inline.completion.features.InlineCompletionFeaturesScopeAnalyzer;
import com.intellij.codeInsight.inline.completion.logs.CharCategory;
import com.intellij.codeInsight.inline.completion.logs.InlineCompletionLogsContainer;
import com.intellij.codeInsight.inline.completion.logs.InlineCompletionSessionLogsEP;
import com.intellij.codeInsight.inline.completion.logs.PhasedLogs;
import com.intellij.codeInsight.inline.completion.logs.TypingSpeedTracker;
import com.intellij.codeInsight.inline.completion.logs.statistics.AcceptanceRateFactorsComponent;
import com.intellij.codeInsight.inline.completion.logs.statistics.AcceptanceRateFeatures;
import com.intellij.codeInsight.inline.completion.logs.statistics.CompletionFinishTypeFeatures;
import com.intellij.codeInsight.inline.completion.logs.statistics.PrefixLengthFeatures;
import com.intellij.codeInsight.inline.completion.logs.statistics.TimeBetweenTypingFeatures;
import com.intellij.internal.statistic.eventLog.events.EnumEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0002-.B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0012\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005H\u0002J4\u0010\n\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J*\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0014*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0016\u0010\u001a\u001a\u0004\u0018\u00010\u0015*\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u0010H\u0002J\u001e\u0010\u001c\u001a\u00020\u001d*\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u001e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J4\u0010\u001f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u00052\u0006\u0010 \u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010!\u001a\u00020\"2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J*\u0010#\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u00052\u0006\u0010!\u001a\u00020\"2\u0006\u0010 \u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J$\u0010$\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u00052\u0006\u0010%\u001a\u00020\u00102\b\u0010&\u001a\u0004\u0018\u00010'H\u0002J\"\u0010(\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u00052\u0006\u0010!\u001a\u00020\"2\u0006\u0010 \u001a\u00020\fH\u0002J\u001e\u0010)\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005*\u00020\"2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001e\u0010*\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005*\u00020\"2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001e\u0010+\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005*\u00020\"2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010,\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005H\u0002\u00a8\u0006/"}, d2={"Lcom/intellij/codeInsight/inline/completion/logs/InlineCompletionContextLogs;", "", "<init>", "()V", "getFor", "", "Lcom/intellij/internal/statistic/eventLog/events/EventPair;", "request", "Lcom/intellij/codeInsight/inline/completion/InlineCompletionRequest;", "captureUserStatisticsFactors", "captureSimple", "psiFile", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "offset", "", "element", "Lcom/intellij/psi/PsiElement;", "findNonBlankLine", "Lkotlin/Pair;", "", "Lcom/intellij/openapi/editor/Document;", "lineNumber", "following", "", "getNonBlankLineOrNull", "line", "addPsiParents", "", "", "captureFeatureCollectorBased", "file", "featuresCollector", "Lcom/intellij/codeInsight/inline/completion/features/InlineCompletionFeaturesCollector;", "getExtendedScopeFeatures", "getScopeFeatures", "idx", "scopeFeatures", "Lcom/intellij/codeInsight/inline/completion/features/InlineCompletionFeaturesCollector$ScopeFeatures;", "addImportFeatures", "addKeyWordFeatures", "addArgumentsFeatures", "addBracketFeatures", "getTypingSpeedFeatures", "Logs", "CollectorExtension", "intellij.platform.ide.codeinsight.inline"})
@SourceDebugExtension(value={"SMAP\nInlineCompletionContextLogs.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlineCompletionContextLogs.kt\ncom/intellij/codeInsight/inline/completion/logs/InlineCompletionContextLogs\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,370:1\n1#2:371\n1878#3,3:372\n1563#3:377\n1634#3,3:378\n216#4,2:375\n*S KotlinDebug\n*F\n+ 1 InlineCompletionContextLogs.kt\ncom/intellij/codeInsight/inline/completion/logs/InlineCompletionContextLogs\n*L\n138#1:372,3\n225#1:377\n225#1:378,3\n198#1:375,2\n*E\n"})
public final class InlineCompletionContextLogs {
    @NotNull
    public static final InlineCompletionContextLogs INSTANCE = new InlineCompletionContextLogs();

    private InlineCompletionContextLogs() {
    }

    @RequiresReadLock
    @NotNull
    public final List<EventPair<?>> getFor(@NotNull InlineCompletionRequest request2) {
        List list;
        Intrinsics.checkNotNullParameter((Object)((Object)request2), (String)"request");
        PsiElement element = request2.getStartOffset() == 0 ? null : request2.getFile().findElementAt(request2.getStartOffset() - 1);
        List<EventPair<?>> simple = this.captureSimple(request2.getFile(), request2.getEditor(), request2.getStartOffset(), element);
        List<EventPair<?>> typingFeatures = this.getTypingSpeedFeatures();
        Language language = request2.getFile().getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        InlineCompletionFeaturesCollector inlineCompletionFeaturesCollector = InlineCompletionFeaturesCollector.Companion.get(language);
        if (inlineCompletionFeaturesCollector != null) {
            InlineCompletionFeaturesCollector it = inlineCompletionFeaturesCollector;
            boolean bl = false;
            list = INSTANCE.captureFeatureCollectorBased(request2.getFile(), request2.getStartOffset(), it, element);
        } else {
            list = null;
        }
        List featureCollectorBased = list;
        List<EventPair<?>> userFeatures = this.captureUserStatisticsFactors();
        Collection collection = CollectionsKt.plus((Collection)simple, (Iterable)typingFeatures);
        List list2 = featureCollectorBased;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)collection, (Iterable)list2), (Iterable)userFeatures);
    }

    private final List<EventPair<?>> captureUserStatisticsFactors() {
        List list;
        block4: {
            List $this$captureUserStatisticsFactors_u24lambda_u240 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            AcceptanceRateFeatures $this$captureUserStatisticsFactors_u24lambda_u240_u240 = new AcceptanceRateFeatures();
            boolean bl2 = false;
            Iterator<Duration> iterator = AcceptanceRateFactorsComponent.Companion.getDECAY_DURATIONS().iterator();
            while (iterator.hasNext()) {
                List<EventField<Double>> list2;
                long duration = iterator.next().unbox-impl();
                if (Logs.INSTANCE.getDECAYING_FEATURES().get(Duration.box-impl((long)duration)) == null) continue;
                EventField<Double> selectionField = list2.get(0);
                EventField<Double> showupField = list2.get(1);
                EventField<Double> acceptanceField = list2.get(2);
                if (!(Math.abs($this$captureUserStatisticsFactors_u24lambda_u240_u240.showUpCountDecayedBy-LRDsOJo(duration)) > 1.0E-9)) continue;
                $this$captureUserStatisticsFactors_u24lambda_u240.add(showupField.with((Object)$this$captureUserStatisticsFactors_u24lambda_u240_u240.showUpCountDecayedBy-LRDsOJo(duration)));
                if (!(Math.abs($this$captureUserStatisticsFactors_u24lambda_u240_u240.selectionCountDecayedBy-LRDsOJo(duration)) > 1.0E-9)) continue;
                $this$captureUserStatisticsFactors_u24lambda_u240.add(selectionField.with((Object)$this$captureUserStatisticsFactors_u24lambda_u240_u240.selectionCountDecayedBy-LRDsOJo(duration)));
                $this$captureUserStatisticsFactors_u24lambda_u240.add(acceptanceField.with((Object)$this$captureUserStatisticsFactors_u24lambda_u240_u240.smoothedAcceptanceRate-LRDsOJo(duration)));
            }
            $this$captureUserStatisticsFactors_u24lambda_u240.add(Logs.INSTANCE.getPREV_SELECTED().with((Object)$this$captureUserStatisticsFactors_u24lambda_u240_u240.getPrevSelected()));
            $this$captureUserStatisticsFactors_u24lambda_u240.add(Logs.INSTANCE.getTIME_SINCE_LAST_SHOWUP().with((Object)$this$captureUserStatisticsFactors_u24lambda_u240_u240.getTimeSinceLastShowup()));
            $this$captureUserStatisticsFactors_u24lambda_u240.add(Logs.INSTANCE.getTIME_SINCE_LAST_SELECTION().with((Object)$this$captureUserStatisticsFactors_u24lambda_u240_u240.getTimeSinceLastSelection()));
            CompletionFinishTypeFeatures $this$captureUserStatisticsFactors_u24lambda_u240_u241 = new CompletionFinishTypeFeatures();
            boolean bl3 = false;
            if ($this$captureUserStatisticsFactors_u24lambda_u240_u241.hasCompletionStatistics()) {
                $this$captureUserStatisticsFactors_u24lambda_u240.add(Logs.INSTANCE.getSELECTED_RATIO().with((Object)$this$captureUserStatisticsFactors_u24lambda_u240_u241.getSelectedRatio()));
                $this$captureUserStatisticsFactors_u24lambda_u240.add(Logs.INSTANCE.getINVALIDATED_RATIO().with((Object)$this$captureUserStatisticsFactors_u24lambda_u240_u241.getInvalidatedRatio()));
                $this$captureUserStatisticsFactors_u24lambda_u240.add(Logs.INSTANCE.getEXPLICIT_CANCEL_RATIO().with((Object)$this$captureUserStatisticsFactors_u24lambda_u240_u241.getExplicitCancelRatio()));
            }
            PrefixLengthFeatures $this$captureUserStatisticsFactors_u24lambda_u240_u242 = new PrefixLengthFeatures();
            boolean bl4 = false;
            Integer n = $this$captureUserStatisticsFactors_u24lambda_u240_u242.getMostFrequentPrefixLength();
            if (n != null) {
                int it = ((Number)n).intValue();
                boolean bl5 = false;
                $this$captureUserStatisticsFactors_u24lambda_u240.add(Logs.INSTANCE.getMOST_FREQUENT_PREFIX_LENGTH().with((Object)it));
            }
            Double d = $this$captureUserStatisticsFactors_u24lambda_u240_u242.getAveragePrefixLength();
            if (d != null) {
                double it = ((Number)d).doubleValue();
                boolean bl6 = false;
                $this$captureUserStatisticsFactors_u24lambda_u240.add(Logs.INSTANCE.getAVERAGE_PREFIX_LENGTH().with((Object)it));
            }
            TimeBetweenTypingFeatures $this$captureUserStatisticsFactors_u24lambda_u240_u243 = new TimeBetweenTypingFeatures();
            boolean bl7 = false;
            Double d2 = $this$captureUserStatisticsFactors_u24lambda_u240_u243.getAverageTypingSpeed();
            if (d2 == null) break block4;
            double it = ((Number)d2).doubleValue();
            boolean bl8 = false;
            $this$captureUserStatisticsFactors_u24lambda_u240.add(Logs.INSTANCE.getAVERAGE_TIME_BETWEEN_TYPING().with((Object)it));
        }
        return CollectionsKt.build((List)list);
    }

    private final List<EventPair<?>> captureSimple(PsiFile psiFile, Editor editor, int offset, PsiElement element) {
        List result2;
        block7: {
            CharCategory it;
            result2 = new ArrayList();
            PsiElement psiElement = element;
            if (psiElement != null) {
                PsiElement it2 = psiElement;
                boolean bl = false;
                result2.add(Logs.INSTANCE.getELEMENT_PREFIX_LENGTH().with((Object)(offset - it2.getTextOffset())));
            }
            LogicalPosition logicalPosition = editor.offsetToLogicalPosition(offset);
            Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"offsetToLogicalPosition(...)");
            LogicalPosition logicalPosition2 = logicalPosition;
            int lineNumber = logicalPosition2.line;
            result2.add(Logs.INSTANCE.getLINE_NUMBER().with((Object)lineNumber));
            result2.add(Logs.INSTANCE.getCOLUMN_NUMBER().with((Object)logicalPosition2.column));
            result2.add(Logs.INSTANCE.getFILE_LINE_COUNT().with((Object)editor.getDocument().getLineCount()));
            int lineStartOffset = editor.getDocument().getLineStartOffset(lineNumber);
            int lineEndOffset = editor.getDocument().getLineEndOffset(lineNumber);
            String string = editor.getDocument().getText(new TextRange(lineStartOffset, offset));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String linePrefix = string;
            String string2 = editor.getDocument().getText(new TextRange(offset, lineEndOffset));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            String lineSuffix = string2;
            if (!StringsKt.isBlank((CharSequence)linePrefix)) {
                result2.add(Logs.INSTANCE.getIS_WHITE_SPACE_BEFORE_CARET().with((Object)CharsKt.isWhitespace((char)StringsKt.last((CharSequence)linePrefix))));
                String trimmedPrefix = ((Object)StringsKt.trim((CharSequence)linePrefix)).toString();
                result2.add(Logs.INSTANCE.getSYMBOLS_IN_LINE_BEFORE_CARET().with((Object)trimmedPrefix.length()));
                CharCategory charCategory = CharCategory.Companion.find(StringsKt.last((CharSequence)trimmedPrefix));
                if (charCategory != null) {
                    it = charCategory;
                    boolean bl = false;
                    result2.add(Logs.INSTANCE.getNON_SPACE_SYMBOL_BEFORE_CARET().with((Object)it));
                }
            }
            if (!StringsKt.isBlank((CharSequence)lineSuffix)) {
                result2.add(Logs.INSTANCE.getIS_WHITE_SPACE_AFTER_CARET().with((Object)CharsKt.isWhitespace((char)StringsKt.first((CharSequence)lineSuffix))));
                String trimmedSuffix = ((Object)StringsKt.trim((CharSequence)lineSuffix)).toString();
                result2.add(Logs.INSTANCE.getSYMBOLS_IN_LINE_AFTER_CARET().with((Object)trimmedSuffix.length()));
                CharCategory charCategory = CharCategory.Companion.find(StringsKt.first((CharSequence)trimmedSuffix));
                if (charCategory != null) {
                    it = charCategory;
                    boolean bl = false;
                    result2.add(Logs.INSTANCE.getNON_SPACE_SYMBOL_AFTER_CARET().with((Object)it));
                }
            }
            Document document = editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            Document document2 = document;
            Pair<Integer, String> pair = this.findNonBlankLine(document2, lineNumber, false);
            int previousNonEmptyLineNumber = ((Number)pair.component1()).intValue();
            String previousNonEmptyLineText = (String)pair.component2();
            result2.add(Logs.INSTANCE.getPREVIOUS_EMPTY_LINES_COUNT().with((Object)(lineNumber - previousNonEmptyLineNumber - 1)));
            if (previousNonEmptyLineText != null) {
                result2.add(Logs.INSTANCE.getPREVIOUS_NON_EMPTY_LINE_LENGTH().with((Object)previousNonEmptyLineText.length()));
            }
            Pair<Integer, String> pair2 = this.findNonBlankLine(document2, lineNumber, true);
            int followingNonEmptyLineNumber = ((Number)pair2.component1()).intValue();
            String followingNonEmptyLineText = (String)pair2.component2();
            result2.add(Logs.INSTANCE.getFOLLOWING_EMPTY_LINES_COUNT().with((Object)(followingNonEmptyLineNumber - lineNumber - 1)));
            if (followingNonEmptyLineText != null) {
                result2.add(Logs.INSTANCE.getFOLLOWING_NON_EMPTY_LINE_LENGTH().with((Object)followingNonEmptyLineText.length()));
            }
            PsiElement psiElement2 = psiFile.findElementAt(offset - 1);
            if (psiElement2 == null) break block7;
            PsiElement it3 = psiElement2;
            boolean bl = false;
            INSTANCE.addPsiParents(result2, it3);
        }
        return result2;
    }

    private final Pair<Integer, String> findNonBlankLine(Document $this$findNonBlankLine, int lineNumber, boolean following) {
        int delta = following ? 1 : -1;
        int n = lineNumber;
        String text = null;
        while (true) {
            boolean bl = 0 <= n ? n < $this$findNonBlankLine.getLineCount() : false;
            if (!bl || text != null) break;
            text = this.getNonBlankLineOrNull($this$findNonBlankLine, n += delta);
        }
        return TuplesKt.to((Object)n, text);
    }

    private final String getNonBlankLineOrNull(Document $this$getNonBlankLineOrNull, int line) {
        CharSequence charSequence;
        if (!(0 <= line ? line < $this$getNonBlankLineOrNull.getLineCount() : false)) {
            return null;
        }
        String string = $this$getNonBlankLineOrNull.getText(new TextRange($this$getNonBlankLineOrNull.getLineStartOffset(line), $this$getNonBlankLineOrNull.getLineEndOffset(line)));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String res = string;
        CharSequence charSequence2 = ((Object)StringsKt.trim((CharSequence)res)).toString();
        if (charSequence2.length() == 0) {
            boolean bl = false;
            charSequence = null;
        } else {
            charSequence = charSequence2;
        }
        return (String)charSequence;
    }

    /*
     * WARNING - void declaration
     */
    private final void addPsiParents(List<EventPair<?>> $this$addPsiParents, PsiElement element) {
        List parents = SequencesKt.toList((Sequence)PsiTreeUtilKt.parents((PsiElement)element, (boolean)false));
        Iterable $this$forEachIndexed$iv = Logs.INSTANCE.getPARENT_FEATURES();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void parentFeature;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            EventField eventField = (EventField)item$iv;
            int i = n;
            boolean bl = false;
            PsiElement psiElement = (PsiElement)CollectionsKt.getOrNull((List)parents, (int)i);
            if (psiElement == null) continue;
            PsiElement it = psiElement;
            boolean bl2 = false;
            $this$addPsiParents.add(parentFeature.with(it.getClass()));
        }
    }

    private final List<EventPair<?>> captureFeatureCollectorBased(PsiFile file, int offset, InlineCompletionFeaturesCollector featuresCollector, PsiElement element) {
        List result2 = new ArrayList();
        result2.addAll((Collection)this.addImportFeatures(featuresCollector, file));
        result2.addAll((Collection)this.getExtendedScopeFeatures(featuresCollector, file, offset));
        if (element == null) {
            return result2;
        }
        Integer n = featuresCollector.getNumOfPrevQualifiers(element);
        if (n != null) {
            int n2 = ((Number)n).intValue();
            boolean bl = false;
            result2.add(Logs.INSTANCE.getNUMB_OF_PREV_QUALIFIERS().with((Object)n2));
        }
        result2.addAll((Collection)this.addKeyWordFeatures(featuresCollector, element));
        result2.addAll((Collection)this.addArgumentsFeatures(featuresCollector, element));
        result2.addAll((Collection)this.addBracketFeatures(featuresCollector, element));
        Boolean bl = featuresCollector.isInConditionalStatement(element);
        if (bl != null) {
            boolean bl2 = bl;
            boolean bl22 = false;
            result2.add(Logs.INSTANCE.getIS_IN_CONDITIONAL_STATEMENT().with((Object)bl2));
        }
        Boolean bl3 = featuresCollector.isInForStatement(element);
        if (bl3 != null) {
            boolean bl4 = bl3;
            boolean bl42 = false;
            result2.add(Logs.INSTANCE.getIS_IN_FOR_STATEMENT().with((Object)bl4));
        }
        result2.add(Logs.INSTANCE.getBLOCK_STATEMENT_LEVEL().with((Object)featuresCollector.getBlockStatementLevel(element)));
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<EventPair<?>> getExtendedScopeFeatures(InlineCompletionFeaturesCollector featuresCollector, PsiFile file, int offset) {
        InlineCompletionFeaturesCollector.ExtendedScopeFeatures scopeFeatures = featuresCollector.getExtendedScopeFeatures(file, offset);
        Object[] objectArray = new InlineCompletionFeaturesCollector.ScopeFeatures[]{scopeFeatures.getScopeFeatures(), scopeFeatures.getParentScopeFeatures(), scopeFeatures.getGrandParentScopeFeatures(), scopeFeatures.getPrevSiblingScopeFeatures(), scopeFeatures.getNextSiblingScopeFeatures()};
        Iterable iterable = CollectionsKt.listOf((Object[])objectArray);
        Collection collection = new ArrayList();
        int n = 0;
        for (Object t : iterable) {
            void it;
            int n2;
            if ((n2 = n++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            InlineCompletionFeaturesCollector.ScopeFeatures scopeFeatures2 = (InlineCompletionFeaturesCollector.ScopeFeatures)t;
            int idx = n2;
            boolean bl = false;
            CollectionsKt.addAll((Collection)collection, (Iterable)INSTANCE.getScopeFeatures(idx, (InlineCompletionFeaturesCollector.ScopeFeatures)it));
        }
        return CollectionsKt.toList((Iterable)((List)collection));
    }

    private final List<EventPair<?>> getScopeFeatures(int idx, InlineCompletionFeaturesCollector.ScopeFeatures scopeFeatures) {
        List list;
        block3: {
            boolean it;
            if (scopeFeatures == null) {
                return CollectionsKt.emptyList();
            }
            List $this$getScopeFeatures_u24lambda_u240 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            $this$getScopeFeatures_u24lambda_u240.add(Logs.INSTANCE.getSCOPE_TYPE().get(idx).with((Object)scopeFeatures.getType()));
            $this$getScopeFeatures_u24lambda_u240.add(Logs.INSTANCE.getSCOPE_INIT().get(idx).with((Object)scopeFeatures.isInit()));
            $this$getScopeFeatures_u24lambda_u240.add(Logs.INSTANCE.getSCOPE_NUM_LINES().get(idx).with((Object)scopeFeatures.getNumLines()));
            $this$getScopeFeatures_u24lambda_u240.add(Logs.INSTANCE.getSCOPE_NUM_SYMBOLS().get(idx).with((Object)scopeFeatures.getNumSymbols()));
            $this$getScopeFeatures_u24lambda_u240.add(Logs.INSTANCE.getSCOPE_LINE_OFFSET().get(idx).with((Object)scopeFeatures.getLineOffset()));
            $this$getScopeFeatures_u24lambda_u240.add(Logs.INSTANCE.getSCOPE_OFFSET().get(idx).with((Object)scopeFeatures.getOffset()));
            Boolean bl2 = scopeFeatures.getValuableSymbolsAfter();
            if (bl2 != null) {
                it = bl2;
                boolean bl3 = false;
                $this$getScopeFeatures_u24lambda_u240.add(Logs.INSTANCE.getSCOPE_VALUABLE_SYMBOLS_AFTER().get(idx).with((Object)it));
            }
            Boolean bl4 = scopeFeatures.getValuableSymbolsBefore();
            if (bl4 != null) {
                it = bl4;
                boolean bl5 = false;
                $this$getScopeFeatures_u24lambda_u240.add(Logs.INSTANCE.getSCOPE_VALUABLE_SYMBOLS_BEFORE().get(idx).with((Object)it));
            }
            Boolean bl6 = scopeFeatures.getHasErrorPsi();
            if (bl6 == null) break block3;
            it = bl6;
            boolean bl7 = false;
            $this$getScopeFeatures_u24lambda_u240.add(Logs.INSTANCE.getSCOPE_HAS_ERROR_PSI().get(idx).with((Object)it));
        }
        return CollectionsKt.build((List)list);
    }

    private final List<EventPair<?>> addImportFeatures(InlineCompletionFeaturesCollector featuresCollector, PsiFile file) {
        List result2 = new ArrayList();
        Collection allImports = featuresCollector.getAllImports(file);
        int allImportsCount = allImports.size();
        result2.add(Logs.INSTANCE.getIMPORTS_COUNT().with((Object)allImportsCount));
        if (allImportsCount != 0) {
            Collection sourceNames = featuresCollector.getSourceNames(allImports);
            Map $this$forEach$iv = featuresCollector.classifyByImportsToTopics(sourceNames);
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl = false;
                String topic = (String)entry.getKey();
                boolean value = (Boolean)entry.getValue();
                EventField<Boolean> field = Logs.INSTANCE.getTOPIC_TO_FIELD().get(topic);
                if (field == null) continue;
                result2.add(field.with((Object)value));
            }
            int popularLibraryImportsCount = featuresCollector.countPopularLibraries(sourceNames);
            result2.add(Logs.INSTANCE.getPOPULAR_LIBRARY_IMPORTS_COUNT().with((Object)popularLibraryImportsCount));
            result2.add(Logs.INSTANCE.getPOPULAR_LIBRARY_IMPORTS_RATIO().with((Object)Float.valueOf((float)popularLibraryImportsCount / (float)allImportsCount)));
            Project project = file.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Integer libraryImportsCount = featuresCollector.countLibraries(project, allImports);
            if (libraryImportsCount != null) {
                result2.add(Logs.INSTANCE.getLIBRARY_IMPORTS_COUNT().with((Object)libraryImportsCount));
                result2.add(Logs.INSTANCE.getLIBRARY_IMPORTS_RATIO().with((Object)Float.valueOf((float)libraryImportsCount.intValue() / (float)allImportsCount)));
            }
        } else {
            result2.add(Logs.INSTANCE.getPOPULAR_LIBRARY_IMPORTS_COUNT().with((Object)0));
            result2.add(Logs.INSTANCE.getLIBRARY_IMPORTS_COUNT().with((Object)0));
        }
        return result2;
    }

    private final List<EventPair<?>> addKeyWordFeatures(InlineCompletionFeaturesCollector $this$addKeyWordFeatures, PsiElement element) {
        Object[] objectArray = new EventField[]{Logs.INSTANCE.getPREV_NEIGHBOUR_KEYWORD_1(), Logs.INSTANCE.getPREV_NEIGHBOUR_KEYWORD_2()};
        Collection collection = InlineCompletionContextLogs.addKeyWordFeatures$zipLogs(CollectionsKt.listOf((Object[])objectArray), $this$addKeyWordFeatures.getPrevNeighboursKeywordIds(element));
        objectArray = new EventField[]{Logs.INSTANCE.getPREV_SAME_LINE_KEYWORD_1(), Logs.INSTANCE.getPREV_SAME_LINE_KEYWORD_2()};
        Collection collection2 = CollectionsKt.plus((Collection)collection, (Iterable)InlineCompletionContextLogs.addKeyWordFeatures$zipLogs(CollectionsKt.listOf((Object[])objectArray), $this$addKeyWordFeatures.getPrevKeywordsIdsInTheSameLine(element)));
        objectArray = new EventField[]{Logs.INSTANCE.getPREV_SAME_COLUMN_KEYWORD_1(), Logs.INSTANCE.getPREV_SAME_COLUMN_KEYWORD_2()};
        return CollectionsKt.plus((Collection)collection2, (Iterable)InlineCompletionContextLogs.addKeyWordFeatures$zipLogs(CollectionsKt.listOf((Object[])objectArray), $this$addKeyWordFeatures.getPrevKeywordsIdsInTheSameColumn(element)));
    }

    private final List<EventPair<?>> addArgumentsFeatures(InlineCompletionFeaturesCollector $this$addArgumentsFeatures, PsiElement element) {
        List result2;
        block4: {
            result2 = new ArrayList();
            InlineCompletionFeaturesCollector.ArgumentFeatures argumentFeatures = $this$addArgumentsFeatures.getArgumentFeatures(element);
            if (argumentFeatures == null) break block4;
            InlineCompletionFeaturesCollector.ArgumentFeatures it2 = argumentFeatures;
            boolean bl = false;
            InlineCompletionFeaturesCollector.ArgumentFeatures $this$addArgumentsFeatures_u24lambda_u240_u240 = it2;
            boolean bl2 = false;
            result2.add(Logs.INSTANCE.getIS_IN_ARGUMENTS().with((Object)$this$addArgumentsFeatures_u24lambda_u240_u240.isInArguments()));
            result2.add(Logs.INSTANCE.getIS_DIRECTLY_IN_ARGUMENTS_CONTEXT().with((Object)$this$addArgumentsFeatures_u24lambda_u240_u240.isDirectlyInArgumentContext()));
            Integer n = $this$addArgumentsFeatures_u24lambda_u240_u240.getArgumentIndex();
            if (n != null) {
                int n2 = ((Number)n).intValue();
                boolean bl3 = false;
                result2.add(Logs.INSTANCE.getARGUMENT_INDEX().with((Object)n2));
            }
            Integer n3 = $this$addArgumentsFeatures_u24lambda_u240_u240.getArgumentsSize();
            if (n3 != null) {
                int n4 = ((Number)n3).intValue();
                boolean bl4 = false;
                result2.add(Logs.INSTANCE.getARGUMENTS_SIZE().with((Object)n4));
            }
            Boolean bl3 = $this$addArgumentsFeatures_u24lambda_u240_u240.getHaveNamedArgLeft();
            if (bl3 != null) {
                boolean bl4 = bl3;
                boolean bl6 = false;
                result2.add(Logs.INSTANCE.getHAVE_NAMED_ARG_LEFT().with((Object)bl4));
            }
            Boolean bl5 = $this$addArgumentsFeatures_u24lambda_u240_u240.getHaveNamedArgRight();
            if (bl5 != null) {
                boolean bl6 = bl5;
                boolean bl8 = false;
                result2.add(Logs.INSTANCE.getHAVE_NAMED_ARG_RIGHT().with((Object)bl6));
            }
        }
        return result2;
    }

    private final List<EventPair<?>> addBracketFeatures(InlineCompletionFeaturesCollector $this$addBracketFeatures, PsiElement element) {
        List result2;
        block0: {
            result2 = new ArrayList();
            InlineCompletionFeaturesCollector.BracketFeatures bracketFeatures = $this$addBracketFeatures.getBracketFeatures(element);
            if (bracketFeatures == null) break block0;
            InlineCompletionFeaturesCollector.BracketFeatures it = bracketFeatures;
            boolean bl = false;
            InlineCompletionFeaturesCollector.BracketFeatures $this$addBracketFeatures_u24lambda_u240_u240 = it;
            boolean bl2 = false;
            result2.add(Logs.INSTANCE.getHAVE_OPENING_PARENTHESIS_LEFT().with((Object)$this$addBracketFeatures_u24lambda_u240_u240.getHaveOpeningParenthesisOnTheLeft()));
            result2.add(Logs.INSTANCE.getHAVE_OPENING_BRACKET_LEFT().with((Object)$this$addBracketFeatures_u24lambda_u240_u240.getHaveOpeningBracketOnTheLeft()));
            result2.add(Logs.INSTANCE.getHAVE_OPENING_BRACE_LEFT().with((Object)$this$addBracketFeatures_u24lambda_u240_u240.getHaveOpeningBraceOnTheLeft()));
            result2.add(Logs.INSTANCE.getHAVE_OPENING_ANGLE_BRACKET_LEFT().with((Object)$this$addBracketFeatures_u24lambda_u240_u240.getHaveOpeningAngleBracketOnTheLeft()));
        }
        return result2;
    }

    private final List<EventPair<?>> getTypingSpeedFeatures() {
        List list;
        block0: {
            List $this$getTypingSpeedFeatures_u24lambda_u240 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            TypingSpeedTracker tracker = TypingSpeedTracker.Companion.getInstance();
            Long l = TypingSpeedTracker.getTimeSinceLastTyping$default(tracker, 0L, 1, null);
            if (l == null) break block0;
            long it = ((Number)l).longValue();
            boolean bl2 = false;
            $this$getTypingSpeedFeatures_u24lambda_u240.add(Logs.INSTANCE.getTIME_SINCE_LAST_TYPING().with((Object)it));
            $this$getTypingSpeedFeatures_u24lambda_u240.addAll(tracker.getTypingSpeedEventPairs());
        }
        return CollectionsKt.build((List)list);
    }

    /*
     * WARNING - void declaration
     */
    private static final <T> List<EventPair<T>> addKeyWordFeatures$zipLogs(List<? extends EventField<T>> logs, List<? extends T> values) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = CollectionsKt.zip((Iterable)logs, (Iterable)values);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            EventField log = (EventField)pair.component1();
            Object value = pair.component2();
            collection.add(log.with(value));
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/codeInsight/inline/completion/logs/InlineCompletionContextLogs$CollectorExtension;", "Lcom/intellij/codeInsight/inline/completion/logs/InlineCompletionSessionLogsEP;", "<init>", "()V", "logGroups", "", "Lcom/intellij/codeInsight/inline/completion/logs/PhasedLogs;", "getLogGroups", "()Ljava/util/List;", "intellij.platform.ide.codeinsight.inline"})
    public static final class CollectorExtension
    implements InlineCompletionSessionLogsEP {
        @NotNull
        private final List<PhasedLogs> logGroups = CollectionsKt.listOf((Object)Logs.INSTANCE);

        @Override
        @NotNull
        public List<PhasedLogs> getLogGroups() {
            return this.logGroups;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b.\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\u0006\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u0005*\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ:\u0010\u0093\u0001\u001a\u000f\u0012\u000b\u0012\t\u0012\u0005\u0012\u0003H\u0094\u00010\n0+\"\u0005\b\u0000\u0010\u0094\u00012\u001b\u0010\u0095\u0001\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\u000b\u0012\t\u0012\u0005\u0012\u0003H\u0094\u00010\n0\u0096\u0001H\u0002R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\rR\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\rR\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\rR\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\rR\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00190\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\rR\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\rR\u0017\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001e0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\rR\u0017\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\rR\u0017\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\rR\u0017\u0010&\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\rR\u0017\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\rR#\u0010*\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010,0\n0+\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0017\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010\rR\u0017\u00101\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010\rR\u0017\u00103\u001a\b\u0012\u0004\u0012\u0002040\n\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010\rR\u0017\u00106\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010\rR\u0017\u00108\u001a\b\u0012\u0004\u0012\u0002040\n\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010\rR\u0017\u0010:\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010\rR\u0017\u0010<\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010\rR\u0017\u0010>\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010\rR\u0017\u0010@\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u0010\rR\u0017\u0010B\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u0010\rR\u0017\u0010D\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u0010\rR\u0017\u0010F\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\bG\u0010\rR\u0017\u0010H\u001a\b\u0012\u0004\u0012\u00020\u00190\n\u00a2\u0006\b\n\u0000\u001a\u0004\bI\u0010\rR\u0017\u0010J\u001a\b\u0012\u0004\u0012\u00020\u00190\n\u00a2\u0006\b\n\u0000\u001a\u0004\bK\u0010\rR\u0017\u0010L\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\bM\u0010\rR\u0017\u0010N\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\bO\u0010\rR\u0017\u0010P\u001a\b\u0012\u0004\u0012\u00020\u00190\n\u00a2\u0006\b\n\u0000\u001a\u0004\bQ\u0010\rR\u0017\u0010R\u001a\b\u0012\u0004\u0012\u00020\u00190\n\u00a2\u0006\b\n\u0000\u001a\u0004\bS\u0010\rR\u0017\u0010T\u001a\b\u0012\u0004\u0012\u00020\u00190\n\u00a2\u0006\b\n\u0000\u001a\u0004\bU\u0010\rR\u0017\u0010V\u001a\b\u0012\u0004\u0012\u00020\u00190\n\u00a2\u0006\b\n\u0000\u001a\u0004\bW\u0010\rR\u0017\u0010X\u001a\b\u0012\u0004\u0012\u00020\u00190\n\u00a2\u0006\b\n\u0000\u001a\u0004\bY\u0010\rR\u0017\u0010Z\u001a\b\u0012\u0004\u0012\u00020\u00190\n\u00a2\u0006\b\n\u0000\u001a\u0004\b[\u0010\rR\u0017\u0010\\\u001a\b\u0012\u0004\u0012\u00020\u00190\n\u00a2\u0006\b\n\u0000\u001a\u0004\b]\u0010\rR\u0017\u0010^\u001a\b\u0012\u0004\u0012\u00020\u00190\n\u00a2\u0006\b\n\u0000\u001a\u0004\b_\u0010\rR\u0017\u0010`\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\ba\u0010\rR#\u0010b\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\n0c\u00a2\u0006\b\n\u0000\u001a\u0004\bd\u0010eR\u001d\u0010f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020g0\n0+\u00a2\u0006\b\n\u0000\u001a\u0004\bh\u0010.R\u001d\u0010i\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\n0+\u00a2\u0006\b\n\u0000\u001a\u0004\bj\u0010.R\u001d\u0010k\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0+\u00a2\u0006\b\n\u0000\u001a\u0004\bl\u0010.R\u001d\u0010m\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0+\u00a2\u0006\b\n\u0000\u001a\u0004\bn\u0010.R\u001d\u0010o\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0+\u00a2\u0006\b\n\u0000\u001a\u0004\bp\u0010.R\u001d\u0010q\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0+\u00a2\u0006\b\n\u0000\u001a\u0004\br\u0010.R\u001d\u0010s\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\n0+\u00a2\u0006\b\n\u0000\u001a\u0004\bt\u0010.R\u001d\u0010u\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\n0+\u00a2\u0006\b\n\u0000\u001a\u0004\bv\u0010.R\u001d\u0010w\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\n0+\u00a2\u0006\b\n\u0000\u001a\u0004\bx\u0010.R\u0017\u0010y\u001a\b\u0012\u0004\u0012\u00020z0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b{\u0010\rR\u001b\u0010|\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0+\u00a2\u0006\b\n\u0000\u001a\u0004\b}\u0010.R\u0017\u0010~\u001a\b\u0012\u0004\u0012\u00020\u00190\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u007f\u0010\rR\u0019\u0010\u0080\u0001\u001a\b\u0012\u0004\u0012\u00020z0\n\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0081\u0001\u0010\rR\u0019\u0010\u0082\u0001\u001a\b\u0012\u0004\u0012\u00020z0\n\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0083\u0001\u0010\rR\u001a\u0010\u0084\u0001\u001a\t\u0012\u0005\u0012\u00030\u0085\u00010\n\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0086\u0001\u0010\rR\u001a\u0010\u0087\u0001\u001a\t\u0012\u0005\u0012\u00030\u0085\u00010\n\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0088\u0001\u0010\rR\u001a\u0010\u0089\u0001\u001a\t\u0012\u0005\u0012\u00030\u0085\u00010\n\u00a2\u0006\t\n\u0000\u001a\u0005\b\u008a\u0001\u0010\rR,\u0010\u008b\u0001\u001a\u001b\u0012\u0004\u0012\u00020\u0006\u0012\u0011\u0012\u000f\u0012\u000b\u0012\t\u0012\u0005\u0012\u00030\u0085\u00010\n0+0c\u00a2\u0006\t\n\u0000\u001a\u0005\b\u008c\u0001\u0010eR\u001a\u0010\u008d\u0001\u001a\t\u0012\u0005\u0012\u00030\u0085\u00010\n\u00a2\u0006\t\n\u0000\u001a\u0005\b\u008e\u0001\u0010\rR\u0019\u0010\u008f\u0001\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0090\u0001\u0010\rR\u001a\u0010\u0091\u0001\u001a\t\u0012\u0005\u0012\u00030\u0085\u00010\n\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0092\u0001\u0010\r\u00a8\u0006\u0097\u0001"}, d2={"Lcom/intellij/codeInsight/inline/completion/logs/InlineCompletionContextLogs$Logs;", "Lcom/intellij/codeInsight/inline/completion/logs/PhasedLogs;", "<init>", "()V", "toDescription", "", "Lkotlin/time/Duration;", "toDescription-LRDsOJo", "(J)Ljava/lang/String;", "ELEMENT_PREFIX_LENGTH", "Lcom/intellij/internal/statistic/eventLog/events/EventField;", "", "getELEMENT_PREFIX_LENGTH", "()Lcom/intellij/internal/statistic/eventLog/events/EventField;", "LINE_NUMBER", "getLINE_NUMBER", "COLUMN_NUMBER", "getCOLUMN_NUMBER", "FILE_LINE_COUNT", "getFILE_LINE_COUNT", "SYMBOLS_IN_LINE_BEFORE_CARET", "getSYMBOLS_IN_LINE_BEFORE_CARET", "SYMBOLS_IN_LINE_AFTER_CARET", "getSYMBOLS_IN_LINE_AFTER_CARET", "IS_WHITE_SPACE_BEFORE_CARET", "", "getIS_WHITE_SPACE_BEFORE_CARET", "IS_WHITE_SPACE_AFTER_CARET", "getIS_WHITE_SPACE_AFTER_CARET", "NON_SPACE_SYMBOL_BEFORE_CARET", "Lcom/intellij/codeInsight/inline/completion/logs/CharCategory;", "getNON_SPACE_SYMBOL_BEFORE_CARET", "NON_SPACE_SYMBOL_AFTER_CARET", "getNON_SPACE_SYMBOL_AFTER_CARET", "PREVIOUS_EMPTY_LINES_COUNT", "getPREVIOUS_EMPTY_LINES_COUNT", "PREVIOUS_NON_EMPTY_LINE_LENGTH", "getPREVIOUS_NON_EMPTY_LINE_LENGTH", "FOLLOWING_EMPTY_LINES_COUNT", "getFOLLOWING_EMPTY_LINES_COUNT", "FOLLOWING_NON_EMPTY_LINE_LENGTH", "getFOLLOWING_NON_EMPTY_LINE_LENGTH", "PARENT_FEATURES", "", "Ljava/lang/Class;", "getPARENT_FEATURES", "()Ljava/util/List;", "IMPORTS_COUNT", "getIMPORTS_COUNT", "POPULAR_LIBRARY_IMPORTS_COUNT", "getPOPULAR_LIBRARY_IMPORTS_COUNT", "POPULAR_LIBRARY_IMPORTS_RATIO", "", "getPOPULAR_LIBRARY_IMPORTS_RATIO", "LIBRARY_IMPORTS_COUNT", "getLIBRARY_IMPORTS_COUNT", "LIBRARY_IMPORTS_RATIO", "getLIBRARY_IMPORTS_RATIO", "NUMB_OF_PREV_QUALIFIERS", "getNUMB_OF_PREV_QUALIFIERS", "PREV_NEIGHBOUR_KEYWORD_1", "getPREV_NEIGHBOUR_KEYWORD_1", "PREV_NEIGHBOUR_KEYWORD_2", "getPREV_NEIGHBOUR_KEYWORD_2", "PREV_SAME_LINE_KEYWORD_1", "getPREV_SAME_LINE_KEYWORD_1", "PREV_SAME_LINE_KEYWORD_2", "getPREV_SAME_LINE_KEYWORD_2", "PREV_SAME_COLUMN_KEYWORD_1", "getPREV_SAME_COLUMN_KEYWORD_1", "PREV_SAME_COLUMN_KEYWORD_2", "getPREV_SAME_COLUMN_KEYWORD_2", "IS_IN_ARGUMENTS", "getIS_IN_ARGUMENTS", "IS_DIRECTLY_IN_ARGUMENTS_CONTEXT", "getIS_DIRECTLY_IN_ARGUMENTS_CONTEXT", "ARGUMENT_INDEX", "getARGUMENT_INDEX", "ARGUMENTS_SIZE", "getARGUMENTS_SIZE", "HAVE_NAMED_ARG_LEFT", "getHAVE_NAMED_ARG_LEFT", "HAVE_NAMED_ARG_RIGHT", "getHAVE_NAMED_ARG_RIGHT", "HAVE_OPENING_PARENTHESIS_LEFT", "getHAVE_OPENING_PARENTHESIS_LEFT", "HAVE_OPENING_BRACKET_LEFT", "getHAVE_OPENING_BRACKET_LEFT", "HAVE_OPENING_BRACE_LEFT", "getHAVE_OPENING_BRACE_LEFT", "HAVE_OPENING_ANGLE_BRACKET_LEFT", "getHAVE_OPENING_ANGLE_BRACKET_LEFT", "IS_IN_CONDITIONAL_STATEMENT", "getIS_IN_CONDITIONAL_STATEMENT", "IS_IN_FOR_STATEMENT", "getIS_IN_FOR_STATEMENT", "BLOCK_STATEMENT_LEVEL", "getBLOCK_STATEMENT_LEVEL", "TOPIC_TO_FIELD", "", "getTOPIC_TO_FIELD", "()Ljava/util/Map;", "SCOPE_TYPE", "Lcom/intellij/codeInsight/inline/completion/features/InlineCompletionFeaturesScopeAnalyzer$ScopeType;", "getSCOPE_TYPE", "SCOPE_INIT", "getSCOPE_INIT", "SCOPE_NUM_LINES", "getSCOPE_NUM_LINES", "SCOPE_NUM_SYMBOLS", "getSCOPE_NUM_SYMBOLS", "SCOPE_LINE_OFFSET", "getSCOPE_LINE_OFFSET", "SCOPE_OFFSET", "getSCOPE_OFFSET", "SCOPE_VALUABLE_SYMBOLS_BEFORE", "getSCOPE_VALUABLE_SYMBOLS_BEFORE", "SCOPE_VALUABLE_SYMBOLS_AFTER", "getSCOPE_VALUABLE_SYMBOLS_AFTER", "SCOPE_HAS_ERROR_PSI", "getSCOPE_HAS_ERROR_PSI", "TIME_SINCE_LAST_TYPING", "", "getTIME_SINCE_LAST_TYPING", "TYPING_SPEEDS", "getTYPING_SPEEDS", "PREV_SELECTED", "getPREV_SELECTED", "TIME_SINCE_LAST_SELECTION", "getTIME_SINCE_LAST_SELECTION", "TIME_SINCE_LAST_SHOWUP", "getTIME_SINCE_LAST_SHOWUP", "SELECTED_RATIO", "", "getSELECTED_RATIO", "INVALIDATED_RATIO", "getINVALIDATED_RATIO", "EXPLICIT_CANCEL_RATIO", "getEXPLICIT_CANCEL_RATIO", "DECAYING_FEATURES", "getDECAYING_FEATURES", "AVERAGE_PREFIX_LENGTH", "getAVERAGE_PREFIX_LENGTH", "MOST_FREQUENT_PREFIX_LENGTH", "getMOST_FREQUENT_PREFIX_LENGTH", "AVERAGE_TIME_BETWEEN_TYPING", "getAVERAGE_TIME_BETWEEN_TYPING", "scopeFeatures", "T", "createFeatureDeclaration", "Lkotlin/Function1;", "intellij.platform.ide.codeinsight.inline"})
    @SourceDebugExtension(value={"SMAP\nInlineCompletionContextLogs.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlineCompletionContextLogs.kt\ncom/intellij/codeInsight/inline/completion/logs/InlineCompletionContextLogs$Logs\n+ 2 EventFields.kt\ncom/intellij/internal/statistic/eventLog/events/EventFields\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,370:1\n256#2,4:371\n261#2,3:375\n261#2,3:378\n1563#3:381\n1634#3,3:382\n1285#3,2:385\n1299#3,4:387\n1285#3,2:395\n1299#3,4:397\n11561#4:391\n11896#4,3:392\n*S KotlinDebug\n*F\n+ 1 InlineCompletionContextLogs.kt\ncom/intellij/codeInsight/inline/completion/logs/InlineCompletionContextLogs$Logs\n*L\n317#1:371,4\n281#1:375,3\n282#1:378,3\n287#1:381\n287#1:382,3\n316#1:385,2\n316#1:387,4\n339#1:395,2\n339#1:397,4\n328#1:391\n328#1:392,3\n*E\n"})
    private static final class Logs
    extends PhasedLogs {
        @NotNull
        public static final Logs INSTANCE;
        @NotNull
        private static final EventField<Integer> ELEMENT_PREFIX_LENGTH;
        @NotNull
        private static final EventField<Integer> LINE_NUMBER;
        @NotNull
        private static final EventField<Integer> COLUMN_NUMBER;
        @NotNull
        private static final EventField<Integer> FILE_LINE_COUNT;
        @NotNull
        private static final EventField<Integer> SYMBOLS_IN_LINE_BEFORE_CARET;
        @NotNull
        private static final EventField<Integer> SYMBOLS_IN_LINE_AFTER_CARET;
        @NotNull
        private static final EventField<Boolean> IS_WHITE_SPACE_BEFORE_CARET;
        @NotNull
        private static final EventField<Boolean> IS_WHITE_SPACE_AFTER_CARET;
        @NotNull
        private static final EventField<CharCategory> NON_SPACE_SYMBOL_BEFORE_CARET;
        @NotNull
        private static final EventField<CharCategory> NON_SPACE_SYMBOL_AFTER_CARET;
        @NotNull
        private static final EventField<Integer> PREVIOUS_EMPTY_LINES_COUNT;
        @NotNull
        private static final EventField<Integer> PREVIOUS_NON_EMPTY_LINE_LENGTH;
        @NotNull
        private static final EventField<Integer> FOLLOWING_EMPTY_LINES_COUNT;
        @NotNull
        private static final EventField<Integer> FOLLOWING_NON_EMPTY_LINE_LENGTH;
        @NotNull
        private static final List<EventField<Class<?>>> PARENT_FEATURES;
        @NotNull
        private static final EventField<Integer> IMPORTS_COUNT;
        @NotNull
        private static final EventField<Integer> POPULAR_LIBRARY_IMPORTS_COUNT;
        @NotNull
        private static final EventField<Float> POPULAR_LIBRARY_IMPORTS_RATIO;
        @NotNull
        private static final EventField<Integer> LIBRARY_IMPORTS_COUNT;
        @NotNull
        private static final EventField<Float> LIBRARY_IMPORTS_RATIO;
        @NotNull
        private static final EventField<Integer> NUMB_OF_PREV_QUALIFIERS;
        @NotNull
        private static final EventField<Integer> PREV_NEIGHBOUR_KEYWORD_1;
        @NotNull
        private static final EventField<Integer> PREV_NEIGHBOUR_KEYWORD_2;
        @NotNull
        private static final EventField<Integer> PREV_SAME_LINE_KEYWORD_1;
        @NotNull
        private static final EventField<Integer> PREV_SAME_LINE_KEYWORD_2;
        @NotNull
        private static final EventField<Integer> PREV_SAME_COLUMN_KEYWORD_1;
        @NotNull
        private static final EventField<Integer> PREV_SAME_COLUMN_KEYWORD_2;
        @NotNull
        private static final EventField<Boolean> IS_IN_ARGUMENTS;
        @NotNull
        private static final EventField<Boolean> IS_DIRECTLY_IN_ARGUMENTS_CONTEXT;
        @NotNull
        private static final EventField<Integer> ARGUMENT_INDEX;
        @NotNull
        private static final EventField<Integer> ARGUMENTS_SIZE;
        @NotNull
        private static final EventField<Boolean> HAVE_NAMED_ARG_LEFT;
        @NotNull
        private static final EventField<Boolean> HAVE_NAMED_ARG_RIGHT;
        @NotNull
        private static final EventField<Boolean> HAVE_OPENING_PARENTHESIS_LEFT;
        @NotNull
        private static final EventField<Boolean> HAVE_OPENING_BRACKET_LEFT;
        @NotNull
        private static final EventField<Boolean> HAVE_OPENING_BRACE_LEFT;
        @NotNull
        private static final EventField<Boolean> HAVE_OPENING_ANGLE_BRACKET_LEFT;
        @NotNull
        private static final EventField<Boolean> IS_IN_CONDITIONAL_STATEMENT;
        @NotNull
        private static final EventField<Boolean> IS_IN_FOR_STATEMENT;
        @NotNull
        private static final EventField<Integer> BLOCK_STATEMENT_LEVEL;
        @NotNull
        private static final Map<String, EventField<Boolean>> TOPIC_TO_FIELD;
        @NotNull
        private static final List<EventField<InlineCompletionFeaturesScopeAnalyzer.ScopeType>> SCOPE_TYPE;
        @NotNull
        private static final List<EventField<Boolean>> SCOPE_INIT;
        @NotNull
        private static final List<EventField<Integer>> SCOPE_NUM_LINES;
        @NotNull
        private static final List<EventField<Integer>> SCOPE_NUM_SYMBOLS;
        @NotNull
        private static final List<EventField<Integer>> SCOPE_LINE_OFFSET;
        @NotNull
        private static final List<EventField<Integer>> SCOPE_OFFSET;
        @NotNull
        private static final List<EventField<Boolean>> SCOPE_VALUABLE_SYMBOLS_BEFORE;
        @NotNull
        private static final List<EventField<Boolean>> SCOPE_VALUABLE_SYMBOLS_AFTER;
        @NotNull
        private static final List<EventField<Boolean>> SCOPE_HAS_ERROR_PSI;
        @NotNull
        private static final EventField<Long> TIME_SINCE_LAST_TYPING;
        @NotNull
        private static final List<EventField<?>> TYPING_SPEEDS;
        @NotNull
        private static final EventField<Boolean> PREV_SELECTED;
        @NotNull
        private static final EventField<Long> TIME_SINCE_LAST_SELECTION;
        @NotNull
        private static final EventField<Long> TIME_SINCE_LAST_SHOWUP;
        @NotNull
        private static final EventField<Double> SELECTED_RATIO;
        @NotNull
        private static final EventField<Double> INVALIDATED_RATIO;
        @NotNull
        private static final EventField<Double> EXPLICIT_CANCEL_RATIO;
        @NotNull
        private static final Map<Duration, List<EventField<Double>>> DECAYING_FEATURES;
        @NotNull
        private static final EventField<Double> AVERAGE_PREFIX_LENGTH;
        @NotNull
        private static final EventField<Integer> MOST_FREQUENT_PREFIX_LENGTH;
        @NotNull
        private static final EventField<Double> AVERAGE_TIME_BETWEEN_TYPING;

        private Logs() {
            super(InlineCompletionLogsContainer.Phase.INLINE_API_STARTING);
        }

        private final String toDescription-LRDsOJo(long l) {
            return StringsKt.replace$default((String)Duration.toString-impl((long)l), (String)" ", (String)"", (boolean)false, (int)4, null);
        }

        @NotNull
        public final EventField<Integer> getELEMENT_PREFIX_LENGTH() {
            return ELEMENT_PREFIX_LENGTH;
        }

        @NotNull
        public final EventField<Integer> getLINE_NUMBER() {
            return LINE_NUMBER;
        }

        @NotNull
        public final EventField<Integer> getCOLUMN_NUMBER() {
            return COLUMN_NUMBER;
        }

        @NotNull
        public final EventField<Integer> getFILE_LINE_COUNT() {
            return FILE_LINE_COUNT;
        }

        @NotNull
        public final EventField<Integer> getSYMBOLS_IN_LINE_BEFORE_CARET() {
            return SYMBOLS_IN_LINE_BEFORE_CARET;
        }

        @NotNull
        public final EventField<Integer> getSYMBOLS_IN_LINE_AFTER_CARET() {
            return SYMBOLS_IN_LINE_AFTER_CARET;
        }

        @NotNull
        public final EventField<Boolean> getIS_WHITE_SPACE_BEFORE_CARET() {
            return IS_WHITE_SPACE_BEFORE_CARET;
        }

        @NotNull
        public final EventField<Boolean> getIS_WHITE_SPACE_AFTER_CARET() {
            return IS_WHITE_SPACE_AFTER_CARET;
        }

        @NotNull
        public final EventField<CharCategory> getNON_SPACE_SYMBOL_BEFORE_CARET() {
            return NON_SPACE_SYMBOL_BEFORE_CARET;
        }

        @NotNull
        public final EventField<CharCategory> getNON_SPACE_SYMBOL_AFTER_CARET() {
            return NON_SPACE_SYMBOL_AFTER_CARET;
        }

        @NotNull
        public final EventField<Integer> getPREVIOUS_EMPTY_LINES_COUNT() {
            return PREVIOUS_EMPTY_LINES_COUNT;
        }

        @NotNull
        public final EventField<Integer> getPREVIOUS_NON_EMPTY_LINE_LENGTH() {
            return PREVIOUS_NON_EMPTY_LINE_LENGTH;
        }

        @NotNull
        public final EventField<Integer> getFOLLOWING_EMPTY_LINES_COUNT() {
            return FOLLOWING_EMPTY_LINES_COUNT;
        }

        @NotNull
        public final EventField<Integer> getFOLLOWING_NON_EMPTY_LINE_LENGTH() {
            return FOLLOWING_NON_EMPTY_LINE_LENGTH;
        }

        @NotNull
        public final List<EventField<Class<?>>> getPARENT_FEATURES() {
            return PARENT_FEATURES;
        }

        @NotNull
        public final EventField<Integer> getIMPORTS_COUNT() {
            return IMPORTS_COUNT;
        }

        @NotNull
        public final EventField<Integer> getPOPULAR_LIBRARY_IMPORTS_COUNT() {
            return POPULAR_LIBRARY_IMPORTS_COUNT;
        }

        @NotNull
        public final EventField<Float> getPOPULAR_LIBRARY_IMPORTS_RATIO() {
            return POPULAR_LIBRARY_IMPORTS_RATIO;
        }

        @NotNull
        public final EventField<Integer> getLIBRARY_IMPORTS_COUNT() {
            return LIBRARY_IMPORTS_COUNT;
        }

        @NotNull
        public final EventField<Float> getLIBRARY_IMPORTS_RATIO() {
            return LIBRARY_IMPORTS_RATIO;
        }

        @NotNull
        public final EventField<Integer> getNUMB_OF_PREV_QUALIFIERS() {
            return NUMB_OF_PREV_QUALIFIERS;
        }

        @NotNull
        public final EventField<Integer> getPREV_NEIGHBOUR_KEYWORD_1() {
            return PREV_NEIGHBOUR_KEYWORD_1;
        }

        @NotNull
        public final EventField<Integer> getPREV_NEIGHBOUR_KEYWORD_2() {
            return PREV_NEIGHBOUR_KEYWORD_2;
        }

        @NotNull
        public final EventField<Integer> getPREV_SAME_LINE_KEYWORD_1() {
            return PREV_SAME_LINE_KEYWORD_1;
        }

        @NotNull
        public final EventField<Integer> getPREV_SAME_LINE_KEYWORD_2() {
            return PREV_SAME_LINE_KEYWORD_2;
        }

        @NotNull
        public final EventField<Integer> getPREV_SAME_COLUMN_KEYWORD_1() {
            return PREV_SAME_COLUMN_KEYWORD_1;
        }

        @NotNull
        public final EventField<Integer> getPREV_SAME_COLUMN_KEYWORD_2() {
            return PREV_SAME_COLUMN_KEYWORD_2;
        }

        @NotNull
        public final EventField<Boolean> getIS_IN_ARGUMENTS() {
            return IS_IN_ARGUMENTS;
        }

        @NotNull
        public final EventField<Boolean> getIS_DIRECTLY_IN_ARGUMENTS_CONTEXT() {
            return IS_DIRECTLY_IN_ARGUMENTS_CONTEXT;
        }

        @NotNull
        public final EventField<Integer> getARGUMENT_INDEX() {
            return ARGUMENT_INDEX;
        }

        @NotNull
        public final EventField<Integer> getARGUMENTS_SIZE() {
            return ARGUMENTS_SIZE;
        }

        @NotNull
        public final EventField<Boolean> getHAVE_NAMED_ARG_LEFT() {
            return HAVE_NAMED_ARG_LEFT;
        }

        @NotNull
        public final EventField<Boolean> getHAVE_NAMED_ARG_RIGHT() {
            return HAVE_NAMED_ARG_RIGHT;
        }

        @NotNull
        public final EventField<Boolean> getHAVE_OPENING_PARENTHESIS_LEFT() {
            return HAVE_OPENING_PARENTHESIS_LEFT;
        }

        @NotNull
        public final EventField<Boolean> getHAVE_OPENING_BRACKET_LEFT() {
            return HAVE_OPENING_BRACKET_LEFT;
        }

        @NotNull
        public final EventField<Boolean> getHAVE_OPENING_BRACE_LEFT() {
            return HAVE_OPENING_BRACE_LEFT;
        }

        @NotNull
        public final EventField<Boolean> getHAVE_OPENING_ANGLE_BRACKET_LEFT() {
            return HAVE_OPENING_ANGLE_BRACKET_LEFT;
        }

        @NotNull
        public final EventField<Boolean> getIS_IN_CONDITIONAL_STATEMENT() {
            return IS_IN_CONDITIONAL_STATEMENT;
        }

        @NotNull
        public final EventField<Boolean> getIS_IN_FOR_STATEMENT() {
            return IS_IN_FOR_STATEMENT;
        }

        @NotNull
        public final EventField<Integer> getBLOCK_STATEMENT_LEVEL() {
            return BLOCK_STATEMENT_LEVEL;
        }

        @NotNull
        public final Map<String, EventField<Boolean>> getTOPIC_TO_FIELD() {
            return TOPIC_TO_FIELD;
        }

        @NotNull
        public final List<EventField<InlineCompletionFeaturesScopeAnalyzer.ScopeType>> getSCOPE_TYPE() {
            return SCOPE_TYPE;
        }

        @NotNull
        public final List<EventField<Boolean>> getSCOPE_INIT() {
            return SCOPE_INIT;
        }

        @NotNull
        public final List<EventField<Integer>> getSCOPE_NUM_LINES() {
            return SCOPE_NUM_LINES;
        }

        @NotNull
        public final List<EventField<Integer>> getSCOPE_NUM_SYMBOLS() {
            return SCOPE_NUM_SYMBOLS;
        }

        @NotNull
        public final List<EventField<Integer>> getSCOPE_LINE_OFFSET() {
            return SCOPE_LINE_OFFSET;
        }

        @NotNull
        public final List<EventField<Integer>> getSCOPE_OFFSET() {
            return SCOPE_OFFSET;
        }

        @NotNull
        public final List<EventField<Boolean>> getSCOPE_VALUABLE_SYMBOLS_BEFORE() {
            return SCOPE_VALUABLE_SYMBOLS_BEFORE;
        }

        @NotNull
        public final List<EventField<Boolean>> getSCOPE_VALUABLE_SYMBOLS_AFTER() {
            return SCOPE_VALUABLE_SYMBOLS_AFTER;
        }

        @NotNull
        public final List<EventField<Boolean>> getSCOPE_HAS_ERROR_PSI() {
            return SCOPE_HAS_ERROR_PSI;
        }

        @NotNull
        public final EventField<Long> getTIME_SINCE_LAST_TYPING() {
            return TIME_SINCE_LAST_TYPING;
        }

        @NotNull
        public final List<EventField<?>> getTYPING_SPEEDS() {
            return TYPING_SPEEDS;
        }

        @NotNull
        public final EventField<Boolean> getPREV_SELECTED() {
            return PREV_SELECTED;
        }

        @NotNull
        public final EventField<Long> getTIME_SINCE_LAST_SELECTION() {
            return TIME_SINCE_LAST_SELECTION;
        }

        @NotNull
        public final EventField<Long> getTIME_SINCE_LAST_SHOWUP() {
            return TIME_SINCE_LAST_SHOWUP;
        }

        @NotNull
        public final EventField<Double> getSELECTED_RATIO() {
            return SELECTED_RATIO;
        }

        @NotNull
        public final EventField<Double> getINVALIDATED_RATIO() {
            return INVALIDATED_RATIO;
        }

        @NotNull
        public final EventField<Double> getEXPLICIT_CANCEL_RATIO() {
            return EXPLICIT_CANCEL_RATIO;
        }

        @NotNull
        public final Map<Duration, List<EventField<Double>>> getDECAYING_FEATURES() {
            return DECAYING_FEATURES;
        }

        @NotNull
        public final EventField<Double> getAVERAGE_PREFIX_LENGTH() {
            return AVERAGE_PREFIX_LENGTH;
        }

        @NotNull
        public final EventField<Integer> getMOST_FREQUENT_PREFIX_LENGTH() {
            return MOST_FREQUENT_PREFIX_LENGTH;
        }

        @NotNull
        public final EventField<Double> getAVERAGE_TIME_BETWEEN_TYPING() {
            return AVERAGE_TIME_BETWEEN_TYPING;
        }

        private final <T> List<EventField<T>> scopeFeatures(Function1<? super String, ? extends EventField<T>> createFeatureDeclaration) {
            Object[] objectArray = new EventField[]{this.register((EventField)createFeatureDeclaration.invoke((Object)"caret")), this.register((EventField)createFeatureDeclaration.invoke((Object)"parent")), this.register((EventField)createFeatureDeclaration.invoke((Object)"grand_parent")), this.register((EventField)createFeatureDeclaration.invoke((Object)"prev")), this.register((EventField)createFeatureDeclaration.invoke((Object)"next"))};
            return CollectionsKt.listOf((Object[])objectArray);
        }

        /*
         * WARNING - void declaration
         */
        private static final EventField SCOPE_TYPE$lambda$0(String it) {
            void name$iv;
            void $this$iv;
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            EventFields eventFields = EventFields.INSTANCE;
            String string = it + "_scope_type";
            String description$iv = "Type of " + it + " scope where the caret is placed";
            Function1 transform$iv = $this$iv.getDefaultEnumTransform();
            boolean $i$f$Enum = false;
            return (EventField)new EnumEventField((String)name$iv, InlineCompletionFeaturesScopeAnalyzer.ScopeType.class, description$iv, transform$iv);
        }

        private static final EventField SCOPE_INIT$lambda$0(String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return (EventField)EventFields.Boolean((String)(it + "_scope_init"), (String)("True if caret is placed at the " + it + " scope initialization"));
        }

        private static final EventField SCOPE_NUM_LINES$lambda$0(String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return (EventField)EventFields.Int((String)(it + "_scope_num_lines"), (String)("Number of lines in the " + it + " scope where the caret is placed"));
        }

        private static final EventField SCOPE_NUM_SYMBOLS$lambda$0(String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return (EventField)EventFields.Int((String)(it + "_scope_num_symbols"), (String)("Number of symbols in the " + it + " scope where the caret is placed"));
        }

        private static final EventField SCOPE_LINE_OFFSET$lambda$0(String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return (EventField)EventFields.Int((String)(it + "_scope_line_offset"), (String)("Line offset of the caret in the " + it + " scope"));
        }

        private static final EventField SCOPE_OFFSET$lambda$0(String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return (EventField)EventFields.Int((String)(it + "_scope_offset"), (String)("Char offset of the caret in the " + it + " scope"));
        }

        private static final EventField SCOPE_VALUABLE_SYMBOLS_BEFORE$lambda$0(String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return (EventField)EventFields.Boolean((String)(it + "_scope_valuable_symbols_before"), (String)("False if in the " + it + " scope before caret there are only whitespaces or statements/strings enclosures"));
        }

        private static final EventField SCOPE_VALUABLE_SYMBOLS_AFTER$lambda$0(String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return (EventField)EventFields.Boolean((String)(it + "_scope_valuable_symbols_after"), (String)("False if in the " + it + " scope after caret there are only whitespaces or statements/strings enclosures"));
        }

        private static final EventField SCOPE_HAS_ERROR_PSI$lambda$0(String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return (EventField)EventFields.Boolean((String)(it + "_scope_has_error_psi"), (String)("True if in the " + it + " scope there's any PsiError element"));
        }

        /*
         * WARNING - void declaration
         */
        static {
            Object object;
            Object t;
            void $this$associateWithTo$iv$iv;
            Object object2;
            void $this$mapTo$iv$iv;
            Object[] $this$iv;
            INSTANCE = new Logs();
            ELEMENT_PREFIX_LENGTH = INSTANCE.register((EventField)EventFields.Int((String)"element_prefix_length"));
            LINE_NUMBER = INSTANCE.register((EventField)EventFields.Int((String)"line_number"));
            COLUMN_NUMBER = INSTANCE.register((EventField)EventFields.Int((String)"column_number"));
            FILE_LINE_COUNT = INSTANCE.register((EventField)EventFields.Int((String)"file_line_count"));
            SYMBOLS_IN_LINE_BEFORE_CARET = INSTANCE.register((EventField)EventFields.Int((String)"symbols_in_line_before_caret"));
            SYMBOLS_IN_LINE_AFTER_CARET = INSTANCE.register((EventField)EventFields.Int((String)"symbols_in_line_after_caret"));
            IS_WHITE_SPACE_BEFORE_CARET = INSTANCE.register((EventField)EventFields.Boolean((String)"is_white_space_before_caret"));
            IS_WHITE_SPACE_AFTER_CARET = INSTANCE.register((EventField)EventFields.Boolean((String)"is_white_space_after_caret"));
            EventFields eventFields = EventFields.INSTANCE;
            String name$iv = "non_space_symbol_before_caret";
            Object transform$iv = $this$iv.getDefaultEnumTransform();
            boolean $i$f$Enum = false;
            NON_SPACE_SYMBOL_BEFORE_CARET = INSTANCE.register((EventField)new EnumEventField(name$iv, CharCategory.class, null, transform$iv));
            $this$iv = EventFields.INSTANCE;
            name$iv = "non_space_symbol_after_caret";
            transform$iv = $this$iv.getDefaultEnumTransform();
            $i$f$Enum = false;
            NON_SPACE_SYMBOL_AFTER_CARET = INSTANCE.register((EventField)new EnumEventField(name$iv, CharCategory.class, null, transform$iv));
            PREVIOUS_EMPTY_LINES_COUNT = INSTANCE.register((EventField)EventFields.Int((String)"previous_empty_lines_count"));
            PREVIOUS_NON_EMPTY_LINE_LENGTH = INSTANCE.register((EventField)EventFields.Int((String)"previous_non_empty_line_length"));
            FOLLOWING_EMPTY_LINES_COUNT = INSTANCE.register((EventField)EventFields.Int((String)"following_empty_lines_count"));
            FOLLOWING_NON_EMPTY_LINE_LENGTH = INSTANCE.register((EventField)EventFields.Int((String)"following_non_empty_line_length"));
            $this$iv = new String[]{"first", "second", "third", "forth", "fifth"};
            Object[] $this$map$iv = (Object[])CollectionsKt.listOf((Object[])$this$iv);
            boolean $i$f$map = false;
            transform$iv = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                object2 = destination$iv$iv;
                boolean bl = false;
                object2.add(INSTANCE.register((EventField)EventFields.Class((String)((String)it + "_parent"))));
            }
            PARENT_FEATURES = (List)destination$iv$iv;
            IMPORTS_COUNT = INSTANCE.register((EventField)EventFields.Int((String)"imports_count"));
            POPULAR_LIBRARY_IMPORTS_COUNT = INSTANCE.register((EventField)EventFields.Int((String)"popular_library_imports_count"));
            POPULAR_LIBRARY_IMPORTS_RATIO = INSTANCE.register((EventField)EventFields.Float$default((String)"popular_library_imports_ratio", null, (int)2, null));
            LIBRARY_IMPORTS_COUNT = INSTANCE.register((EventField)EventFields.Int((String)"library_imports_count"));
            LIBRARY_IMPORTS_RATIO = INSTANCE.register((EventField)EventFields.Float$default((String)"library_imports_ratio", null, (int)2, null));
            NUMB_OF_PREV_QUALIFIERS = INSTANCE.register((EventField)EventFields.Int((String)"num_of_prev_qualifiers"));
            PREV_NEIGHBOUR_KEYWORD_1 = INSTANCE.register((EventField)EventFields.Int((String)"prev_neighbour_keyword_1"));
            PREV_NEIGHBOUR_KEYWORD_2 = INSTANCE.register((EventField)EventFields.Int((String)"prev_neighbour_keyword_2"));
            PREV_SAME_LINE_KEYWORD_1 = INSTANCE.register((EventField)EventFields.Int((String)"prev_same_line_keyword_1"));
            PREV_SAME_LINE_KEYWORD_2 = INSTANCE.register((EventField)EventFields.Int((String)"prev_same_line_keyword_2"));
            PREV_SAME_COLUMN_KEYWORD_1 = INSTANCE.register((EventField)EventFields.Int((String)"prev_same_column_keyword_1"));
            PREV_SAME_COLUMN_KEYWORD_2 = INSTANCE.register((EventField)EventFields.Int((String)"prev_same_column_keyword_2"));
            IS_IN_ARGUMENTS = INSTANCE.register((EventField)EventFields.Boolean((String)"is_in_arguments"));
            IS_DIRECTLY_IN_ARGUMENTS_CONTEXT = INSTANCE.register((EventField)EventFields.Boolean((String)"is_directly_in_arguments_context"));
            ARGUMENT_INDEX = INSTANCE.register((EventField)EventFields.Int((String)"argument_index"));
            ARGUMENTS_SIZE = INSTANCE.register((EventField)EventFields.Int((String)"number_of_arguments_already"));
            HAVE_NAMED_ARG_LEFT = INSTANCE.register((EventField)EventFields.Boolean((String)"have_named_arg_left"));
            HAVE_NAMED_ARG_RIGHT = INSTANCE.register((EventField)EventFields.Boolean((String)"have_named_arg_right"));
            HAVE_OPENING_PARENTHESIS_LEFT = INSTANCE.register((EventField)EventFields.Boolean((String)"have_opening_parenthesis_left"));
            HAVE_OPENING_BRACKET_LEFT = INSTANCE.register((EventField)EventFields.Boolean((String)"have_opening_bracket_left"));
            HAVE_OPENING_BRACE_LEFT = INSTANCE.register((EventField)EventFields.Boolean((String)"have_opening_brace_left"));
            HAVE_OPENING_ANGLE_BRACKET_LEFT = INSTANCE.register((EventField)EventFields.Boolean((String)"have_opening_angle_bracket_left"));
            IS_IN_CONDITIONAL_STATEMENT = INSTANCE.register((EventField)EventFields.Boolean((String)"is_in_conditional_statement"));
            IS_IN_FOR_STATEMENT = INSTANCE.register((EventField)EventFields.Boolean((String)"is_in_for_statement"));
            BLOCK_STATEMENT_LEVEL = INSTANCE.register((EventField)EventFields.Int((String)"block_statement_level"));
            $this$map$iv = new String[]{"data_science", "web"};
            Iterable $this$associateWith$iv = CollectionsKt.listOf((Object[])$this$map$iv);
            boolean $i$f$associateWith = false;
            Object result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            destination$iv$iv = $this$associateWith$iv;
            Map destination$iv$iv2 = (Map)result$iv;
            int $i$f$associateWithTo = 0;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                void it;
                String bl = (String)element$iv$iv;
                t = element$iv$iv;
                object2 = destination$iv$iv2;
                boolean bl2 = false;
                object = INSTANCE.register((EventField)EventFields.Boolean((String)("has_" + (String)it + "_imports")));
                object2.put(t, object);
            }
            TOPIC_TO_FIELD = destination$iv$iv2;
            SCOPE_TYPE = INSTANCE.scopeFeatures(Logs::SCOPE_TYPE$lambda$0);
            SCOPE_INIT = INSTANCE.scopeFeatures(Logs::SCOPE_INIT$lambda$0);
            SCOPE_NUM_LINES = INSTANCE.scopeFeatures(Logs::SCOPE_NUM_LINES$lambda$0);
            SCOPE_NUM_SYMBOLS = INSTANCE.scopeFeatures(Logs::SCOPE_NUM_SYMBOLS$lambda$0);
            SCOPE_LINE_OFFSET = INSTANCE.scopeFeatures(Logs::SCOPE_LINE_OFFSET$lambda$0);
            SCOPE_OFFSET = INSTANCE.scopeFeatures(Logs::SCOPE_OFFSET$lambda$0);
            SCOPE_VALUABLE_SYMBOLS_BEFORE = INSTANCE.scopeFeatures(Logs::SCOPE_VALUABLE_SYMBOLS_BEFORE$lambda$0);
            SCOPE_VALUABLE_SYMBOLS_AFTER = INSTANCE.scopeFeatures(Logs::SCOPE_VALUABLE_SYMBOLS_AFTER$lambda$0);
            SCOPE_HAS_ERROR_PSI = INSTANCE.scopeFeatures(Logs::SCOPE_HAS_ERROR_PSI$lambda$0);
            TIME_SINCE_LAST_TYPING = INSTANCE.register((EventField)EventFields.Long((String)"time_since_last_typing", (String)"Duration between current typing and previous one."));
            $this$map$iv = TypingSpeedTracker.Companion.getEventFields();
            $i$f$map = false;
            result$iv = $this$map$iv;
            destination$iv$iv = new ArrayList($this$map$iv.length);
            $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for ($i$f$associateWithTo = 0; $i$f$associateWithTo < n; ++$i$f$associateWithTo) {
                void item$iv$iv;
                void it = item$iv$iv = $this$mapTo$iv$iv[$i$f$associateWithTo];
                object2 = destination$iv$iv;
                boolean bl = false;
                object2.add(INSTANCE.register(it));
            }
            TYPING_SPEEDS = (List)destination$iv$iv;
            PREV_SELECTED = INSTANCE.register((EventField)EventFields.Boolean((String)"prev_selected", (String)"Indicates whether the previous inline completion was selected or not"));
            TIME_SINCE_LAST_SELECTION = INSTANCE.register((EventField)EventFields.Long((String)"time_since_last_selection", (String)"Time (in ms) elapsed since the last completion selection event"));
            TIME_SINCE_LAST_SHOWUP = INSTANCE.register((EventField)EventFields.Long((String)"time_since_last_showup", (String)"Time (in ms) elapsed since the last completion show-up event"));
            SELECTED_RATIO = INSTANCE.register((EventField)EventFields.Double((String)"selected_ratio", (String)"Ratio of completions selected by the user relative to the total number of completions (statistics are given for the last 10 days)"));
            INVALIDATED_RATIO = INSTANCE.register((EventField)EventFields.Double((String)"invalidated_ratio", (String)"Ratio of completions that were invalidated relative to the total number of completions (statistics are given for the last 10 days)"));
            EXPLICIT_CANCEL_RATIO = INSTANCE.register((EventField)EventFields.Double((String)"explicit_cancel_ratio", (String)"Ratio of completions explicitly canceled by the user relative to the total number of completions (statistics are given for the last 10 days)"));
            $this$associateWith$iv = AcceptanceRateFactorsComponent.Companion.getDECAY_DURATIONS();
            $i$f$associateWith = false;
            result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            destination$iv$iv = $this$associateWith$iv;
            destination$iv$iv = (Map)result$iv;
            $i$f$associateWithTo = 0;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                void duration;
                long it = ((Duration)element$iv$iv).unbox-impl();
                t = element$iv$iv;
                object2 = destination$iv$iv;
                boolean bl = false;
                Object[] objectArray = new EventField[]{INSTANCE.register((EventField)EventFields.Double((String)("selection_decayed_by_" + INSTANCE.toDescription-LRDsOJo((long)duration)), (String)("Selection count with exponential decay applied over a period of " + INSTANCE.toDescription-LRDsOJo((long)duration)))), INSTANCE.register((EventField)EventFields.Double((String)("showup_decayed_by_" + INSTANCE.toDescription-LRDsOJo((long)duration)), (String)("Show-up count with exponential decay applied over a period of " + INSTANCE.toDescription-LRDsOJo((long)duration)))), INSTANCE.register((EventField)EventFields.Double((String)("acceptance_rate_smoothed_by_" + INSTANCE.toDescription-LRDsOJo((long)duration)), (String)("Smoothed acceptance rate (ratio of selections to show-ups) with exponential smoothing over " + INSTANCE.toDescription-LRDsOJo((long)duration))))};
                object = CollectionsKt.listOf((Object[])objectArray);
                object2.put(t, object);
            }
            DECAYING_FEATURES = destination$iv$iv;
            AVERAGE_PREFIX_LENGTH = INSTANCE.register((EventField)EventFields.Double((String)"average_prefix_length", (String)"Average prefix length for completions that resulted in selection"));
            MOST_FREQUENT_PREFIX_LENGTH = INSTANCE.register((EventField)EventFields.Int((String)"most_frequent_prefix_length", (String)"Most frequently observed prefix length among completions that resulted in selection"));
            AVERAGE_TIME_BETWEEN_TYPING = INSTANCE.register((EventField)EventFields.Double((String)"average_time_between_typing", (String)"Average time (in ms) between typing events"));
        }
    }
}

