/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.inline.completion.tooltip;

import com.intellij.codeInsight.inline.completion.editor.InlineCompletionEditorType;
import com.intellij.codeInsight.inline.completion.session.InlineCompletionSession;
import com.intellij.codeInsight.inline.completion.session.InlineCompletionState;
import com.intellij.codeInsight.inline.completion.session.InlineCompletionStateKt;
import com.intellij.codeInsight.inline.completion.tooltip.InlineCompletionTooltip;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.util.Disposer;
import java.awt.Point;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J\b\u0010\f\u001a\u00020\u0007H\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/codeInsight/inline/completion/tooltip/InlineCompletionTooltipProvokerMouseMotionListener;", "Lcom/intellij/openapi/editor/event/EditorMouseMotionListener;", "<init>", "()V", "hoveredSession", "Lcom/intellij/codeInsight/inline/completion/session/InlineCompletionSession;", "mouseMoved", "", "e", "Lcom/intellij/openapi/editor/event/EditorMouseEvent;", "enterHover", "newHoveredSession", "exitHover", "isEditorTypeSupported", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.platform.ide.codeinsight.inline"})
@SourceDebugExtension(value={"SMAP\nInlineCompletionTooltipProvokerMouseMotionListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlineCompletionTooltipProvokerMouseMotionListener.kt\ncom/intellij/codeInsight/inline/completion/tooltip/InlineCompletionTooltipProvokerMouseMotionListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,60:1\n1#2:61\n*E\n"})
public final class InlineCompletionTooltipProvokerMouseMotionListener
implements EditorMouseMotionListener {
    @Nullable
    private InlineCompletionSession hoveredSession;

    public void mouseMoved(@NotNull EditorMouseEvent e) {
        InlineCompletionSession newHoveredSession;
        block11: {
            block10: {
                block9: {
                    block8: {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        if (e.isConsumed()) break block8;
                        Editor editor = e.getEditor();
                        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
                        if (this.isEditorTypeSupported(editor)) break block9;
                    }
                    return;
                }
                if (!Intrinsics.areEqual((Object)e.getArea(), (Object)EditorMouseEventArea.EDITING_AREA)) {
                    this.exitHover();
                    return;
                }
                Editor it = e.getEditor();
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                newHoveredSession = InlineCompletionSession.Companion.getOrNull(it);
                if (newHoveredSession == null) break block10;
                InlineCompletionState inlineCompletionState = newHoveredSession.getContext().getState();
                Point point = e.getMouseEvent().getPoint();
                Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getPoint(...)");
                if (InlineCompletionStateKt.containsPoint(inlineCompletionState, point)) break block11;
            }
            this.exitHover();
            return;
        }
        if (this.hoveredSession != newHoveredSession) {
            this.exitHover();
            this.enterHover(newHoveredSession);
        }
    }

    private final void enterHover(InlineCompletionSession newHoveredSession) {
        this.hoveredSession = newHoveredSession;
        Disposer.register((Disposable)newHoveredSession, () -> InlineCompletionTooltipProvokerMouseMotionListener.enterHover$lambda$0(this));
        InlineCompletionTooltip.INSTANCE.show(newHoveredSession);
    }

    private final void exitHover() {
        this.hoveredSession = null;
    }

    private final boolean isEditorTypeSupported(Editor editor) {
        return switch (WhenMappings.$EnumSwitchMapping$0[InlineCompletionEditorType.Companion.get(editor).ordinal()]) {
            case 1, 2 -> true;
            case 3, 4, 5, 6 -> false;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final void enterHover$lambda$0(InlineCompletionTooltipProvokerMouseMotionListener this$0) {
        this$0.exitHover();
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[InlineCompletionEditorType.values().length];
            try {
                nArray[InlineCompletionEditorType.TERMINAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InlineCompletionEditorType.MAIN_EDITOR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InlineCompletionEditorType.XDEBUGGER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InlineCompletionEditorType.COMMIT_MESSAGES.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InlineCompletionEditorType.AI_ASSISTANT_CHAT_INPUT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InlineCompletionEditorType.UNKNOWN.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

