/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.util.ThreeState;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.LegacyInvokerDelegate;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J$\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00072\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0016H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/util/concurrency/BgtLegacyInvokerDelegate;", "Lcom/intellij/util/concurrency/LegacyInvokerDelegate;", "description", "", "useReadAction", "", "maxThreads", "", "<init>", "(Ljava/lang/String;ZI)V", "getDescription", "()Ljava/lang/String;", "executor", "Ljava/util/concurrent/ScheduledExecutorService;", "Lorg/jetbrains/annotations/NotNull;", "dispose", "", "offer", "runnable", "Ljava/lang/Runnable;", "delay", "promise", "Lorg/jetbrains/concurrency/Promise;", "intellij.platform.ide.concurrency"})
public final class BgtLegacyInvokerDelegate
extends LegacyInvokerDelegate {
    @NotNull
    private final String description;
    @NotNull
    private final ScheduledExecutorService executor;

    public BgtLegacyInvokerDelegate(@NotNull String description, boolean useReadAction, int maxThreads) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        super(useReadAction ? ThreeState.YES : ThreeState.NO);
        this.description = description;
        ScheduledExecutorService scheduledExecutorService = AppExecutorUtil.createBoundedScheduledExecutorService((String)this.getDescription(), (int)maxThreads);
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"createBoundedScheduledExecutorService(...)");
        this.executor = scheduledExecutorService;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.executor.shutdown();
    }

    @Override
    public void offer(@NotNull Runnable runnable, int delay, @NotNull Promise<?> promise) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        Intrinsics.checkNotNullParameter(promise, (String)"promise");
        if (delay > 0) {
            this.executor.schedule(runnable, (long)delay, TimeUnit.MILLISECONDS);
        } else {
            this.executor.execute(runnable);
        }
    }
}

