/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.codeWithMe.ClientId;
import com.intellij.codeWithMe.ClientIdContextElement;
import com.intellij.codeWithMe.ClientIdKt;
import com.intellij.concurrency.ThreadContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.util.concurrency.BgtLegacyInvokerDelegate;
import com.intellij.util.concurrency.ConcurrentBgtCoroutineInvokerDelegate;
import com.intellij.util.concurrency.EdtCoroutineInvokerDelegate;
import com.intellij.util.concurrency.EdtLegacyInvokerDelegate;
import com.intellij.util.concurrency.InvokerDelegate;
import com.intellij.util.concurrency.SequentialBgtCoroutineInvokerDelegate;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0001\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u001e\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/util/concurrency/InvokerService;", "", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "forEdt", "Lcom/intellij/util/concurrency/InvokerDelegate;", "description", "", "forBgt", "useReadAction", "", "maxThreads", "", "Companion", "intellij.platform.ide.concurrency"})
public final class InvokerService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope scope;

    public InvokerService(@NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.scope = scope;
    }

    @NotNull
    public final InvokerDelegate forEdt(@NotNull String description) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        if (InvokerService.Companion.getUseCoroutineInvoker()) {
            ClientIdContextElement clientIdContextElement = ClientIdKt.getClientIdContextElement((CoroutineContext)ThreadContext.currentThreadContext());
            CoroutineContext clientIdContextElement2 = clientIdContextElement != null ? (CoroutineContext)clientIdContextElement : (CoroutineContext)EmptyCoroutineContext.INSTANCE;
            return new EdtCoroutineInvokerDelegate(description, CoroutineScopeKt.childScope$default((CoroutineScope)this.scope, (String)description, (CoroutineContext)clientIdContextElement2, (boolean)false, (int)4, null));
        }
        return new EdtLegacyInvokerDelegate(description);
    }

    @NotNull
    public final InvokerDelegate forBgt(@NotNull String description, boolean useReadAction, int maxThreads) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        if (InvokerService.Companion.getUseCoroutineInvoker()) {
            ClientIdContextElement clientIdContextElement = ClientIdKt.getClientIdContextElement((CoroutineContext)ThreadContext.currentThreadContext());
            CoroutineContext clientIdContextElement2 = clientIdContextElement != null ? (CoroutineContext)clientIdContextElement : (CoroutineContext)EmptyCoroutineContext.INSTANCE;
            return maxThreads == 1 ? (InvokerDelegate)new SequentialBgtCoroutineInvokerDelegate(description, CoroutineScopeKt.childScope$default((CoroutineScope)this.scope, (String)description, (CoroutineContext)clientIdContextElement2, (boolean)false, (int)4, null), useReadAction) : (InvokerDelegate)new ConcurrentBgtCoroutineInvokerDelegate(description, CoroutineScopeKt.childScope$default((CoroutineScope)this.scope, (String)description, (CoroutineContext)clientIdContextElement2, (boolean)false, (int)4, null), useReadAction, maxThreads);
        }
        return new BgtLegacyInvokerDelegate(description, useReadAction, maxThreads);
    }

    @JvmStatic
    @NotNull
    public static final InvokerService getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/util/concurrency/InvokerService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/util/concurrency/InvokerService;", "useCoroutineInvoker", "", "getUseCoroutineInvoker", "()Z", "intellij.platform.ide.concurrency"})
    @SourceDebugExtension(value={"SMAP\nInvokerDelegate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InvokerDelegate.kt\ncom/intellij/util/concurrency/InvokerService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,58:1\n42#2,3:59\n*S KotlinDebug\n*F\n+ 1 InvokerDelegate.kt\ncom/intellij/util/concurrency/InvokerService$Companion\n*L\n27#1:59,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final InvokerService getInstance() {
            boolean $i$f$service = false;
            Class<InvokerService> serviceClass$iv = InvokerService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (InvokerService)object;
        }

        private final boolean getUseCoroutineInvoker() {
            return Registry.Companion.is("ide.tree.invoker.use.coroutines", true);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

