/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.impl;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.intellij.application.impl.AssertingPlatformCoroutineSupport;
import com.intellij.application.impl.AssertingPlatformCoroutineSupportKt;
import com.intellij.diagnostic.LoadingState;
import com.intellij.openapi.application.impl.PlatformCoroutineSupport;
import com.intellij.serviceContainer.NonInjectable;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.ExecutorsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0011\u0018\u00002\u00020\u0001B\u0011\b\u0005\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\t\b\u0016\u00a2\u0006\u0004\b\u0004\u0010\u0006J\b\u0010\u0002\u001a\u00020\u000eH\u0014J\b\u0010\u000f\u001a\u00020\u0003H\u0015J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\tH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R'\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00030\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lcom/intellij/application/impl/AssertingPlatformCoroutineSupport;", "Lcom/intellij/openapi/application/impl/PlatformCoroutineSupport;", "warnAboutUsingLegacyEdt", "", "<init>", "(Z)V", "()V", "uniqueLogWarn", "Lcom/github/benmanes/caffeine/cache/LoadingCache;", "", "getUniqueLogWarn", "()Lcom/github/benmanes/caffeine/cache/LoadingCache;", "uniqueLogWarn$delegate", "Lkotlin/Lazy;", "", "isLegacyEdtWarningEnabled", "logWarning", "className", "intellij.platform.ide.concurrency"})
@VisibleForTesting
@SourceDebugExtension(value={"SMAP\nAssertingPlatformCoroutineSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AssertingPlatformCoroutineSupport.kt\ncom/intellij/application/impl/AssertingPlatformCoroutineSupport\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,84:1\n1#2:85\n*E\n"})
public class AssertingPlatformCoroutineSupport
extends PlatformCoroutineSupport {
    private final boolean warnAboutUsingLegacyEdt;
    @NotNull
    private final Lazy uniqueLogWarn$delegate;

    @NonInjectable
    protected AssertingPlatformCoroutineSupport(boolean warnAboutUsingLegacyEdt) {
        this.warnAboutUsingLegacyEdt = warnAboutUsingLegacyEdt;
        this.uniqueLogWarn$delegate = LazyKt.lazy(AssertingPlatformCoroutineSupport::uniqueLogWarn_delegate$lambda$0);
    }

    public AssertingPlatformCoroutineSupport() {
        this(Boolean.parseBoolean(System.getProperty("idea.warn.legacy.edt", "false")));
    }

    private final LoadingCache<String, Boolean> getUniqueLogWarn() {
        Lazy lazy = this.uniqueLogWarn$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (LoadingCache)object;
    }

    protected void warnAboutUsingLegacyEdt() {
        block1: {
            if (!this.isLegacyEdtWarningEnabled()) break block1;
            String string = AssertingPlatformCoroutineSupportKt.access$checkUsingLegacyEdt();
            if (string != null) {
                String it = string;
                boolean bl = false;
                this.logWarning(it);
            }
        }
    }

    @VisibleForTesting
    protected boolean isLegacyEdtWarningEnabled() {
        return this.warnAboutUsingLegacyEdt && !LoadingState.PROJECT_OPENED.isOccurred();
    }

    protected void logWarning(@NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        this.getUniqueLogWarn().get((Object)className);
    }

    private static final LoadingCache uniqueLogWarn_delegate$lambda$0() {
        return Caffeine.newBuilder().maximumSize(1000L).executor(ExecutorsKt.asExecutor((CoroutineDispatcher)Dispatchers.getDefault())).expireAfterAccess(8L, TimeUnit.HOURS).build((CacheLoader)uniqueLogWarn.2.1.INSTANCE);
    }
}

