/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.concurrency;

import com.intellij.concurrency.ThreadContext;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.ChildContext;
import com.intellij.util.concurrency.Propagation;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

final class ApplierCompleter<T>
extends ForkJoinTask<Void> {
    private final ApplierCompleter<T>[] myCompleters;
    private final int myIndex;
    private final AtomicReference<Throwable> myThrown;
    private final boolean runInReadAction;
    private final boolean failFastOnAcquireReadAction;
    private final ProgressIndicator progressIndicator;
    @NotNull
    private final List<? extends T> array;
    @NotNull
    private final Processor<?> processor;
    private final int lo;
    private final int hi;
    private final AtomicInteger finishedOrUnqueuedAllOwned;
    private static final VarHandle booleanArrayHandle = MethodHandles.arrayElementVarHandle(boolean[].class);
    private final boolean @NotNull [] processed;
    private final Collection<? super ApplierCompleter<T>> failedSubTasks;
    private final ChildContext childContext;

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.progressIndicator.cancel();
        return super.cancel(mayInterruptIfRunning);
    }

    ApplierCompleter(@NotNull @NotNull ApplierCompleter<T> @NotNull [] globalCompleters, int myIndex, @NotNull AtomicReference<Throwable> thrown, boolean runInReadAction, boolean failFastOnAcquireReadAction, @NotNull ProgressIndicator progressIndicator, @NotNull List<? extends T> array, boolean @NotNull [] processed, int lo, int hi, @NotNull Collection<? super ApplierCompleter<T>> failedSubTasks, @NotNull Processor<? super T> processor) {
        if (thrown == null) {
            ApplierCompleter.$$$reportNull$$$0(0);
        }
        if (progressIndicator == null) {
            ApplierCompleter.$$$reportNull$$$0(1);
        }
        if (array == null) {
            ApplierCompleter.$$$reportNull$$$0(2);
        }
        if (failedSubTasks == null) {
            ApplierCompleter.$$$reportNull$$$0(3);
        }
        if (processor == null) {
            ApplierCompleter.$$$reportNull$$$0(4);
        }
        if (globalCompleters == null) {
            ApplierCompleter.$$$reportNull$$$0(5);
        }
        if (processed == null) {
            ApplierCompleter.$$$reportNull$$$0(6);
        }
        this.finishedOrUnqueuedAllOwned = new AtomicInteger();
        this.myCompleters = globalCompleters;
        this.myIndex = myIndex;
        this.myThrown = thrown;
        this.runInReadAction = runInReadAction;
        this.failFastOnAcquireReadAction = failFastOnAcquireReadAction;
        this.progressIndicator = progressIndicator;
        this.array = array;
        this.processed = processed;
        this.processor = processor;
        this.lo = lo;
        this.hi = hi;
        this.failedSubTasks = failedSubTasks;
        this.childContext = Propagation.createChildContextIgnoreStructuredConcurrency((String)"ApplierCompleter");
    }

    @Override
    public Void getRawResult() {
        return null;
    }

    @Override
    protected void setRawResult(Void value) {
    }

    @Override
    protected boolean exec() {
        Runnable runnable = () -> {
            this.execAll();
            this.helpAll();
        };
        this.wrapAndRun(runnable);
        return true;
    }

    private boolean processArrayItem(int i) {
        boolean r;
        try {
            r = this.processor.process(this.array.get(i));
        }
        finally {
            this.finishedOrUnqueuedAllOwned.incrementAndGet();
        }
        return r;
    }

    private static Throwable moreImportant(Throwable throwable1, Throwable throwable2) {
        Throwable result = throwable1 == null ? throwable2 : (throwable2 == null ? throwable1 : (throwable1 instanceof ProcessCanceledException ? throwable2 : throwable1));
        return result;
    }

    void wrapAndRun(@NotNull Runnable process) {
        if (process == null) {
            ApplierCompleter.$$$reportNull$$$0(7);
        }
        if (this.failFastOnAcquireReadAction) {
            ((ApplicationEx)ApplicationManager.getApplication()).executeByImpatientReader(() -> this.wrapInReadActionAndIndicator(process));
        } else {
            this.wrapInReadActionAndIndicator(process);
        }
    }

    private void wrapInReadActionAndIndicator(@NotNull Runnable process) {
        if (process == null) {
            ApplierCompleter.$$$reportNull$$$0(8);
        }
        Runnable toRun = this.runInReadAction ? () -> {
            if (!ApplicationManagerEx.getApplicationEx().tryRunReadAction(process)) {
                this.failedSubTasks.add(this);
            }
        } : process;
        ProgressManager progressManager = ProgressManager.getInstance();
        ProgressIndicator existing = progressManager.getProgressIndicator();
        if (existing == this.progressIndicator) {
            toRun.run();
        } else {
            progressManager.executeProcessUnderProgress(toRun, this.progressIndicator);
        }
    }

    void execAll() {
        try {
            this.processArray();
        }
        catch (IndexNotReadyException indexNotReadyException) {
        }
        catch (Throwable e) {
            this.accumulateAndRethrowUncheckedRaw(e);
        }
    }

    private void helpAll() {
        try {
            ThreadContext.resetThreadContext(() -> {
                this.helpOthers();
                return null;
            });
        }
        catch (IndexNotReadyException indexNotReadyException) {
        }
        catch (Throwable e) {
            this.accumulateAndRethrowUncheckedRaw(e);
        }
    }

    @Contract(value="_->fail")
    private void accumulateAndRethrowUncheckedRaw(@NotNull Throwable e) {
        if (e == null) {
            ApplierCompleter.$$$reportNull$$$0(9);
        }
        e = ApplierCompleter.accumulateException(this.myThrown, e);
        this.cancelProgress();
        ApplierCompleter.rethrowUncheckedRaw(e);
    }

    @Contract(value="_->fail")
    static void rethrowUncheckedRaw(@NotNull Throwable e) throws RuntimeException, Error {
        if (e == null) {
            ApplierCompleter.$$$reportNull$$$0(10);
        }
        if (e instanceof Error) {
            throw (Error)e;
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        throw new RuntimeException(e);
    }

    @NotNull
    static Throwable accumulateException(@NotNull AtomicReference<Throwable> thrown, @NotNull Throwable e) {
        if (thrown == null) {
            ApplierCompleter.$$$reportNull$$$0(11);
        }
        if (e == null) {
            ApplierCompleter.$$$reportNull$$$0(12);
        }
        Throwable throwable = thrown.accumulateAndGet(e, ApplierCompleter::moreImportant);
        if (throwable == null) {
            ApplierCompleter.$$$reportNull$$$0(13);
        }
        return throwable;
    }

    private void processArray() {
        int lo = this.lo;
        int hi = this.hi;
        try (AccessToken ignored = this.childContext.applyContextActions(true);){
            for (int i = lo; i < hi && !this.isFinishedAll(); ++i) {
                ProgressManager.checkCanceled();
                if (!this.unqueue(i) || this.processArrayItem(i)) continue;
                throw new ComputationAbortedException();
            }
        }
    }

    private boolean isFinishedAll() {
        return this.finishedOrUnqueuedAllOwned.get() == this.hi - this.lo;
    }

    private boolean unqueue(int i) {
        return booleanArrayHandle.compareAndSet(this.processed, i, false, true);
    }

    private void helpOthers() {
        int i;
        int n = i = this.myIndex == this.myCompleters.length - 1 ? 0 : this.myIndex + 1;
        while (i != this.myIndex) {
            ApplierCompleter<T> completer = this.myCompleters[i];
            if (!completer.isFinishedAll()) {
                completer.processArray();
            }
            i = i == this.myCompleters.length - 1 ? 0 : i + 1;
        }
    }

    private void cancelProgress() {
        if (!this.progressIndicator.isCanceled()) {
            this.progressIndicator.cancel();
        }
    }

    static boolean completeTaskWhichFailToAcquireReadAction(@NotNull List<? extends ApplierCompleter<?>> tasks) {
        if (tasks == null) {
            ApplierCompleter.$$$reportNull$$$0(14);
        }
        if (tasks.isEmpty()) {
            return true;
        }
        ApplierCompleter[] array = tasks.toArray(new ApplierCompleter[0]);
        boolean[] result = new boolean[]{true};
        boolean inReadAction = ApplicationManager.getApplication().isReadAccessAllowed();
        ThreadContext.resetThreadContext(() -> {
            for (ApplierCompleter task : array) {
                ProgressManager.checkCanceled();
                Runnable r = () -> task.wrapInReadActionAndIndicator(() -> {
                    try {
                        task.processArray();
                    }
                    catch (ComputationAbortedException e) {
                        result[0] = false;
                    }
                });
                if (inReadAction) {
                    r.run();
                    continue;
                }
                ApplicationManager.getApplication().runReadAction(r);
            }
            return null;
        });
        return result[0];
    }

    @NonNls
    public String toString() {
        return "(" + this.lo + "-" + this.hi + ")" + (this.isFinishedAll() ? " finished" : "");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thrown";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "failedSubTasks";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalCompleters";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processed";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/concurrency/ApplierCompleter";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/concurrency/ApplierCompleter";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "accumulateException";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "wrapAndRun";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "wrapInReadActionAndIndicator";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "accumulateAndRethrowUncheckedRaw";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "rethrowUncheckedRaw";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "accumulateException";
                break;
            }
            case 13: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "completeTaskWhichFailToAcquireReadAction";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 13 -> new IllegalStateException(string);
        };
    }

    static final class ComputationAbortedException
    extends RuntimeException {
        ComputationAbortedException() {
        }
    }
}

