/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.concurrency;

import com.intellij.concurrency.ApplierCompleter;
import com.intellij.concurrency.Job;
import com.intellij.concurrency.JobLauncher;
import com.intellij.concurrency.JobSchedulerImpl;
import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.concurrency.ThreadContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.progress.util.StandardProgressIndicatorBase;
import com.intellij.openapi.util.Ref;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import kotlin.coroutines.CoroutineContext;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class JobLauncherImpl
extends JobLauncher {
    @ApiStatus.Internal
    public static final int CORES_FORK_THRESHOLD = 1;
    private static final Logger LOG = Logger.getInstance(JobLauncher.class);
    private final boolean logAllExceptions;
    private final ForkJoinPool myForkJoinPool;

    @VisibleForTesting
    public JobLauncherImpl(@NotNull ForkJoinPool pool) {
        if (pool == null) {
            JobLauncherImpl.$$$reportNull$$$0(0);
        }
        this.logAllExceptions = System.getProperty("idea.job.launcher.log.all.exceptions", "false").equals("true");
        this.myForkJoinPool = pool;
    }

    JobLauncherImpl() {
        this(ForkJoinPool.commonPool());
    }

    public <T> boolean invokeConcurrentlyUnderProgress(@NotNull List<? extends T> things, ProgressIndicator progress, boolean runInReadAction, boolean failFastOnAcquireReadAction, @NotNull Processor<? super T> thingProcessor) throws ProcessCanceledException {
        if (things == null) {
            JobLauncherImpl.$$$reportNull$$$0(1);
        }
        if (thingProcessor == null) {
            JobLauncherImpl.$$$reportNull$$$0(2);
        }
        return JobLauncherImpl.invokeConcurrentlyUnderProgressAsync(things, progress, runInReadAction, failFastOnAcquireReadAction, thingProcessor, () -> {});
    }

    private static <T> boolean invokeConcurrentlyUnderProgressAsync(@NotNull List<? extends T> things, ProgressIndicator progress, boolean runInReadAction, boolean failFastOnAcquireReadAction, @NotNull Processor<? super T> thingProcessor, @NotNull Runnable runWhileForking) {
        StandardProgressIndicatorBase wrapper;
        Boolean result;
        if (things == null) {
            JobLauncherImpl.$$$reportNull$$$0(3);
        }
        if (thingProcessor == null) {
            JobLauncherImpl.$$$reportNull$$$0(4);
        }
        if (runWhileForking == null) {
            JobLauncherImpl.$$$reportNull$$$0(5);
        }
        if ((result = JobLauncherImpl.processImmediatelyIfTooFew(things, (ProgressIndicator)(wrapper = progress == null ? new StandardProgressIndicatorBase() : new SensitiveProgressWrapper(progress)), runInReadAction, thingProcessor)) != null) {
            runWhileForking.run();
            return result;
        }
        ProgressManager pm = ProgressManager.getInstance();
        Processor processor = ((CoreProgressManager)pm).isCurrentThreadPrioritized() ? t -> (Boolean)pm.computePrioritized(() -> thingProcessor.process(t)) : thingProcessor;
        processor = FileBasedIndex.getInstance().inheritCurrentDumbAccessType(processor);
        List failedSubTasks = Collections.synchronizedList(new ArrayList());
        int availableParallelism = JobSchedulerImpl.getJobPoolParallelism();
        int chunk = Math.max(1, things.size() / availableParallelism);
        ApplierCompleter[] globalCompleters = new ApplierCompleter[things.size() / chunk];
        int hi = things.size();
        boolean[] processed = new boolean[things.size()];
        AtomicReference<Throwable> thrown = new AtomicReference<Throwable>();
        for (int n = globalCompleters.length - 1; n >= 0; --n) {
            ApplierCompleter<? extends T> completer;
            int lo = n == 0 ? 0 : hi - chunk;
            globalCompleters[n] = completer = new ApplierCompleter<T>(globalCompleters, n, thrown, runInReadAction, failFastOnAcquireReadAction, (ProgressIndicator)wrapper, things, processed, lo, hi, failedSubTasks, processor);
            hi -= chunk;
        }
        for (ApplierCompleter completer : globalCompleters) {
            completer.fork();
        }
        try {
            runWhileForking.run();
            ThreadContext.resetThreadContext(() -> JobLauncherImpl.lambda$invokeConcurrentlyUnderProgressAsync$5(globalCompleters, thrown, (ProgressIndicator)wrapper));
            JobLauncherImpl.safeIterate(globalCompleters, thrown, arg_0 -> JobLauncherImpl.lambda$invokeConcurrentlyUnderProgressAsync$7((ProgressIndicator)wrapper, thrown, arg_0));
            if (thrown.get() != null) {
                throw thrown.get();
            }
        }
        catch (ApplierCompleter.ComputationAbortedException e) {
            return false;
        }
        catch (ApplicationUtil.CannotRunReadActionException e) {
            throw e;
        }
        catch (ProcessCanceledException e) {
            if (progress != null) {
                progress.checkCanceled();
            }
            ProgressManager.checkCanceled();
            Throwable savedException = (Throwable)thrown.get();
            if (savedException != null) {
                ApplierCompleter.rethrowUncheckedRaw(savedException);
            }
            return false;
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        return ApplierCompleter.completeTaskWhichFailToAcquireReadAction(failedSubTasks);
    }

    private static <T> void safeIterate(ApplierCompleter<T> @NotNull [] globalCompleters, @NotNull AtomicReference<Throwable> thrown, @NotNull ThrowableConsumer<? super ApplierCompleter<T>, Throwable> consumer) throws ProcessCanceledException {
        if (thrown == null) {
            JobLauncherImpl.$$$reportNull$$$0(6);
        }
        if (consumer == null) {
            JobLauncherImpl.$$$reportNull$$$0(7);
        }
        if (globalCompleters == null) {
            JobLauncherImpl.$$$reportNull$$$0(8);
        }
        for (ApplierCompleter<T> completer : globalCompleters) {
            try {
                consumer.consume(completer);
            }
            catch (ProcessCanceledException e) {
                if (thrown.get() instanceof ApplierCompleter.ComputationAbortedException) continue;
                throw e;
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof ApplierCompleter.ComputationAbortedException) {
                    thrown.set(cause);
                    continue;
                }
                cause = ApplierCompleter.accumulateException(thrown, cause);
                ApplierCompleter.rethrowUncheckedRaw(cause);
            }
            catch (ApplierCompleter.ComputationAbortedException e) {
                thrown.set(e);
            }
            catch (Throwable e) {
                e = ApplierCompleter.accumulateException(thrown, e);
                ApplierCompleter.rethrowUncheckedRaw(e);
            }
        }
    }

    private static <T> Boolean processImmediatelyIfTooFew(@NotNull List<? extends T> things, @NotNull ProgressIndicator progress, boolean runInReadAction, @NotNull Processor<? super T> thingProcessor) {
        if (things == null) {
            JobLauncherImpl.$$$reportNull$$$0(9);
        }
        if (progress == null) {
            JobLauncherImpl.$$$reportNull$$$0(10);
        }
        if (thingProcessor == null) {
            JobLauncherImpl.$$$reportNull$$$0(11);
        }
        if (things.isEmpty()) {
            return true;
        }
        if (things.size() == 1 || JobSchedulerImpl.getJobPoolParallelism() <= 1 || runInReadAction && ApplicationManager.getApplication().isWriteAccessAllowed()) {
            AtomicBoolean result = new AtomicBoolean(true);
            Runnable runnable = () -> ProgressManager.getInstance().executeProcessUnderProgress(() -> {
                for (int i = 0; i < things.size(); ++i) {
                    Object thing = things.get(i);
                    if (thingProcessor.process(thing)) continue;
                    result.set(false);
                    break;
                }
            }, progress);
            if (runInReadAction) {
                ApplicationManager.getApplication().runReadAction(runnable);
            } else {
                runnable.run();
            }
            return result.get();
        }
        return null;
    }

    @NotNull
    public Job submitToJobThread(@NotNull Runnable action, @Nullable Consumer<? super Future<?>> onDoneCallback) {
        if (action == null) {
            JobLauncherImpl.$$$reportNull$$$0(12);
        }
        VoidForkJoinTask task = new VoidForkJoinTask(action, this.myForkJoinPool, onDoneCallback);
        task.submit();
        VoidForkJoinTask voidForkJoinTask = task;
        if (voidForkJoinTask == null) {
            JobLauncherImpl.$$$reportNull$$$0(13);
        }
        return voidForkJoinTask;
    }

    @ApiStatus.Internal
    public <T> boolean processQueue(final @NotNull @NotNull BlockingQueue<@NotNull T> things, final @NotNull @NotNull Queue<@NotNull T> failedToProcess, final @NotNull ProgressIndicator progress, final @NotNull T tombStone, final @NotNull Processor<? super T> thingProcessor) throws ProcessCanceledException {
        final class MyProcessQueueTask
        implements Callable<Boolean> {
            private final int mySeq;
            private final T myFirstTask;
            private final CoroutineContext myContext = ThreadContext.currentThreadContext();

            private MyProcessQueueTask(@Nullable int seq, T firstTask) {
                this.mySeq = seq;
                this.myFirstTask = firstTask;
            }

            @Override
            public Boolean call() {
                boolean[] result = new boolean[1];
                ProgressManager.getInstance().executeProcessUnderProgress(() -> {
                    try {
                        Object element = this.myFirstTask;
                        while (true) {
                            block10: {
                                if (element == null) {
                                    element = failedToProcess.poll();
                                }
                                if (element == null) {
                                    element = things.take();
                                }
                                if (element == tombStone) {
                                    things.put(tombStone);
                                    result[0] = true;
                                    break;
                                }
                                try {
                                    Object finalElement = element;
                                    boolean shouldBreak = (Boolean)ThreadContext.installThreadContext((CoroutineContext)this.myContext, (boolean)true, () -> {
                                        ProgressManager.checkCanceled();
                                        if (!thingProcessor.process(finalElement)) {
                                            return true;
                                        }
                                        return false;
                                    });
                                    if (!shouldBreak) break block10;
                                    break;
                                }
                                catch (Error | RuntimeException e) {
                                    if (logAllExceptions) {
                                        LOG.info("Failed to process " + String.valueOf(element) + ". Add too failed query.", e);
                                    }
                                    failedToProcess.add(element);
                                    throw e;
                                }
                            }
                            element = null;
                        }
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }, progress);
                return result[0];
            }

            @NonNls
            public String toString() {
                return super.toString() + " seq=" + this.mySeq;
            }
        }
        if (things == null) {
            JobLauncherImpl.$$$reportNull$$$0(14);
        }
        if (failedToProcess == null) {
            JobLauncherImpl.$$$reportNull$$$0(15);
        }
        if (progress == null) {
            JobLauncherImpl.$$$reportNull$$$0(16);
        }
        if (tombStone == null) {
            JobLauncherImpl.$$$reportNull$$$0(17);
        }
        if (thingProcessor == null) {
            JobLauncherImpl.$$$reportNull$$$0(18);
        }
        progress.checkCanceled();
        int size = things.size();
        boolean isQueueBounded = things.contains(tombStone);
        int n = Math.max(1, Math.min(isQueueBounded ? size - 1 : Integer.MAX_VALUE, JobSchedulerImpl.getJobPoolParallelism() - 1));
        ArrayList<Future> tasks = new ArrayList<Future>(n - 1);
        ArrayList firstElements = new ArrayList(n);
        things.drainTo(firstElements, n);
        if (ContainerUtil.getLastItem(firstElements) == tombStone) {
            firstElements.remove(firstElements.size() - 1);
            try {
                things.put(tombStone);
            }
            catch (InterruptedException e) {
                LOG.error((Throwable)e);
            }
        }
        for (int i = 1; i < n; ++i) {
            tasks.add(this.myForkJoinPool.submit((Callable)new MyProcessQueueTask(i, i < firstElements.size() ? firstElements.get(i) : null)));
        }
        MyProcessQueueTask firstTask = new MyProcessQueueTask(0, ContainerUtil.getFirstItem(firstElements));
        boolean result = false;
        Throwable exception = null;
        try {
            result = firstTask.call();
        }
        catch (Throwable e) {
            exception = e;
        }
        for (ForkJoinTask forkJoinTask : tasks) {
            try {
                result &= ((Boolean)forkJoinTask.join()).booleanValue();
            }
            catch (Throwable e) {
                exception = e;
            }
        }
        if (exception != null) {
            ApplierCompleter.rethrowUncheckedRaw(exception);
        }
        return result;
    }

    @ApiStatus.Internal
    public <T> boolean processConcurrentlyAsync(@NotNull ProgressIndicator progress, @NotNull List<? extends T> items, @NotNull Processor<? super T> thingProcessor, @NotNull Runnable runnable) throws ProcessCanceledException {
        if (progress == null) {
            JobLauncherImpl.$$$reportNull$$$0(19);
        }
        if (items == null) {
            JobLauncherImpl.$$$reportNull$$$0(20);
        }
        if (thingProcessor == null) {
            JobLauncherImpl.$$$reportNull$$$0(21);
        }
        if (runnable == null) {
            JobLauncherImpl.$$$reportNull$$$0(22);
        }
        return JobLauncherImpl.invokeConcurrentlyUnderProgressAsync(items, progress, true, true, thingProcessor, runnable);
    }

    private static /* synthetic */ void lambda$invokeConcurrentlyUnderProgressAsync$7(ProgressIndicator wrapper, AtomicReference thrown, ApplierCompleter completer) throws Throwable {
        while (true) {
            try {
                if (wrapper.isCanceled() && !(thrown.get() instanceof ApplierCompleter.ComputationAbortedException)) {
                    wrapper.checkCanceled();
                }
                if (completer.isDone()) {
                    completer.get();
                } else {
                    Ref throwableRef = new Ref(null);
                    ThreadContext.resetThreadContext(() -> {
                        try {
                            completer.get(1L, TimeUnit.MILLISECONDS);
                        }
                        catch (Throwable e) {
                            throwableRef.set((Object)e);
                        }
                        return null;
                    });
                    Throwable throwable = (Throwable)throwableRef.get();
                    if (throwable != null) {
                        throw throwable;
                    }
                }
            }
            catch (TimeoutException timeoutException) {
                continue;
            }
            break;
        }
    }

    private static /* synthetic */ Object lambda$invokeConcurrentlyUnderProgressAsync$5(ApplierCompleter[] globalCompleters, AtomicReference thrown, ProgressIndicator wrapper) {
        JobLauncherImpl.safeIterate(globalCompleters, thrown, completer -> {
            wrapper.checkCanceled();
            completer.wrapAndRun(() -> completer.execAll());
        });
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pool";
                break;
            }
            case 1: 
            case 3: 
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "things";
                break;
            }
            case 2: 
            case 4: 
            case 11: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thingProcessor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runWhileForking";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thrown";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalCompleters";
                break;
            }
            case 10: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/concurrency/JobLauncherImpl";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "failedToProcess";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tombStone";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/concurrency/JobLauncherImpl";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "submitToJobThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invokeConcurrentlyUnderProgress";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invokeConcurrentlyUnderProgressAsync";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "safeIterate";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processImmediatelyIfTooFew";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "submitToJobThread";
                break;
            }
            case 13: {
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "processQueue";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "processConcurrentlyAsync";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 13 -> new IllegalStateException(string);
        };
    }

    private static final class VoidForkJoinTask
    implements Job {
        private final Runnable myAction;
        private final ForkJoinPool myForkJoinPool;
        private final Consumer<? super Future<?>> myOnDoneCallback;
        private volatile Status myStatus;
        private final ForkJoinTask<Void> myForkJoinTask;

        private VoidForkJoinTask(@NotNull Runnable action, @NotNull ForkJoinPool forkJoinPool, @Nullable Consumer<? super Future<?>> onDoneCallback) {
            if (action == null) {
                VoidForkJoinTask.$$$reportNull$$$0(0);
            }
            if (forkJoinPool == null) {
                VoidForkJoinTask.$$$reportNull$$$0(1);
            }
            this.myForkJoinTask = new ForkJoinTask<Void>(){

                @Override
                public Void getRawResult() {
                    return null;
                }

                @Override
                protected void setRawResult(Void value) {
                }

                @Override
                protected boolean exec() {
                    myStatus = Status.STARTED;
                    try {
                        myAction.run();
                        this.complete(null);
                    }
                    catch (Throwable throwable) {
                        myStatus = Status.EXECUTED;
                        this.completeExceptionally(throwable);
                    }
                    finally {
                        myStatus = Status.EXECUTED;
                        if (myOnDoneCallback != null) {
                            myOnDoneCallback.accept(this);
                        }
                    }
                    return true;
                }
            };
            this.myAction = action;
            this.myForkJoinPool = forkJoinPool;
            this.myOnDoneCallback = onDoneCallback;
        }

        private void submit() {
            this.myForkJoinPool.execute(this.myForkJoinTask);
        }

        public boolean isDone() {
            boolean wasCancelled = this.myForkJoinTask.isCancelled();
            Status status = this.myStatus;
            return status == Status.EXECUTED || status == null && wasCancelled;
        }

        public boolean isCanceled() {
            return this.myForkJoinTask.isCancelled();
        }

        public void cancel() {
            this.myForkJoinTask.cancel(true);
        }

        public boolean waitForCompletion(int millis) throws InterruptedException {
            if (millis <= 0) {
                return this.isDone();
            }
            long deadline = System.currentTimeMillis() + (long)millis;
            while (!this.isDone()) {
                long toWait = deadline - System.currentTimeMillis();
                if (toWait < 0L) {
                    return false;
                }
                ThreadContext.resetThreadContext(() -> {
                    this.myForkJoinPool.awaitQuiescence(Math.min(toWait, 10L), TimeUnit.MILLISECONDS);
                    return null;
                });
            }
            if (this.myForkJoinTask.isDone()) {
                try {
                    this.myForkJoinTask.get();
                }
                catch (CancellationException toWait) {
                }
                catch (ExecutionException e) {
                    ApplierCompleter.rethrowUncheckedRaw((Throwable)ObjectUtils.notNull((Object)e.getCause(), (Object)e));
                }
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "action";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "forkJoinPool";
                    break;
                }
            }
            objectArray[1] = "com/intellij/concurrency/JobLauncherImpl$VoidForkJoinTask";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static enum Status {
            STARTED,
            EXECUTED;

        }
    }
}

