/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginEnabler;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import java.nio.file.FileVisitResult;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0001\u00a2\u0006\u0002\b\u000bJ\u0016\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0003\u00a8\u0006\u0011"}, d2={"Lcom/intellij/diagnostic/DisablePluginsDialog;", "", "<init>", "()V", "confirmDisablePlugins", "", "project", "Lcom/intellij/openapi/project/Project;", "pluginsToDisable", "", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "confirmDisablePlugins$intellij_platform_ide_impl", "morePluginsAffected", "", "pluginIdsToDisable", "", "Lcom/intellij/openapi/extensions/PluginId;", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nDisablePluginsDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DisablePluginsDialog.kt\ncom/intellij/diagnostic/DisablePluginsDialog\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,90:1\n1634#2,3:91\n*S KotlinDebug\n*F\n+ 1 DisablePluginsDialog.kt\ncom/intellij/diagnostic/DisablePluginsDialog\n*L\n22#1:91,3\n*E\n"})
public final class DisablePluginsDialog {
    @NotNull
    public static final DisablePluginsDialog INSTANCE = new DisablePluginsDialog();

    private DisablePluginsDialog() {
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void confirmDisablePlugins$intellij_platform_ide_impl(@Nullable Project project2, @NotNull List<? extends IdeaPluginDescriptor> pluginsToDisable) {
        Pair pair;
        String string;
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter(pluginsToDisable, (String)"pluginsToDisable");
        if (pluginsToDisable.isEmpty()) {
            return;
        }
        Iterable iterable = pluginsToDisable;
        Collection destination$iv = new HashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void obj;
            IdeaPluginDescriptor ideaPluginDescriptor = (IdeaPluginDescriptor)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add(obj.getPluginId());
        }
        HashSet pluginIdsToDisable = (HashSet)destination$iv;
        boolean hasDependents = DisablePluginsDialog.morePluginsAffected(pluginIdsToDisable);
        boolean canRestart = ApplicationManager.getApplication().isRestartCapable();
        if (pluginsToDisable.size() == 1) {
            Object item$iv;
            IdeaPluginDescriptor plugin = pluginsToDisable.iterator().next();
            item$iv = new Object[]{plugin.getName()};
            string = DiagnosticBundle.message("error.dialog.disable.prompt", item$iv) + "<br/>" + DiagnosticBundle.message(hasDependents ? "error.dialog.disable.prompt.deps" : "error.dialog.disable.prompt.lone", new Object[0]);
        } else {
            string = DiagnosticBundle.message("error.dialog.disable.prompt.multiple", new Object[0]) + "<br/>" + DiagnosticBundle.message(hasDependents ? "error.dialog.disable.prompt.deps.multiple" : "error.dialog.disable.prompt.lone.multiple", new Object[0]);
        }
        String message = "<html>" + string + "<br/><br/>" + DiagnosticBundle.message(canRestart ? "error.dialog.disable.plugin.can.restart" : "error.dialog.disable.plugin.no.restart", new Object[0]) + "</html>";
        String string2 = DiagnosticBundle.message("error.dialog.disable.plugin.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        String title2 = string2;
        String string3 = DiagnosticBundle.message("error.dialog.disable.plugin.action.disable", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        String disable = string3;
        String string4 = IdeBundle.message((String)"button.cancel", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        String cancel2 = string4;
        if (canRestart) {
            String string5 = DiagnosticBundle.message("error.dialog.disable.plugin.action.disableAndRestart", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
            String restart = string5;
            int result2 = Messages.showYesNoCancelDialog((Project)project2, (String)message, (String)title2, (String)disable, (String)restart, (String)cancel2, (Icon)Messages.getQuestionIcon());
            pair = TuplesKt.to((Object)(result2 == 0 || result2 == 1 ? 1 : 0), (Object)(result2 == 1 ? 1 : 0));
        } else {
            int result3 = Messages.showYesNoDialog((Project)project2, (String)message, (String)title2, (String)disable, (String)cancel2, (Icon)Messages.getQuestionIcon());
            pair = TuplesKt.to((Object)(result3 == 0 ? 1 : 0), (Object)false);
        }
        Pair pair2 = pair;
        boolean doDisable = (Boolean)pair2.component1();
        boolean doRestart2 = (Boolean)pair2.component2();
        if (doDisable) {
            PluginEnabler.HEADLESS.disable((Collection)pluginsToDisable);
            if (doRestart2) {
                ApplicationManagerEx.getApplicationEx().restart(true);
            }
        }
    }

    @JvmStatic
    private static final boolean morePluginsAffected(Set<PluginId> pluginIdsToDisable) {
        Map pluginIdMap = PluginManagerCore.INSTANCE.buildPluginIdMap();
        Map contentModuleIdMap = PluginManagerCore.getPluginSet().buildContentModuleIdMap();
        for (IdeaPluginDescriptor rootDescriptor : PluginManagerCore.getPlugins()) {
            if (!rootDescriptor.isEnabled() || pluginIdsToDisable.contains(rootDescriptor.getPluginId())) continue;
            Intrinsics.checkNotNull((Object)rootDescriptor, (String)"null cannot be cast to non-null type com.intellij.ide.plugins.IdeaPluginDescriptorImpl");
            if (PluginManagerCore.INSTANCE.processAllNonOptionalDependencies((IdeaPluginDescriptorImpl)rootDescriptor, pluginIdMap, contentModuleIdMap, arg_0 -> DisablePluginsDialog.morePluginsAffected$lambda$0(pluginIdsToDisable, arg_0))) continue;
            return true;
        }
        return false;
    }

    private static final FileVisitResult morePluginsAffected$lambda$0(Set $pluginIdsToDisable, IdeaPluginDescriptorImpl descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return descriptor.isEnabled() ? ($pluginIdsToDisable.contains(descriptor.getPluginId()) ? FileVisitResult.TERMINATE : FileVisitResult.CONTINUE) : FileVisitResult.SKIP_SUBTREE;
    }
}

