/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.impl.EditorHyperlinkSupport;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Expirable;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.Promise;

final class AsyncFilterRunner {
    private static final Logger LOG = Logger.getInstance(AsyncFilterRunner.class);
    private static final ExecutorService ourExecutor = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"Console Filters");
    private final EditorHyperlinkSupport myHyperlinks;
    private final Editor myEditor;
    private final Queue<HighlighterJob> myQueue;
    @NotNull
    private List<FilterResult> myResults;
    private final boolean myTrackDocumentChangesManually;

    AsyncFilterRunner(@NotNull EditorHyperlinkSupport hyperlinks, @NotNull Editor editor2, boolean trackDocumentChangesManually) {
        if (hyperlinks == null) {
            AsyncFilterRunner.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            AsyncFilterRunner.$$$reportNull$$$0(1);
        }
        this.myQueue = new ConcurrentLinkedQueue<HighlighterJob>();
        this.myResults = new ArrayList<FilterResult>();
        this.myHyperlinks = hyperlinks;
        this.myEditor = editor2;
        this.myTrackDocumentChangesManually = trackDocumentChangesManually;
        if (trackDocumentChangesManually) {
            this.trackDocumentChanges(editor2.getDocument());
        }
    }

    private void trackDocumentChanges(@NotNull Document document2) {
        if (document2 == null) {
            AsyncFilterRunner.$$$reportNull$$$0(2);
        }
        document2.addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                block4: {
                    block3: {
                        if (event == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (event.getOffset() != 0 || event.getNewLength() != 0) break block3;
                        if (event.getOldLength() <= 0) break block4;
                        for (DeltaTracker deltaTracker : AsyncFilterRunner.this.collectActiveDeltaTrackers()) {
                            deltaTracker.onDeletedFromDocumentTop(event.getOldLength());
                        }
                        break block4;
                    }
                    for (DeltaTracker deltaTracker : AsyncFilterRunner.this.collectActiveDeltaTrackers()) {
                        deltaTracker.stopAt(event.getOffset());
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/execution/impl/AsyncFilterRunner$1", "documentChanged"));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private Set<DeltaTracker> collectActiveDeltaTrackers() {
        List pendingResultTrackers;
        Queue<HighlighterJob> queue = this.myQueue;
        synchronized (queue) {
            pendingResultTrackers = ContainerUtil.map(this.myResults, result2 -> result2.myDelta);
        }
        HashSet<DeltaTracker> trackers = new HashSet<DeltaTracker>(pendingResultTrackers);
        for (HighlighterJob runningJob : this.myQueue) {
            trackers.add(runningJob.delta);
        }
        HashSet<DeltaTracker> hashSet = trackers;
        if (hashSet == null) {
            AsyncFilterRunner.$$$reportNull$$$0(3);
        }
        return hashSet;
    }

    void highlightHyperlinks(@NotNull Project project2, @NotNull Filter customFilter, int startLine, int endLine, @NotNull Expirable token) {
        if (project2 == null) {
            AsyncFilterRunner.$$$reportNull$$$0(4);
        }
        if (customFilter == null) {
            AsyncFilterRunner.$$$reportNull$$$0(5);
        }
        if (token == null) {
            AsyncFilterRunner.$$$reportNull$$$0(6);
        }
        if (endLine < 0) {
            return;
        }
        Document document2 = this.myEditor.getDocument();
        long startStamp = document2.getModificationStamp();
        if (this.myTrackDocumentChangesManually) {
            for (DeltaTracker deltaTracker : this.collectActiveDeltaTrackers()) {
                deltaTracker.stopAt(document2.getLineStartOffset(startLine));
            }
        }
        this.myQueue.offer(new HighlighterJob(project2, customFilter, startLine, endLine, document2, token));
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            this.runTasks();
            this.highlightAvailableResults();
            return;
        }
        CancellablePromise promise = ReadAction.nonBlocking(this::runTasks).expireWhen(() -> document2.getModificationStamp() != startStamp).submit((Executor)ourExecutor);
        if (AsyncFilterRunner.isQuick(promise)) {
            this.highlightAvailableResults();
        } else {
            promise.onSuccess(__ -> {
                if (this.hasResults()) {
                    ApplicationManager.getApplication().invokeLater(this::highlightAvailableResults, ModalityState.any());
                }
            });
        }
    }

    private static boolean isQuick(Promise<?> future) {
        try {
            future.blockingGet(5, TimeUnit.MILLISECONDS);
            return true;
        }
        catch (TimeoutException ignored) {
            return false;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void highlightAvailableResults() {
        for (FilterResult result2 : this.takeAvailableResults()) {
            result2.applyHighlights();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasResults() {
        Queue<HighlighterJob> queue = this.myQueue;
        synchronized (queue) {
            return !this.myResults.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private List<FilterResult> takeAvailableResults() {
        Queue<HighlighterJob> queue = this.myQueue;
        // MONITORENTER : queue
        List<FilterResult> results = this.myResults;
        this.myResults = new ArrayList<FilterResult>();
        List<FilterResult> list2 = results;
        // MONITOREXIT : queue
        if (list2 != null) return list2;
        AsyncFilterRunner.$$$reportNull$$$0(7);
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLineResult(@Nullable FilterResult result2) {
        if (result2 == null) {
            return;
        }
        Queue<HighlighterJob> queue = this.myQueue;
        synchronized (queue) {
            this.myResults.add(result2);
        }
    }

    @TestOnly
    void waitForPendingFilters(long timeoutMs) {
        ThreadingAssertions.assertEventDispatchThread();
        long started = System.currentTimeMillis();
        while (true) {
            if (this.myQueue.isEmpty()) {
                this.highlightAvailableResults();
                return;
            }
            if (this.hasResults()) {
                this.highlightAvailableResults();
                continue;
            }
            if (System.currentTimeMillis() - started > timeoutMs) {
                return;
            }
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                UIUtil.dispatchAllInvocationEvents();
            }
            TimeoutUtil.sleep((long)1L);
        }
    }

    private void runTasks() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (this.myEditor.isDisposed()) {
            return;
        }
        while (!this.myQueue.isEmpty()) {
            HighlighterJob highlighter = this.myQueue.peek();
            if (!DumbService.getInstance((Project)highlighter.myProject).isUsableInCurrentContext((Object)highlighter.filter)) {
                return;
            }
            while (highlighter.hasUnprocessedLines()) {
                ProgressManager.checkCanceled();
                this.addLineResult(highlighter.analyzeNextLine());
            }
            LOG.assertTrue(highlighter == this.myQueue.remove());
        }
    }

    static Filter.Result checkRange(Filter filter2, int endOffset, Filter.Result result2) {
        if (result2 != null) {
            for (Filter.ResultItem resultItem : result2.getResultItems()) {
                int start2 = resultItem.getHighlightStartOffset();
                int end = resultItem.getHighlightEndOffset();
                if (end >= start2 && end <= endOffset) continue;
                LOG.error("Filter returned wrong range: start=" + start2 + "; end=" + end + "; max=" + endOffset + "; filter=" + String.valueOf(filter2));
            }
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hyperlinks";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/impl/AsyncFilterRunner";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customFilter";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "token";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/impl/AsyncFilterRunner";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "collectActiveDeltaTrackers";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "takeAvailableResults";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "trackDocumentChanges";
                break;
            }
            case 3: 
            case 7: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "highlightHyperlinks";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 7 -> new IllegalStateException(string);
        };
    }

    private final class HighlighterJob {
        @NotNull
        private final Project myProject;
        private final AtomicInteger startLine;
        private final int endLine;
        private final DeltaTracker delta;
        @NotNull
        private final Filter filter;
        @NotNull
        private final Document snapshot;

        HighlighterJob(@NotNull Project project2, Filter filter2, int startLine, @NotNull int endLine, @NotNull Document document2, Expirable expirableToken) {
            if (project2 == null) {
                HighlighterJob.$$$reportNull$$$0(0);
            }
            if (filter2 == null) {
                HighlighterJob.$$$reportNull$$$0(1);
            }
            if (document2 == null) {
                HighlighterJob.$$$reportNull$$$0(2);
            }
            if (expirableToken == null) {
                HighlighterJob.$$$reportNull$$$0(3);
            }
            this.myProject = project2;
            this.startLine = new AtomicInteger(startLine);
            this.endLine = endLine;
            this.filter = filter2;
            this.delta = new DeltaTracker(AsyncFilterRunner.this, document2, document2.getLineEndOffset(endLine), expirableToken);
            this.snapshot = ((DocumentImpl)document2).freeze();
        }

        boolean hasUnprocessedLines() {
            return !this.delta.isOutdated() && this.startLine.get() <= this.endLine;
        }

        @Nullable
        private FilterResult analyzeNextLine() {
            int line = this.startLine.get();
            Filter.Result result2 = this.analyzeLine(line);
            LOG.assertTrue(line == this.startLine.getAndIncrement());
            return result2 == null ? null : new FilterResult(this.delta, result2);
        }

        @Nullable
        private Filter.Result analyzeLine(int line) {
            int lineEndOffset;
            int lineStartOffset = this.snapshot.getLineStartOffset(line);
            if (!this.delta.isSnapshotRangeValid(lineStartOffset, lineEndOffset = this.snapshot.getLineEndOffset(line))) {
                return null;
            }
            String lineText = EditorHyperlinkSupport.getLineText(this.snapshot, line, true);
            int endOffset = lineStartOffset + lineText.length();
            return AsyncFilterRunner.checkRange(this.filter, endOffset, this.filter.applyFilter(lineText, endOffset));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "filter";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "document";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "expirableToken";
                    break;
                }
            }
            objectArray[1] = "com/intellij/execution/impl/AsyncFilterRunner$HighlighterJob";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class DeltaTracker {
        private final AsyncFilterRunner myRunner;
        private final int initialMarkerOffset;
        private final RangeMarker endMarker;
        @NotNull
        private final Expirable myExpirableToken;
        private final AtomicInteger myDeletedLengthFromDocumentTop;
        private final AtomicInteger myStopOffset;

        DeltaTracker(@NotNull AsyncFilterRunner runner2, @NotNull Document document2, int offset, @NotNull Expirable token) {
            if (runner2 == null) {
                DeltaTracker.$$$reportNull$$$0(0);
            }
            if (document2 == null) {
                DeltaTracker.$$$reportNull$$$0(1);
            }
            if (token == null) {
                DeltaTracker.$$$reportNull$$$0(2);
            }
            this.myDeletedLengthFromDocumentTop = new AtomicInteger(0);
            this.myRunner = runner2;
            this.myExpirableToken = token;
            this.initialMarkerOffset = offset;
            this.endMarker = document2.createRangeMarker(this.initialMarkerOffset, this.initialMarkerOffset);
            this.myStopOffset = new AtomicInteger(offset);
        }

        boolean isOutdated() {
            return !this.endMarker.isValid() || this.endMarker.getEndOffset() == 0 || this.myExpirableToken.isExpired();
        }

        int getOffsetDelta() {
            if (this.myRunner.myTrackDocumentChangesManually) {
                return -this.myDeletedLengthFromDocumentTop.get();
            }
            return this.endMarker.getStartOffset() - this.initialMarkerOffset;
        }

        void onDeletedFromDocumentTop(int deletedLengthFromDocumentTop) {
            this.myDeletedLengthFromDocumentTop.addAndGet(deletedLengthFromDocumentTop);
        }

        void stopAt(int offset) {
            int snapshotOffset = offset + this.myDeletedLengthFromDocumentTop.get();
            this.myStopOffset.set(Math.min(this.myStopOffset.get(), snapshotOffset));
        }

        boolean isSnapshotRangeValid(int startOffset, int endOffset) {
            if (startOffset + this.getOffsetDelta() < 0) {
                return false;
            }
            return !this.myRunner.myTrackDocumentChangesManually || endOffset <= this.myStopOffset.get();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "runner";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "document";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "token";
                    break;
                }
            }
            objectArray[1] = "com/intellij/execution/impl/AsyncFilterRunner$DeltaTracker";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class FilterResult {
        private final DeltaTracker myDelta;
        private final Filter.Result myResult;

        FilterResult(DeltaTracker delta, Filter.Result result2) {
            this.myDelta = delta;
            this.myResult = result2;
        }

        void applyHighlights() {
            if (!this.myDelta.isOutdated()) {
                AsyncFilterRunner.this.myHyperlinks.highlightHyperlinks(this.myResult, item -> {
                    int endOffset;
                    int startOffset = item.getHighlightStartOffset();
                    if (this.myDelta.isSnapshotRangeValid(startOffset, endOffset = item.getHighlightEndOffset())) {
                        int offsetDelta = this.myDelta.getOffsetDelta();
                        return new TextRange(startOffset + offsetDelta, endOffset + offsetDelta);
                    }
                    return null;
                });
            }
        }
    }
}

