/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.wsl;

import com.google.common.net.InetAddresses;
import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialPromptDialog;
import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.LocalPtyOptions;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.wsl.AbstractWslDistribution;
import com.intellij.execution.wsl.AbstractWslDistributionKt;
import com.intellij.execution.wsl.WSLCommandLineOptions;
import com.intellij.execution.wsl.WSLUtil;
import com.intellij.execution.wsl.WslDistributionDescriptor;
import com.intellij.execution.wsl.WslDistributionSafeNullableLazyValue;
import com.intellij.execution.wsl.WslExecution;
import com.intellij.execution.wsl.WslIjentAvailabilityService;
import com.intellij.execution.wsl.WslIjentManager;
import com.intellij.execution.wsl.WslIjentUtil;
import com.intellij.execution.wsl.WslPath;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Functions;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

public class WSLDistribution
implements AbstractWslDistribution {
    public static final String DEFAULT_WSL_MNT_ROOT = "/mnt/";
    private static final String DEFAULT_WSL_IP = "127.0.0.1";
    private static final int RESOLVE_SYMLINK_TIMEOUT = 10000;
    private static final String RUN_PARAMETER = "run";
    @ApiStatus.Internal
    public static final String DEFAULT_SHELL = "/bin/sh";
    static final int DEFAULT_TIMEOUT = SystemProperties.getIntProperty((String)"ide.wsl.probe.timeout", (int)20000);
    private static final String SHELL_PARAMETER = "$SHELL";
    public static final String WSL_EXE = "wsl.exe";
    public static final String DISTRIBUTION_PARAMETER = "--distribution";
    public static final String EXIT_CODE_PARAMETER = "; exitcode=$?";
    public static final String EXEC_PARAMETER = "--exec";
    private static final Key<ProcessListener> SUDO_LISTENER_KEY = Key.create((String)"WSL sudo listener");
    private static final Key<Boolean> NEVER_RUN_TTY_FIX = Key.create((String)"Never run ttyfix");
    @ApiStatus.Internal
    public static final Pattern ENV_VARIABLE_NAME_PATTERN = Pattern.compile("[a-zA-Z_][a-zA-Z0-9_]*");
    @NotNull
    private final WslDistributionDescriptor myDescriptor;
    @Nullable
    private final Path myExecutablePath;
    @Nullable
    private Integer myVersion;
    private final WslDistributionSafeNullableLazyValue<String> myLazyWslIp;
    private final WslDistributionSafeNullableLazyValue<String> myLazyShellPath;
    private final WslDistributionSafeNullableLazyValue<String> myLazyUserHome;
    @Nullable
    private static Path testOverriddenWslExe;
    private static final AtomicBoolean isAttemptToFindWslExeLogged;
    @VisibleForTesting
    @Nullable
    protected String testOverriddenShellPath;

    protected WSLDistribution(@NotNull WSLDistribution dist) {
        if (dist == null) {
            WSLDistribution.$$$reportNull$$$0(0);
        }
        this(dist.myDescriptor, dist.myExecutablePath);
        this.myVersion = dist.myVersion;
    }

    WSLDistribution(@NotNull WslDistributionDescriptor descriptor, @Nullable Path executablePath) {
        if (descriptor == null) {
            WSLDistribution.$$$reportNull$$$0(1);
        }
        this.myLazyWslIp = WslDistributionSafeNullableLazyValue.create(() -> {
            try {
                return this.readWslIp();
            }
            catch (ExecutionException ex) {
                WSLUtil.LOG.warn("Can't read WSL IP, will use default: 127.0.0.1", (Throwable)ex);
                return DEFAULT_WSL_IP;
            }
        });
        this.myLazyShellPath = WslDistributionSafeNullableLazyValue.create(this::readShellPath);
        this.myLazyUserHome = WslDistributionSafeNullableLazyValue.create(this::readUserHome);
        this.myDescriptor = descriptor;
        this.myExecutablePath = executablePath;
    }

    public WSLDistribution(@NotNull String msId) {
        if (msId == null) {
            WSLDistribution.$$$reportNull$$$0(2);
        }
        this(new WslDistributionDescriptor(msId), null);
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public Path getExecutablePath() {
        return this.myExecutablePath;
    }

    @Nullable
    @NlsSafe
    public String readReleaseInfo() {
        try {
            String key = "PRETTY_NAME";
            String releaseInfo = "/etc/os-release";
            ProcessOutput output = this.executeOnWsl(10000, "cat", "/etc/os-release");
            if (WSLUtil.LOG.isDebugEnabled()) {
                WSLUtil.LOG.debug("Reading release info: " + this.getId());
            }
            if (!output.checkSuccess(WSLUtil.LOG)) {
                return null;
            }
            for (String line : output.getStdoutLines(true)) {
                if (!line.startsWith("PRETTY_NAME") || line.length() < "PRETTY_NAME".length() + 1) continue;
                String prettyName = line.substring("PRETTY_NAME".length() + 1);
                return StringUtil.nullize((String)StringUtil.unquoteString((String)prettyName));
            }
        }
        catch (ExecutionException e) {
            WSLUtil.LOG.warn((Throwable)e);
        }
        return null;
    }

    void setVersion(@Nullable Integer version) {
        this.myVersion = version;
    }

    public int getVersion() {
        if (this.myVersion == null) {
            this.myVersion = WSLUtil.getWslVersion(this);
        }
        return this.myVersion;
    }

    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    public ProcessOutput executeOnWsl(@NotNull List<String> command, @NotNull WSLCommandLineOptions options2, int timeout, @Nullable Consumer<? super ProcessHandler> processHandlerConsumer) throws ExecutionException {
        ProcessOutput output;
        if (command == null) {
            WSLDistribution.$$$reportNull$$$0(3);
        }
        if (options2 == null) {
            WSLDistribution.$$$reportNull$$$0(4);
        }
        GeneralCommandLine commandLine = this.patchCommandLine(new GeneralCommandLine(command), null, options2);
        CapturingProcessHandler processHandler = new CapturingProcessHandler(commandLine);
        if (processHandlerConsumer != null) {
            processHandlerConsumer.consume((Object)processHandler);
        }
        if ((output = processHandler.runProcess(timeout)).getExitCode() != 0 || output.isTimeout() || output.isCancelled()) {
            WSLUtil.LOG.info("command on wsl: " + commandLine.getCommandLineString() + " was failed:ec=" + output.getExitCode() + ",timeout=" + output.isTimeout() + ",cancelled=" + output.isCancelled() + ",stderr=" + output.getStderr() + ",stdout=" + output.getStdout());
        }
        ProcessOutput processOutput = output;
        if (processOutput == null) {
            WSLDistribution.$$$reportNull$$$0(5);
        }
        return processOutput;
    }

    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    public ProcessOutput executeOnWsl(int timeout, String ... command) throws ExecutionException {
        if (command == null) {
            WSLDistribution.$$$reportNull$$$0(6);
        }
        ProcessOutput processOutput = this.executeOnWsl(Arrays.asList(command), new WSLCommandLineOptions(), timeout, null);
        if (processOutput == null) {
            WSLDistribution.$$$reportNull$$$0(7);
        }
        return processOutput;
    }

    @Deprecated
    @ApiStatus.Internal
    @NotNull
    public <T extends GeneralCommandLine> T patchCommandLine(@NotNull T commandLine, @Nullable Project project2, @Nullable String remoteWorkingDir, boolean askForSudo) {
        T t;
        if (commandLine == null) {
            WSLDistribution.$$$reportNull$$$0(8);
        }
        WSLCommandLineOptions options2 = new WSLCommandLineOptions().setRemoteWorkingDirectory(remoteWorkingDir).setSudo(askForSudo);
        try {
            t = this.patchCommandLine(commandLine, project2, options2);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException("Cannot patch command line for WSL", e);
        }
        if (t == null) {
            WSLDistribution.$$$reportNull$$$0(9);
        }
        return t;
    }

    @NotNull
    public <T extends GeneralCommandLine> T patchCommandLine(@NotNull T commandLine, @Nullable Project project2, @NotNull WSLCommandLineOptions options2) throws ExecutionException {
        if (commandLine == null) {
            WSLDistribution.$$$reportNull$$$0(10);
        }
        if (options2 == null) {
            WSLDistribution.$$$reportNull$$$0(11);
        }
        if (WSLDistribution.mustRunCommandLineWithIjent(options2)) {
            LocalPtyOptions ptyOptions;
            if (commandLine instanceof PtyCommandLine) {
                PtyCommandLine ptyCommandLine = (PtyCommandLine)commandLine;
                ptyOptions = ptyCommandLine.getPtyOptions();
            } else {
                ptyOptions = null;
            }
            commandLine.setProcessCreator(processBuilder -> (Process)ProgressManager.getInstance().runProcess(() -> WslIjentUtil.runProcessBlocking(WslIjentManager.getInstance(), project2, this, processBuilder, options2, ptyOptions), (ProgressIndicator)new EmptyProgressIndicator()));
        } else {
            this.doPatchCommandLine(commandLine, project2, options2);
        }
        T t = commandLine;
        if (t == null) {
            WSLDistribution.$$$reportNull$$$0(12);
        }
        return t;
    }

    @VisibleForTesting
    public static boolean mustRunCommandLineWithIjent(@NotNull WSLCommandLineOptions options2) {
        if (options2 == null) {
            WSLDistribution.$$$reportNull$$$0(13);
        }
        return WslIjentManager.getInstance().isIjentAvailable() && !options2.isLaunchWithWslExe();
    }

    @ApiStatus.Internal
    @NotNull
    public final <T extends GeneralCommandLine> T doPatchCommandLine(final @NotNull T commandLine, final @Nullable Project project2, @NotNull WSLCommandLineOptions options2) throws ExecutionException {
        Path wslExe;
        if (commandLine == null) {
            WSLDistribution.$$$reportNull$$$0(14);
        }
        if (options2 == null) {
            WSLDistribution.$$$reportNull$$$0(15);
        }
        this.logCommandLineBefore(commandLine, options2);
        Path executable = this.getExecutablePath();
        boolean launchWithWslExe = options2.isLaunchWithWslExe() || executable == null;
        Path path = wslExe = launchWithWslExe ? WSLDistribution.findWslExe() : null;
        if (wslExe == null && executable == null) {
            throw new ExecutionException(IdeBundle.message((String)"wsl.not.installed.dialog.message", (Object[])new Object[0]));
        }
        boolean executeCommandInShell = wslExe == null || options2.isExecuteCommandInShell();
        List<String> linuxCommand = WSLDistribution.buildLinuxCommand(commandLine, executeCommandInShell);
        boolean isElevated = options2.isSudo();
        if (isElevated && wslExe == null) {
            WSLDistribution.prependCommand(linuxCommand, "sudo", "-S", "-p", "''");
            SUDO_LISTENER_KEY.set(commandLine, (Object)new ProcessListener(){

                public void startNotified(@NotNull ProcessEvent event) {
                    OutputStream input;
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((input = event.getProcessHandler().getProcessInput()) == null) {
                        return;
                    }
                    String password = CredentialPromptDialog.askPassword(project2, IdeBundle.message((String)"wsl.enter.root.password.dialog.title", (Object[])new Object[0]), IdeBundle.message((String)"wsl.sudo.password.for.root.label", (Object[])new Object[]{WSLDistribution.this.getPresentableName()}), new CredentialAttributes("WSL", "root"), true);
                    if (password != null) {
                        try (PrintWriter pw = new PrintWriter(input, false, commandLine.getCharset());){
                            pw.println(password);
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/execution/wsl/WSLDistribution$1", "startNotified"));
                }
            });
        }
        if (executeCommandInShell && StringUtil.isNotEmpty((String)options2.getRemoteWorkingDirectory())) {
            WSLDistribution.prependCommand(linuxCommand, "cd", CommandLineUtil.posixQuote((String)options2.getRemoteWorkingDirectory()), "&&");
        }
        if (executeCommandInShell && !options2.isPassEnvVarsUsingInterop()) {
            Comparator comparator = Map.Entry.comparingByKey().reversed();
            commandLine.getEnvironment().entrySet().stream().sorted(comparator).forEach(entry -> {
                String key = (String)entry.getKey();
                String val = (String)entry.getValue();
                if (ENV_VARIABLE_NAME_PATTERN.matcher(key).matches()) {
                    WSLDistribution.prependCommand(linuxCommand, "export", key + "=" + CommandLineUtil.posixQuote((String)val), "&&");
                } else {
                    WSLUtil.LOG.debug("Can not pass environment variable (bad name): '", new Object[]{key, "'"});
                }
            });
            commandLine.getEnvironment().clear();
        } else {
            WSLDistribution.passEnvironmentUsingInterop(commandLine);
        }
        if (executeCommandInShell) {
            for (String command : options2.getInitShellCommands()) {
                WSLDistribution.prependCommand(linuxCommand, command, "&&");
            }
        }
        commandLine.getParametersList().clearAll();
        Object linuxCommandStr = StringUtil.join(linuxCommand, (String)" ");
        if (wslExe != null) {
            commandLine.setExePath(wslExe.toString());
            commandLine.addParameters(new String[]{DISTRIBUTION_PARAMETER, this.getMsId()});
            if (isElevated) {
                commandLine.addParameters(new String[]{"-u", "root"});
            }
            if (options2.isExecuteCommandInShell()) {
                if (options2.getSleepTimeoutSec() > 0.0 && this.getVersion() == 1) {
                    linuxCommandStr = (String)linuxCommandStr + "; exitcode=$?; sleep " + options2.getSleepTimeoutSec() + "; (exit $exitcode)";
                }
                if (options2.isExecuteCommandInDefaultShell()) {
                    this.fixTTYSize(commandLine);
                    commandLine.addParameters(new String[]{SHELL_PARAMETER, "-c", linuxCommandStr});
                } else {
                    commandLine.addParameter(EXEC_PARAMETER);
                    this.fixTTYSize(commandLine);
                    commandLine.addParameter(this.getShellPath());
                    if (options2.isExecuteCommandInInteractiveShell()) {
                        commandLine.addParameters(new String[]{"-i"});
                    }
                    if (options2.isExecuteCommandInLoginShell()) {
                        commandLine.addParameters(new String[]{"-l"});
                    }
                    commandLine.addParameters(new String[]{"-c", linuxCommandStr});
                }
            } else {
                commandLine.addParameter(EXEC_PARAMETER);
                commandLine.addParameters(linuxCommand);
            }
        } else {
            commandLine.setExePath(executable.toString());
            commandLine.addParameter(this.getRunCommandLineParameter());
            commandLine.addParameter((String)linuxCommandStr);
        }
        if (Registry.is((String)"wsl.use.utf8.encoding", (boolean)true)) {
            commandLine.setCharset(StandardCharsets.UTF_8);
        }
        this.logCommandLineAfter(commandLine);
        T t = commandLine;
        if (t == null) {
            WSLDistribution.$$$reportNull$$$0(16);
        }
        return t;
    }

    @NotNull
    public static GeneralCommandLine neverRunTTYFix(@NotNull GeneralCommandLine commandLine) {
        if (commandLine == null) {
            WSLDistribution.$$$reportNull$$$0(17);
        }
        commandLine.putUserData(NEVER_RUN_TTY_FIX, (Object)true);
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            WSLDistribution.$$$reportNull$$$0(18);
        }
        return generalCommandLine;
    }

    private void fixTTYSize(@NotNull GeneralCommandLine cmd) {
        if (cmd == null) {
            WSLDistribution.$$$reportNull$$$0(19);
        }
        if (!WslDistributionDescriptor.isCalculatingMountRootCommand(cmd) && cmd.getUserData(NEVER_RUN_TTY_FIX) == null && !(cmd instanceof PtyCommandLine) && Registry.is((String)"wsl.fix.initial.tty.size.when.running.without.tty", (boolean)true)) {
            String ttyfix = AbstractWslDistributionKt.getToolLinuxPath((AbstractWslDistribution)this, (String)"ttyfix");
            cmd.addParameter(ttyfix);
        }
    }

    private void logCommandLineBefore(@NotNull GeneralCommandLine commandLine, @NotNull WSLCommandLineOptions options2) {
        if (commandLine == null) {
            WSLDistribution.$$$reportNull$$$0(20);
        }
        if (options2 == null) {
            WSLDistribution.$$$reportNull$$$0(21);
        }
        if (WSLUtil.LOG.isTraceEnabled()) {
            WSLUtil.LOG.trace("[" + this.getId() + "] Patching: " + commandLine.getCommandLineString() + "; options: " + String.valueOf(options2) + "; envs: " + String.valueOf(commandLine.getEnvironment()));
        }
    }

    private void logCommandLineAfter(@NotNull GeneralCommandLine commandLine) {
        if (commandLine == null) {
            WSLDistribution.$$$reportNull$$$0(22);
        }
        if (WSLUtil.LOG.isDebugEnabled()) {
            WSLUtil.LOG.debug("[" + this.getId() + "] Patched as: " + String.valueOf(commandLine.getCommandLineList(null)));
        }
    }

    @TestOnly
    public static void testOverriddenWslExe(@NotNull Path path, @NotNull Disposable disposable) {
        if (path == null) {
            WSLDistribution.$$$reportNull$$$0(23);
        }
        if (disposable == null) {
            WSLDistribution.$$$reportNull$$$0(24);
        }
        Disposer.register((Disposable)disposable, () -> {
            testOverriddenWslExe = null;
        });
        testOverriddenWslExe = path;
    }

    @Nullable
    public static Path findWslExe() {
        if (testOverriddenWslExe != null) {
            return testOverriddenWslExe;
        }
        File file2 = PathEnvironmentVariableUtil.findInPath((String)WSL_EXE);
        if (WSLUtil.LOG.isTraceEnabled() && isAttemptToFindWslExeLogged.compareAndSet(false, true)) {
            WSLUtil.LOG.trace(new Throwable("findWslExe called"));
        }
        return file2 != null ? file2.toPath() : null;
    }

    @NotNull
    private static List<String> buildLinuxCommand(@NotNull GeneralCommandLine commandLine, boolean executeCommandInShell) {
        if (commandLine == null) {
            WSLDistribution.$$$reportNull$$$0(25);
        }
        List command = ContainerUtil.concat(List.of(commandLine.getExePath()), (List)commandLine.getParametersList().getList());
        return new ArrayList<String>(ContainerUtil.map((Collection)command, (com.intellij.util.Function)(executeCommandInShell ? CommandLineUtil::posixQuote : Functions.identity())));
    }

    private static void passEnvironmentUsingInterop(@NotNull GeneralCommandLine commandLine) {
        if (commandLine == null) {
            WSLDistribution.$$$reportNull$$$0(26);
        }
        StringBuilder builder = new StringBuilder();
        commandLine.getEnvironment().keySet().stream().sorted().forEach(envName -> {
            if (StringUtil.isNotEmpty((String)envName)) {
                if (!builder.isEmpty()) {
                    builder.append(":");
                }
                builder.append((String)envName).append("/u");
            }
        });
        if (!builder.isEmpty()) {
            String prevValue = (String)commandLine.getEnvironment().get("WSLENV");
            if (prevValue == null) {
                prevValue = (String)commandLine.getParentEnvironment().get("WSLENV");
            }
            String value = prevValue != null ? StringUtil.trimEnd((String)prevValue, (char)':') + ":" + String.valueOf(builder) : builder.toString();
            commandLine.getEnvironment().put("WSLENV", value);
        }
    }

    @NotNull
    @NlsSafe
    protected String getRunCommandLineParameter() {
        return RUN_PARAMETER;
    }

    @NotNull
    @NlsSafe
    public String resolveSymlink(@NotNull String path, int timeoutInMilliseconds) {
        block5: {
            String string;
            if (path == null) {
                WSLDistribution.$$$reportNull$$$0(27);
            }
            try {
                ProcessOutput output = this.executeOnWsl(timeoutInMilliseconds, "readlink", "-f", path);
                if (output.getExitCode() != 0) break block5;
                String stdout = output.getStdout().trim();
                if (output.getExitCode() != 0 || !StringUtil.isNotEmpty((String)stdout)) break block5;
                string = stdout;
            }
            catch (ExecutionException e) {
                WSLUtil.LOG.debug("Error while resolving symlink: " + path, (Throwable)e);
            }
            if (string == null) {
                WSLDistribution.$$$reportNull$$$0(28);
            }
            return string;
        }
        String string = path;
        if (string == null) {
            WSLDistribution.$$$reportNull$$$0(29);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public String resolveSymlink(@NotNull String path) {
        if (path == null) {
            WSLDistribution.$$$reportNull$$$0(30);
        }
        String string = this.resolveSymlink(path, 10000);
        if (string == null) {
            WSLDistribution.$$$reportNull$$$0(31);
        }
        return string;
    }

    @NotNull
    public <T extends ProcessHandler> T patchProcessHandler(@NotNull GeneralCommandLine commandLine, @NotNull T processHandler) {
        ProcessListener listener2;
        if (commandLine == null) {
            WSLDistribution.$$$reportNull$$$0(32);
        }
        if (processHandler == null) {
            WSLDistribution.$$$reportNull$$$0(33);
        }
        if ((listener2 = (ProcessListener)SUDO_LISTENER_KEY.get((UserDataHolder)commandLine)) != null) {
            processHandler.addProcessListener(listener2);
            SUDO_LISTENER_KEY.set((UserDataHolder)commandLine, null);
        }
        T t = processHandler;
        if (t == null) {
            WSLDistribution.$$$reportNull$$$0(34);
        }
        return t;
    }

    @Nullable
    public Map<String, String> getEnvironment() {
        if (WslIjentManager.getInstance().isIjentAvailable()) {
            return WslIjentUtil.fetchLoginShellEnv(WslIjentManager.getInstance(), this, null, false);
        }
        try {
            ProcessOutput processOutput = WslExecution.executeInShellAndGetCommandOnlyStdout(this, new GeneralCommandLine(new String[]{"env"}), new WSLCommandLineOptions().setExecuteCommandInShell(true).setExecuteCommandInLoginShell(true).setExecuteCommandInInteractiveShell(true), DEFAULT_TIMEOUT);
            if (processOutput.getExitCode() == 0) {
                HashMap<String, String> result2 = new HashMap<String, String>();
                for (String string : processOutput.getStdoutLines()) {
                    int assignIndex = string.indexOf(61);
                    if (assignIndex == -1) {
                        result2.put(string, "");
                        continue;
                    }
                    result2.put(string.substring(0, assignIndex), string.substring(assignIndex + 1));
                }
                return result2;
            }
        }
        catch (ExecutionException e) {
            WSLUtil.LOG.warn((Throwable)e);
        }
        return null;
    }

    @NotNull
    @NlsSafe
    public String getWindowsPath(@NotNull String wslPath) {
        if (wslPath == null) {
            WSLDistribution.$$$reportNull$$$0(35);
        }
        String string = this.getWindowsPath(wslPath, this::getMntRoot);
        if (string == null) {
            WSLDistribution.$$$reportNull$$$0(36);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public String getWindowsPath(@NotNull String wslPath, @NotNull Supplier<String> mntRootSupplier) {
        String windowsPath;
        if (wslPath == null) {
            WSLDistribution.$$$reportNull$$$0(37);
        }
        if (mntRootSupplier == null) {
            WSLDistribution.$$$reportNull$$$0(38);
        }
        if (WSLDistribution.containsDriveLetter(wslPath) && (windowsPath = WSLUtil.getWindowsPath(wslPath, mntRootSupplier.get())) != null) {
            String string = windowsPath;
            if (string == null) {
                WSLDistribution.$$$reportNull$$$0(39);
            }
            return string;
        }
        String string = this.getUNCRootPathString() + FileUtil.toSystemDependentName((String)FileUtil.normalize((String)wslPath));
        if (string == null) {
            WSLDistribution.$$$reportNull$$$0(40);
        }
        return string;
    }

    private static boolean containsDriveLetter(@NotNull String linuxPath) {
        if (linuxPath == null) {
            WSLDistribution.$$$reportNull$$$0(41);
        }
        int slashInd = linuxPath.indexOf(47);
        while (slashInd >= 0) {
            int nextSlashInd = linuxPath.indexOf(47, slashInd + 1);
            if ((nextSlashInd == slashInd + 2 || nextSlashInd == -1 && slashInd + 2 == linuxPath.length()) && OSAgnosticPathUtil.isDriveLetter((char)linuxPath.charAt(slashInd + 1))) {
                return true;
            }
            slashInd = nextSlashInd;
        }
        return false;
    }

    @Deprecated
    @Nullable
    public final String getWslPath(@NotNull @NlsSafe String windowsPath) {
        if (windowsPath == null) {
            WSLDistribution.$$$reportNull$$$0(42);
        }
        try {
            return this.getWslPath(Path.of(windowsPath, new String[0]));
        }
        catch (InvalidPathException e) {
            WSLUtil.LOG.warn("Failed to convert '" + windowsPath + "' to wsl path", (Throwable)e);
            return null;
        }
    }

    @Nullable
    @NlsSafe
    public String getWslPath(@NotNull Path windowsPath) {
        WslPath wslPath;
        if (windowsPath == null) {
            WSLDistribution.$$$reportNull$$$0(43);
        }
        if ((wslPath = WslPath.parseWindowsUncPath(windowsPath.toString())) != null) {
            if (wslPath.getDistributionId().equalsIgnoreCase(this.myDescriptor.getMsId())) {
                return wslPath.getLinuxPath();
            }
            throw new IllegalArgumentException("Trying to get WSL path from a different WSL distribution. Requested path (" + String.valueOf(windowsPath) + ") belongs to " + wslPath.getDistributionId() + " distribution, but context distribution is " + this.myDescriptor.getMsId());
        }
        if (OSAgnosticPathUtil.isAbsoluteDosPath((String)windowsPath.toString())) {
            return this.getMntRoot() + WSLDistribution.convertWindowsPath(windowsPath.toString());
        }
        return null;
    }

    @NotNull
    @NlsSafe
    public final String getMntRoot() {
        String string = this.myDescriptor.getMntRoot();
        if (string == null) {
            WSLDistribution.$$$reportNull$$$0(44);
        }
        return string;
    }

    @Nullable
    @NlsSafe
    public final String getUserHome() {
        return this.getValueWithLogging(this.myLazyUserHome, "user's home path");
    }

    @NlsSafe
    @Nullable
    private String readUserHome() {
        return this.getEnvironmentVariable("HOME");
    }

    @NotNull
    @NlsSafe
    static String convertWindowsPath(@NotNull String windowsAbsolutePath) {
        if (windowsAbsolutePath == null) {
            WSLDistribution.$$$reportNull$$$0(45);
        }
        String string = Character.toLowerCase(windowsAbsolutePath.charAt(0)) + FileUtil.toSystemIndependentName((String)windowsAbsolutePath.substring(2));
        if (string == null) {
            WSLDistribution.$$$reportNull$$$0(46);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public String getId() {
        String string = this.myDescriptor.getId();
        if (string == null) {
            WSLDistribution.$$$reportNull$$$0(47);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public String getMsId() {
        String string = this.myDescriptor.getMsId();
        if (string == null) {
            WSLDistribution.$$$reportNull$$$0(48);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public String getPresentableName() {
        String string = this.myDescriptor.getPresentableName();
        if (string == null) {
            WSLDistribution.$$$reportNull$$$0(49);
        }
        return string;
    }

    public String toString() {
        return this.myDescriptor.getMsId();
    }

    private static void prependCommand(@NotNull List<? super String> command, String ... commandToPrepend) {
        if (command == null) {
            WSLDistribution.$$$reportNull$$$0(50);
        }
        if (commandToPrepend == null) {
            WSLDistribution.$$$reportNull$$$0(51);
        }
        command.addAll(0, Arrays.asList(commandToPrepend));
    }

    public boolean equals(Object o) {
        return this == o || o != null && this.getClass() == o.getClass() && this.getMsId().equals(((WSLDistribution)o).getMsId());
    }

    public int hashCode() {
        return Strings.stringHashCodeInsensitive((CharSequence)this.getMsId());
    }

    @ApiStatus.Experimental
    @NotNull
    public Path getUNCRootPath() {
        Path path = Path.of(this.getUNCRootPathString(), new String[0]);
        if (path == null) {
            WSLDistribution.$$$reportNull$$$0(52);
        }
        return path;
    }

    @NotNull
    private String getUNCRootPathString() {
        String string = WSLUtil.getUncPrefix() + this.myDescriptor.getMsId();
        if (string == null) {
            WSLDistribution.$$$reportNull$$$0(53);
        }
        return string;
    }

    @NotNull
    public final InetAddress getWslIpAddress() {
        if (Registry.is((String)"wsl.proxy.connect.localhost")) {
            InetAddress inetAddress = InetAddresses.forString((String)DEFAULT_WSL_IP);
            if (inetAddress == null) {
                WSLDistribution.$$$reportNull$$$0(54);
            }
            return inetAddress;
        }
        InetAddress inetAddress = InetAddresses.forString((String)((String)ObjectUtils.coalesce((Object)this.getValueWithLogging(this.myLazyWslIp, "WSL IP"), (Object)DEFAULT_WSL_IP)));
        if (inetAddress == null) {
            WSLDistribution.$$$reportNull$$$0(55);
        }
        return inetAddress;
    }

    @NotNull
    private String readWslIp() throws ExecutionException {
        String wsl1LoopbackAddress = this.getWsl1LoopbackAddress();
        if (wsl1LoopbackAddress != null) {
            String string = wsl1LoopbackAddress;
            if (string == null) {
                WSLDistribution.$$$reportNull$$$0(56);
            }
            return string;
        }
        return this.executeAndParseOutput(IdeBundle.message((String)"wsl.wsl.ip", (Object[])new Object[0]), strings -> {
            for (String line : strings) {
                int index;
                String trimmed = line.trim();
                if (!trimmed.startsWith("inet ") || (index = trimmed.indexOf("/")) == -1) continue;
                return trimmed.substring("inet ".length(), index);
            }
            return null;
        }, "ip", "addr", "show", "eth0");
    }

    @NotNull
    private String executeAndParseOutput(@NlsContexts.DialogMessage @NotNull String ipType, @NotNull Function<List<@NlsSafe String>, @Nullable String> parser, String ... command) throws ExecutionException {
        if (ipType == null) {
            WSLDistribution.$$$reportNull$$$0(57);
        }
        if (parser == null) {
            WSLDistribution.$$$reportNull$$$0(58);
        }
        if (command == null) {
            WSLDistribution.$$$reportNull$$$0(59);
        }
        ProcessOutput output = this.executeOnWsl(Arrays.asList(command), new WSLCommandLineOptions(), 10000, null);
        if (WSLUtil.LOG.isDebugEnabled()) {
            WSLUtil.LOG.debug(ipType + " " + this.getId());
        }
        if (!output.checkSuccess(WSLUtil.LOG)) {
            WSLUtil.LOG.warn(String.format("%s. Exit code: %s. Error %s", ipType, output.getExitCode(), output.getStderr()));
            throw new ExecutionException(IdeBundle.message((String)"wsl.cant.parse.ip.no.output", (Object[])new Object[]{ipType}));
        }
        List stdout = output.getStdoutLines(true);
        String ip = parser.apply(stdout);
        if (ip != null) {
            String string = ip;
            if (string == null) {
                WSLDistribution.$$$reportNull$$$0(60);
            }
            return string;
        }
        WSLUtil.LOG.warn(String.format("Can't parse data for %s, stdout is %s", ipType, String.join((CharSequence)"\n", stdout)));
        throw new ExecutionException(IdeBundle.message((String)"wsl.cant.parse.ip.process.failed", (Object[])new Object[]{ipType}));
    }

    @Nullable
    private String getWsl1LoopbackAddress() {
        return this.getVersion() == 1 ? InetAddress.getLoopbackAddress().getHostAddress() : null;
    }

    @ApiStatus.Internal
    @RequiresBackgroundThread(generateAssertion=false)
    @NonNls
    @Nullable
    public final String getEnvironmentVariable(@NotNull String name2) {
        if (name2 == null) {
            WSLDistribution.$$$reportNull$$$0(61);
        }
        if (WslIjentAvailabilityService.getInstance().runWslCommandsViaIjent()) {
            Map<String, String> map2 = WslIjentUtil.fetchLoginShellEnv(WslIjentManager.getInstance(), this, null, false);
            return map2.get(name2);
        }
        WSLCommandLineOptions options2 = new WSLCommandLineOptions().setExecuteCommandInInteractiveShell(true).setExecuteCommandInLoginShell(true);
        return WslExecution.executeInShellAndGetCommandOnlyStdout(this, new GeneralCommandLine(new String[]{"printenv", name2}), options2.setLaunchWithWslExe(true), DEFAULT_TIMEOUT, true);
    }

    @NlsSafe
    @NotNull
    public String getShellPath() {
        String string = (String)ObjectUtils.coalesce((Object)this.getValueWithLogging(this.myLazyShellPath, "user's shell path"), (Object)DEFAULT_SHELL);
        if (string == null) {
            WSLDistribution.$$$reportNull$$$0(62);
        }
        return string;
    }

    @NlsSafe
    @Nullable
    private String readShellPath() {
        if (this.testOverriddenShellPath != null) {
            return this.testOverriddenShellPath;
        }
        WSLCommandLineOptions options2 = new WSLCommandLineOptions().setExecuteCommandInDefaultShell(true).setLaunchWithWslExe(true);
        return WslExecution.executeInShellAndGetCommandOnlyStdout(this, new GeneralCommandLine(new String[]{"printenv", "SHELL"}), options2, DEFAULT_TIMEOUT, true);
    }

    @Nullable
    private <T> T getValueWithLogging(@NotNull WslDistributionSafeNullableLazyValue<T> lazyValue, @NotNull String fieldName) {
        T value;
        if (lazyValue == null) {
            WSLDistribution.$$$reportNull$$$0(63);
        }
        if (fieldName == null) {
            WSLDistribution.$$$reportNull$$$0(64);
        }
        if ((value = lazyValue.getValue()) == null) {
            Application app = ApplicationManager.getApplication();
            if (WSLUtil.LOG.isDebugEnabled()) {
                WSLUtil.LOG.debug("Lazy value for %s returned null: MsId=%s, EDT=%s, RA=%s, stackTrace=%s".formatted(fieldName, this.getMsId(), app.isDispatchThread(), app.isReadAccessAllowed(), ExceptionUtil.currentStackTrace()));
            } else {
                WSLUtil.LOG.warn("Lazy value for %s returned null: MsId=%s, EDT=%s, RA=%s".formatted(fieldName, this.getMsId(), app.isDispatchThread(), app.isReadAccessAllowed()));
            }
        }
        return value;
    }

    static {
        isAttemptToFindWslExeLogged = new AtomicBoolean(false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 7, 9, 12, 16, 18, 28, 29, 31, 34, 36, 39, 40, 44, 46, 47, 48, 49, 52, 53, 54, 55, 56, 60, 62 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dist";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "msId";
                break;
            }
            case 3: 
            case 6: 
            case 50: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 4: 
            case 11: 
            case 13: 
            case 15: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 16: 
            case 18: 
            case 28: 
            case 29: 
            case 31: 
            case 34: 
            case 36: 
            case 39: 
            case 40: 
            case 44: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 60: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/wsl/WSLDistribution";
                break;
            }
            case 8: 
            case 10: 
            case 14: 
            case 17: 
            case 20: 
            case 22: 
            case 25: 
            case 26: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmd";
                break;
            }
            case 23: 
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wslPath";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mntRootSupplier";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linuxPath";
                break;
            }
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "windowsPath";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "windowsAbsolutePath";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandToPrepend";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ipType";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parser";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lazyValue";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/wsl/WSLDistribution";
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "executeOnWsl";
                break;
            }
            case 9: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "patchCommandLine";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "doPatchCommandLine";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "neverRunTTYFix";
                break;
            }
            case 28: 
            case 29: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveSymlink";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "patchProcessHandler";
                break;
            }
            case 36: 
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getWindowsPath";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getMntRoot";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "convertWindowsPath";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getMsId";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getUNCRootPath";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getUNCRootPathString";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getWslIpAddress";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "readWslIp";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "executeAndParseOutput";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "getShellPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "executeOnWsl";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 16: 
            case 18: 
            case 28: 
            case 29: 
            case 31: 
            case 34: 
            case 36: 
            case 39: 
            case 40: 
            case 44: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 60: 
            case 62: {
                break;
            }
            case 8: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "patchCommandLine";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "mustRunCommandLineWithIjent";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "doPatchCommandLine";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "neverRunTTYFix";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "fixTTYSize";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "logCommandLineBefore";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "logCommandLineAfter";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "testOverriddenWslExe";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "buildLinuxCommand";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "passEnvironmentUsingInterop";
                break;
            }
            case 27: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "resolveSymlink";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "patchProcessHandler";
                break;
            }
            case 35: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getWindowsPath";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "containsDriveLetter";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getWslPath";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "convertWindowsPath";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "prependCommand";
                break;
            }
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "executeAndParseOutput";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getEnvironmentVariable";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "getValueWithLogging";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 7, 9, 12, 16, 18, 28, 29, 31, 34, 36, 39, 40, 44, 46, 47, 48, 49, 52, 53, 54, 55, 56, 60, 62 -> new IllegalStateException(string);
        };
    }
}

