/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.AppIdleMemoryCleanerKt;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.IntEventField;
import com.intellij.internal.statistic.eventLog.events.LongEventField;
import com.intellij.internal.statistic.eventLog.events.PrimitiveEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import java.lang.management.ManagementFactory;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0015\u001a\u00020\u0005H\u0016J=\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b\u001fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/ide/AppIdleMemoryCleanerUsagesCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "<init>", "()V", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "XMX", "Lcom/intellij/internal/statistic/eventLog/events/PrimitiveEventField;", "", "DURATION_SINCE_LAST_CLEANUP", "Lcom/intellij/internal/statistic/eventLog/events/LongEventField;", "GC_DURATION", "Lcom/intellij/internal/statistic/eventLog/events/IntEventField;", "MEM_BEFORE_CLEANUP_MB", "MEM_AFTER_CLEANUP_MB", "TOTAL_CLEANED_MB", "TOTAL_CLEANED_PERCENT", "GC_CLEANED_MB", "DIRECT_BUFFERS_CLEANED_MB", "MEMORY_CLEANUP_PERFORMED", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "getGroup", "memoryCleanupPerformed", "", "durationSinceLastCleanupMs", "", "gcDurationMs", "memBeforeCleanupMb", "memAfterCleanupMb", "gcCleanedMb", "directBuffersCleanedMb", "memoryCleanupPerformed$intellij_platform_ide_impl", "intellij.platform.ide.impl"})
public final class AppIdleMemoryCleanerUsagesCollector
extends CounterUsagesCollector {
    @NotNull
    public static final AppIdleMemoryCleanerUsagesCollector INSTANCE = new AppIdleMemoryCleanerUsagesCollector();
    @NotNull
    private static final EventLogGroup GROUP = new EventLogGroup("ide.idle.memory.cleaner", 1, null, 4, null);
    @NotNull
    private static final PrimitiveEventField<Integer> XMX;
    @NotNull
    private static final LongEventField DURATION_SINCE_LAST_CLEANUP;
    @NotNull
    private static final IntEventField GC_DURATION;
    @NotNull
    private static final IntEventField MEM_BEFORE_CLEANUP_MB;
    @NotNull
    private static final IntEventField MEM_AFTER_CLEANUP_MB;
    @NotNull
    private static final IntEventField TOTAL_CLEANED_MB;
    @NotNull
    private static final IntEventField TOTAL_CLEANED_PERCENT;
    @NotNull
    private static final IntEventField GC_CLEANED_MB;
    @NotNull
    private static final IntEventField DIRECT_BUFFERS_CLEANED_MB;
    @NotNull
    private static final VarargEventId MEMORY_CLEANUP_PERFORMED;

    private AppIdleMemoryCleanerUsagesCollector() {
    }

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    public final void memoryCleanupPerformed$intellij_platform_ide_impl(long durationSinceLastCleanupMs, long gcDurationMs, long memBeforeCleanupMb, long memAfterCleanupMb, long gcCleanedMb, long directBuffersCleanedMb) {
        long xmxMb = AppIdleMemoryCleanerKt.access$toMB(ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getMax());
        long totalCleanedMb = memBeforeCleanupMb - memAfterCleanupMb;
        EventPair[] eventPairArray = new EventPair[]{XMX.with((Object)((int)xmxMb)), DURATION_SINCE_LAST_CLEANUP.with((Object)durationSinceLastCleanupMs), GC_DURATION.with((Object)((int)gcDurationMs)), MEM_BEFORE_CLEANUP_MB.with((Object)((int)memBeforeCleanupMb)), MEM_AFTER_CLEANUP_MB.with((Object)((int)memAfterCleanupMb)), TOTAL_CLEANED_MB.with((Object)((int)totalCleanedMb)), TOTAL_CLEANED_PERCENT.with((Object)((int)(totalCleanedMb * (long)100 / memBeforeCleanupMb))), GC_CLEANED_MB.with((Object)((int)gcCleanedMb)), DIRECT_BUFFERS_CLEANED_MB.with((Object)((int)directBuffersCleanedMb))};
        MEMORY_CLEANUP_PERFORMED.log(eventPairArray);
    }

    static {
        Object[] objectArray = new int[]{512, 768, 1024, 1536, 2048, 4096, 6000, 8192, 12288, 16384};
        XMX = EventFields.BoundedInt((String)"xmx", (int[])objectArray);
        DURATION_SINCE_LAST_CLEANUP = EventFields.Long((String)"duration_since_last_cleanup_ms", (String)"Duration since last event");
        GC_DURATION = EventFields.Int((String)"gc_duration_ms", (String)"Duration of GC invocation");
        MEM_BEFORE_CLEANUP_MB = EventFields.Int((String)"mem_before_cleanup_mb", (String)"OS-provided process memory usage (`RAM + SWAP - FileMappings`) before cleanup");
        MEM_AFTER_CLEANUP_MB = EventFields.Int((String)"mem_after_cleanup_mb", (String)"OS-provided process memory usage (`RAM + SWAP - FileMappings`) after cleanup");
        TOTAL_CLEANED_MB = EventFields.Int((String)"total_cleaned_mb", (String)"mem_before_cleanup_mb - mem_after_cleanup_mb");
        TOTAL_CLEANED_PERCENT = EventFields.Int((String)"total_cleaned_percent", (String)"total_cleaned_mb * 100 / mem_before_cleanup_mb");
        GC_CLEANED_MB = EventFields.Int((String)"gc_cleaned_mb");
        DIRECT_BUFFERS_CLEANED_MB = EventFields.Int((String)"direct_buffers_cleaned_mb");
        objectArray = new EventField[9];
        objectArray[0] = (int)XMX;
        objectArray[1] = (int)DURATION_SINCE_LAST_CLEANUP;
        objectArray[2] = (int)MEM_BEFORE_CLEANUP_MB;
        objectArray[3] = (int)MEM_AFTER_CLEANUP_MB;
        objectArray[4] = (int)GC_DURATION;
        objectArray[5] = (int)TOTAL_CLEANED_MB;
        objectArray[6] = (int)TOTAL_CLEANED_PERCENT;
        objectArray[7] = (int)GC_CLEANED_MB;
        objectArray[8] = (int)DIRECT_BUFFERS_CLEANED_MB;
        MEMORY_CLEANUP_PERFORMED = GROUP.registerVarargEvent("memory.cleanup.performed", (EventField[])objectArray);
    }
}

