/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.DisplayChangeDetector;
import com.intellij.ide.RemoteDesktopService;
import com.intellij.jna.JnaLoader;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfoRt;
import com.sun.jna.platform.win32.User32;

final class RemoteDesktopDetector
extends RemoteDesktopService {
    private volatile boolean myFailureDetected;
    private volatile boolean myRemoteDesktopConnected;

    private RemoteDesktopDetector() {
        if (SystemInfoRt.isWindows && JnaLoader.isLoaded()) {
            DisplayChangeDetector.getInstance().addListener(this::updateState);
            this.updateState();
        }
    }

    private void updateState() {
        if (!this.myFailureDetected) {
            try {
                this.myRemoteDesktopConnected = User32.INSTANCE.GetSystemMetrics(4096) != 0;
                Logger.getInstance(RemoteDesktopDetector.class).debug("Detected remote desktop: ", new Object[]{this.myRemoteDesktopConnected});
            }
            catch (Throwable e) {
                this.myRemoteDesktopConnected = false;
                this.myFailureDetected = true;
                Logger.getInstance(RemoteDesktopDetector.class).warn("Error while calling GetSystemMetrics", e);
            }
        }
    }

    public boolean isRemoteDesktopConnected() {
        return this.myRemoteDesktopConnected;
    }
}

