/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.CloseEditorsActionBase;
import com.intellij.ide.ui.UISettings;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class CloseAllEditorsToTheLeftAction
extends CloseEditorsActionBase {
    @Override
    protected boolean isFileToClose(@NotNull EditorComposite editor2, @NotNull EditorWindow window, @NotNull FileEditorManagerEx fileEditorManager) {
        if (editor2 == null) {
            CloseAllEditorsToTheLeftAction.$$$reportNull$$$0(0);
        }
        if (window == null) {
            CloseAllEditorsToTheLeftAction.$$$reportNull$$$0(1);
        }
        if (fileEditorManager == null) {
            CloseAllEditorsToTheLeftAction.$$$reportNull$$$0(2);
        }
        return false;
    }

    @Override
    protected boolean isFileToCloseInContext(DataContext dataContext2, EditorComposite candidate, EditorWindow window) {
        VirtualFile contextFile = window.getContextFile();
        VirtualFile candidateFile = candidate.getFile();
        if (candidate.isPinned()) {
            return false;
        }
        if (Comparing.equal((Object)candidateFile, (Object)contextFile)) {
            return false;
        }
        for (EditorComposite composite2 : window.getAllComposites()) {
            VirtualFile cursorFile = composite2.getFile();
            if (!Comparing.equal((Object)cursorFile, (Object)contextFile) && !Comparing.equal((Object)cursorFile, (Object)candidateFile)) continue;
            return this.isOKToClose(contextFile, candidateFile, cursorFile);
        }
        return false;
    }

    protected boolean isOKToClose(VirtualFile contextFile, VirtualFile candidateFile, VirtualFile cursorFile) {
        return Comparing.equal((Object)cursorFile, (Object)candidateFile);
    }

    @Override
    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            CloseAllEditorsToTheLeftAction.$$$reportNull$$$0(3);
        }
        super.update(event);
        int tabPlacement = UISettings.getInstance().getEditorTabPlacement();
        if (tabPlacement == 2 || tabPlacement == 4) {
            event.getPresentation().setText(IdeBundle.messagePointer((String)this.getAlternativeTextKey(), (Object[])new Object[0]));
        }
    }

    protected String getAlternativeTextKey() {
        return "action.close.all.editors.above";
    }

    @Override
    protected String getPresentationText(boolean inSplitter) {
        return ActionsBundle.actionText((String)"CloseAllToTheLeft");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditorManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/actions/CloseAllEditorsToTheLeftAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isFileToClose";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

