/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.CloseProjectsActionBase;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.projectImport.ProjectAttachProcessor;
import com.intellij.ui.IdeUICustomization;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0014J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ide/actions/CloseProjectAction;", "Lcom/intellij/ide/actions/CloseProjectsActionBase;", "<init>", "()V", "canClose", "", "project", "Lcom/intellij/openapi/project/Project;", "currentProject", "shouldShow", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "intellij.platform.ide.impl"})
public class CloseProjectAction
extends CloseProjectsActionBase {
    public CloseProjectAction() {
        IdeUICustomization uiCustomization = IdeUICustomization.getInstance();
        this.getTemplatePresentation().setText(uiCustomization.projectMessagePointer("action.close.project.text", new Object[0]));
        this.getTemplatePresentation().setDescription(uiCustomization.projectMessagePointer("action.close.project.description", new Object[0]));
    }

    @Override
    protected boolean canClose(@NotNull Project project2, @NotNull Project currentProject) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)currentProject, (String)"currentProject");
        return project2 == currentProject;
    }

    @Override
    protected boolean shouldShow(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        super.update(e);
        if (ProjectAttachProcessor.Companion.canAttachToProject() && e.getProject() != null) {
            Project project2 = e.getProject();
            Intrinsics.checkNotNull((Object)project2);
            if (ModuleManager.Companion.getInstance(project2).getModules().length > 1) {
                e.getPresentation().setText(IdeBundle.messagePointer((String)"action.close.projects.in.current.window", (Object[])new Object[0]));
                return;
            }
        }
        e.getPresentation().setTextWithMnemonic(this.getTemplatePresentation().getTextWithPossibleMnemonic());
        e.getPresentation().setDescription(this.getTemplatePresentation().getDescription());
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }
}

