/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.DefaultProjectFactory;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.EditorTextField;
import com.intellij.util.ui.IoErrorText;
import java.awt.Component;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import javax.swing.JFrame;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0004\u001a\u0004\u0018\u00010\u0005H$J\b\u0010\u0006\u001a\u00020\u0007H$J\b\u0010\b\u001a\u00020\tH\u0014J\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0014J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ide/actions/EditCustomSettingsAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "file", "Ljava/nio/file/Path;", "template", "", "charset", "Ljava/nio/charset/Charset;", "prepareDocument", "", "document", "Lcom/intellij/openapi/editor/Document;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "openInEditor", "project", "Lcom/intellij/openapi/project/Project;", "openInDialog", "frame", "Ljavax/swing/JFrame;", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public abstract class EditCustomSettingsAction
extends DumbAwareAction {
    @Nullable
    protected abstract Path file();

    @NotNull
    protected abstract String template();

    @NotNull
    protected Charset charset() {
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        return charset;
    }

    protected void prepareDocument(@Nullable Document document2) {
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setEnabled((e.getProject() != null || WelcomeFrame.Companion.getInstance() != null) && this.file() != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Path path = this.file();
        if (path == null) {
            return;
        }
        Path file2 = path;
        Project project2 = e.getProject();
        if (project2 != null) {
            WriteIntentReadAction.run(() -> EditCustomSettingsAction.actionPerformed$lambda$0(this, file2, project2));
        } else {
            JFrame frame = (JFrame)WelcomeFrame.Companion.getInstance();
            if (frame != null) {
                WriteIntentReadAction.run(() -> EditCustomSettingsAction.actionPerformed$lambda$1(this, file2, frame));
            }
        }
    }

    private final void openInEditor(Path file2, Project project2) {
        VirtualFile vFile;
        if (!Files.exists(file2, new LinkOption[0])) {
            try {
                Files.write(file2, (Iterable<? extends CharSequence>)StringsKt.lines((CharSequence)this.template()), this.charset(), new OpenOption[0]);
            }
            catch (IOException e) {
                Logger.getInstance(((Object)((Object)this)).getClass()).warn(((Object)file2).toString(), (Throwable)e);
                Object[] objectArray = new Object[]{file2, IoErrorText.message((Throwable)e)};
                String string = IdeBundle.message((String)"file.write.error.details", (Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                String message = string;
                Messages.showErrorDialog((Project)project2, (String)message, (String)CommonBundle.getErrorTitle());
                return;
            }
        }
        if ((vFile = LocalFileSystem.getInstance().refreshAndFindFileByNioFile(file2)) != null) {
            vFile.refresh(false, false);
            PsiFile psiFile = PsiManager.getInstance((Project)project2).findFile(vFile);
            if (psiFile != null) {
                this.prepareDocument(psiFile.getViewProvider().getDocument());
                PsiNavigationSupport.getInstance().createNavigatable(project2, vFile, psiFile.getTextLength()).navigate(true);
            }
        }
    }

    private final void openInDialog(Path file2, JFrame frame) {
        List<String> list2;
        if (!Files.exists(file2, new LinkOption[0])) {
            list2 = StringsKt.lines((CharSequence)this.template());
        } else {
            List<String> list3;
            try {
                list3 = Files.readAllLines(file2, this.charset());
            }
            catch (IOException e) {
                Logger.getInstance(((Object)((Object)this)).getClass()).warn(((Object)file2).toString(), (Throwable)e);
                Object[] objectArray = new Object[]{file2, IoErrorText.message((Throwable)e)};
                String string = IdeBundle.message((String)"file.read.error.details", (Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                String message = string;
                Messages.showErrorDialog((Component)frame, (String)message, (String)CommonBundle.getErrorTitle());
                return;
            }
            list2 = list3;
        }
        List<String> lines = list2;
        Intrinsics.checkNotNull((Object)lines);
        String text2 = CollectionsKt.joinToString$default((Iterable)lines, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        new DialogWrapper(file2, text2, frame, this){
            private final EditorTextField editor;
            final /* synthetic */ Path $file;
            final /* synthetic */ EditCustomSettingsAction this$0;
            {
                this.$file = $file;
                this.this$0 = $receiver;
                super((Component)$frame, true);
                this.setTitle(FileUtil.getLocationRelativeToUserHome((String)((Object)$file).toString()));
                this.setOKButtonText(IdeBundle.message((String)"button.save", (Object[])new Object[0]));
                Document document2 = EditorFactory.getInstance().createDocument((CharSequence)$text);
                Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"createDocument(...)");
                Document document3 = document2;
                Project defaultProject = DefaultProjectFactory.getInstance().getDefaultProject();
                FileType fileType2 = FileTypeManager.getInstance().getFileTypeByFileName(((Object)$file.getFileName()).toString());
                Intrinsics.checkNotNullExpressionValue((Object)fileType2, (String)"getFileTypeByFileName(...)");
                FileType fileType3 = fileType2;
                this.editor = new EditorTextField(document3, defaultProject, fileType3){

                    protected EditorEx createEditor() {
                        EditorEx editorEx = super.createEditor();
                        Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"createEditor(...)");
                        EditorEx editor2 = editorEx;
                        editor2.getScrollPane().setVerticalScrollBarPolicy(20);
                        editor2.getScrollPane().setHorizontalScrollBarPolicy(30);
                        return editor2;
                    }
                };
                this.init();
            }

            protected EditorTextField createCenterPanel() {
                return this.editor;
            }

            public EditorTextField getPreferredFocusedComponent() {
                return this.editor;
            }

            protected String getDimensionServiceKey() {
                return "ide.config.custom.settings";
            }

            protected void doOKAction() {
                try {
                    String string = this.editor.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    char[] cArray = new char[]{'\n'};
                    Files.write(this.$file, (Iterable<? extends CharSequence>)StringsKt.split$default((CharSequence)string, (char[])cArray, (boolean)false, (int)0, (int)6, null), this.this$0.charset(), new OpenOption[0]);
                    this.close(0);
                }
                catch (IOException e) {
                    Logger.getInstance(((Object)((Object)this)).getClass()).warn(((Object)this.$file).toString(), (Throwable)e);
                    Object[] objectArray = new Object[]{this.$file, IoErrorText.message((Throwable)e)};
                    String string = IdeBundle.message((String)"file.write.error.details", (Object[])objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    String message = string;
                    Messages.showErrorDialog((Component)this.getWindow(), (String)message, (String)CommonBundle.getErrorTitle());
                }
            }
        }.show();
    }

    private static final void actionPerformed$lambda$0(EditCustomSettingsAction this$0, Path $file, Project $project) {
        this$0.openInEditor($file, $project);
    }

    private static final void actionPerformed$lambda$1(EditCustomSettingsAction this$0, Path $file, JFrame $frame) {
        this$0.openInDialog($file, $frame);
    }
}

