/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.ModuleChooserDialog;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.java.JavaResourceRootProperties;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001:\u0002%&B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0013H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u000fH\u0002J \u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020\u001cH\u0002J\u0010\u0010#\u001a\u00020\n2\u0006\u0010$\u001a\u00020\u0015H\u0002R\u0018\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/ide/actions/MoveFileToAnotherModuleAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "sourceRootTypes", "", "Lorg/jetbrains/jps/model/module/JpsModuleSourceRootType;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "findSourceLocation", "Lcom/intellij/ide/actions/MoveFileToAnotherModuleAction$SourceLocation;", "sourceModule", "Lcom/intellij/openapi/module/Module;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "collectPath", "", "root", "isGenerated", "", "sourceFolder", "Lcom/intellij/openapi/roots/SourceFolder;", "findTargetLocation", "Lcom/intellij/ide/actions/MoveFileToAnotherModuleAction$TargetLocation;", "targetModule", "sourceLocation", "moveFile", "project", "Lcom/intellij/openapi/project/Project;", "targetLocation", "bail", "message", "SourceLocation", "TargetLocation", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nMoveFileToAnotherModuleAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MoveFileToAnotherModuleAction.kt\ncom/intellij/ide/actions/MoveFileToAnotherModuleAction\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,220:1\n13805#2:221\n13806#2:226\n13805#2,2:227\n13805#2:229\n13806#2:232\n1869#3:222\n1869#3,2:223\n1870#3:225\n1869#3,2:230\n1869#3,2:233\n*S KotlinDebug\n*F\n+ 1 MoveFileToAnotherModuleAction.kt\ncom/intellij/ide/actions/MoveFileToAnotherModuleAction\n*L\n90#1:221\n90#1:226\n106#1:227,2\n145#1:229\n145#1:232\n91#1:222\n92#1:223,2\n91#1:225\n146#1:230,2\n166#1:233,2\n*E\n"})
final class MoveFileToAnotherModuleAction
extends DumbAwareAction {
    @NotNull
    private final List<JpsModuleSourceRootType<?>> sourceRootTypes;

    public MoveFileToAnotherModuleAction() {
        Object[] objectArray = new JpsModuleSourceRootType[4];
        Intrinsics.checkNotNullExpressionValue((Object)JavaSourceRootType.SOURCE, (String)"SOURCE");
        Intrinsics.checkNotNullExpressionValue((Object)JavaSourceRootType.TEST_SOURCE, (String)"TEST_SOURCE");
        Intrinsics.checkNotNullExpressionValue((Object)JavaResourceRootType.RESOURCE, (String)"RESOURCE");
        Intrinsics.checkNotNullExpressionValue((Object)JavaResourceRootType.TEST_RESOURCE, (String)"TEST_RESOURCE");
        this.sourceRootTypes = CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        VirtualFile file2 = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        e.getPresentation().setEnabled(project2 != null && file2 != null && VirtualFileUtil.isFile((VirtualFile)file2));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        VirtualFile virtualFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (virtualFile == null) {
            return;
        }
        VirtualFile file2 = virtualFile;
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file2, (Project)project3);
        if (module == null) {
            this.bail("Didn't find module for file " + file2.getName());
            return;
        }
        SourceLocation sourceLocation = this.findSourceLocation(module, file2);
        if (sourceLocation == null) {
            this.bail("Didn't detect source root for file " + file2.getName());
            return;
        }
        String string = file2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        ModuleChooserDialog chooserDialog = new ModuleChooserDialog(project3, string);
        if (!chooserDialog.showAndGet()) {
            return;
        }
        Module module2 = chooserDialog.getSelectedModule();
        if (module2 == null) {
            return;
        }
        Module targetModule = module2;
        TargetLocation targetLocation = this.findTargetLocation(targetModule, sourceLocation);
        if (targetLocation == null) {
            this.bail("Couldn't detect target source root in module " + targetModule.getName());
            return;
        }
        try {
            this.moveFile(project3, file2, targetLocation);
        }
        catch (IOException e2) {
            String string2 = e2.getMessage();
            if (string2 == null) {
                string2 = "Unexpected error while moving the file";
            }
            this.bail(string2);
        }
    }

    private final SourceLocation findSourceLocation(Module sourceModule, VirtualFile file2) {
        ModuleRootManager rootManager = ProjectUtil.getRootManager((Module)sourceModule);
        JpsModuleSourceRootType sourceRootType = null;
        boolean generatedSourceRoot = false;
        List<String> pathFromSourceRoot = null;
        List<String> pathFromContentRoot = null;
        ContentEntry[] contentEntryArray = rootManager.getContentEntries();
        Intrinsics.checkNotNullExpressionValue((Object)contentEntryArray, (String)"getContentEntries(...)");
        Object[] $this$forEach$iv = contentEntryArray;
        boolean $i$f$forEach = false;
        block0: for (Object element$iv : $this$forEach$iv) {
            ContentEntry contentEntry = (ContentEntry)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = this.sourceRootTypes;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                JpsModuleSourceRootType rootType = (JpsModuleSourceRootType)element$iv2;
                boolean bl2 = false;
                List list2 = contentEntry.getSourceFolders(rootType);
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getSourceFolders(...)");
                Iterable $this$forEach$iv3 = list2;
                boolean $i$f$forEach3 = false;
                for (Object element$iv3 : $this$forEach$iv3) {
                    List<String> path;
                    SourceFolder sourceFolder = (SourceFolder)element$iv3;
                    boolean bl3 = false;
                    VirtualFile root = sourceFolder.getFile();
                    if (root == null || (path = this.collectPath(file2, root)) == null) continue;
                    sourceRootType = rootType;
                    pathFromSourceRoot = path;
                    Intrinsics.checkNotNull((Object)sourceFolder);
                    generatedSourceRoot = this.isGenerated(sourceFolder);
                    continue block0;
                }
            }
        }
        VirtualFile[] virtualFileArray = rootManager.getContentRoots();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getContentRoots(...)");
        $this$forEach$iv = virtualFileArray;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VirtualFile root = (VirtualFile)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)root);
            List<String> path = this.collectPath(file2, root);
            if (path == null) continue;
            pathFromContentRoot = path;
        }
        return pathFromSourceRoot == null && pathFromContentRoot == null ? null : new SourceLocation(sourceRootType, generatedSourceRoot, pathFromSourceRoot, pathFromContentRoot);
    }

    private final List<String> collectPath(VirtualFile file2, VirtualFile root) {
        List pathToRoot = new ArrayList();
        VirtualFile f = file2;
        VirtualFile parent;
        while ((parent = f.getParent()) != null) {
            if (Intrinsics.areEqual((Object)parent, (Object)root)) {
                return CollectionsKt.reversed((Iterable)pathToRoot);
            }
            String string = parent.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            pathToRoot.add(string);
            f = parent;
        }
        return null;
    }

    private final boolean isGenerated(SourceFolder sourceFolder) {
        JpsElement jpsElement = sourceFolder.getJpsElement().getProperties();
        Intrinsics.checkNotNullExpressionValue((Object)jpsElement, (String)"getProperties(...)");
        JpsElement props = jpsElement;
        return props instanceof JavaSourceRootProperties ? ((JavaSourceRootProperties)props).isForGeneratedSources() : (props instanceof JavaResourceRootProperties ? ((JavaResourceRootProperties)props).isForGeneratedSources() : false);
    }

    private final TargetLocation findTargetLocation(Module targetModule, SourceLocation sourceLocation) {
        ModuleRootManager rootManager = ProjectUtil.getRootManager((Module)targetModule);
        if (sourceLocation.getSourceRootType() != null && sourceLocation.getPathFromSourceRoot() != null) {
            ContentEntry[] contentEntryArray = rootManager.getContentEntries();
            Intrinsics.checkNotNullExpressionValue((Object)contentEntryArray, (String)"getContentEntries(...)");
            Object[] $this$forEach$iv = contentEntryArray;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ContentEntry contentEntry = (ContentEntry)element$iv;
                boolean bl = false;
                List list2 = contentEntry.getSourceFolders(sourceLocation.getSourceRootType());
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getSourceFolders(...)");
                Iterable $this$forEach$iv2 = list2;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    SourceFolder sourceFolder = (SourceFolder)element$iv2;
                    boolean bl2 = false;
                    VirtualFile root = sourceFolder.getFile();
                    if (root == null) continue;
                    boolean bl3 = sourceLocation.getGeneratedSourceRoot();
                    Intrinsics.checkNotNull((Object)sourceFolder);
                    if (bl3 != this.isGenerated(sourceFolder)) continue;
                    return new TargetLocation(root, sourceLocation.getPathFromSourceRoot());
                }
            }
        }
        if (sourceLocation.getPathFromContentRoot() != null) {
            VirtualFile[] virtualFileArray = rootManager.getContentRoots();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getContentRoots(...)");
            VirtualFile virtualFile = (VirtualFile)ArraysKt.firstOrNull((Object[])virtualFileArray);
            if (virtualFile != null) {
                VirtualFile it = virtualFile;
                boolean bl = false;
                return new TargetLocation(it, sourceLocation.getPathFromContentRoot());
            }
        }
        return null;
    }

    private final void moveFile(Project project2, VirtualFile file2, TargetLocation targetLocation) {
        WriteCommandAction.writeCommandAction((Project)project2).withName("Move File").run(() -> MoveFileToAnotherModuleAction.moveFile$lambda$0(this, targetLocation, file2));
    }

    private final void bail(String message) {
        Messages.showErrorDialog((String)message, (String)"Error");
    }

    private static final void moveFile$lambda$0(MoveFileToAnotherModuleAction this$0, TargetLocation $targetLocation, VirtualFile $file) {
        MoveFileToAnotherModuleAction requestor = this$0;
        VirtualFile target = null;
        target = $targetLocation.getRoot();
        Iterable $this$forEach$iv = $targetLocation.getPathFromRoot();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            VirtualFile child = target.findChild(it);
            VirtualFile virtualFile = child;
            if (virtualFile == null) {
                VirtualFile virtualFile2 = target.createChildDirectory((Object)requestor, it);
                virtualFile = virtualFile2;
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"createChildDirectory(...)");
            }
            if (!VirtualFileUtil.isFile((VirtualFile)(target = virtualFile))) continue;
            throw new IOException("Existing file in target module prevents moving: " + target.getPath());
        }
        $file.move((Object)requestor, target);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0012\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B=\u0012\f\u0010\u0002\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u0012\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\u0013\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\u0011\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007H\u00c6\u0003J\u0011\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007H\u00c6\u0003JG\u0010\u0017\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u0010\b\u0002\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00072\u0010\b\u0002\u0010\t\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00052\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\bH\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0019\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0019\u0010\t\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011\u00a8\u0006\u001d"}, d2={"Lcom/intellij/ide/actions/MoveFileToAnotherModuleAction$SourceLocation;", "", "sourceRootType", "Lorg/jetbrains/jps/model/module/JpsModuleSourceRootType;", "generatedSourceRoot", "", "pathFromSourceRoot", "", "", "pathFromContentRoot", "<init>", "(Lorg/jetbrains/jps/model/module/JpsModuleSourceRootType;ZLjava/util/List;Ljava/util/List;)V", "getSourceRootType", "()Lorg/jetbrains/jps/model/module/JpsModuleSourceRootType;", "getGeneratedSourceRoot", "()Z", "getPathFromSourceRoot", "()Ljava/util/List;", "getPathFromContentRoot", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "intellij.platform.ide.impl"})
    private static final class SourceLocation {
        @Nullable
        private final JpsModuleSourceRootType<?> sourceRootType;
        private final boolean generatedSourceRoot;
        @Nullable
        private final List<String> pathFromSourceRoot;
        @Nullable
        private final List<String> pathFromContentRoot;

        public SourceLocation(@Nullable JpsModuleSourceRootType<?> sourceRootType, boolean generatedSourceRoot, @Nullable List<String> pathFromSourceRoot, @Nullable List<String> pathFromContentRoot) {
            this.sourceRootType = sourceRootType;
            this.generatedSourceRoot = generatedSourceRoot;
            this.pathFromSourceRoot = pathFromSourceRoot;
            this.pathFromContentRoot = pathFromContentRoot;
        }

        @Nullable
        public final JpsModuleSourceRootType<?> getSourceRootType() {
            return this.sourceRootType;
        }

        public final boolean getGeneratedSourceRoot() {
            return this.generatedSourceRoot;
        }

        @Nullable
        public final List<String> getPathFromSourceRoot() {
            return this.pathFromSourceRoot;
        }

        @Nullable
        public final List<String> getPathFromContentRoot() {
            return this.pathFromContentRoot;
        }

        @Nullable
        public final JpsModuleSourceRootType<?> component1() {
            return this.sourceRootType;
        }

        public final boolean component2() {
            return this.generatedSourceRoot;
        }

        @Nullable
        public final List<String> component3() {
            return this.pathFromSourceRoot;
        }

        @Nullable
        public final List<String> component4() {
            return this.pathFromContentRoot;
        }

        @NotNull
        public final SourceLocation copy(@Nullable JpsModuleSourceRootType<?> sourceRootType, boolean generatedSourceRoot, @Nullable List<String> pathFromSourceRoot, @Nullable List<String> pathFromContentRoot) {
            return new SourceLocation(sourceRootType, generatedSourceRoot, pathFromSourceRoot, pathFromContentRoot);
        }

        public static /* synthetic */ SourceLocation copy$default(SourceLocation sourceLocation, JpsModuleSourceRootType jpsModuleSourceRootType, boolean bl, List list2, List list3, int n, Object object) {
            if ((n & 1) != 0) {
                jpsModuleSourceRootType = sourceLocation.sourceRootType;
            }
            if ((n & 2) != 0) {
                bl = sourceLocation.generatedSourceRoot;
            }
            if ((n & 4) != 0) {
                list2 = sourceLocation.pathFromSourceRoot;
            }
            if ((n & 8) != 0) {
                list3 = sourceLocation.pathFromContentRoot;
            }
            return sourceLocation.copy(jpsModuleSourceRootType, bl, list2, list3);
        }

        @NotNull
        public String toString() {
            return "SourceLocation(sourceRootType=" + this.sourceRootType + ", generatedSourceRoot=" + this.generatedSourceRoot + ", pathFromSourceRoot=" + this.pathFromSourceRoot + ", pathFromContentRoot=" + this.pathFromContentRoot + ")";
        }

        public int hashCode() {
            int result2 = this.sourceRootType == null ? 0 : this.sourceRootType.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.generatedSourceRoot);
            result2 = result2 * 31 + (this.pathFromSourceRoot == null ? 0 : ((Object)this.pathFromSourceRoot).hashCode());
            result2 = result2 * 31 + (this.pathFromContentRoot == null ? 0 : ((Object)this.pathFromContentRoot).hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SourceLocation)) {
                return false;
            }
            SourceLocation sourceLocation = (SourceLocation)other;
            if (!Intrinsics.areEqual(this.sourceRootType, sourceLocation.sourceRootType)) {
                return false;
            }
            if (this.generatedSourceRoot != sourceLocation.generatedSourceRoot) {
                return false;
            }
            if (!Intrinsics.areEqual(this.pathFromSourceRoot, sourceLocation.pathFromSourceRoot)) {
                return false;
            }
            return Intrinsics.areEqual(this.pathFromContentRoot, sourceLocation.pathFromContentRoot);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ide/actions/MoveFileToAnotherModuleAction$TargetLocation;", "", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "pathFromRoot", "", "", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/util/List;)V", "getRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getPathFromRoot", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.platform.ide.impl"})
    private static final class TargetLocation {
        @NotNull
        private final VirtualFile root;
        @NotNull
        private final List<String> pathFromRoot;

        public TargetLocation(@NotNull VirtualFile root, @NotNull List<String> pathFromRoot) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter(pathFromRoot, (String)"pathFromRoot");
            this.root = root;
            this.pathFromRoot = pathFromRoot;
        }

        @NotNull
        public final VirtualFile getRoot() {
            return this.root;
        }

        @NotNull
        public final List<String> getPathFromRoot() {
            return this.pathFromRoot;
        }

        @NotNull
        public final VirtualFile component1() {
            return this.root;
        }

        @NotNull
        public final List<String> component2() {
            return this.pathFromRoot;
        }

        @NotNull
        public final TargetLocation copy(@NotNull VirtualFile root, @NotNull List<String> pathFromRoot) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter(pathFromRoot, (String)"pathFromRoot");
            return new TargetLocation(root, pathFromRoot);
        }

        public static /* synthetic */ TargetLocation copy$default(TargetLocation targetLocation, VirtualFile virtualFile, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                virtualFile = targetLocation.root;
            }
            if ((n & 2) != 0) {
                list2 = targetLocation.pathFromRoot;
            }
            return targetLocation.copy(virtualFile, list2);
        }

        @NotNull
        public String toString() {
            return "TargetLocation(root=" + this.root + ", pathFromRoot=" + this.pathFromRoot + ")";
        }

        public int hashCode() {
            int result2 = this.root.hashCode();
            result2 = result2 * 31 + ((Object)this.pathFromRoot).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TargetLocation)) {
                return false;
            }
            TargetLocation targetLocation = (TargetLocation)other;
            if (!Intrinsics.areEqual((Object)this.root, (Object)targetLocation.root)) {
                return false;
            }
            return Intrinsics.areEqual(this.pathFromRoot, targetLocation.pathFromRoot);
        }
    }
}

