/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.IdeScaleTransformer;
import com.intellij.ide.actions.QuickChangeIdeScaleActionKt;
import com.intellij.ide.actions.QuickSwitchSchemeAction;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsUtils;
import com.intellij.ide.ui.UISettingsUtilsKt;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionHolder;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Condition;
import com.intellij.ui.hover.HoverListener;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.concurrency.EdtScheduler;
import java.awt.Component;
import java.awt.Point;
import java.util.Collection;
import java.util.List;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u0000 \u001f2\u00020\u00012\u00020\u0002:\u0003\u001e\u001f B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\"\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\b\u0010\u0011\u001a\u00020\u0012H\u0014J\b\u0010\u0013\u001a\u00020\u0014H\u0014J\u001a\u0010\u0015\u001a\u00020\n2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\b\u0010\u001a\u001a\u00020\nH\u0002J\u0012\u0010\u001b\u001a\f\u0012\b\b\u0000\u0012\u0004\u0018\u00010\u001d0\u001cH\u0014R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/ide/actions/QuickChangeIdeScaleAction;", "Lcom/intellij/ide/actions/QuickSwitchSchemeAction;", "Lcom/intellij/openapi/actionSystem/remoting/ActionRemoteBehaviorSpecification$Frontend;", "<init>", "()V", "job", "Lkotlinx/coroutines/Job;", "popupSession", "Lcom/intellij/ide/actions/QuickChangeIdeScaleAction$PopupSession;", "fillActions", "", "project", "Lcom/intellij/openapi/project/Project;", "group", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "isEnabled", "", "getAidMethod", "Lcom/intellij/openapi/ui/popup/JBPopupFactory$ActionSelectionAid;", "showPopup", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "popup", "Lcom/intellij/openapi/ui/popup/ListPopup;", "cancelJob", "preselectAction", "Lcom/intellij/openapi/util/Condition;", "Lcom/intellij/openapi/actionSystem/AnAction;", "ChangeScaleAction", "Companion", "PopupSession", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nQuickChangeIdeScaleAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QuickChangeIdeScaleAction.kt\ncom/intellij/ide/actions/QuickChangeIdeScaleAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,192:1\n295#2,2:193\n1869#2,2:195\n*S KotlinDebug\n*F\n+ 1 QuickChangeIdeScaleAction.kt\ncom/intellij/ide/actions/QuickChangeIdeScaleAction\n*L\n37#1:193,2\n42#1:195,2\n*E\n"})
final class QuickChangeIdeScaleAction
extends QuickSwitchSchemeAction
implements ActionRemoteBehaviorSpecification.Frontend {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Job job;
    @Nullable
    private PopupSession popupSession;
    private static final int SELECTION_THROTTLING_MS = 500;

    protected void fillActions(@Nullable Project project2, @NotNull DefaultActionGroup group2, @NotNull DataContext dataContext2) {
        Object v0;
        List options2;
        float initialScale;
        block3: {
            Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
            Intrinsics.checkNotNullParameter((Object)dataContext2, (String)"dataContext");
            initialScale = UISettingsUtils.Companion.getInstance().getCurrentIdeScale();
            options2 = CollectionsKt.toMutableList((Collection)IdeScaleTransformer.Settings.Companion.getCurrentScaleOptions());
            Iterable $this$firstOrNull$iv = options2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                float it = ((Number)element$iv).floatValue();
                boolean bl = false;
                if (!(UISettingsUtilsKt.getPercentValue((float)it) == UISettingsUtilsKt.getPercentValue((float)initialScale))) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        if (v0 == null) {
            options2.add(Float.valueOf(initialScale));
            CollectionsKt.sort((List)options2);
        }
        Iterable $this$forEach$iv = options2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            float scale = ((Number)element$iv).floatValue();
            boolean bl = false;
            group2.add((AnAction)new ChangeScaleAction(scale));
        }
    }

    protected boolean isEnabled() {
        return !((Collection)IdeScaleTransformer.Settings.Companion.getCurrentScaleOptions()).isEmpty();
    }

    @NotNull
    protected JBPopupFactory.ActionSelectionAid getAidMethod() {
        return JBPopupFactory.ActionSelectionAid.SPEEDSEARCH;
    }

    protected void showPopup(@Nullable AnActionEvent e, @NotNull ListPopup popup2) {
        Intrinsics.checkNotNullParameter((Object)popup2, (String)"popup");
        float initialScale = UISettingsUtils.Companion.getInstance().getCurrentIdeScale();
        this.cancelJob();
        popup2.addListSelectionListener(arg_0 -> QuickChangeIdeScaleAction.showPopup$lambda$0(this, popup2, arg_0));
        popup2.addListener(new JBPopupListener(this, initialScale){
            final /* synthetic */ QuickChangeIdeScaleAction this$0;
            final /* synthetic */ float $initialScale;
            {
                this.this$0 = $receiver;
                this.$initialScale = $initialScale;
            }

            public void onClosed(LightweightWindowEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                QuickChangeIdeScaleAction.access$cancelJob(this.this$0);
                QuickChangeIdeScaleAction.access$setPopupSession$p(this.this$0, null);
                if (!event.isOk()) {
                    com.intellij.ide.actions.QuickChangeIdeScaleAction$Companion.access$applyUserScale(QuickChangeIdeScaleAction.Companion, this.$initialScale, false);
                    QuickChangeIdeScaleActionKt.access$logSwitcherClosed(false);
                }
            }
        });
        HoverListener hoverListener2 = new HoverListener(this){
            final /* synthetic */ QuickChangeIdeScaleAction this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseEntered(Component component2, int x, int y) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
                    PopupSession popupSession = QuickChangeIdeScaleAction.access$getPopupSession$p(this.this$0);
                    if (popupSession == null) break block0;
                    popupSession.updateMouseCoordinates(x, y);
                }
            }

            public void mouseMoved(Component component2, int x, int y) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
                    PopupSession popupSession = QuickChangeIdeScaleAction.access$getPopupSession$p(this.this$0);
                    if (popupSession == null) break block0;
                    popupSession.updateMouseCoordinates(x, y);
                }
            }

            public void mouseExited(Component component2) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
                    PopupSession popupSession = QuickChangeIdeScaleAction.access$getPopupSession$p(this.this$0);
                    if (popupSession == null) break block0;
                    popupSession.setMouseIsInside(false);
                }
            }
        };
        hoverListener2.addTo(popup2.getContent());
        this.popupSession = new PopupSession(popup2);
        super.showPopup(e, popup2);
    }

    private final void cancelJob() {
        block0: {
            Job job2 = this.job;
            if (job2 == null) break block0;
            Job it = job2;
            boolean bl = false;
            Job.DefaultImpls.cancel$default((Job)it, null, (int)1, null);
            this.job = null;
        }
    }

    @NotNull
    protected Condition<? super AnAction> preselectAction() {
        return QuickChangeIdeScaleAction::preselectAction$lambda$0;
    }

    private static final void showPopup$lambda$0(QuickChangeIdeScaleAction this$0, ListPopup $popup, ListSelectionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Object object = event.getSource();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.JList<*>");
        Object item = ((JList)object).getSelectedValue();
        if (item instanceof AnActionHolder) {
            AnAction anAction = ((AnActionHolder)item).getAction();
            Intrinsics.checkNotNullExpressionValue((Object)anAction, (String)"getAction(...)");
            AnAction anAction2 = anAction;
            if (anAction2 instanceof ChangeScaleAction) {
                Job job2 = this$0.job;
                if (job2 != null) {
                    Job.DefaultImpls.cancel$default((Job)job2, null, (int)1, null);
                }
                this$0.job = EdtScheduler.Companion.getInstance().schedule(500, () -> QuickChangeIdeScaleAction.showPopup$lambda$0$0(anAction2, $popup, this$0));
            }
        }
    }

    private static final void showPopup$lambda$0$0(AnAction $anAction, ListPopup $popup, QuickChangeIdeScaleAction this$0) {
        block1: {
            QuickChangeIdeScaleAction.Companion.applyUserScale(((ChangeScaleAction)$anAction).getScale(), true);
            if ($popup.isDisposed()) break block1;
            $popup.pack(true, true);
            PopupSession popupSession = this$0.popupSession;
            if (popupSession != null) {
                popupSession.updateLocation();
            }
        }
    }

    private static final boolean preselectAction$lambda$0(AnAction a) {
        return a instanceof ChangeScaleAction && UISettingsUtilsKt.getPercentValue((float)((ChangeScaleAction)a).getScale()) == UISettingsUtilsKt.getPercentValue((float)UISettingsUtils.Companion.getInstance().getCurrentIdeScale());
    }

    public static final /* synthetic */ void access$cancelJob(QuickChangeIdeScaleAction $this) {
        $this.cancelJob();
    }

    public static final /* synthetic */ void access$setPopupSession$p(QuickChangeIdeScaleAction $this, PopupSession popupSession) {
        $this.popupSession = popupSession;
    }

    public static final /* synthetic */ PopupSession access$getPopupSession$p(QuickChangeIdeScaleAction $this) {
        return $this.popupSession;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ide/actions/QuickChangeIdeScaleAction$ChangeScaleAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "scale", "", "<init>", "(F)V", "getScale", "()F", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.platform.ide.impl"})
    private static final class ChangeScaleAction
    extends DumbAwareAction {
        private final float scale;

        public ChangeScaleAction(float scale) {
            super(UISettingsUtilsKt.getPercentStringValue((float)scale));
            this.scale = scale;
        }

        public final float getScale() {
            return this.scale;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Companion.applyUserScale(this.scale, true);
            QuickChangeIdeScaleActionKt.access$logSwitcherClosed(true);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/ide/actions/QuickChangeIdeScaleAction$Companion;", "", "<init>", "()V", "applyUserScale", "", "scale", "", "shouldLog", "", "SELECTION_THROTTLING_MS", "", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final void applyUserScale(float scale, boolean shouldLog) {
            if (UISettingsUtilsKt.getPercentValue((float)UISettingsUtils.Companion.getInstance().getCurrentIdeScale()) == UISettingsUtilsKt.getPercentValue((float)scale)) {
                return;
            }
            if (shouldLog) {
                QuickChangeIdeScaleActionKt.access$logIdeZoomChanged(scale);
            }
            UISettingsUtils.Companion.getInstance().setCurrentIdeScale(scale);
            UISettings.Companion.getInstance().fireUISettingsChanged();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020\tJ\u0006\u0010!\u001a\u00020\u001eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\rR\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\u00a8\u0006\""}, d2={"Lcom/intellij/ide/actions/QuickChangeIdeScaleAction$PopupSession;", "", "popup", "Lcom/intellij/openapi/ui/popup/ListPopup;", "<init>", "(Lcom/intellij/openapi/ui/popup/ListPopup;)V", "getPopup", "()Lcom/intellij/openapi/ui/popup/ListPopup;", "lastMouseX", "", "getLastMouseX", "()I", "setLastMouseX", "(I)V", "lastMouseY", "getLastMouseY", "setLastMouseY", "lastScale", "", "getLastScale", "()F", "setLastScale", "(F)V", "mouseIsInside", "", "getMouseIsInside", "()Z", "setMouseIsInside", "(Z)V", "updateMouseCoordinates", "", "x", "y", "updateLocation", "intellij.platform.ide.impl"})
    private static final class PopupSession {
        @NotNull
        private final ListPopup popup;
        private int lastMouseX;
        private int lastMouseY;
        private float lastScale;
        private boolean mouseIsInside;

        public PopupSession(@NotNull ListPopup popup2) {
            Intrinsics.checkNotNullParameter((Object)popup2, (String)"popup");
            this.popup = popup2;
            this.lastMouseX = -1;
            this.lastMouseY = -1;
            this.lastScale = 1.0f;
        }

        @NotNull
        public final ListPopup getPopup() {
            return this.popup;
        }

        public final int getLastMouseX() {
            return this.lastMouseX;
        }

        public final void setLastMouseX(int n) {
            this.lastMouseX = n;
        }

        public final int getLastMouseY() {
            return this.lastMouseY;
        }

        public final void setLastMouseY(int n) {
            this.lastMouseY = n;
        }

        public final float getLastScale() {
            return this.lastScale;
        }

        public final void setLastScale(float f) {
            this.lastScale = f;
        }

        public final boolean getMouseIsInside() {
            return this.mouseIsInside;
        }

        public final void setMouseIsInside(boolean bl) {
            this.mouseIsInside = bl;
        }

        public final void updateMouseCoordinates(int x, int y) {
            this.mouseIsInside = true;
            this.lastMouseX = x;
            this.lastMouseY = y;
            this.lastScale = JBUIScale.scale((float)1.0f);
        }

        public final void updateLocation() {
            int oldX = this.lastMouseX;
            int oldY = this.lastMouseY;
            float oldScale = this.lastScale;
            if (this.popup.isDisposed() || !this.mouseIsInside || this.lastMouseX < 0 || this.lastMouseY < 0) {
                return;
            }
            float newScale = JBUIScale.scale((float)1.0f);
            int newX = MathKt.roundToInt((float)((float)oldX * newScale / oldScale));
            int newY = MathKt.roundToInt((float)((float)oldY * newScale / oldScale));
            int dX = newX - oldX;
            int dY = newY - oldY;
            Point point = this.popup.getLocationOnScreen();
            Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getLocationOnScreen(...)");
            Point location = point;
            location.x -= dX;
            location.y -= dY;
            this.popup.setLocation(location);
        }
    }
}

