/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers;

import com.google.common.base.CharMatcher;
import com.intellij.configurationStore.XmlSerializer;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="browser")
public class StartBrowserSettings {
    private boolean mySelected;
    private String myBrowserReference;
    private String myUrl;
    private boolean myStartJavaScriptDebugger;

    @Attribute(value="start")
    public boolean isSelected() {
        return this.mySelected;
    }

    public void setSelected(boolean selected) {
        this.mySelected = selected;
    }

    @Attribute(value="name")
    @Nullable
    public String getBrowserReference() {
        return this.myBrowserReference;
    }

    public void setBrowserReference(@Nullable String value) {
        this.myBrowserReference = value;
    }

    @Transient
    @Nullable
    public WebBrowser getBrowser() {
        return WebBrowserManager.getInstance().findBrowserById(this.myBrowserReference);
    }

    public void setBrowser(@Nullable WebBrowser value) {
        this.myBrowserReference = value != null ? value.getId().toString() : null;
    }

    @Attribute
    @Nullable
    public String getUrl() {
        return this.myUrl;
    }

    public void setUrl(@Nullable String value) {
        String normalized = StringUtil.nullize((String)value, (boolean)true);
        if (normalized != null) {
            normalized = CharMatcher.whitespace().trimFrom((CharSequence)normalized);
        }
        this.myUrl = normalized;
    }

    @Attribute(value="with-js-debugger")
    public boolean isStartJavaScriptDebugger() {
        return this.myStartJavaScriptDebugger;
    }

    public void setStartJavaScriptDebugger(boolean value) {
        this.myStartJavaScriptDebugger = value;
    }

    @NotNull
    public static StartBrowserSettings readExternal(@NotNull Element parent) {
        if (parent == null) {
            StartBrowserSettings.$$$reportNull$$$0(0);
        }
        Element state2 = parent.getChild("browser");
        StartBrowserSettings settings = new StartBrowserSettings();
        if (state2 != null) {
            XmlSerializer.deserializeInto((Element)state2, (Object)settings);
        }
        StartBrowserSettings startBrowserSettings = settings;
        if (startBrowserSettings == null) {
            StartBrowserSettings.$$$reportNull$$$0(1);
        }
        return startBrowserSettings;
    }

    public void writeExternal(@NotNull Element parent) {
        Element state2;
        if (parent == null) {
            StartBrowserSettings.$$$reportNull$$$0(2);
        }
        if ((state2 = XmlSerializer.serialize((Object)this)) != null) {
            parent.addContent(state2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/browsers/StartBrowserSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/browsers/StartBrowserSettings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "readExternal";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

