/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.minimap;

import com.intellij.concurrency.JobScheduler;
import com.intellij.ide.minimap.settings.MinimapSettings;
import com.intellij.ide.minimap.settings.MinimapSettingsState;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.util.ui.ImageUtil;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 ,2\u00020\u0001:\u0001,B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J(\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u000bH\u0002J0\u0010%\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020\u000b2\b\b\u0002\u0010)\u001a\u00020*J(\u0010+\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020\u000bH\u0002R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/intellij/ide/minimap/MinimapImage;", "", "<init>", "()V", "preview", "Ljava/awt/image/BufferedImage;", "getPreview", "()Ljava/awt/image/BufferedImage;", "setPreview", "(Ljava/awt/image/BufferedImage;)V", "imgHeight", "", "imgWidth", "height", "contentHeight", "contentVisibleWidth", "bufferUnscaled", "buHeight", "buWidth", "lastWidth", "onImageReady", "Lkotlin/Function0;", "", "getOnImageReady", "()Lkotlin/jvm/functions/Function0;", "setOnImageReady", "(Lkotlin/jvm/functions/Function0;)V", "updateImage", "editor", "Lcom/intellij/openapi/editor/Editor;", "progressiveDownscale", "image", "finalWidth", "finalHeight", "steps", "scheduled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "update", "visibleHeight", "visibleWidth", "minimapHeight", "force", "", "innerUpdate", "Companion", "intellij.platform.ide.impl"})
public final class MinimapImage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private BufferedImage preview;
    private int imgHeight = -1;
    private int imgWidth = -1;
    private int height = -1;
    private int contentHeight = -1;
    private int contentVisibleWidth = -1;
    @Nullable
    private BufferedImage bufferUnscaled;
    private int buHeight = -1;
    private int buWidth = -1;
    private int lastWidth = -1;
    @Nullable
    private Function0<Unit> onImageReady;
    @NotNull
    private final AtomicBoolean scheduled = new AtomicBoolean();
    private static final long UPDATE_DELAY_MILLIS = 200L;
    private static final int BUFFER_UNSCALED_HEIGHT = 500;

    @Nullable
    public final BufferedImage getPreview() {
        return this.preview;
    }

    public final void setPreview(@Nullable BufferedImage bufferedImage) {
        this.preview = bufferedImage;
    }

    @Nullable
    public final Function0<Unit> getOnImageReady() {
        return this.onImageReady;
    }

    public final void setOnImageReady(@Nullable Function0<Unit> function0) {
        this.onImageReady = function0;
    }

    private final void updateImage(Editor editor2) {
        if (this.buWidth != this.contentVisibleWidth || this.buHeight != 500) {
            this.bufferUnscaled = ImageUtil.createImage((int)this.contentVisibleWidth, (int)500, (int)2);
            this.buHeight = 500;
            this.buWidth = this.contentVisibleWidth;
        }
        BufferedImage bufferedImage = this.bufferUnscaled;
        Intrinsics.checkNotNull((Object)bufferedImage);
        BufferedImage bufferUnscaled = bufferedImage;
        int blocks = (int)Math.ceil((double)this.contentHeight / (double)this.buHeight);
        Graphics2D g = bufferUnscaled.createGraphics();
        BufferedImage bufferedImage2 = this.preview;
        Intrinsics.checkNotNull((Object)bufferedImage2);
        Graphics2D g2d = bufferedImage2.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        int minimapHeightEx = (int)((double)this.buHeight * (double)this.imgWidth / (double)this.buWidth);
        for (int i2 = 0; i2 < blocks; ++i2) {
            ActionsKt.invokeAndWaitIfNeeded$default(null, () -> MinimapImage.updateImage$lambda$0(editor2, g), (int)1, null);
            g2d.drawImage(bufferUnscaled, 0, i2 * minimapHeightEx, this.imgWidth, (i2 + 1) * minimapHeightEx, 0, 0, bufferUnscaled.getWidth(), bufferUnscaled.getHeight(), null);
            g.translate(0, -this.buHeight);
        }
        g.dispose();
        int fillHeight = blocks * this.buHeight - this.contentHeight;
        if (fillHeight > 0) {
            fillHeight = (int)((double)fillHeight * (double)this.imgWidth / (double)this.buWidth / g2d.getTransform().getScaleY());
            g2d.setColor(editor2.getContentComponent().getBackground());
            g2d.fillRect(0, this.imgHeight - fillHeight, this.imgWidth, fillHeight);
        }
        g2d.dispose();
    }

    private final void progressiveDownscale(BufferedImage image2, int finalWidth, int finalHeight, int steps) {
        Graphics2D g2d = image2.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        int imageWidth = image2.getWidth();
        int imageHeight = image2.getHeight();
        int deltaWidth = (imageWidth - finalWidth) / steps;
        int deltaHeight = (imageHeight - finalHeight) / steps;
        for (int i2 = 0; i2 < steps; ++i2) {
            g2d.drawImage(image2, 0, 0, imageWidth - deltaWidth, imageHeight - deltaHeight, 0, 0, imageWidth, imageHeight, null);
            imageWidth -= deltaWidth;
            imageHeight -= deltaHeight;
        }
    }

    public final void update(@NotNull Editor editor2, int visibleHeight, int visibleWidth, int minimapHeight, boolean force) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        if (minimapHeight <= 0 || visibleHeight <= 0 || visibleWidth <= 0) {
            return;
        }
        if (force) {
            this.lastWidth = -1;
        }
        if (this.scheduled.compareAndSet(false, true)) {
            JobScheduler.getScheduler().schedule(() -> MinimapImage.update$lambda$0(this, editor2, visibleHeight, visibleWidth, minimapHeight), 200L, TimeUnit.MILLISECONDS);
        }
    }

    public static /* synthetic */ void update$default(MinimapImage minimapImage, Editor editor2, int n, int n2, int n3, boolean bl, int n4, Object object) {
        if ((n4 & 0x10) != 0) {
            bl = false;
        }
        minimapImage.update(editor2, n, n2, n3, bl);
    }

    private final void innerUpdate(Editor editor2, int visibleHeight, int visibleWidth, int minimapHeight) {
        block3: {
            MinimapSettingsState state2 = MinimapSettings.Companion.getInstance().getState();
            if (this.contentHeight == visibleHeight && this.contentVisibleWidth == visibleWidth && this.lastWidth == state2.getWidth()) {
                return;
            }
            this.contentHeight = visibleHeight;
            this.contentVisibleWidth = visibleWidth;
            this.lastWidth = state2.getWidth();
            if (this.contentHeight <= 0 || this.contentVisibleWidth <= 0 || state2.getWidth() <= 0) {
                return;
            }
            this.height = minimapHeight;
            if (this.imgWidth != state2.getWidth() || this.imgHeight != this.height) {
                this.preview = ImageUtil.createImage((int)state2.getWidth(), (int)this.height, (int)2);
                this.imgHeight = this.height;
                this.imgWidth = state2.getWidth();
            }
            this.updateImage(editor2);
            Function0<Unit> function0 = this.onImageReady;
            if (function0 == null) break block3;
            function0.invoke();
        }
    }

    private static final Unit updateImage$lambda$0(Editor $editor, Graphics2D $g) {
        $editor.getContentComponent().print($g);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void update$lambda$0(MinimapImage this$0, Editor $editor, int $visibleHeight, int $visibleWidth, int $minimapHeight) {
        try {
            this$0.innerUpdate($editor, $visibleHeight, $visibleWidth, $minimapHeight);
        }
        finally {
            this$0.scheduled.set(false);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/ide/minimap/MinimapImage$Companion;", "", "<init>", "()V", "UPDATE_DELAY_MILLIS", "", "BUFFER_UNSCALED_HEIGHT", "", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

