/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.accessibility.AccessibilityUtils;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.ListPluginModel;
import com.intellij.ide.plugins.PluginEnableDisableAction;
import com.intellij.ide.plugins.PluginEnabledState;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.PluginUtilsKt;
import com.intellij.ide.plugins.newui.ColorButton;
import com.intellij.ide.plugins.newui.ErrorComponent;
import com.intellij.ide.plugins.newui.EventHandler;
import com.intellij.ide.plugins.newui.InstallButton;
import com.intellij.ide.plugins.newui.LicensePanel;
import com.intellij.ide.plugins.newui.NewUiUtil;
import com.intellij.ide.plugins.newui.PluginInstallationState;
import com.intellij.ide.plugins.newui.PluginManagerCustomizer;
import com.intellij.ide.plugins.newui.PluginModelAsyncOperationsExecutor;
import com.intellij.ide.plugins.newui.PluginModelFacade;
import com.intellij.ide.plugins.newui.PluginStatus;
import com.intellij.ide.plugins.newui.PluginUiModel;
import com.intellij.ide.plugins.newui.PluginUiModelAdapter;
import com.intellij.ide.plugins.newui.PluginUiModelKt;
import com.intellij.ide.plugins.newui.PluginsGroup;
import com.intellij.ide.plugins.newui.PluginsViewCustomizerKt;
import com.intellij.ide.plugins.newui.RestartButton;
import com.intellij.ide.plugins.newui.SelectionBasedPluginModelAction;
import com.intellij.ide.plugins.newui.TagComponent;
import com.intellij.ide.plugins.newui.Tags;
import com.intellij.ide.plugins.newui.TextHorizontalLayout;
import com.intellij.ide.plugins.newui.UiPluginManager;
import com.intellij.ide.plugins.newui.UnavailableWithoutSubscriptionComponent;
import com.intellij.ide.plugins.newui.UninstallAction;
import com.intellij.ide.plugins.newui.UpdateButton;
import com.intellij.internal.inspector.PropertyBean;
import com.intellij.internal.inspector.UiInspectorContextProvider;
import com.intellij.internal.inspector.UiInspectorUtil;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.LicensingFacade;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.system.OS;
import com.intellij.util.ui.AbstractLayoutManager;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringJoiner;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ButtonUI;
import javax.swing.text.BadLocationException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ListPluginComponent
extends JPanel {
    public static final Color DisabledColor = JBColor.namedColor((String)"Plugins.disabledForeground", (Color)new JBColor(0xB1B1B1, 0x696969));
    public static final Color GRAY_COLOR = JBColor.namedColor((String)"Label.infoForeground", (Color)new JBColor((Color)Gray._120, (Color)Gray._135));
    public static final Color SELECTION_COLOR = JBColor.namedColor((String)"Plugins.lightSelectionBackground", (Color)new JBColor(15595262, 4606541));
    public static final Color HOVER_COLOR = JBColor.namedColor((String)"Plugins.hoverBackground", (Color)new JBColor(15595262, 4606541));
    private static final Logger LOG = Logger.getInstance(ListPluginComponent.class);
    private static final Ref<Boolean> HANDLE_FOCUS_ON_SELECTION = new Ref((Object)Boolean.TRUE);
    private final PluginModelFacade myModelFacade;
    private final LinkListener<Object> mySearchListener;
    private final boolean myMarketplace;
    private final boolean myIsAvailable;
    private final boolean myIsDisableAllowed;
    private final boolean myIsNotFreeInFreeMode;
    @NotNull
    private PluginUiModel myPlugin;
    private PluginUiModel myInstalledPluginMarketplaceNode;
    @NotNull
    private final PluginsGroup myGroup;
    private boolean myOnlyUpdateMode;
    private boolean myAfterUpdate;
    @Nullable
    public PluginUiModel myUpdateDescriptor;
    PluginUiModel myInstalledDescriptorForMarketplace;
    private final JBLabel myNameComponent;
    private final JLabel myIconComponent;
    private final BaselineLayout myLayout;
    private boolean succesefullyFinishedOnce;
    JButton myRestartButton;
    InstallButton myInstallButton;
    JButton myUpdateButton;
    private JComponent myEnableDisableButton;
    private JCheckBox myChooseUpdateButton;
    private JComponent myAlignButton;
    private JPanel myMetricsPanel;
    private JLabel myRating;
    private JLabel myDownloads;
    private JLabel myVersion;
    private JLabel myVendor;
    private LicensePanel myLicensePanel;
    private LicensePanel myUpdateLicensePanel;
    private JPanel myErrorPanel;
    private ErrorComponent myErrorComponent;
    private ProgressIndicatorEx myIndicator;
    private EventHandler myEventHandler;
    private PluginManagerCustomizer myCustomizer;
    private CoroutineScope myCoroutineScope;
    @NotNull
    private EventHandler.SelectionType mySelection;

    public ListPluginComponent(@NotNull PluginModelFacade pluginModelFacade, @NotNull PluginUiModel pluginUiModel, @NotNull PluginsGroup group2, @NotNull ListPluginModel listModel, @NotNull LinkListener<Object> searchListener, @NotNull CoroutineScope coroutineScope, boolean marketplace) {
        if (pluginModelFacade == null) {
            ListPluginComponent.$$$reportNull$$$0(0);
        }
        if (pluginUiModel == null) {
            ListPluginComponent.$$$reportNull$$$0(1);
        }
        if (group2 == null) {
            ListPluginComponent.$$$reportNull$$$0(2);
        }
        if (listModel == null) {
            ListPluginComponent.$$$reportNull$$$0(3);
        }
        if (searchListener == null) {
            ListPluginComponent.$$$reportNull$$$0(4);
        }
        if (coroutineScope == null) {
            ListPluginComponent.$$$reportNull$$$0(5);
        }
        this.myNameComponent = new JBLabel();
        this.myIconComponent = new JLabel(AllIcons.Plugins.PluginLogo);
        this.myLayout = new BaselineLayout();
        this.succesefullyFinishedOnce = false;
        this.mySelection = EventHandler.SelectionType.NONE;
        this.myPlugin = pluginUiModel;
        this.myGroup = group2;
        this.myModelFacade = pluginModelFacade;
        this.mySearchListener = searchListener;
        this.myMarketplace = marketplace;
        this.myCoroutineScope = coroutineScope;
        this.myInstalledDescriptorForMarketplace = listModel.getInstalledModels().get(pluginUiModel.getPluginId());
        PluginId pluginId = this.myPlugin.getPluginId();
        boolean compatible = !this.myPlugin.isIncompatibleWithCurrentPlatform();
        PluginInstallationState pluginInstallationState = listModel.getPluginInstallationStates().get(pluginId);
        this.myIsAvailable = (compatible || this.isInstalledAndEnabled(pluginInstallationState)) && pluginUiModel.getCanBeEnabled();
        UiPluginManager pluginManager = UiPluginManager.getInstance();
        this.myIsNotFreeInFreeMode = pluginManager.isPluginRequiresUltimateButItIsDisabled(pluginModelFacade.getModel().getSessionId(), pluginUiModel.getPluginId());
        this.myIsDisableAllowed = pluginUiModel.isDisableAllowed() && !this.myIsNotFreeInFreeMode;
        pluginModelFacade.addComponent(this);
        this.myCustomizer = UiPluginManager.isCombinedPluginManagerEnabled() ? PluginManagerCustomizer.getInstance() : null;
        this.setOpaque(true);
        this.setBorder(JBUI.Borders.empty((int)10));
        this.setLayout((LayoutManager)((Object)this.myLayout));
        this.myIconComponent.setVerticalAlignment(1);
        this.myIconComponent.setOpaque(false);
        this.myLayout.setIconComponent(this.myIconComponent);
        this.myNameComponent.setText(pluginUiModel.getName());
        this.myLayout.setNameComponent((JLabel)RelativeFont.BOLD.install((Component)this.myNameComponent));
        this.createTag();
        if (this.myIsAvailable) {
            this.createButtons(listModel.getInstalledModels().get(pluginId), pluginInstallationState);
            this.createMetricsPanel();
            this.createLicensePanel();
        } else {
            this.createNotAvailableMarker(compatible);
        }
        if (marketplace && this.myInstalledDescriptorForMarketplace == null) {
            this.updateIcon(false, !this.myIsAvailable);
        } else {
            this.updateErrors(listModel.getErrors().getOrDefault(pluginId, Collections.emptyList()));
        }
        if (this.myModelFacade.isPluginInstallingOrUpdating(pluginUiModel)) {
            this.showProgress(false);
        }
        this.updateColors(EventHandler.SelectionType.NONE);
        this.putClientProperty("AccessibleName", pluginUiModel.getName());
        UiInspectorUtil.registerProvider((JComponent)this, (UiInspectorContextProvider)new PluginIdUiInspectorContextProvider());
        try {
            PluginsViewCustomizerKt.getListPluginComponentCustomizer().processListPluginComponent(this);
        }
        catch (Exception e) {
            LOG.error("Error while customizing list plugin component", (Throwable)e);
        }
    }

    @NotNull
    PluginsGroup getGroup() {
        PluginsGroup pluginsGroup = this.myGroup;
        if (pluginsGroup == null) {
            ListPluginComponent.$$$reportNull$$$0(6);
        }
        return pluginsGroup;
    }

    @NotNull
    EventHandler.SelectionType getSelection() {
        EventHandler.SelectionType selectionType = this.mySelection;
        if (selectionType == null) {
            ListPluginComponent.$$$reportNull$$$0(7);
        }
        return selectionType;
    }

    void setSelection(@NotNull EventHandler.SelectionType type) {
        if (type == null) {
            ListPluginComponent.$$$reportNull$$$0(8);
        }
        this.setSelection(type, type == EventHandler.SelectionType.SELECTION);
    }

    void setSelection(@NotNull EventHandler.SelectionType type, boolean scrollAndFocus) {
        JComponent parent;
        if (type == null) {
            ListPluginComponent.$$$reportNull$$$0(9);
        }
        this.mySelection = type;
        if (scrollAndFocus && (parent = (JComponent)this.getParent()) != null) {
            ListPluginComponent.scrollToVisible(parent, this.getBounds());
            if (type == EventHandler.SelectionType.SELECTION && ((Boolean)HANDLE_FOCUS_ON_SELECTION.get()).booleanValue()) {
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this, true));
            }
        }
        this.updateColors(type);
        this.repaint();
    }

    void onSelection(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            ListPluginComponent.$$$reportNull$$$0(10);
        }
        try {
            HANDLE_FOCUS_ON_SELECTION.set((Object)Boolean.FALSE);
            runnable2.run();
        }
        finally {
            HANDLE_FOCUS_ON_SELECTION.set((Object)Boolean.TRUE);
        }
    }

    private static void scrollToVisible(@NotNull JComponent parent, @NotNull Rectangle bounds) {
        if (parent == null) {
            ListPluginComponent.$$$reportNull$$$0(11);
        }
        if (bounds == null) {
            ListPluginComponent.$$$reportNull$$$0(12);
        }
        if (!parent.getVisibleRect().contains(bounds)) {
            parent.scrollRectToVisible(bounds);
        }
    }

    private void createNotAvailableMarker(boolean compatible) {
        this.myInstallButton = this.createInstallButton();
        if (!compatible) {
            this.setupNotCompatibleMarkerButton();
        } else {
            this.setupNotAllowedMarkerButton();
        }
        this.myLayout.addButtonComponent(this.myInstallButton);
    }

    private void setupNotCompatibleMarkerButton() {
        this.myInstallButton.setButtonColors(false);
        this.myInstallButton.setEnabled(false, IdeBundle.message((String)"plugins.configurable.unavailable.for.platform", (Object[])new Object[0]));
        this.myInstallButton.setToolTipText(IdeBundle.message((String)"plugins.configurable.plugin.unavailable.for.platform", (Object[])new Object[]{OS.CURRENT}));
    }

    private void setupNotAllowedMarkerButton() {
        if (this.myMarketplace || this.myModelFacade.getState(this.myPlugin).isDisabled()) {
            this.myInstallButton.setButtonColors(false);
            this.myInstallButton.setEnabled(false, IdeBundle.message((String)"plugin.status.not.allowed", (Object[])new Object[0]));
            this.myInstallButton.setToolTipText(IdeBundle.message((String)"plugin.status.not.allowed.tooltip", (Object[])new Object[0]));
        } else {
            this.myInstallButton.setButtonColors(false);
            this.myInstallButton.setEnabled(true, IdeBundle.message((String)"plugin.status.not.allowed.but.enabled", (Object[])new Object[0]));
            this.myInstallButton.setText(IdeBundle.message((String)"plugin.status.not.allowed.but.enabled", (Object[])new Object[0]));
            this.myInstallButton.setToolTipText(IdeBundle.message((String)"plugin.status.not.allowed.tooltip.but.enabled", (Object[])new Object[0]));
            this.myInstallButton.setBorderColor((Color)JBColor.red);
            this.myInstallButton.setTextColor((Color)JBColor.red);
            this.myInstallButton.addActionListener(e -> {
                this.myModelFacade.disable(this.myPlugin);
                this.setupNotAllowedMarkerButton();
            });
        }
        ColorButton.setWidth72(this.myInstallButton);
    }

    private void createButtons(PluginUiModel installedModel, PluginInstallationState installationState2) {
        PluginInstallationState pluginInstallationState = installationState2 = installationState2 == null ? new PluginInstallationState(false, null) : installationState2;
        if (this.myMarketplace) {
            if (installationState2.getStatus() == PluginStatus.INSTALLED_AND_REQUIRED_RESTART) {
                this.myRestartButton = new RestartButton(this.myModelFacade);
                this.myLayout.addButtonComponent(this.myRestartButton);
            } else {
                boolean showInstall = installedModel == null;
                this.myInstallButton = this.createInstallButton();
                this.myLayout.addButtonComponent(this.myInstallButton);
                this.myInstallButton.addActionListener(e -> PluginModelAsyncOperationsExecutor.INSTANCE.performAutoInstall(this.myCoroutineScope, this.myModelFacade, this.myPlugin, this.myCustomizer, this));
                this.myInstallButton.setEnabled(showInstall, IdeBundle.message((String)"plugin.status.installed", (Object[])new Object[0]));
                ColorButton.setWidth72(this.myInstallButton);
                this.myInstalledDescriptorForMarketplace = installedModel;
                this.myInstallButton.setVisible(showInstall);
                if (this.myInstalledDescriptorForMarketplace != null && this.myInstalledDescriptorForMarketplace.isDeleted()) {
                    if (installationState2.getStatus() == PluginStatus.INSTALLED_WITHOUT_RESTART) {
                        this.myInstallButton.setVisible(true);
                        this.myInstallButton.setEnabled(false, IdeBundle.message((String)"plugins.configurable.uninstalled", (Object[])new Object[0]));
                        this.myInstallButton.setPreferredSize(null);
                        this.myAfterUpdate = true;
                    } else {
                        this.myRestartButton = new RestartButton(this.myModelFacade);
                        this.myLayout.addButtonComponent(this.myRestartButton);
                        this.myModelFacade.addUninstalled(this.myInstalledDescriptorForMarketplace.getPluginId());
                    }
                } else {
                    this.createEnableDisableButton(this::getInstalledDescriptorForMarketplace);
                    this.myEnableDisableButton.setVisible(!showInstall);
                    if (!showInstall) {
                        this.updateEnabledStateUI();
                    }
                }
            }
        } else {
            if (this.myPlugin.isDeleted()) {
                if (installationState2.getStatus() == PluginStatus.UNINSTALLED_WITHOUT_RESTART) {
                    this.myInstallButton = this.createInstallButton();
                    this.myLayout.addButtonComponent(this.myInstallButton);
                    this.myInstallButton.setVisible(true);
                    this.myInstallButton.setEnabled(false, IdeBundle.message((String)"plugins.configurable.uninstalled", (Object[])new Object[0]));
                    this.myAfterUpdate = true;
                } else {
                    this.myRestartButton = new RestartButton(this.myModelFacade);
                    this.myLayout.addButtonComponent(this.myRestartButton);
                    this.myModelFacade.addUninstalled(this.myPlugin.getPluginId());
                }
            } else if (installationState2.getStatus() == PluginStatus.INSTALLED_AND_REQUIRED_RESTART || installationState2.getStatus() == PluginStatus.UPDATED_WITH_RESTART) {
                this.myRestartButton = new RestartButton(this.myModelFacade);
                this.myLayout.addButtonComponent(this.myRestartButton);
            } else {
                this.createEnableDisableButton(this::getPluginModel);
                this.updateEnabledStateUI();
            }
            this.myAlignButton = new JComponent(){

                @Override
                public Dimension getPreferredSize() {
                    return ListPluginComponent.this.myEnableDisableButton instanceof JCheckBox ? ListPluginComponent.this.myEnableDisableButton.getPreferredSize() : super.getPreferredSize();
                }

                @Override
                public boolean isFocusable() {
                    return false;
                }
            };
            this.myLayout.addButtonComponent(this.myAlignButton);
            this.myAlignButton.setOpaque(false);
        }
        try {
            PluginsViewCustomizerKt.getListPluginComponentCustomizer().processCreateButtons(this);
        }
        catch (Exception e2) {
            LOG.error("Error while customizing create buttons", (Throwable)e2);
        }
    }

    @NotNull
    private InstallButton createInstallButton() {
        return new InstallButton(false, this.myPlugin.getRequiresUpgrade());
    }

    private void createEnableDisableButton(@NotNull Supplier<PluginUiModel> modelFunction) {
        if (modelFunction == null) {
            ListPluginComponent.$$$reportNull$$$0(13);
        }
        this.myEnableDisableButton = ListPluginComponent.createEnableDisableButton(__ -> {
            PluginUiModel pluginToSwitch = (PluginUiModel)modelFunction.get();
            PluginEnableDisableAction action2 = this.myModelFacade.getState(this.myPlugin).isDisabled() ? PluginEnableDisableAction.ENABLE_GLOBALLY : PluginEnableDisableAction.DISABLE_GLOBALLY;
            this.myModelFacade.setEnabledState(Collections.singletonList(pluginToSwitch), action2);
        });
        this.myLayout.addButtonComponent(this.myEnableDisableButton);
        this.myEnableDisableButton.setOpaque(false);
        this.myEnableDisableButton.setEnabled(this.myIsDisableAllowed);
        this.myEnableDisableButton.getAccessibleContext().setAccessibleName(IdeBundle.message((String)"plugins.configurable.enable.checkbox.accessible.name", (Object[])new Object[0]));
    }

    @NotNull
    private static JCheckBox createEnableDisableButton(final @NotNull ActionListener listener2) {
        if (listener2 == null) {
            ListPluginComponent.$$$reportNull$$$0(14);
        }
        return new JCheckBox(){
            private int myBaseline = -1;
            {
                this.addActionListener(listener2);
            }

            @Override
            public int getBaseline(int width, int height) {
                if (this.myBaseline == -1) {
                    JCheckBox checkBox = new JCheckBox("Foo", true);
                    Dimension size2 = checkBox.getPreferredSize();
                    this.myBaseline = checkBox.getBaseline(size2.width, size2.height) - JBUIScale.scale((int)1);
                }
                return this.myBaseline;
            }

            @Override
            public void setUI(ButtonUI ui) {
                this.myBaseline = -1;
                super.setUI(ui);
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension size2 = super.getPreferredSize();
                return new Dimension(size2.width + JBUIScale.scale((int)8), size2.height + JBUIScale.scale((int)2));
            }
        };
    }

    private void createMetricsPanel() {
        String vendor;
        this.myMetricsPanel = new NonOpaquePanel((LayoutManager)((Object)new TextHorizontalLayout(JBUIScale.scale((int)7))));
        this.myMetricsPanel.setBorder((Border)JBUI.Borders.emptyTop((int)5));
        this.myLayout.addLineComponent(this.myMetricsPanel);
        if (this.myMarketplace) {
            String rating;
            String downloads = PluginUiModelKt.presentableDownloads(this.myPlugin);
            if (downloads != null) {
                this.myDownloads = ListPluginComponent.createRatingLabel(this.myMetricsPanel, downloads, AllIcons.Plugins.Downloads);
            }
            if ((rating = PluginUiModelKt.presentableRating(this.myPlugin)) != null) {
                this.myRating = ListPluginComponent.createRatingLabel(this.myMetricsPanel, rating, AllIcons.Plugins.Rating);
            }
            String version = this.myInstalledDescriptorForMarketplace == null ? "" : this.myInstalledDescriptorForMarketplace.getVersion();
            this.myVersion = ListPluginComponent.createRatingLabel(this.myMetricsPanel, version, null);
            this.myVersion.setVisible(!StringUtil.isEmptyOrSpaces((String)version));
        } else {
            String version;
            String string = version = this.myPlugin.isBundled() ? IdeBundle.message((String)"plugin.status.bundled", (Object[])new Object[0]) : this.myPlugin.getVersion();
            if (!StringUtil.isEmptyOrSpaces((String)version)) {
                this.myVersion = ListPluginComponent.createRatingLabel(this.myMetricsPanel, version, null);
            }
        }
        if (!this.myPlugin.isBundled() && !StringUtil.isEmptyOrSpaces((String)(vendor = StringUtil.defaultIfEmpty((String)Strings.trim((String)this.myPlugin.getVendor()), (String)Strings.trim((String)this.myPlugin.getOrganization()))))) {
            this.myVendor = ListPluginComponent.createRatingLabel(this.myMetricsPanel, "fix_label", vendor, null, null, true);
        }
    }

    private void createTag() {
        List<String> tags = PluginUiModelKt.calculateTags(this.myPlugin);
        String tooltip = null;
        if (this.myIsNotFreeInFreeMode) {
            tags = PlatformUtils.isPyCharmPro() ? Collections.singletonList(Tags.Pro.name()) : Collections.singletonList(Tags.Ultimate.name());
            tooltip = UnavailableWithoutSubscriptionComponent.getHelpTooltip();
        }
        if (!tags.isEmpty()) {
            TagComponent tagComponent = this.createTagComponent(tags.get(0));
            if (tooltip != null) {
                tagComponent.setToolTipText(tooltip);
            }
            this.myLayout.setTagComponent((JComponent)((Object)PluginManagerConfigurable.setTinyFont(tagComponent)));
        }
    }

    @NotNull
    private TagComponent createTagComponent(@Nls @NotNull String tag) {
        if (tag == null) {
            ListPluginComponent.$$$reportNull$$$0(15);
        }
        TagComponent component2 = new TagComponent(tag);
        component2.setListener(this.mySearchListener, (Object)component2);
        TagComponent tagComponent = component2;
        if (tagComponent == null) {
            ListPluginComponent.$$$reportNull$$$0(16);
        }
        return tagComponent;
    }

    private void setTagTooltip(@Nullable @Nls String text2) {
        if (this.myLayout.myTagComponent != null) {
            this.myLayout.myTagComponent.setToolTipText(text2);
        }
    }

    private void createLicensePanel() {
        String productCode = this.myPlugin.getProductCode();
        LicensingFacade instance = LicensingFacade.getInstance();
        if (this.myMarketplace || productCode == null || instance == null || this.myPlugin.isBundled() || LicensePanel.isEA2Product(productCode)) {
            return;
        }
        LicensePanel licensePanel = new LicensePanel(true);
        String stamp = instance.getConfirmationStamp(productCode);
        if (stamp == null) {
            if (ApplicationManager.getApplication().isEAP() && !Arrays.asList("release", "true").contains(System.getProperty("eap.require.license"))) {
                this.setTagTooltip(IdeBundle.message((String)"label.text.plugin.eap.license.not.required", (Object[])new Object[0]));
                return;
            }
            if (this.myPlugin.isLicenseOptional()) {
                return;
            }
            licensePanel.setText(IdeBundle.message((String)"label.text.plugin.no.license", (Object[])new Object[0]), true, false);
        } else {
            licensePanel.setTextFromStamp(stamp, instance.getExpirationDate(productCode));
        }
        this.setTagTooltip(licensePanel.getMessage());
        if (licensePanel.isNotification()) {
            licensePanel.setBorder((Border)JBUI.Borders.emptyTop((int)3));
            this.myLayout.addLineComponent((JComponent)((Object)licensePanel));
            this.myLicensePanel = licensePanel;
        }
    }

    public void setOnlyUpdateMode(@Nullable PluginUiModel installedPlugin) {
        this.myOnlyUpdateMode = true;
        this.removeButtons(false);
        this.myChooseUpdateButton = new JCheckBox((String)null, true);
        this.myLayout.setCheckBoxComponent(this.myChooseUpdateButton);
        this.myChooseUpdateButton.setOpaque(false);
        this.myChooseUpdateButton.getAccessibleContext().setAccessibleName(IdeBundle.message((String)"plugins.configurable.choose.update.checkbox.accessible.name", (Object[])new Object[0]));
        if (installedPlugin != null) {
            if (this.myDownloads != null) {
                this.myMetricsPanel.remove(this.myDownloads);
            }
            if (this.myRating != null) {
                this.myMetricsPanel.remove(this.myRating);
            }
            if (this.myVendor != null) {
                this.myMetricsPanel.remove(this.myVendor);
            }
            if (this.myVersion != null) {
                this.myMetricsPanel.remove(this.myVersion);
            }
            String version = NewUiUtil.getUpdateVersionText(installedPlugin.getVersion(), this.myPlugin.getVersion());
            String size2 = PluginUiModelKt.presentableSize(this.myPlugin);
            this.myVersion = ListPluginComponent.createRatingLabel(this.myMetricsPanel, null, (String)(size2 != null ? version + " | " + size2 : version), null, null, false);
        }
        this.updateColors(EventHandler.SelectionType.NONE);
    }

    public JCheckBox getChooseUpdateButton() {
        return this.myChooseUpdateButton;
    }

    @Deprecated
    public void setUpdateDescriptor(@Nullable IdeaPluginDescriptor descriptor) {
        this.setUpdateDescriptor(descriptor == null ? null : new PluginUiModelAdapter(descriptor));
    }

    public void setUpdateDescriptor(@Nullable PluginUiModel descriptor) {
        if (this.myMarketplace && this.myInstalledDescriptorForMarketplace == null || descriptor != null && this.myModelFacade.isUninstalled(descriptor.getPluginId())) {
            return;
        }
        if (this.myUpdateDescriptor == null && descriptor == null) {
            return;
        }
        if (this.myIndicator != null || this.isRestartEnabled()) {
            return;
        }
        this.myUpdateDescriptor = descriptor;
        PluginUiModel plugin = this.getDescriptorForActions();
        if (this.myUpdateDescriptor == null) {
            if (this.myVersion != null) {
                this.myVersion.setText(plugin.getVersion());
            }
            if (this.myUpdateLicensePanel != null) {
                this.myLayout.removeLineComponent((JComponent)((Object)this.myUpdateLicensePanel));
                this.myUpdateLicensePanel = null;
            }
            if (this.myUpdateButton != null) {
                this.myUpdateButton.setVisible(false);
            }
            if (this.myAlignButton != null) {
                this.myAlignButton.setVisible(false);
            }
        } else {
            if (this.myVersion != null) {
                this.myVersion.setText(NewUiUtil.getUpdateVersionText(plugin.getVersion(), this.myUpdateDescriptor.getVersion()));
            }
            if (!(plugin.getProductCode() != null || this.myUpdateDescriptor.getProductCode() == null || plugin.isBundled() || LicensePanel.isEA2Product(this.myUpdateDescriptor.getProductCode()) || LicensePanel.shouldSkipPluginLicenseDescriptionPublishing(this.myUpdateDescriptor))) {
                if (this.myUpdateLicensePanel == null) {
                    this.myUpdateLicensePanel = new LicensePanel(true);
                    this.myLayout.addLineComponent((JComponent)((Object)this.myUpdateLicensePanel));
                    this.myUpdateLicensePanel.setBorder((Border)JBUI.Borders.emptyTop((int)3));
                    this.myUpdateLicensePanel.setVisible(this.myErrorPanel == null);
                    if (this.myEventHandler != null) {
                        this.myEventHandler.addAll((Component)((Object)this.myUpdateLicensePanel));
                    }
                }
                this.myUpdateLicensePanel.showBuyPluginWithText(IdeBundle.message((String)"label.next.plugin.version.is", (Object[])new Object[0]), true, false, () -> this.myUpdateDescriptor, true, true);
            }
            if (this.myUpdateButton == null) {
                this.myUpdateButton = new UpdateButton();
                this.myLayout.addButtonComponent(this.myUpdateButton, 0);
                this.myUpdateButton.addActionListener(e -> this.updatePlugin(plugin));
            } else {
                this.myUpdateButton.setEnabled(true);
                this.myUpdateButton.setVisible(true);
            }
            if (this.myAlignButton != null) {
                this.myAlignButton.setVisible(this.myEnableDisableButton != null && !this.myEnableDisableButton.isVisible());
            }
        }
        this.doLayout();
    }

    public void setListeners(@NotNull EventHandler eventHandler) {
        if (eventHandler == null) {
            ListPluginComponent.$$$reportNull$$$0(17);
        }
        this.myEventHandler = eventHandler;
        eventHandler.addAll(this);
    }

    void updateColors(@NotNull EventHandler.SelectionType type) {
        if (type == null) {
            ListPluginComponent.$$$reportNull$$$0(18);
        }
        this.updateColors(GRAY_COLOR, type == EventHandler.SelectionType.NONE ? PluginManagerConfigurable.MAIN_BG_COLOR : (type == EventHandler.SelectionType.HOVER ? HOVER_COLOR : SELECTION_COLOR));
    }

    private void updateColors(@NotNull Color grayedFg, @NotNull Color background) {
        Color color;
        if (grayedFg == null) {
            ListPluginComponent.$$$reportNull$$$0(19);
        }
        if (background == null) {
            ListPluginComponent.$$$reportNull$$$0(20);
        }
        this.setBackground(background);
        Color nameForeground = null;
        Color otherForeground = grayedFg;
        boolean calcColor = true;
        if (this.mySelection != EventHandler.SelectionType.NONE && (color = UIManager.getColor("Plugins.selectionForeground")) != null) {
            nameForeground = otherForeground = color;
            calcColor = false;
        }
        if (calcColor && !this.myIsAvailable) {
            calcColor = false;
            nameForeground = otherForeground = DisabledColor;
        }
        if (calcColor && (!this.myMarketplace || this.myInstalledDescriptorForMarketplace != null)) {
            boolean disabled;
            PluginUiModel plugin = this.getDescriptorForActions();
            boolean bl = disabled = this.myModelFacade.isUninstalled(plugin.getPluginId()) || !this.myModelFacade.isPluginInstallingOrUpdating(this.myPlugin) && !this.isEnabledState();
            if (disabled) {
                nameForeground = otherForeground = DisabledColor;
            }
        }
        this.myNameComponent.setHorizontalTextPosition(2);
        this.myNameComponent.setForeground(nameForeground);
        if (this.myRating != null) {
            this.myRating.setForeground(otherForeground);
        }
        if (this.myDownloads != null) {
            this.myDownloads.setForeground(otherForeground);
        }
        if (this.myVersion != null) {
            this.myVersion.setForeground(otherForeground);
        }
        if (this.myVendor != null) {
            this.myVendor.setForeground(otherForeground);
        }
    }

    public void updateErrors(List<? extends HtmlChunk> errors) {
        PluginUiModel plugin = this.getDescriptorForActions();
        boolean hasErrors2 = !errors.isEmpty() && !this.myIsNotFreeInFreeMode;
        this.updateIcon(hasErrors2, this.myModelFacade.isUninstalled(plugin.getPluginId()) || !this.isEnabledState() || !this.myIsAvailable);
        if (this.myAlignButton != null) {
            this.myAlignButton.setVisible(this.myRestartButton != null || this.myAfterUpdate);
        }
        if (hasErrors2) {
            boolean addListeners2;
            boolean bl = addListeners2 = this.myErrorComponent == null && this.myEventHandler != null;
            if (this.myErrorPanel == null) {
                this.myErrorPanel = new NonOpaquePanel();
                this.myLayout.addLineComponent(this.myErrorPanel);
            }
            if (this.myErrorComponent == null) {
                this.myErrorComponent = new ErrorComponent();
                this.myErrorComponent.setBorder((Border)JBUI.Borders.emptyTop((int)5));
                this.myErrorPanel.add((Component)this.myErrorComponent, "Center");
            }
            this.myErrorComponent.setErrors(errors, () -> this.myModelFacade.enableRequiredPluginsAsync(plugin));
            if (addListeners2) {
                this.myEventHandler.addAll(this.myErrorPanel);
            }
        } else if (this.myErrorPanel != null) {
            this.myLayout.removeLineComponent(this.myErrorPanel);
            this.myErrorPanel = null;
            this.myErrorComponent = null;
        }
        if (this.myLicensePanel != null) {
            this.myLicensePanel.setVisible(!hasErrors2 && !this.myIsNotFreeInFreeMode);
        }
        if (this.myUpdateLicensePanel != null) {
            this.myUpdateLicensePanel.setVisible(!hasErrors2 && !this.myIsNotFreeInFreeMode);
        }
    }

    @Deprecated(forRemoval=true)
    public void updateErrors() {
        PluginUiModel plugin = this.getDescriptorForActions();
        if (this.myOnlyUpdateMode) {
            this.updateErrors(List.of());
        } else {
            PluginModelAsyncOperationsExecutor.INSTANCE.updateErrors(this.myModelFacade.getModel().getSessionId(), plugin.getPluginId(), (Function1<? super List<? extends HtmlChunk>, Unit>)((Function1)res -> {
                this.updateErrors((List<? extends HtmlChunk>)res);
                return null;
            }));
        }
    }

    private void updatePlugin(PluginUiModel plugin) {
        PluginModelAsyncOperationsExecutor.INSTANCE.updatePlugin(this.myCoroutineScope, this.myModelFacade, plugin, this.myUpdateDescriptor, this.myCustomizer, ModalityState.stateForComponent((Component)this.myUpdateButton), this);
    }

    private void updateIcon(boolean errors, boolean disabled) {
        this.myIconComponent.setIcon(this.myModelFacade.getIcon(this.myPlugin, false, errors, disabled));
    }

    public void showProgress() {
        this.showProgress(true);
    }

    private void showProgress(boolean repaint) {
        if (this.succesefullyFinishedOnce) {
            return;
        }
        this.myIndicator = new AbstractProgressIndicatorExBase();
        this.myLayout.setProgressComponent((JComponent)new AsyncProcessIcon("PluginListComponentIconProgress"){

            public int getBaseline(int width, int height) {
                return (int)((double)height * 0.85);
            }

            public void removeNotify() {
                super.removeNotify();
                if (!this.isDisposed()) {
                    this.dispose();
                }
            }
        });
        PluginModelFacade.addProgress(this.getDescriptorForActions(), this.myIndicator);
        if (repaint) {
            this.fullRepaint();
        }
    }

    public void hideProgress() {
        if (this.succesefullyFinishedOnce) {
            return;
        }
        this.myIndicator = null;
        this.myLayout.removeProgressComponent();
    }

    public void pluginInstalled(boolean success2, boolean restartRequired, PluginUiModel installedPlugin) {
        if (success2) {
            this.succesefullyFinishedOnce = true;
            if (restartRequired) {
                this.enableRestart();
            } else {
                if (this.myInstallButton != null) {
                    this.myInstallButton.setEnabled(false, IdeBundle.message((String)"plugin.status.installed", (Object[])new Object[0]));
                    if (this.myInstallButton.isVisible()) {
                        this.myInstalledDescriptorForMarketplace = installedPlugin;
                        if (this.myInstalledDescriptorForMarketplace != null) {
                            if (this.myMarketplace) {
                                this.myInstallButton.setVisible(false);
                                this.myEnableDisableButton.setVisible(true);
                                this.myVersion.setText(this.myInstalledDescriptorForMarketplace.getVersion());
                                this.myVersion.setVisible(true);
                                this.updateEnabledStateUI();
                                this.fullRepaint();
                            } else {
                                this.myPlugin = this.myInstalledDescriptorForMarketplace;
                                this.myInstalledDescriptorForMarketplace = null;
                                this.updateButtons(installedPlugin, new PluginInstallationState(true, PluginStatus.INSTALLED_WITHOUT_RESTART));
                            }
                            return;
                        }
                    }
                }
                if (this.myUpdateButton != null) {
                    this.myUpdateButton.setEnabled(false);
                    this.myUpdateButton.setText(IdeBundle.message((String)"plugin.status.installed", (Object[])new Object[0]));
                    this.myAfterUpdate = true;
                }
                if (this.myEnableDisableButton != null) {
                    this.myLayout.removeButtonComponent(this.myEnableDisableButton);
                    this.myEnableDisableButton = null;
                    if (this.myAlignButton != null) {
                        this.myAlignButton.setVisible(true);
                    }
                }
            }
        }
        this.fullRepaint();
    }

    public void clearProgress() {
        this.myIndicator = null;
    }

    public void enableRestart() {
        this.removeButtons(true);
    }

    private void removeButtons(boolean showRestart) {
        if (this.myInstallButton != null) {
            this.myLayout.removeButtonComponent(this.myInstallButton);
            this.myInstallButton = null;
        }
        if (this.myUpdateButton != null) {
            this.myLayout.removeButtonComponent(this.myUpdateButton);
            this.myUpdateButton = null;
        }
        if (this.myEnableDisableButton != null) {
            this.myLayout.removeButtonComponent(this.myEnableDisableButton);
            this.myEnableDisableButton = null;
        }
        if (this.myIsAvailable && showRestart && this.myRestartButton == null) {
            this.myRestartButton = new RestartButton(this.myModelFacade);
            this.myLayout.addButtonComponent(this.myRestartButton, 0);
        }
        if (this.myAlignButton != null) {
            this.myAlignButton.setVisible(true);
        }
        try {
            PluginsViewCustomizerKt.getListPluginComponentCustomizer().processRemoveButtons(this);
        }
        catch (Exception e) {
            LOG.error("Error while customizing remove buttons", (Throwable)e);
        }
    }

    public void updateButtons(PluginUiModel installedPlugin, PluginInstallationState state2) {
        if (this.myIsAvailable) {
            this.removeButtons(false);
            if (this.myRestartButton != null) {
                this.myLayout.removeButtonComponent(this.myRestartButton);
                this.myRestartButton = null;
            }
            if (this.myAlignButton != null) {
                this.myLayout.removeButtonComponent(this.myAlignButton);
                this.myAlignButton = null;
            }
            this.myAfterUpdate = false;
            this.createButtons(installedPlugin, state2);
            if (this.myUpdateDescriptor != null) {
                this.setUpdateDescriptor(this.myUpdateDescriptor);
            }
            this.doUpdateEnabledState();
        }
    }

    public void updateEnabledState() {
        if (this.myMarketplace && this.myInstalledDescriptorForMarketplace == null) {
            return;
        }
        this.doUpdateEnabledState();
    }

    private void doUpdateEnabledState() {
        if (!this.myModelFacade.isUninstalled(this.getDescriptorForActions().getPluginId())) {
            this.updateEnabledStateUI();
        }
        this.updateErrors();
        this.setSelection(this.mySelection, false);
        try {
            PluginsViewCustomizerKt.getListPluginComponentCustomizer().processUpdateEnabledState(this);
        }
        catch (Exception e) {
            LOG.error("Error while customizing enabled state", (Throwable)e);
        }
    }

    private void updateEnabledStateUI() {
        if (this.myEnableDisableButton instanceof JCheckBox) {
            ((JCheckBox)this.myEnableDisableButton).setSelected(this.myModelFacade.isEnabled(this.getDescriptorForActions()) && !this.myIsNotFreeInFreeMode);
        }
    }

    public void updateAfterUninstall(boolean needRestartForUninstall, PluginInstallationState pluginInstallationState) {
        this.myModelFacade.addUninstalled(this.getDescriptorForActions().getPluginId());
        this.updateColors(this.mySelection);
        this.removeButtons(needRestartForUninstall);
        if (!needRestartForUninstall && pluginInstallationState.getStatus() == PluginStatus.UNINSTALLED_WITHOUT_RESTART) {
            this.myInstallButton = this.createInstallButton();
            this.myLayout.addButtonComponent(this.myInstallButton);
            this.myInstallButton.setEnabled(false, IdeBundle.message((String)"plugins.configurable.uninstalled", (Object[])new Object[0]));
        }
    }

    public void updatePlugin() {
        if ((!this.myMarketplace || this.myInstalledDescriptorForMarketplace == null) && this.myUpdateButton != null && this.myUpdateButton.isVisible() && this.myUpdateButton.isEnabled()) {
            this.myUpdateButton.doClick();
        }
    }

    private boolean isEnabledState() {
        return this.myModelFacade.isEnabled(this.getDescriptorForActions()) && !this.myIsNotFreeInFreeMode;
    }

    public boolean isMarketplace() {
        return this.myMarketplace;
    }

    boolean isNotFreeInFreeMode() {
        return this.myIsNotFreeInFreeMode;
    }

    public boolean isDisableAllowed() {
        return this.myIsDisableAllowed;
    }

    public boolean isRestartEnabled() {
        return this.myRestartButton != null && this.myRestartButton.isVisible();
    }

    public boolean isUpdatedWithoutRestart() {
        return this.myUpdateButton != null && this.myUpdateButton.isVisible() && !this.myUpdateButton.isEnabled();
    }

    public boolean underProgress() {
        return this.myIndicator != null;
    }

    public void close() {
        if (this.myIndicator != null) {
            PluginModelFacade.removeProgress(this.getDescriptorForActions(), this.myIndicator);
            this.myIndicator = null;
        }
        this.myModelFacade.removeComponent(this);
    }

    public void createPopupMenu(@NotNull DefaultActionGroup group2, @NotNull List<ListPluginComponent> selection) {
        if (group2 == null) {
            ListPluginComponent.$$$reportNull$$$0(21);
        }
        if (selection == null) {
            ListPluginComponent.$$$reportNull$$$0(22);
        }
        if (selection.isEmpty()) {
            return;
        }
        if (!this.myIsAvailable) {
            return;
        }
        if (this.myOnlyUpdateMode) {
            return;
        }
        for (ListPluginComponent listPluginComponent : selection) {
            if (!this.myModelFacade.isPluginInstallingOrUpdating(listPluginComponent.myPlugin) && !listPluginComponent.myAfterUpdate) continue;
            return;
        }
        boolean restart = true;
        for (ListPluginComponent component3 : selection) {
            if (component3.myRestartButton != null) continue;
            restart = false;
            break;
        }
        if (restart) {
            group2.add((AnAction)new ButtonAnAction(selection.get((int)0).myRestartButton));
            return;
        }
        int n = selection.size();
        boolean getDescriptorFunction = true;
        if (this.myMarketplace) {
            JButton[] installButtons = new JButton[n];
            int installCount = 0;
            int installedCount = 0;
            for (int i2 = 0; i2 < n; ++i2) {
                ListPluginComponent component4 = selection.get(i2);
                InstallButton button2 = component4.myInstallButton;
                if (button2 != null && button2.isVisible() && button2.isEnabled()) {
                    installButtons[i2] = button2;
                    ++installCount;
                    continue;
                }
                if (component4.myInstalledDescriptorForMarketplace != null) {
                    ++installedCount;
                    continue;
                }
                return;
            }
            if (installCount == n) {
                group2.add((AnAction)new ButtonAnAction(installButtons));
                return;
            }
            if (installedCount != n) {
                return;
            }
            getDescriptorFunction = false;
        }
        JButton[] updateButtons2 = new JButton[n];
        for (int i3 = 0; i3 < n; ++i3) {
            JButton button3 = selection.get((int)i3).myUpdateButton;
            if (button3 == null || !button3.isVisible() || !button3.isEnabled()) {
                updateButtons2 = null;
                break;
            }
            updateButtons2[i3] = button3;
        }
        if (updateButtons2 != null) {
            group2.add((AnAction)new ButtonAnAction(updateButtons2));
            if (n > 1) {
                return;
            }
        }
        Function<ListPluginComponent, PluginUiModel> function = getDescriptorFunction ? ListPluginComponent::getPluginModel : ListPluginComponent::getInstalledDescriptorForMarketplace;
        SelectionBasedPluginModelAction.addActionsTo(group2, action2 -> this.createEnableDisableAction((PluginEnableDisableAction)((Object)((Object)action2)), (List<? extends ListPluginComponent>)selection, (Function<? super ListPluginComponent, PluginUiModel>)function), () -> this.createUninstallAction(selection, function));
    }

    /*
     * WARNING - void declaration
     */
    public void handleKeyAction(@NotNull KeyEvent event, @NotNull List<ListPluginComponent> selection) {
        if (event == null) {
            ListPluginComponent.$$$reportNull$$$0(23);
        }
        if (selection == null) {
            ListPluginComponent.$$$reportNull$$$0(24);
        }
        if (selection.isEmpty()) {
            return;
        }
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (event.getKeyCode() == 32 && !(focusOwner instanceof ListPluginComponent)) {
            return;
        }
        if (this.myOnlyUpdateMode) {
            if (event.getKeyCode() == 32) {
                for (ListPluginComponent listPluginComponent : selection) {
                    listPluginComponent.myChooseUpdateButton.doClick();
                }
            }
            return;
        }
        for (ListPluginComponent listPluginComponent : selection) {
            if (!this.myModelFacade.isPluginInstallingOrUpdating(listPluginComponent.myPlugin) && !listPluginComponent.myAfterUpdate) continue;
            return;
        }
        boolean restart = true;
        for (ListPluginComponent component4 : selection) {
            if (component4.myRestartButton != null) continue;
            restart = false;
            break;
        }
        boolean bl = true;
        int keyCode = event.getKeyCode();
        if (this.myMarketplace) {
            if (keyCode == 10) {
                if (restart) {
                    selection.get((int)0).myRestartButton.doClick();
                }
                int installCount = 0;
                int installedCount = 0;
                for (ListPluginComponent listPluginComponent : selection) {
                    InstallButton button2 = listPluginComponent.myInstallButton;
                    if (button2 != null && button2.isVisible() && button2.isEnabled()) {
                        ++installCount;
                        continue;
                    }
                    if (listPluginComponent.myInstalledDescriptorForMarketplace != null) {
                        ++installedCount;
                        continue;
                    }
                    return;
                }
                int size2 = selection.size();
                if (installCount == size2) {
                    for (ListPluginComponent component6 : selection) {
                        component6.myInstallButton.doClick();
                    }
                    return;
                }
                if (installedCount != size2) {
                    return;
                }
                boolean bl2 = false;
            } else if (keyCode == 32 || keyCode == EventHandler.DELETE_CODE) {
                int installedCount = 0;
                for (ListPluginComponent component7 : selection) {
                    if (component7.myInstalledDescriptorForMarketplace != null) {
                        ++installedCount;
                        continue;
                    }
                    return;
                }
                if (installedCount != selection.size()) {
                    return;
                }
                boolean bl3 = false;
            } else {
                return;
            }
        }
        boolean update2 = true;
        for (ListPluginComponent component8 : selection) {
            JButton jButton = component8.myUpdateButton;
            if (jButton != null && jButton.isVisible() && jButton.isEnabled()) continue;
            update2 = false;
            break;
        }
        if (keyCode == 10) {
            if (restart) {
                selection.get((int)0).myRestartButton.doClick();
            } else if (update2) {
                for (ListPluginComponent component9 : selection) {
                    component9.myUpdateButton.doClick();
                }
            }
        } else if (!restart && !update2) {
            SelectionBasedPluginModelAction.EnableDisableAction<ListPluginComponent> action2;
            void var5_13;
            Function<ListPluginComponent, PluginUiModel> function;
            Function<ListPluginComponent, PluginUiModel> function2 = function = var5_13 != false ? ListPluginComponent::getPluginModel : ListPluginComponent::getInstalledDescriptorForMarketplace;
            if (keyCode == 32 && event.getModifiersEx() == 0) {
                action2 = this.createEnableDisableAction(this.getEnableDisableAction(selection), selection, function);
            } else if (keyCode == EventHandler.DELETE_CODE) {
                UninstallAction<ListPluginComponent> action22 = this.createUninstallAction(selection, function);
            } else {
                return;
            }
            ActionManager.getInstance().tryToExecute(action2, (InputEvent)event, (Component)this, "unknown", true);
        }
    }

    private void fullRepaint() {
        Container parent = this.getParent();
        parent.doLayout();
        parent.revalidate();
        parent.repaint();
    }

    @Deprecated
    @NotNull
    public IdeaPluginDescriptor getPluginDescriptor() {
        IdeaPluginDescriptor ideaPluginDescriptor = this.myPlugin.getDescriptor();
        if (ideaPluginDescriptor == null) {
            ListPluginComponent.$$$reportNull$$$0(25);
        }
        return ideaPluginDescriptor;
    }

    public PluginUiModel getPluginModel() {
        return this.myPlugin;
    }

    public PluginUiModel getInstalledDescriptorForMarketplace() {
        return this.myInstalledDescriptorForMarketplace;
    }

    public PluginUiModel getUpdatePluginDescriptor() {
        return this.myUpdateDescriptor != null ? this.myUpdateDescriptor : null;
    }

    public PluginUiModel getDescriptorForActions() {
        return !this.myMarketplace || this.myInstalledDescriptorForMarketplace == null ? this.myPlugin : this.myInstalledDescriptorForMarketplace;
    }

    public void setPluginModel(@NotNull PluginUiModel pluginModel) {
        if (pluginModel == null) {
            ListPluginComponent.$$$reportNull$$$0(26);
        }
        this.myPlugin = pluginModel;
    }

    @Nullable
    public synchronized PluginUiModel getInstalledPluginMarketplaceModel() {
        return this.myInstalledPluginMarketplaceNode;
    }

    public synchronized void setInstalledPluginMarketplaceModel(@NotNull PluginUiModel model2) {
        if (model2 == null) {
            ListPluginComponent.$$$reportNull$$$0(27);
        }
        this.myInstalledPluginMarketplaceNode = model2;
    }

    @NotNull
    private PluginEnableDisableAction getEnableDisableAction(@NotNull List<? extends ListPluginComponent> selection) {
        Iterator<? extends ListPluginComponent> iterator;
        BooleanSupplier isGloballyEnabledGenerator;
        boolean firstDisabled;
        if (selection == null) {
            ListPluginComponent.$$$reportNull$$$0(28);
        }
        boolean bl = firstDisabled = !(isGloballyEnabledGenerator = () -> this.lambda$getEnableDisableAction$10(iterator = selection.iterator())).getAsBoolean();
        while (iterator.hasNext()) {
            if (firstDisabled != isGloballyEnabledGenerator.getAsBoolean()) continue;
            PluginEnableDisableAction pluginEnableDisableAction = PluginEnableDisableAction.ENABLE_GLOBALLY;
            if (pluginEnableDisableAction == null) {
                ListPluginComponent.$$$reportNull$$$0(29);
            }
            return pluginEnableDisableAction;
        }
        PluginEnableDisableAction pluginEnableDisableAction = PluginEnableDisableAction.globally(firstDisabled);
        if (pluginEnableDisableAction == null) {
            ListPluginComponent.$$$reportNull$$$0(30);
        }
        return pluginEnableDisableAction;
    }

    @NotNull
    private SelectionBasedPluginModelAction.EnableDisableAction<ListPluginComponent> createEnableDisableAction(@NotNull PluginEnableDisableAction action2, @NotNull List<? extends ListPluginComponent> selection, final @NotNull Function<? super ListPluginComponent, PluginUiModel> function) {
        if (action2 == null) {
            ListPluginComponent.$$$reportNull$$$0(31);
        }
        if (selection == null) {
            ListPluginComponent.$$$reportNull$$$0(32);
        }
        if (function == null) {
            ListPluginComponent.$$$reportNull$$$0(33);
        }
        PluginModelFacade model2 = this.myModelFacade;
        if (this.myIsNotFreeInFreeMode) {
            model2 = new PluginModelFacade(model2.getModel()){

                @Override
                @NotNull
                public PluginEnabledState getState(@NotNull PluginUiModel model2) {
                    if (model2 == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    if (model2 == function.apply(ListPluginComponent.this)) {
                        PluginEnabledState pluginEnabledState = PluginEnabledState.DISABLED;
                        if (pluginEnabledState == null) {
                            4.$$$reportNull$$$0(1);
                        }
                        return pluginEnabledState;
                    }
                    PluginEnabledState pluginEnabledState = super.getState(model2);
                    if (pluginEnabledState == null) {
                        4.$$$reportNull$$$0(2);
                    }
                    return pluginEnabledState;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 1, 2 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "model";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/ide/plugins/newui/ListPluginComponent$4";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/ide/plugins/newui/ListPluginComponent$4";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getState";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "getState";
                            break;
                        }
                        case 1: 
                        case 2: {
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 1, 2 -> new IllegalStateException(string);
                    };
                }
            };
        }
        return new SelectionBasedPluginModelAction.EnableDisableAction<ListPluginComponent>(model2, action2, true, selection, function, () -> {});
    }

    @NotNull
    private UninstallAction<ListPluginComponent> createUninstallAction(@NotNull List<ListPluginComponent> selection, @NotNull Function<ListPluginComponent, PluginUiModel> function) {
        if (selection == null) {
            ListPluginComponent.$$$reportNull$$$0(34);
        }
        if (function == null) {
            ListPluginComponent.$$$reportNull$$$0(35);
        }
        return new UninstallAction<ListPluginComponent>(this.myCoroutineScope, this.myModelFacade, true, this, selection, function, () -> {});
    }

    @NotNull
    static JLabel createRatingLabel(@NotNull JPanel panel2, @NotNull @Nls String text2, @Nullable Icon icon2) {
        if (panel2 == null) {
            ListPluginComponent.$$$reportNull$$$0(36);
        }
        if (text2 == null) {
            ListPluginComponent.$$$reportNull$$$0(37);
        }
        return ListPluginComponent.createRatingLabel(panel2, null, text2, icon2, null, true);
    }

    @NotNull
    static JLabel createRatingLabel(@NotNull JPanel panel2, @Nullable Object constraints, @NotNull @Nls String text2, @Nullable Icon icon2, @Nullable Color color, boolean tiny) {
        if (panel2 == null) {
            ListPluginComponent.$$$reportNull$$$0(38);
        }
        if (text2 == null) {
            ListPluginComponent.$$$reportNull$$$0(39);
        }
        JLabel label2 = new JLabel(text2, icon2, 0);
        label2.setOpaque(false);
        label2.setIconTextGap(2);
        if (color != null) {
            label2.setForeground(color);
        }
        panel2.add((Component)(tiny ? PluginManagerConfigurable.setTinyFont(label2) : label2), constraints);
        JLabel jLabel = label2;
        if (jLabel == null) {
            ListPluginComponent.$$$reportNull$$$0(40);
        }
        return jLabel;
    }

    @NotNull
    List<JComponent> getFocusableComponents() {
        ArrayList<JComponent> components = new ArrayList<JComponent>();
        if (UIUtil.isFocusable((Component)this.myLayout.myCheckBoxComponent)) {
            components.add(this.myLayout.myCheckBoxComponent);
        }
        components.addAll(ContainerUtil.filter(this.myLayout.myButtonComponents, UIUtil::isFocusable));
        ArrayList<JComponent> arrayList = components;
        if (arrayList == null) {
            ListPluginComponent.$$$reportNull$$$0(41);
        }
        return arrayList;
    }

    private boolean isInstalledAndEnabled(PluginInstallationState pluginInstallationState) {
        return pluginInstallationState.getFullyInstalled() && !this.myModelFacade.getState(this.myPlugin).isDisabled();
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleListPluginComponent();
        }
        return this.accessibleContext;
    }

    private /* synthetic */ boolean lambda$getEnableDisableAction$10(Iterator iterator) {
        return this.myModelFacade.getState(((ListPluginComponent)iterator.next()).getPluginModel()) == PluginEnabledState.ENABLED;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 16, 25, 29, 30, 40, 41 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginModelFacade";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginUiModel";
                break;
            }
            case 2: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listModel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchListener";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coroutineScope";
                break;
            }
            case 6: 
            case 7: 
            case 16: 
            case 25: 
            case 29: 
            case 30: 
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/newui/ListPluginComponent";
                break;
            }
            case 8: 
            case 9: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bounds";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelFunction";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventHandler";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grayedFg";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "background";
                break;
            }
            case 22: 
            case 24: 
            case 28: 
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginModel";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/newui/ListPluginComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroup";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelection";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createTagComponent";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginDescriptor";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnableDisableAction";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "createRatingLabel";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getFocusableComponents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 16: 
            case 25: 
            case 29: 
            case 30: 
            case 40: 
            case 41: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setSelection";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "onSelection";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "scrollToVisible";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createEnableDisableButton";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createTagComponent";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setListeners";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "updateColors";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createPopupMenu";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "handleKeyAction";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "setPluginModel";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "setInstalledPluginMarketplaceModel";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getEnableDisableAction";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createEnableDisableAction";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "createUninstallAction";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "createRatingLabel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 16, 25, 29, 30, 40, 41 -> new IllegalStateException(string);
        };
    }

    private final class BaselineLayout
    extends AbstractLayoutManager {
        private final JBValue myHGap = new JBValue.Float(10.0f);
        private final JBValue myHOffset = new JBValue.Float(8.0f);
        private final JBValue myButtonOffset = new JBValue.Float(6.0f);
        private JComponent myIconComponent;
        private JLabel myNameComponent;
        private JComponent myProgressComponent;
        private JComponent myTagComponent;
        private JComponent myCheckBoxComponent;
        private final List<JComponent> myButtonComponents = new ArrayList<JComponent>();
        private final List<JComponent> myLineComponents = new ArrayList<JComponent>();
        private boolean[] myButtonEnableStates;

        private BaselineLayout() {
        }

        public Dimension preferredLayoutSize(Container parent) {
            Dimension result2 = new Dimension(this.myNameComponent.getPreferredSize());
            if (this.myProgressComponent == null) {
                int count;
                if (this.myCheckBoxComponent != null) {
                    Dimension size2 = this.myCheckBoxComponent.getPreferredSize();
                    result2.width += size2.width + this.myHOffset.get();
                    result2.height = Math.max(result2.height, size2.height);
                }
                if (this.myTagComponent != null) {
                    Dimension size2 = this.myTagComponent.getPreferredSize();
                    result2.width += size2.width + 2 * this.myHOffset.get();
                    result2.height = Math.max(result2.height, size2.height);
                }
                if ((count = this.myButtonComponents.size()) > 0) {
                    int visibleCount = 0;
                    for (Component component2 : this.myButtonComponents) {
                        if (!component2.isVisible()) continue;
                        Dimension size3 = component2.getPreferredSize();
                        result2.width += size3.width;
                        result2.height = Math.max(result2.height, size3.height);
                        ++visibleCount;
                    }
                    if (visibleCount > 0) {
                        result2.width += this.myHOffset.get();
                        result2.width += (visibleCount - 1) * this.myButtonOffset.get();
                    }
                }
            } else {
                Dimension size4 = this.myProgressComponent.getPreferredSize();
                result2.width += this.myHOffset.get() + size4.width;
                result2.height = Math.max(result2.height, size4.height);
            }
            for (JComponent component3 : this.myLineComponents) {
                if (!component3.isVisible()) continue;
                Dimension size5 = component3.getPreferredSize();
                result2.width = Math.max(result2.width, size5.width);
                result2.height += size5.height;
            }
            Dimension iconSize = this.myIconComponent.getPreferredSize();
            result2.width += iconSize.width + this.myHGap.get();
            result2.height = Math.max(result2.height, iconSize.height);
            JBInsets.addTo((Dimension)result2, (Insets)ListPluginComponent.this.getInsets());
            return result2;
        }

        public void layoutContainer(Container parent) {
            Insets insets = ListPluginComponent.this.getInsets();
            int x = insets.left;
            int y = insets.top;
            if (this.myProgressComponent == null && this.myCheckBoxComponent != null) {
                Dimension size2 = this.myCheckBoxComponent.getPreferredSize();
                this.myCheckBoxComponent.setBounds(x, (parent.getHeight() - size2.height) / 2, size2.width, size2.height);
                x += size2.width + this.myHGap.get();
            }
            Dimension iconSize = this.myIconComponent.getPreferredSize();
            this.myIconComponent.setBounds(x, y, iconSize.width, iconSize.height);
            x += iconSize.width + this.myHGap.get();
            int width20 = JBUIScale.scale((int)20);
            int calcNameWidth = Math.max(width20, this.calculateNameWidth());
            Dimension nameSize = this.myNameComponent.getPreferredSize();
            int baseline = (y += JBUIScale.scale((int)2)) + this.myNameComponent.getBaseline(nameSize.width, nameSize.height);
            this.myNameComponent.setToolTipText(calcNameWidth < nameSize.width ? this.myNameComponent.getText() : null);
            nameSize.width = Math.min(nameSize.width, calcNameWidth);
            this.myNameComponent.setBounds(x, y, nameSize.width, nameSize.height);
            y += nameSize.height;
            int width = ListPluginComponent.this.getWidth();
            if (this.myProgressComponent == null) {
                int nextX = x + nameSize.width + this.myHOffset.get();
                if (this.myTagComponent != null) {
                    Dimension size3 = this.myTagComponent.getPreferredSize();
                    this.setBaselineBounds(nextX, baseline, this.myTagComponent, size3);
                    nextX += size3.width;
                }
                int lastX = width - insets.right;
                if (calcNameWidth > width20) {
                    for (int i2 = this.myButtonComponents.size() - 1; i2 >= 0; --i2) {
                        Component component2 = this.myButtonComponents.get(i2);
                        if (!component2.isVisible()) continue;
                        size = component2.getPreferredSize();
                        this.setBaselineBounds(lastX -= size.width, baseline, component2, size);
                        lastX -= this.myButtonOffset.get();
                    }
                } else {
                    for (JComponent jComponent : this.myButtonComponents) {
                        if (!jComponent.isVisible()) continue;
                        size = jComponent.getPreferredSize();
                        this.setBaselineBounds(nextX, baseline, jComponent, size);
                        nextX += size.width + this.myButtonOffset.get();
                    }
                }
            } else {
                Dimension size4 = this.myProgressComponent.getPreferredSize();
                this.setBaselineBounds(width - size4.width - insets.right, baseline, this.myProgressComponent, size4);
            }
            int lineWidth = width - x - insets.right;
            for (JComponent component3 : this.myLineComponents) {
                if (!component3.isVisible()) continue;
                int n = component3.getPreferredSize().height;
                component3.setBounds(x, y, lineWidth, n);
                y += n;
            }
        }

        private int calculateNameWidth() {
            Insets insets = ListPluginComponent.this.getInsets();
            int width = ListPluginComponent.this.getWidth() - insets.left - insets.right - this.myIconComponent.getPreferredSize().width - this.myHGap.get();
            if (this.myProgressComponent != null) {
                return width - this.myProgressComponent.getPreferredSize().width - this.myHOffset.get();
            }
            if (this.myCheckBoxComponent != null) {
                width -= this.myCheckBoxComponent.getPreferredSize().width + this.myHOffset.get();
            }
            if (this.myTagComponent != null) {
                width -= this.myTagComponent.getPreferredSize().width + 2 * this.myHOffset.get();
            }
            int visibleCount = 0;
            for (Component component2 : this.myButtonComponents) {
                if (!component2.isVisible()) continue;
                width -= component2.getPreferredSize().width;
                ++visibleCount;
            }
            width -= this.myButtonOffset.get() * (visibleCount - 1);
            if (visibleCount > 0) {
                width -= this.myHOffset.get();
            }
            return width;
        }

        private void setBaselineBounds(int x, int y, @NotNull Component component2, @NotNull Dimension size2) {
            if (component2 == null) {
                BaselineLayout.$$$reportNull$$$0(0);
            }
            if (size2 == null) {
                BaselineLayout.$$$reportNull$$$0(1);
            }
            if (component2 instanceof ActionToolbar) {
                component2.setBounds(x, ListPluginComponent.this.getInsets().top - JBUI.scale((int)1), size2.width, size2.height);
            } else {
                component2.setBounds(x, y - component2.getBaseline(size2.width, size2.height), size2.width, size2.height);
            }
        }

        public void setIconComponent(@NotNull JComponent iconComponent) {
            if (iconComponent == null) {
                BaselineLayout.$$$reportNull$$$0(2);
            }
            assert (this.myIconComponent == null);
            this.myIconComponent = iconComponent;
            ListPluginComponent.this.add(iconComponent);
        }

        public void setNameComponent(@NotNull JLabel nameComponent) {
            if (nameComponent == null) {
                BaselineLayout.$$$reportNull$$$0(3);
            }
            assert (this.myNameComponent == null);
            this.myNameComponent = nameComponent;
            ListPluginComponent.this.add(this.myNameComponent);
        }

        public void setTagComponent(@NotNull JComponent component2) {
            if (component2 == null) {
                BaselineLayout.$$$reportNull$$$0(4);
            }
            assert (this.myTagComponent == null);
            this.myTagComponent = component2;
            ListPluginComponent.this.add(this.myTagComponent);
        }

        public void addLineComponent(@NotNull JComponent component2) {
            if (component2 == null) {
                BaselineLayout.$$$reportNull$$$0(5);
            }
            this.myLineComponents.add(component2);
            ListPluginComponent.this.add(component2);
        }

        public void removeLineComponent(@NotNull JComponent component2) {
            if (component2 == null) {
                BaselineLayout.$$$reportNull$$$0(6);
            }
            this.myLineComponents.remove(component2);
            ListPluginComponent.this.remove(component2);
        }

        public void addButtonComponent(@NotNull JComponent component2) {
            if (component2 == null) {
                BaselineLayout.$$$reportNull$$$0(7);
            }
            this.addButtonComponent(component2, -1);
        }

        public void addButtonComponent(@NotNull JComponent component2, int index) {
            if (component2 == null) {
                BaselineLayout.$$$reportNull$$$0(8);
            }
            if (this.myButtonComponents.isEmpty() || index == -1) {
                this.myButtonComponents.add(component2);
            } else {
                this.myButtonComponents.add(index, component2);
            }
            ListPluginComponent.this.add(component2);
            this.updateVisibleOther();
        }

        public void removeButtonComponent(@NotNull JComponent component2) {
            if (component2 == null) {
                BaselineLayout.$$$reportNull$$$0(9);
            }
            this.myButtonComponents.remove(component2);
            ListPluginComponent.this.remove(component2);
            this.updateVisibleOther();
        }

        public void setCheckBoxComponent(@NotNull JComponent checkBoxComponent) {
            if (checkBoxComponent == null) {
                BaselineLayout.$$$reportNull$$$0(10);
            }
            assert (this.myCheckBoxComponent == null);
            this.myCheckBoxComponent = checkBoxComponent;
            ListPluginComponent.this.add(checkBoxComponent);
            ListPluginComponent.this.doLayout();
        }

        public void setProgressComponent(@NotNull JComponent progressComponent) {
            if (progressComponent == null) {
                BaselineLayout.$$$reportNull$$$0(11);
            }
            if (this.myProgressComponent != null) {
                return;
            }
            this.myProgressComponent = progressComponent;
            ListPluginComponent.this.add(progressComponent);
            if (ListPluginComponent.this.myEventHandler != null) {
                ListPluginComponent.this.myEventHandler.addAll(progressComponent);
                ListPluginComponent.this.myEventHandler.updateHover(ListPluginComponent.this);
            }
            this.setVisibleOther(false);
            ListPluginComponent.this.doLayout();
        }

        public void removeProgressComponent() {
            if (this.myProgressComponent == null) {
                return;
            }
            ListPluginComponent.this.remove(this.myProgressComponent);
            this.myProgressComponent = null;
            this.setVisibleOther(true);
            ListPluginComponent.this.doLayout();
        }

        private void updateVisibleOther() {
            if (this.myProgressComponent != null) {
                this.myButtonEnableStates = null;
                this.setVisibleOther(false);
            }
        }

        private void setVisibleOther(boolean value) {
            if (this.myTagComponent != null) {
                this.myTagComponent.setVisible(value);
            }
            if (this.myButtonComponents.isEmpty()) {
                return;
            }
            if (value) {
                assert (this.myButtonEnableStates != null && this.myButtonEnableStates.length == this.myButtonComponents.size());
                int size2 = this.myButtonComponents.size();
                for (int i2 = 0; i2 < size2; ++i2) {
                    this.myButtonComponents.get(i2).setVisible(this.myButtonEnableStates[i2]);
                }
                this.myButtonEnableStates = null;
            } else {
                assert (this.myButtonEnableStates == null);
                this.myButtonEnableStates = new boolean[this.myButtonComponents.size()];
                int size3 = this.myButtonComponents.size();
                for (int i3 = 0; i3 < size3; ++i3) {
                    Component component2 = this.myButtonComponents.get(i3);
                    this.myButtonEnableStates[i3] = component2.isVisible();
                    component2.setVisible(false);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "size";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "iconComponent";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nameComponent";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "checkBoxComponent";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "progressComponent";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/plugins/newui/ListPluginComponent$BaselineLayout";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setBaselineBounds";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setIconComponent";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setNameComponent";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setTagComponent";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addLineComponent";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removeLineComponent";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addButtonComponent";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removeButtonComponent";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setCheckBoxComponent";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setProgressComponent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class PluginIdUiInspectorContextProvider
    implements UiInspectorContextProvider {
        private PluginIdUiInspectorContextProvider() {
        }

        @NotNull
        public List<PropertyBean> getUiInspectorContext() {
            List<PropertyBean> list2 = PluginUtilsKt.getUiInspectorContextFor(ListPluginComponent.this.myPlugin);
            if (list2 == null) {
                PluginIdUiInspectorContextProvider.$$$reportNull$$$0(0);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/newui/ListPluginComponent$PluginIdUiInspectorContextProvider", "getUiInspectorContext"));
        }
    }

    public static final class ButtonAnAction
    extends DumbAwareAction {
        private final JButton[] myButtons;

        ButtonAnAction(JButton ... buttons) {
            if (buttons == null) {
                ButtonAnAction.$$$reportNull$$$0(0);
            }
            super(buttons[0].getText());
            this.myButtons = buttons;
            this.setShortcutSet(CommonShortcuts.ENTER);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ButtonAnAction.$$$reportNull$$$0(1);
            }
            for (JButton button2 : this.myButtons) {
                button2.doClick();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buttons";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/plugins/newui/ListPluginComponent$ButtonAnAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected class AccessibleListPluginComponent
    extends JComponent.AccessibleJComponent {
        protected AccessibleListPluginComponent() {
            super(ListPluginComponent.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibilityUtils.GROUPED_ELEMENTS;
        }

        @Override
        public String getAccessibleDescription() {
            @Nls StringJoiner description = new StringJoiner(", ");
            if (AccessibleListPluginComponent.isNotNullAndVisible(ListPluginComponent.this.myRestartButton)) {
                description.add(IdeBundle.message((String)"plugins.configurable.list.component.accessible.description.restart.pending", (Object[])new Object[0]));
            }
            if (AccessibleListPluginComponent.isNotNullAndVisible(ListPluginComponent.this.myUpdateButton)) {
                if (ListPluginComponent.this.myUpdateButton.isEnabled()) {
                    description.add(IdeBundle.message((String)"plugins.configurable.list.component.accessible.description.update.available", (Object[])new Object[0]));
                } else {
                    description.add(ListPluginComponent.this.myUpdateButton.getText());
                }
            }
            if (AccessibleListPluginComponent.isNotNullAndVisible(ListPluginComponent.this.myEnableDisableButton) && ListPluginComponent.this.myEnableDisableButton instanceof JCheckBox) {
                String key = ((JCheckBox)ListPluginComponent.this.myEnableDisableButton).isSelected() ? "plugins.configurable.enabled" : "plugins.configurable.disabled";
                description.add(IdeBundle.message((String)key, (Object[])new Object[0]));
            }
            if (AccessibleListPluginComponent.isNotNullAndVisible(ListPluginComponent.this.myInstallButton)) {
                boolean isDefaultText = IdeBundle.message((String)"action.AnActionButton.text.install", (Object[])new Object[0]).equals(ListPluginComponent.this.myInstallButton.getText());
                if (ListPluginComponent.this.myInstallButton.isEnabled() && isDefaultText) {
                    description.add(IdeBundle.message((String)"plugins.configurable.list.component.accessible.description.install.available", (Object[])new Object[0]));
                } else if (!ListPluginComponent.this.myInstallButton.isEnabled() && !isDefaultText) {
                    description.add(ListPluginComponent.this.myInstallButton.getText());
                }
            }
            if (AccessibleListPluginComponent.isNotNullAndVisible(ListPluginComponent.this.myLayout.myTagComponent) && ListPluginComponent.this.myLayout.myTagComponent instanceof TagComponent) {
                description.add(((TagComponent)((Object)ListPluginComponent.this.myLayout.myTagComponent)).getText());
            }
            if (AccessibleListPluginComponent.isNotNullAndVisible(ListPluginComponent.this.myDownloads)) {
                description.add(IdeBundle.message((String)"plugins.configurable.list.component.accessible.description.0.downloads", (Object[])new Object[]{ListPluginComponent.this.myDownloads.getText()}));
            }
            if (AccessibleListPluginComponent.isNotNullAndVisible(ListPluginComponent.this.myRating)) {
                description.add(IdeBundle.message((String)"plugins.configurable.list.component.accessible.description.0.stars", (Object[])new Object[]{ListPluginComponent.this.myRating.getText()}));
            }
            if (AccessibleListPluginComponent.isNotNullAndVisible(ListPluginComponent.this.myVersion)) {
                description.add(ListPluginComponent.this.myVersion.getText());
            }
            if (AccessibleListPluginComponent.isNotNullAndVisible(ListPluginComponent.this.myVendor)) {
                description.add(ListPluginComponent.this.myVendor.getText());
            }
            if (AccessibleListPluginComponent.isNotNullAndVisible(ListPluginComponent.this.myErrorComponent)) {
                try {
                    description.add(ListPluginComponent.this.myErrorComponent.getDocument().getText(0, ListPluginComponent.this.myErrorComponent.getDocument().getLength()));
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            return description.toString();
        }

        private static boolean isNotNullAndVisible(JComponent component2) {
            return component2 != null && component2.isVisible();
        }
    }
}

